/*
 * Decompiled with CFR 0.152.
 */
package gate.persist;

import gate.Corpus;
import gate.DataStore;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.LanguageResource;
import gate.corpora.SerialCorpusImpl;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.event.DatastoreEvent;
import gate.event.DatastoreListener;
import gate.persist.GateAwareObjectInputStream;
import gate.persist.PersistenceException;
import gate.util.AbstractFeatureBearer;
import gate.util.Files;
import gate.util.GateRuntimeException;
import gate.util.Strings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class SerialDataStore
extends AbstractFeatureBearer
implements DataStore {
    private static final long serialVersionUID = -2109852254191554517L;
    private static final boolean DEBUG = false;
    protected String name;
    protected File storageDir;
    private static String versionFileName = "__GATE_SerialDataStore__";
    protected String currentProtocolVersion = null;
    protected static final String versionNumber = "1.1";
    protected static final String[] protocolVersionNumbers = new String[]{"1.0", "1.1"};
    protected boolean autoSaving = false;
    private static final Random randomiser = new Random();
    private transient Vector<DatastoreListener> datastoreListeners;

    public SerialDataStore(String storageDirUrl) throws PersistenceException {
        this.setStorageUrl(storageDirUrl);
    }

    public SerialDataStore() {
    }

    public void setStorageDir(File storageDir) {
        this.storageDir = storageDir;
    }

    public File getStorageDir() {
        return this.storageDir;
    }

    @Override
    public void setStorageUrl(String urlString) throws PersistenceException {
        URL storageUrl = null;
        try {
            storageUrl = new URL(urlString);
        }
        catch (MalformedURLException ex) {
            throw new PersistenceException("The URL passed is not correct: " + urlString);
        }
        if (!storageUrl.getProtocol().equalsIgnoreCase("file")) {
            throw new PersistenceException("A serial data store needs a file URL, not " + storageUrl);
        }
        try {
            this.storageDir = new File(storageUrl.toURI());
        }
        catch (URISyntaxException use) {
            this.storageDir = Files.fileFromURL(storageUrl);
        }
    }

    @Override
    public String getStorageUrl() {
        if (this.storageDir == null) {
            return null;
        }
        URL u = null;
        try {
            u = this.storageDir.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return u.toString();
    }

    @Override
    public void create() throws PersistenceException {
        if (this.storageDir == null) {
            throw new PersistenceException("null storage directory: cannot create");
        }
        if (!this.storageDir.exists()) {
            if (!this.storageDir.mkdir()) {
                throw new PersistenceException("cannot create directory " + this.storageDir);
            }
        } else {
            String[] existingFiles = this.filterIgnoredFileNames(this.storageDir.list());
            if (existingFiles != null && existingFiles.length != 0) {
                throw new PersistenceException("directory " + this.storageDir + " is not empty: cannot use for data store");
            }
        }
        try {
            File versionFile = this.getVersionFile();
            OutputStreamWriter osw = new OutputStreamWriter(new FileOutputStream(versionFile));
            osw.write(versionNumber + Strings.getNl());
            osw.close();
        }
        catch (IOException e) {
            throw new PersistenceException("couldn't write version file: " + e);
        }
    }

    protected File getVersionFile() throws IOException {
        return new File(this.storageDir, versionFileName);
    }

    protected static boolean isValidProtocolVersion(String versionNumber) {
        if (versionNumber == null) {
            return false;
        }
        for (int i = 0; i < protocolVersionNumbers.length; ++i) {
            if (!protocolVersionNumbers[i].equals(versionNumber)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void delete() throws PersistenceException {
        if (this.storageDir == null || !Files.rmdir(this.storageDir)) {
            throw new PersistenceException("couldn't delete " + this.storageDir);
        }
        Gate.getDataStoreRegister().remove(this);
    }

    @Override
    public void delete(String lrClassName, Object lrPersistenceId) throws PersistenceException {
        File resourceTypeDirectory = new File(this.storageDir, lrClassName);
        if (!resourceTypeDirectory.exists() || !resourceTypeDirectory.isDirectory()) {
            throw new PersistenceException("Can't find " + resourceTypeDirectory);
        }
        File resourceFile = new File(resourceTypeDirectory, (String)lrPersistenceId);
        if (!resourceFile.exists() || !resourceFile.isFile()) {
            throw new PersistenceException("Can't find file " + resourceFile);
        }
        if (!resourceFile.delete()) {
            throw new PersistenceException("Can't delete file " + resourceFile);
        }
        if (this.filterIgnoredFileNames(resourceTypeDirectory.list()).length == 0 && !resourceTypeDirectory.delete()) {
            throw new PersistenceException("Can't delete " + resourceTypeDirectory);
        }
        this.fireResourceDeleted(new DatastoreEvent(this, 302, null, lrPersistenceId));
    }

    @Override
    public LanguageResource adopt(LanguageResource lr) throws PersistenceException {
        DataStore currentDS = lr.getDataStore();
        if (currentDS == null) {
            LanguageResource res = lr;
            if (lr instanceof Corpus) {
                FeatureMap features1 = Factory.newFeatureMap();
                features1.put("transientSource", lr);
                try {
                    res = (LanguageResource)Factory.createResource("gate.corpora.SerialCorpusImpl", features1);
                }
                catch (ResourceInstantiationException ex) {
                    throw new GateRuntimeException(ex.getMessage());
                }
            }
            res.setDataStore(this);
            this.fireResourceAdopted(new DatastoreEvent(this, 301, lr, null));
            return res;
        }
        if (currentDS.equals(this)) {
            return lr;
        }
        throw new PersistenceException("Can't adopt a resource which is already in a different datastore");
    }

    @Override
    public void open() throws PersistenceException {
        if (this.storageDir == null) {
            throw new PersistenceException("Can't open: storage dir is null");
        }
        if (!this.storageDir.canRead()) {
            throw new PersistenceException("Can't read " + this.storageDir);
        }
        try {
            FileReader fis = new FileReader(this.getVersionFile());
            BufferedReader isr = new BufferedReader(fis);
            this.currentProtocolVersion = isr.readLine();
            isr.close();
        }
        catch (IOException e) {
            throw new PersistenceException("Invalid storage directory: " + e);
        }
        if (!SerialDataStore.isValidProtocolVersion(this.currentProtocolVersion)) {
            throw new PersistenceException("Invalid protocol version number: " + this.currentProtocolVersion);
        }
    }

    @Override
    public void close() throws PersistenceException {
        Gate.getDataStoreRegister().remove(this);
    }

    @Override
    public void sync(LanguageResource lr) throws PersistenceException {
        if (lr.getDataStore() == null || !lr.getDataStore().equals(this)) {
            throw new PersistenceException("LR " + lr.getName() + " has not been adopted by this DataStore");
        }
        ResourceData lrData = (ResourceData)Gate.getCreoleRegister().get(lr.getClass().getName());
        File resourceTypeDirectory = new File(this.storageDir, lrData.getClassName());
        if (!(resourceTypeDirectory.exists() && resourceTypeDirectory.isDirectory() || resourceTypeDirectory.mkdir() || resourceTypeDirectory.exists())) {
            throw new PersistenceException("Can't write " + resourceTypeDirectory);
        }
        String lrName = null;
        Object lrPersistenceId = null;
        lrName = lr.getName();
        lrPersistenceId = lr.getLRPersistenceId();
        if (lrName == null) {
            lrName = lrData.getName();
        }
        if (lrPersistenceId == null) {
            lrPersistenceId = this.constructPersistenceId(lrName);
            lr.setLRPersistenceId(lrPersistenceId);
        }
        if (lr instanceof Corpus) {
            if (!(lr instanceof SerialCorpusImpl)) {
                throw new PersistenceException("Can't save a corpus which is not of type SerialCorpusImpl!");
            }
            SerialCorpusImpl corpus = (SerialCorpusImpl)lr;
            for (int i = 0; i < corpus.size(); ++i) {
                if (!corpus.isDocumentLoaded(i) && corpus.isPersistentDocument(i)) continue;
                Document doc = corpus.get(i);
                try {
                    if (doc.getLRPersistenceId() == null) {
                        doc = (Document)this.adopt(doc);
                        this.sync(doc);
                        corpus.setDocumentPersistentID(i, doc.getLRPersistenceId());
                    } else {
                        this.sync(doc);
                    }
                    corpus.setDocumentPersistentID(i, doc.getLRPersistenceId());
                    continue;
                }
                catch (Exception ex) {
                    throw new PersistenceException("Error while saving corpus: " + corpus + "because of an error storing document " + ex.getMessage(), ex);
                }
            }
        }
        File resourceFile = new File(resourceTypeDirectory, (String)lrPersistenceId);
        try {
            OutputStream os = new FileOutputStream(resourceFile);
            if (!this.currentProtocolVersion.equals("1.0")) {
                os = new GZIPOutputStream(os);
            }
            os = new BufferedOutputStream(os);
            ObjectOutputStream oos = new ObjectOutputStream(os);
            oos.writeObject(lr);
            oos.close();
        }
        catch (IOException e) {
            throw new PersistenceException("Couldn't write to storage file: " + e.getMessage(), e);
        }
        this.fireResourceWritten(new DatastoreEvent(this, 303, lr, lrPersistenceId));
    }

    protected String constructPersistenceId(String lrName) {
        lrName = lrName.substring(0, Math.min(50, lrName.length())).replaceAll("[\\/:\\*\\?\"<>|]", "_");
        return lrName + "___" + new Date().getTime() + "___" + SerialDataStore.random();
    }

    @Override
    public LanguageResource getLr(String lrClassName, Object lrPersistenceId) throws PersistenceException, SecurityException {
        File resourceTypeDirectory = new File(this.storageDir, lrClassName);
        if (!resourceTypeDirectory.exists() || !resourceTypeDirectory.isDirectory()) {
            throw new PersistenceException("Can't find " + resourceTypeDirectory);
        }
        File resourceFile = new File(resourceTypeDirectory, lrPersistenceId.toString());
        if (!resourceFile.exists() || !resourceFile.isFile()) {
            throw new PersistenceException("Can't find file " + resourceFile);
        }
        LanguageResource lr = null;
        try {
            InputStream is = new FileInputStream(resourceFile);
            if (!this.currentProtocolVersion.equals("1.0")) {
                is = new GZIPInputStream(is);
            }
            is = new BufferedInputStream(is);
            GateAwareObjectInputStream ois = new GateAwareObjectInputStream(is);
            lr = (LanguageResource)ois.readObject();
            ois.close();
        }
        catch (IOException e) {
            throw new PersistenceException("Couldn't read file " + resourceFile + ": " + e);
        }
        catch (ClassNotFoundException ee) {
            throw new PersistenceException("Couldn't find class " + lrClassName + ": " + ee);
        }
        lr.setDataStore(this);
        lr.setLRPersistenceId(lrPersistenceId);
        return lr;
    }

    @Override
    public List<String> getLrTypes() throws PersistenceException {
        if (this.storageDir == null || !this.storageDir.exists()) {
            throw new PersistenceException("Can't read storage directory");
        }
        String[] fileArray = this.filterIgnoredFileNames(this.storageDir.list());
        ArrayList<String> lrTypes = new ArrayList<String>();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].equals(versionFileName)) continue;
            lrTypes.add(fileArray[i]);
        }
        return lrTypes;
    }

    @Override
    public List<String> getLrIds(String lrType) throws PersistenceException {
        File resourceTypeDir = new File(this.storageDir, lrType);
        if (!resourceTypeDir.exists()) {
            return Arrays.asList(new String[0]);
        }
        return Arrays.asList(this.filterIgnoredFileNames(resourceTypeDir.list()));
    }

    @Override
    public List<String> getLrNames(String lrType) throws PersistenceException {
        List<String> lrFileNames = this.getLrIds(lrType);
        ArrayList<String> lrNames = new ArrayList<String>();
        for (String fname : lrFileNames) {
            lrNames.add(this.getLrName(fname));
        }
        return lrNames;
    }

    @Override
    public String getLrName(Object lrId) {
        String sLRid = lrId.toString();
        int secondSeparator = sLRid.lastIndexOf("___");
        sLRid = sLRid.substring(0, secondSeparator);
        int firstSeparator = sLRid.lastIndexOf("___");
        return sLRid.substring(0, firstSeparator);
    }

    @Override
    public void setAutoSaving(boolean autoSaving) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("SerialDataStore has no auto-save capability");
    }

    @Override
    public boolean isAutoSaving() {
        return this.autoSaving;
    }

    protected static int random() {
        return randomiser.nextInt(9999);
    }

    public String toString() {
        String nl = Strings.getNl();
        StringBuffer s = new StringBuffer("SerialDataStore: ");
        s.append("autoSaving: " + this.autoSaving);
        s.append("; storageDir: " + this.storageDir);
        s.append(nl);
        return s.toString();
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.storageDir.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof SerialDataStore)) {
            return false;
        }
        if (!((SerialDataStore)other).storageDir.equals(this.storageDir)) {
            return false;
        }
        if (((SerialDataStore)other).name == this.name) {
            return true;
        }
        return ((SerialDataStore)other).name.equals(this.name);
    }

    @Override
    public synchronized void removeDatastoreListener(DatastoreListener l) {
        if (this.datastoreListeners != null && this.datastoreListeners.contains(l)) {
            Vector v = (Vector)this.datastoreListeners.clone();
            v.removeElement(l);
            this.datastoreListeners = v;
        }
    }

    @Override
    public synchronized void addDatastoreListener(DatastoreListener l) {
        Vector v;
        Vector vector = v = this.datastoreListeners == null ? new Vector(2) : (Vector)this.datastoreListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.datastoreListeners = v;
        }
    }

    protected void fireResourceAdopted(DatastoreEvent e) {
        if (this.datastoreListeners != null) {
            Vector<DatastoreListener> listeners = this.datastoreListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).resourceAdopted(e);
            }
        }
    }

    protected void fireResourceDeleted(DatastoreEvent e) {
        if (this.datastoreListeners != null) {
            Vector<DatastoreListener> listeners = this.datastoreListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).resourceDeleted(e);
            }
        }
    }

    protected void fireResourceWritten(DatastoreEvent e) {
        if (this.datastoreListeners != null) {
            Vector<DatastoreListener> listeners = this.datastoreListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).resourceWritten(e);
            }
        }
    }

    @Override
    public String getIconName() {
        return "datastore";
    }

    @Override
    public String getComment() {
        return "GATE serial datastore";
    }

    @Override
    public boolean canReadLR(Object lrID) throws PersistenceException {
        return true;
    }

    @Override
    public boolean canWriteLR(Object lrID) throws PersistenceException {
        return true;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean lockLr(LanguageResource lr) throws PersistenceException, SecurityException {
        return true;
    }

    @Override
    public void unlockLr(LanguageResource lr) throws PersistenceException, SecurityException {
    }

    @Override
    public List findLrIds(List constraints) throws PersistenceException {
        throw new UnsupportedOperationException("Serial DataStore does not support document retrieval.");
    }

    @Override
    public List findLrIds(List constraints, String lrType) throws PersistenceException {
        throw new UnsupportedOperationException("Serial DataStore does not support document retrieval.");
    }

    protected String[] filterIgnoredFileNames(String[] fileNames) {
        if (fileNames == null || fileNames.length == 0) {
            return fileNames;
        }
        Vector<String> filteredNames = new Vector<String>(fileNames.length);
        for (String filename : fileNames) {
            if (filename.startsWith(".") || filename.equals("Icon\r")) continue;
            filteredNames.add(filename);
        }
        return filteredNames.toArray(new String[0]);
    }
}

