/*
 * Decompiled with CFR 0.152.
 */
package gate.persist;

import gate.Corpus;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.LanguageResource;
import gate.Resource;
import gate.corpora.SerialCorpusImpl;
import gate.creole.ResourceInstantiationException;
import gate.creole.annic.Hit;
import gate.creole.annic.IndexException;
import gate.creole.annic.Indexer;
import gate.creole.annic.SearchException;
import gate.creole.annic.SearchableDataStore;
import gate.creole.annic.Searcher;
import gate.creole.annic.lucene.LuceneIndexer;
import gate.creole.annic.lucene.LuceneSearcher;
import gate.event.CorpusEvent;
import gate.event.CorpusListener;
import gate.event.CreoleEvent;
import gate.event.CreoleListener;
import gate.persist.PersistenceException;
import gate.persist.SerialDataStore;
import gate.util.Files;
import gate.util.GateRuntimeException;
import gate.util.Strings;
import gate.util.persistence.PersistenceManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class LuceneDataStoreImpl
extends SerialDataStore
implements SearchableDataStore,
CorpusListener,
CreoleListener {
    private static final long serialVersionUID = 3618696392336421680L;
    protected Map<Object, LabelledSoftReference> lockObjects = new HashMap<Object, LabelledSoftReference>();
    protected ReferenceQueue<Object> refQueue = new ReferenceQueue();
    protected boolean dataStoreClosing = false;
    protected ScheduledThreadPoolExecutor executor;
    protected ConcurrentMap<Object, IndexingTask> currentTasks = new ConcurrentHashMap<Object, IndexingTask>();
    protected long indexDelay = 1000L;
    protected Indexer indexer;
    protected Map<String, Object> indexParameters;
    protected URL indexURL;
    protected Searcher searcher;
    protected Map<String, Object> searchParameters;

    @Override
    public void close() throws PersistenceException {
        IndexingTask[] queuedTasksArray;
        Gate.getCreoleRegister().removeCreoleListener(this);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                LuceneDataStoreImpl.this.executor.shutdown();
            }
        });
        try {
            this.executor.awaitTermination(120L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        Collection queuedTasks = this.currentTasks.values();
        for (IndexingTask task : queuedTasksArray = queuedTasks.toArray(new IndexingTask[queuedTasks.size()])) {
            task.run();
        }
        super.close();
    }

    @Override
    public void open() throws PersistenceException {
        super.open();
        try (BufferedReader isr = new BufferedReader(new FileReader(this.getVersionFile()));){
            this.currentProtocolVersion = isr.readLine();
            String indexDirRelativePath = isr.readLine();
            if (indexDirRelativePath != null && indexDirRelativePath.trim().length() > 1) {
                URL storageDirURL = this.storageDir.toURI().toURL();
                URL theIndexURL = new URL(storageDirURL, indexDirRelativePath);
                File indexDir = Files.fileFromURL(theIndexURL);
                if (!indexDir.exists()) {
                    throw new PersistenceException("Index directory " + indexDirRelativePath + " could not be found for datastore at " + storageDirURL);
                }
                this.indexURL = theIndexURL;
                this.indexer = new LuceneIndexer(this.indexURL);
                this.searcher = new LuceneSearcher();
                ((LuceneSearcher)this.searcher).setLuceneDatastore(this);
            }
        }
        catch (IOException e) {
            throw new PersistenceException("Invalid storage directory: " + e);
        }
        if (!LuceneDataStoreImpl.isValidProtocolVersion(this.currentProtocolVersion)) {
            throw new PersistenceException("Invalid protocol version number: " + this.currentProtocolVersion);
        }
        this.executor = new ScheduledThreadPoolExecutor(1, Executors.defaultThreadFactory());
        this.executor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        this.executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        Gate.getCreoleRegister().addCreoleListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object lockObjectForID(Object id) {
        Map<Object, LabelledSoftReference> map = this.lockObjects;
        synchronized (map) {
            this.processRefQueue();
            Object lock = null;
            if (this.lockObjects.containsKey(id)) {
                lock = this.lockObjects.get(id).get();
            }
            if (lock == null) {
                this.lockObjects.remove(id);
                lock = new Object();
                LabelledSoftReference ref = new LabelledSoftReference(lock);
                ref.label = id;
                this.lockObjects.put(id, ref);
            }
            return lock;
        }
    }

    private void processRefQueue() {
        LabelledSoftReference ref = null;
        while ((ref = (LabelledSoftReference)LabelledSoftReference.class.cast(this.refQueue.poll())) != null) {
            if (this.lockObjects.get(ref.label) != ref) continue;
            this.lockObjects.remove(ref.label);
        }
    }

    protected void queueForIndexing(Object lrID) {
        IndexingTask existingTask = (IndexingTask)this.currentTasks.get(lrID);
        if (existingTask != null) {
            existingTask.disable();
        }
        IndexingTask newTask = new IndexingTask(lrID);
        this.currentTasks.put(lrID, newTask);
        this.executor.schedule(newTask, this.indexDelay, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String lrClassName, Object lrPersistenceId) throws PersistenceException {
        block16: {
            Object lock;
            IndexingTask task = (IndexingTask)this.currentTasks.get(lrPersistenceId);
            if (task != null) {
                task.disable();
            }
            Object object = lock = this.lockObjectForID(lrPersistenceId);
            synchronized (object) {
                super.delete(lrClassName, lrPersistenceId);
            }
            lock = null;
            try {
                if (!Corpus.class.isAssignableFrom(Class.forName(lrClassName, true, Gate.getClassLoader()))) break block16;
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("INDEX_LOCATION_URL", this.indexURL);
                parameters.put("CORPUS_ID", lrPersistenceId.toString());
                try {
                    boolean success = this.getSearcher().search("nothing", parameters);
                    if (!success) {
                        return;
                    }
                    Hit[] hits = this.getSearcher().next(-1);
                    if (hits == null || hits.length == 0) {
                        return;
                    }
                    for (int i = 0; i < hits.length; ++i) {
                        String docID = hits[i].getDocumentID();
                        this.queueForIndexing(docID);
                    }
                }
                catch (SearchException se) {
                    throw new PersistenceException(se);
                }
                return;
            }
            catch (ClassNotFoundException parameters) {
                // empty catch block
            }
        }
        ArrayList<Object> removed = new ArrayList<Object>();
        removed.add(lrPersistenceId);
        try {
            Indexer se = this.indexer;
            synchronized (se) {
                this.indexer.remove(removed);
            }
        }
        catch (IndexException ie) {
            throw new PersistenceException(ie);
        }
    }

    @Override
    public LanguageResource getLr(String lrClassName, Object lrPersistenceId) throws PersistenceException, SecurityException {
        LanguageResource lr = super.getLr(lrClassName, lrPersistenceId);
        if (lr instanceof Corpus) {
            ((Corpus)lr).addCorpusListener(this);
        }
        return lr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void sync(LanguageResource lr) throws PersistenceException {
        block18: {
            block16: {
                if (lr.getLRPersistenceId() == null) break block16;
                var3_3 = lock = this.lockObjectForID(lr.getLRPersistenceId());
                synchronized (var3_3) {
                    block14: {
                        block15: {
                            copy = null;
                            try {
                                copy = this.getLr(lr.getClass().getName(), lr.getLRPersistenceId());
                                if (!(copy instanceof Document) || !(lr instanceof Document)) break block14;
                                cDoc = (Document)copy;
                                lrDoc = (Document)lr;
                                sameDocs = false;
                                if (cDoc.getContent().equals(lrDoc.getContent()) && cDoc.getAnnotations().equals(lrDoc.getAnnotations()) && cDoc.getNamedAnnotationSets().equals(lrDoc.getNamedAnnotationSets())) {
                                    allSetsSame = true;
                                    for (String key : cDoc.getNamedAnnotationSets().keySet()) {
                                        if (cDoc.getAnnotations(key).equals(lrDoc.getAnnotations(key))) continue;
                                        allSetsSame = false;
                                        break;
                                    }
                                    if (allSetsSame) {
                                        sameDocs = true;
                                    }
                                }
                                if (!sameDocs) break block14;
                                lock = null;
                                if (copy == null) break block15;
                            }
                            catch (SecurityException e) {
                                try {
                                    e.printStackTrace();
                                    ** if (copy == null) goto lbl-1000
                                }
                                catch (Throwable var11_12) {
                                    if (copy != null) {
                                        Factory.deleteResource(copy);
                                    }
                                    throw var11_12;
                                }
lbl-1000:
                                // 1 sources

                                {
                                    Factory.deleteResource(copy);
                                }
lbl-1000:
                                // 2 sources

                                {
                                }
                            }
                            Factory.deleteResource(copy);
                        }
                        return;
                    }
                    if (copy != null) {
                        Factory.deleteResource(copy);
                    }
                    super.sync(lr);
                }
                var2_2 = null;
                break block18;
            }
            super.sync(lr);
        }
        if (lr instanceof Document) {
            this.queueForIndexing(lr.getLRPersistenceId());
        }
    }

    @Override
    public void setIndexer(Indexer indexer, Map<String, Object> indexParameters) throws IndexException {
        this.indexer = indexer;
        this.indexParameters = indexParameters;
        this.indexURL = (URL)this.indexParameters.get("INDEX_LOCATION_URL");
        this.indexer.createIndex(this.indexParameters);
        try {
            File versionFile = this.getVersionFile();
            OutputStreamWriter osw = new OutputStreamWriter(new FileOutputStream(versionFile));
            osw.write("1.1" + Strings.getNl());
            String indexDirRelativePath = PersistenceManager.getRelativePath(this.storageDir.toURI().toURL(), this.indexURL);
            osw.write(indexDirRelativePath);
            osw.close();
        }
        catch (IOException e) {
            throw new IndexException("couldn't write version file: " + e);
        }
    }

    @Override
    public Indexer getIndexer() {
        return this.indexer;
    }

    @Override
    public void setSearcher(Searcher searcher) throws SearchException {
        this.searcher = searcher;
        if (this.searcher instanceof LuceneSearcher) {
            ((LuceneSearcher)this.searcher).setLuceneDatastore(this);
        }
    }

    @Override
    public Searcher getSearcher() {
        return this.searcher;
    }

    public void setIndexDelay(long indexDelay) {
        this.indexDelay = indexDelay;
    }

    public long getIndexDelay() {
        return this.indexDelay;
    }

    @Override
    public boolean search(String query, Map<String, Object> searchParameters) throws SearchException {
        return this.searcher.search(query, searchParameters);
    }

    @Override
    public Hit[] next(int numberOfPatterns) throws SearchException {
        return this.searcher.next(numberOfPatterns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void documentRemoved(CorpusEvent ce) {
        Object docLRID = ce.getDocumentLRID();
        if (docLRID != null) {
            ArrayList<Object> removed = new ArrayList<Object>();
            removed.add(docLRID);
            try {
                Indexer indexer = this.indexer;
                synchronized (indexer) {
                    this.indexer.remove(removed);
                }
            }
            catch (IndexException ie) {
                throw new GateRuntimeException(ie);
            }
        }
    }

    @Override
    public void documentAdded(CorpusEvent ce) {
    }

    @Override
    public void datastoreClosed(CreoleEvent e) {
    }

    @Override
    public void datastoreCreated(CreoleEvent e) {
    }

    @Override
    public void datastoreOpened(CreoleEvent e) {
    }

    @Override
    public void resourceLoaded(CreoleEvent e) {
    }

    @Override
    public void resourceRenamed(Resource resource, String oldName, String newName) {
    }

    @Override
    public void resourceUnloaded(CreoleEvent e) {
        Resource res = e.getResource();
        if (res instanceof Corpus) {
            ((Corpus)res).removeCorpusListener(this);
        }
    }

    private class LabelledSoftReference
    extends SoftReference<Object> {
        Object label;

        public LabelledSoftReference(Object referent) {
            super(referent);
        }
    }

    protected class IndexingTask
    implements Runnable {
        private AtomicBoolean disabled = new AtomicBoolean(false);
        private Object lrID;

        public IndexingTask(Object lrID) {
            this.lrID = lrID;
        }

        public void disable() {
            this.disabled.set(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void run() {
            LuceneDataStoreImpl.this.currentTasks.remove(this.lrID, this);
            if (this.disabled.compareAndSet(false, true)) {
                Object object;
                Document doc = null;
                FeatureMap features = Factory.newFeatureMap();
                features.put("LRPersistenceId", this.lrID);
                features.put("DataStore", LuceneDataStoreImpl.this);
                FeatureMap hidefeatures = Factory.newFeatureMap();
                Gate.setHiddenAttribute(hidefeatures, true);
                try {
                    Object lock;
                    object = lock = LuceneDataStoreImpl.this.lockObjectForID(this.lrID);
                    synchronized (object) {
                        doc = (Document)Factory.createResource("gate.corpora.DocumentImpl", features, hidefeatures);
                    }
                    lock = null;
                }
                catch (ResourceInstantiationException rie) {
                    doc = null;
                }
                if (doc != null) {
                    ArrayList<Object> removed = new ArrayList<Object>();
                    removed.add(this.lrID);
                    try {
                        object = LuceneDataStoreImpl.this.indexer;
                        synchronized (object) {
                            LuceneDataStoreImpl.this.indexer.remove(removed);
                        }
                    }
                    catch (IndexException ie) {
                        throw new GateRuntimeException(ie);
                    }
                    ArrayList<Document> added = new ArrayList<Document>();
                    added.add(doc);
                    try {
                        List<String> corpusPIDs;
                        String corpusPID = null;
                        List<LanguageResource> scs = Gate.getCreoleRegister().getLrInstances(SerialCorpusImpl.class.getName());
                        if (scs != null) {
                            for (SerialCorpusImpl serialCorpusImpl : scs) {
                                if (serialCorpusImpl == null || !serialCorpusImpl.contains(doc)) continue;
                                corpusPID = serialCorpusImpl.getLRPersistenceId().toString();
                                break;
                            }
                        }
                        if (corpusPID == null && (corpusPIDs = LuceneDataStoreImpl.this.getLrIds(SerialCorpusImpl.class.getName())) != null) {
                            void var9_16;
                            boolean bl = false;
                            while (var9_16 < corpusPIDs.size()) {
                                Object lock;
                                String corpusID = corpusPIDs.get((int)var9_16);
                                SerialCorpusImpl corpusLR = null;
                                FeatureMap params = Factory.newFeatureMap();
                                params.put("DataStore", LuceneDataStoreImpl.this);
                                params.put("LRPersistenceId", corpusID);
                                hidefeatures = Factory.newFeatureMap();
                                Gate.setHiddenAttribute(hidefeatures, true);
                                Object object2 = lock = LuceneDataStoreImpl.this.lockObjectForID(corpusID);
                                synchronized (object2) {
                                    corpusLR = (SerialCorpusImpl)Factory.createResource(SerialCorpusImpl.class.getCanonicalName(), params, hidefeatures);
                                }
                                lock = null;
                                if (corpusLR != null) {
                                    if (corpusLR.contains(doc)) {
                                        corpusPID = corpusLR.getLRPersistenceId().toString();
                                    }
                                    Factory.deleteResource(corpusLR);
                                    if (corpusPID != null) break;
                                }
                                ++var9_16;
                            }
                        }
                        Indexer indexer = LuceneDataStoreImpl.this.indexer;
                        synchronized (indexer) {
                            LuceneDataStoreImpl.this.indexer.add(corpusPID, added);
                        }
                        Factory.deleteResource(doc);
                    }
                    catch (Exception ie) {
                        ie.printStackTrace();
                    }
                }
            }
        }
    }
}

