/*
 * Decompiled with CFR 0.152.
 */
package gate.persist;

import gate.Gate;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;

public class GateAwareObjectInputStream
extends ObjectInputStream {
    public GateAwareObjectInputStream(InputStream source) throws IOException {
        super(source);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        try {
            return super.resolveClass(desc);
        }
        catch (ClassNotFoundException cnfe) {
            return Class.forName(desc.getName(), false, Gate.getClassLoader());
        }
    }

    @Override
    protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        try {
            return super.resolveProxyClass(interfaces);
        }
        catch (ClassNotFoundException cnfe) {
            Class[] interfaceClasses = new Class[interfaces.length];
            for (int i = 0; i < interfaces.length; ++i) {
                interfaceClasses[i] = Class.forName(interfaces[i], false, Gate.getClassLoader());
            }
            return Proxy.getProxyClass(Gate.getClassLoader(), interfaceClasses);
        }
    }
}

