/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.teamware;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.ComboBoxEditor;
import javax.swing.JTextField;

class AnnotationSetNameComboEditor
implements ComboBoxEditor,
FocusListener {
    public static final String DEFAULT_SET_TEXT = "<Default annotation set>";
    private ComboBoxEditor realEditor;
    private Font normalFont;
    private Font italicFont;
    private boolean isEmpty;

    AnnotationSetNameComboEditor(ComboBoxEditor realEditor) {
        this.realEditor = realEditor;
        this.normalFont = realEditor.getEditorComponent().getFont();
        this.italicFont = this.normalFont.deriveFont(2);
        this.setItem(null, false);
        realEditor.getEditorComponent().addFocusListener(this);
    }

    @Override
    public void addActionListener(ActionListener l) {
        this.realEditor.addActionListener(l);
    }

    @Override
    public Component getEditorComponent() {
        return this.realEditor.getEditorComponent();
    }

    @Override
    public Object getItem() {
        Object realItem = this.realEditor.getItem();
        if (this.isEmpty || DEFAULT_SET_TEXT.equals(realItem)) {
            return null;
        }
        return realItem;
    }

    @Override
    public void removeActionListener(ActionListener l) {
        this.realEditor.removeActionListener(l);
    }

    @Override
    public void selectAll() {
        if (!this.isEmpty) {
            this.realEditor.selectAll();
        }
    }

    @Override
    public void setItem(Object item) {
        this.setItem(item, true);
    }

    private void setItem(Object item, boolean updateFocus) {
        if (item == null || "".equals(item)) {
            this.isEmpty = true;
            this.realEditor.getEditorComponent().setFont(this.italicFont);
            this.realEditor.setItem(DEFAULT_SET_TEXT);
        } else {
            this.isEmpty = false;
            this.realEditor.getEditorComponent().setFont(this.normalFont);
            this.realEditor.setItem(item);
        }
        if (updateFocus) {
            if (this.realEditor.getEditorComponent().isFocusOwner()) {
                this.focusGained(null);
            } else {
                this.focusLost(null);
            }
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.isEmpty) {
            JTextField field = (JTextField)this.realEditor.getEditorComponent();
            field.setText("");
            field.setFont(this.normalFont);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        JTextField field = (JTextField)this.realEditor.getEditorComponent();
        if (field.getDocument().getLength() == 0 || DEFAULT_SET_TEXT.equals(field.getText())) {
            this.setItem(null, false);
        } else {
            this.isEmpty = false;
        }
    }
}

