/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.docview;

import gate.Annotation;
import gate.AnnotationSet;
import gate.event.AnnotationSetEvent;
import gate.event.AnnotationSetListener;
import gate.event.DocumentEvent;
import gate.event.DocumentListener;
import gate.event.FeatureMapListener;
import gate.gui.MainFrame;
import gate.gui.docview.AbstractDocumentView;
import gate.gui.docview.AnnotationSetsView;
import gate.gui.docview.DocumentView;
import gate.gui.docview.TextualDocumentView;
import gate.swing.ColorGenerator;
import gate.util.OffsetComparator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class CorefEditor
extends AbstractDocumentView
implements ActionListener,
FeatureMapListener,
DocumentListener,
AnnotationSetListener {
    private static final String DEFAULT_ANNOTSET_NAME = "Default";
    private JPanel mainPanel;
    private JPanel topPanel;
    private JPanel subPanel;
    private JToggleButton showAnnotations;
    private JComboBox<String> annotSets;
    private JComboBox<String> annotTypes;
    private DefaultComboBoxModel<String> annotSetsModel;
    private DefaultComboBoxModel<String> annotTypesModel;
    private JTree corefTree;
    private CorefTreeNode rootNode;
    private Map<CorefTreeNode, Map<CorefTreeNode, List<Integer>>> corefChains;
    private Map<String, CorefTreeNode> corefAnnotationSetNodesMap;
    private Map<String, Map<String, Boolean>> selectionChainsMap;
    private Map<String, Boolean> currentSelections;
    private Map<String, Map<String, Color>> colorChainsMap;
    private Map<String, Color> currentColors;
    private ColorGenerator colorGenerator;
    private TextualDocumentView textView;
    private JTextArea textPane;
    private Map<CorefTreeNode, List<Object>> highlightedTags;
    private List<Object> typeSpecificHighlightedTags;
    private TextPaneMouseListener textPaneMouseListener;
    private List<Annotation> highlightedChainAnnots = new ArrayList<Annotation>();
    private int[] highlightedChainAnnotsOffsets;
    private List<Annotation> highlightedTypeAnnots = new ArrayList<Annotation>();
    private int[] highlightedTypeAnnotsOffsets;
    private ChainToolTipAction chainToolTipAction;
    private Timer chainToolTipTimer;
    private NewCorefAction newCorefAction;
    private Timer newCorefActionTimer;
    private Annotation annotToConsiderForChain = null;
    private JWindow popupWindow;
    private boolean explicitCall = false;
    private Highlighter highlighter;

    @Override
    protected void initGUI() {
        Iterator<DocumentView> centralViewsIter = this.owner.getCentralViews().iterator();
        while (this.textView == null && centralViewsIter.hasNext()) {
            DocumentView aView = centralViewsIter.next();
            if (!(aView instanceof TextualDocumentView)) continue;
            this.textView = (TextualDocumentView)aView;
        }
        this.textPane = (JTextArea)((JScrollPane)this.textView.getGUI()).getViewport().getView();
        this.highlighter = this.textPane.getHighlighter();
        this.chainToolTipAction = new ChainToolTipAction();
        this.chainToolTipTimer = new Timer(500, this.chainToolTipAction);
        this.chainToolTipTimer.setRepeats(false);
        this.newCorefAction = new NewCorefAction();
        this.newCorefActionTimer = new Timer(500, this.newCorefAction);
        this.newCorefActionTimer.setRepeats(false);
        this.colorGenerator = new ColorGenerator();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.topPanel = new JPanel();
        this.topPanel.setLayout(new BorderLayout());
        this.subPanel = new JPanel();
        this.subPanel.setLayout(new FlowLayout(0));
        this.showAnnotations = new JToggleButton("Show");
        this.showAnnotations.addActionListener(this);
        this.annotSets = new JComboBox();
        this.annotSets.addActionListener(this);
        Map<String, AnnotationSet> annotSetsMap = this.document.getNamedAnnotationSets();
        this.annotSetsModel = new DefaultComboBoxModel();
        if (annotSetsMap != null) {
            String[] array = annotSetsMap.keySet().toArray(new String[annotSetsMap.keySet().size()]);
            for (int i = 0; i < array.length; ++i) {
                annotSetsMap.get(array[i]).addAnnotationSetListener(this);
            }
            this.annotSetsModel = new DefaultComboBoxModel<String>(array);
        }
        this.document.getAnnotations().addAnnotationSetListener(this);
        this.annotSetsModel.insertElementAt(DEFAULT_ANNOTSET_NAME, 0);
        this.annotSets.setModel(this.annotSetsModel);
        this.annotTypesModel = new DefaultComboBoxModel();
        this.annotTypes = new JComboBox<String>(this.annotTypesModel);
        this.annotTypes.addActionListener(this);
        this.subPanel.add(new JLabel("Sets : "));
        this.subPanel.add(this.annotSets);
        JPanel tempPanel = new JPanel(new FlowLayout(0));
        tempPanel.add(new JLabel("Types : "));
        tempPanel.add(this.annotTypes);
        tempPanel.add(this.showAnnotations);
        this.initData();
        this.corefTree = new JTree(this.rootNode);
        this.corefTree.putClientProperty("JTree.lineStyle", "None");
        this.corefTree.setRowHeight(this.corefTree.getRowHeight() * 2);
        this.corefTree.setLargeModel(true);
        this.corefTree.setAutoscrolls(true);
        this.corefTree.addMouseListener(new CorefTreeMouseListener());
        this.corefTree.setCellRenderer(new CorefTreeCellRenderer());
        this.mainPanel.add((Component)this.topPanel, "North");
        this.mainPanel.add((Component)new JScrollPane(this.corefTree), "Center");
        this.topPanel.add((Component)this.subPanel, "Center");
        this.topPanel.add((Component)tempPanel, "South");
        this.textPaneMouseListener = new TextPaneMouseListener();
        this.annotSets.setSelectedIndex(0);
        this.document.addDocumentListener(this);
        this.document.getFeatures().addFeatureMapListener(this);
    }

    public void reinitAllVariables() {
        if (this.highlightedChainAnnots != null) {
            this.highlightedChainAnnots.clear();
        }
        if (this.highlightedTypeAnnots != null) {
            this.highlightedTypeAnnots.clear();
        }
        if (this.typeSpecificHighlightedTags != null) {
            this.typeSpecificHighlightedTags.clear();
        }
        this.highlightedChainAnnotsOffsets = null;
        this.highlightedTypeAnnotsOffsets = null;
        if (this.highlightedTags != null && this.highlightedTags.values() != null) {
            for (List<Object> tags : this.highlightedTags.values()) {
                for (int i = 0; i < tags.size(); ++i) {
                    this.highlighter.removeHighlight(tags.get(i));
                }
            }
            this.highlightedTags.clear();
        }
        Iterator<String> annotSetsIter = this.corefAnnotationSetNodesMap.keySet().iterator();
        while (annotSetsIter.hasNext()) {
            CorefTreeNode annotSetNode = this.corefAnnotationSetNodesMap.get(annotSetsIter.next());
            annotSetNode.removeAllChildren();
            this.colorChainsMap.put(annotSetNode.toString(), new HashMap());
            this.selectionChainsMap.put(annotSetNode.toString(), new HashMap());
            this.corefChains.put(annotSetNode, new HashMap());
        }
    }

    @Override
    public void cleanup() {
        this.document.removeDocumentListener(this);
        this.document.getFeatures().removeFeatureMapListener(this);
    }

    public Annotation findOutTheLongestAnnotation(List<Integer> matches, AnnotationSet set) {
        if (matches == null || matches.size() == 0) {
            return null;
        }
        int length = 0;
        int index = 0;
        for (int i = 0; i < matches.size(); ++i) {
            Annotation currAnn = set.get(matches.get(i));
            int start = currAnn.getStartNode().getOffset().intValue();
            int end = currAnn.getEndNode().getOffset().intValue();
            if (end - start <= length) continue;
            length = end - start;
            index = i;
        }
        return set.get(matches.get(index));
    }

    @Override
    public void annotationSetRemoved(DocumentEvent de) {
        String annotSet = de.getAnnotationSetName();
        annotSet = "".equals(annotSet) ? DEFAULT_ANNOTSET_NAME : annotSet;
        String annotSetName = (String)this.annotSets.getSelectedItem();
        this.corefChains.remove(this.corefAnnotationSetNodesMap.get(annotSet));
        this.corefAnnotationSetNodesMap.remove(annotSet);
        this.annotSetsModel.removeElement(annotSet);
        this.annotSets.setModel(this.annotSetsModel);
        this.colorChainsMap.remove(annotSet);
        this.selectionChainsMap.remove(annotSet);
        if (this.annotSetsModel.getSize() == 0) {
            if (this.popupWindow != null && this.popupWindow.isVisible()) {
                this.popupWindow.setVisible(false);
            }
            this.corefTree.setVisible(false);
        } else if (annotSetName.equals(annotSet)) {
            if (this.popupWindow != null && this.popupWindow.isVisible()) {
                this.popupWindow.setVisible(false);
            }
            if (!this.corefTree.isVisible()) {
                this.corefTree.setVisible(true);
            }
            this.annotSets.setSelectedIndex(0);
        }
    }

    @Override
    public void annotationSetAdded(DocumentEvent de) {
        String annotSet = de.getAnnotationSetName();
        if ("".equals(annotSet)) {
            this.document.getAnnotations().addAnnotationSetListener(this);
        } else {
            this.document.getAnnotations(annotSet).addAnnotationSetListener(this);
        }
        annotSet = "".equals(annotSet) ? DEFAULT_ANNOTSET_NAME : annotSet;
        String annotSetName = (String)this.annotSets.getSelectedItem();
        CorefTreeNode annotSetNode = null;
        annotSetNode = annotSet.equals(DEFAULT_ANNOTSET_NAME) ? this.createAnnotSetNode(this.document.getAnnotations(), true) : this.createAnnotSetNode(this.document.getAnnotations(annotSet), false);
        this.corefAnnotationSetNodesMap.put(annotSet, annotSetNode);
        if (annotSetName != null) {
            this.annotSets.setSelectedItem(annotSetName);
        } else {
            this.annotSets.setSelectedIndex(0);
        }
    }

    @Override
    public void contentEdited(DocumentEvent e) {
    }

    @Override
    public void annotationAdded(AnnotationSetEvent ase) {
    }

    @Override
    public void annotationRemoved(AnnotationSetEvent ase) {
        Annotation delAnnot = ase.getAnnotation();
        Integer id = delAnnot.getId();
        Object matchesMapObject = this.document.getFeatures().get("MatchesAnnots");
        if (matchesMapObject == null) {
            return;
        }
        if (!(matchesMapObject instanceof Map)) {
            return;
        }
        Map matchesMap = (Map)matchesMapObject;
        Set keySet = matchesMap.keySet();
        if (keySet == null) {
            return;
        }
        Iterator iter = keySet.iterator();
        boolean found = false;
        while (iter.hasNext()) {
            String currSet = (String)iter.next();
            List matches = (List)matchesMap.get(currSet);
            if (matches == null || matches.size() == 0) continue;
            for (int i = 0; i < matches.size(); ++i) {
                List ids = (List)matches.get(i);
                if (!ids.contains(id)) continue;
                found = true;
                ids.remove(id);
                matches.set(i, ids);
                break;
            }
            if (!found) continue;
            matchesMap.put(currSet, matches);
            this.explicitCall = true;
            this.document.getFeatures().put("MatchesAnnots", matchesMap);
            this.explicitCall = false;
            break;
        }
        if (found) {
            this.featureMapUpdated();
        }
    }

    @Override
    public void featureMapUpdated() {
        ArrayList<Object> allHighlights;
        if (this.explicitCall) {
            return;
        }
        String currentAnnotSet = (String)this.annotSets.getSelectedItem();
        String currentAnnotType = (String)this.annotTypes.getSelectedItem();
        boolean currentShowAnnotationStatus = this.showAnnotations.isSelected();
        Object matchesMapObject = this.document.getFeatures().get("MatchesAnnots");
        if (matchesMapObject == null || !(matchesMapObject instanceof Map)) {
            this.reinitAllVariables();
            this.explicitCall = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CorefEditor.this.annotSets.setSelectedIndex(0);
                }
            });
            return;
        }
        Map matchesMap = (Map)matchesMapObject;
        Iterator setIter = matchesMap.keySet().iterator();
        HashMap<String, Boolean> annotSetsNamesMap = new HashMap<String, Boolean>();
        for (int i = 0; i < this.annotSets.getItemCount(); ++i) {
            annotSetsNamesMap.put(this.annotSets.getItemAt(i), false);
        }
        while (setIter.hasNext()) {
            Map<Object, Object> tempSelection;
            String currentSet = (String)setIter.next();
            List matches = (List)matchesMap.get(currentSet);
            String string = currentSet = currentSet == "" ? DEFAULT_ANNOTSET_NAME : currentSet;
            if (matches == null) continue;
            AnnotationSet currAnnotSet = this.getAnnotationSet(currentSet);
            annotSetsNamesMap.put(currentSet, true);
            Iterator entitiesIter = matches.iterator();
            if (this.corefAnnotationSetNodesMap.get(currentSet) == null) {
                if (currentSet.equals(DEFAULT_ANNOTSET_NAME)) {
                    this.corefAnnotationSetNodesMap.put(DEFAULT_ANNOTSET_NAME, this.createChain(this.document.getAnnotations(), true));
                    continue;
                }
                this.corefAnnotationSetNodesMap.put(currentSet, this.createChain(this.document.getAnnotations(currentSet), false));
                continue;
            }
            Map<CorefTreeNode, List<Integer>> chains = this.corefChains.get(this.corefAnnotationSetNodesMap.get(currentSet));
            HashMap<CorefTreeNode, Boolean> visitedList = new HashMap<CorefTreeNode, Boolean>();
            if (chains == null) continue;
            Iterator<CorefTreeNode> chainsList = chains.keySet().iterator();
            while (chainsList.hasNext()) {
                visitedList.put(chainsList.next(), false);
            }
            ArrayList<List> idsToRemove = new ArrayList<List>();
            while (entitiesIter.hasNext()) {
                Map<CorefTreeNode, List<Integer>> newHashMap;
                List ids = (List)entitiesIter.next();
                if (ids == null || ids.size() == 0) {
                    idsToRemove.add(ids);
                    continue;
                }
                CorefTreeNode chainHead = null;
                for (int i = 0; i < ids.size(); ++i) {
                    Integer id = (Integer)ids.get(i);
                    chainHead = this.findOutTheChainHead(currAnnotSet.get(id), currentSet);
                    if (chainHead == null) continue;
                    visitedList.put(chainHead, true);
                    break;
                }
                if (chainHead != null) {
                    Annotation longestAnn = this.findOutTheLongestAnnotation(ids, this.getAnnotationSet(currentSet));
                    if (this.getString(longestAnn).equals(chainHead.toString())) {
                        chains.put(chainHead, ids);
                        this.corefChains.put(this.corefAnnotationSetNodesMap.get(currentSet), chains);
                        continue;
                    }
                    if (this.currentColors.containsKey(this.getString(longestAnn))) {
                        String longestString = this.getString(longestAnn);
                        CorefTreeNode tempChainHead = this.findOutChainNode(longestString, currentSet);
                        List<Integer> tempIds = chains.get(tempChainHead);
                        List<Integer> currentChainHeadIds = chains.get(chainHead);
                        tempIds.addAll(currentChainHeadIds);
                        chains.remove(chainHead);
                        chains.put(tempChainHead, tempIds);
                        this.corefChains.put(this.corefAnnotationSetNodesMap.get(currentSet), chains);
                        visitedList.put(chainHead, false);
                        visitedList.put(tempChainHead, true);
                        continue;
                    }
                    String previousString = chainHead.toString();
                    String newString = this.getString(longestAnn);
                    chainHead.setUserObject(newString);
                    Color color = this.currentColors.get(previousString);
                    this.currentColors.remove(previousString);
                    this.currentColors.put(newString, color);
                    this.colorChainsMap.put(newString, this.currentColors);
                    Boolean val = this.currentSelections.get(previousString);
                    this.currentSelections.remove(previousString);
                    this.currentSelections.put(newString, val);
                    this.selectionChainsMap.put(newString, this.currentSelections);
                    chains.put(chainHead, ids);
                    this.corefChains.put(this.corefAnnotationSetNodesMap.get(currentSet), chains);
                    continue;
                }
                CorefTreeNode annotSetNode = this.corefAnnotationSetNodesMap.get(currentSet);
                AnnotationSet actSet = this.getAnnotationSet(currentSet);
                Annotation ann = this.findOutTheLongestAnnotation(ids, this.getAnnotationSet(currentSet));
                tempSelection = (HashMap)this.selectionChainsMap.get(currentSet);
                CorefTreeNode chainNode = null;
                if (((HashMap)tempSelection).containsKey(this.getString(ann))) {
                    chainNode = this.findOutChainNode(this.getString(ann), currentSet);
                    newHashMap = this.corefChains.get(annotSetNode);
                    newHashMap.put(chainNode, ids);
                    this.corefChains.put(annotSetNode, newHashMap);
                    visitedList.put(chainNode, true);
                    continue;
                }
                chainNode = new CorefTreeNode(this.getString(ann), false, 2);
                annotSetNode.add(chainNode);
                this.corefAnnotationSetNodesMap.put(currentSet, annotSetNode);
                newHashMap = this.corefChains.get(annotSetNode);
                newHashMap.put(chainNode, ids);
                this.corefChains.put(annotSetNode, newHashMap);
                boolean selectionValue = false;
                if (currentAnnotSet.equals(currentSet)) {
                    selectionValue = true;
                }
                ((HashMap)tempSelection).put(chainNode.toString(), selectionValue);
                this.selectionChainsMap.put(currentSet, tempSelection);
                float[] components = this.colorGenerator.getNextColor().getComponents(null);
                Color color = new Color(components[0], components[1], components[2], 0.5f);
                Map<String, Color> tempColors = this.colorChainsMap.get(currentSet);
                tempColors.put(chainNode.toString(), color);
                this.colorChainsMap.put(this.annotSets.getSelectedItem().toString(), tempColors);
            }
            Iterator removeIter = idsToRemove.iterator();
            while (removeIter.hasNext()) {
                this.explicitCall = true;
                List ids = (List)removeIter.next();
                matches.remove(ids);
                String set = currentSet.equals(DEFAULT_ANNOTSET_NAME) ? "" : currentSet;
                matchesMap.put(set, matches);
                this.explicitCall = false;
            }
            this.explicitCall = true;
            this.document.getFeatures().put("MatchesAnnots", matchesMap);
            this.explicitCall = false;
            for (CorefTreeNode chainNode : visitedList.keySet()) {
                if (((Boolean)visitedList.get(chainNode)).booleanValue()) continue;
                CorefTreeNode annotSetNode = this.corefAnnotationSetNodesMap.get(currentSet);
                annotSetNode.remove(chainNode);
                this.corefAnnotationSetNodesMap.put(currentSet, annotSetNode);
                Map<CorefTreeNode, List<Integer>> newHashMap = this.corefChains.get(annotSetNode);
                newHashMap.remove(chainNode);
                this.corefChains.put(annotSetNode, newHashMap);
                tempSelection = this.selectionChainsMap.get(currentSet);
                tempSelection.remove(chainNode.toString());
                this.selectionChainsMap.put(currentSet, tempSelection);
                Map<String, Color> tempColors = this.colorChainsMap.get(currentSet);
                tempColors.remove(chainNode.toString());
                this.colorChainsMap.put(currentSet, this.currentColors);
            }
        }
        for (String currentSet : annotSetsNamesMap.keySet()) {
            if (((Boolean)annotSetsNamesMap.get(currentSet)).booleanValue()) continue;
            String annotSet = currentSet;
            String annotSetName = (String)this.annotSets.getSelectedItem();
            this.corefChains.remove(this.corefAnnotationSetNodesMap.get(annotSet));
            this.corefAnnotationSetNodesMap.remove(annotSet);
            this.annotSetsModel.removeElement(annotSet);
            this.annotSets.setModel(this.annotSetsModel);
            this.annotSets.updateUI();
            this.colorChainsMap.remove(annotSet);
            this.selectionChainsMap.remove(annotSet);
        }
        if (this.annotSetsModel.getSize() == 0) {
            if (this.popupWindow != null && this.popupWindow.isVisible()) {
                this.popupWindow.setVisible(false);
            }
            this.corefTree.setVisible(false);
            allHighlights = new ArrayList();
            if (this.typeSpecificHighlightedTags != null) {
                allHighlights.addAll(this.typeSpecificHighlightedTags);
            }
            if (this.highlightedTags != null) {
                for (List<Object> highlights : this.highlightedTags.values()) {
                    allHighlights.addAll(highlights);
                }
            }
            for (int i = 0; i < allHighlights.size(); ++i) {
                this.highlighter.removeHighlight(allHighlights.get(i));
            }
            this.highlightedTags = null;
            this.typeSpecificHighlightedTags = null;
            return;
        }
        if (this.popupWindow != null && this.popupWindow.isVisible()) {
            this.popupWindow.setVisible(false);
        }
        allHighlights = new ArrayList<Object>();
        if (this.typeSpecificHighlightedTags != null) {
            allHighlights.addAll(this.typeSpecificHighlightedTags);
        }
        if (this.highlightedTags != null) {
            for (List<Object> highlights : this.highlightedTags.values()) {
                allHighlights.addAll(highlights);
            }
        }
        for (int i = 0; i < allHighlights.size(); ++i) {
            this.highlighter.removeHighlight(allHighlights.get(i));
        }
        this.highlightedTags = null;
        this.typeSpecificHighlightedTags = null;
        if (currentAnnotSet != null) {
            this.annotSets.setSelectedItem(currentAnnotSet);
            this.currentSelections = this.selectionChainsMap.get(currentAnnotSet);
            this.currentColors = this.colorChainsMap.get(currentAnnotSet);
            this.highlightAnnotations();
            this.showAnnotations.setSelected(currentShowAnnotationStatus);
            if (currentAnnotType != null) {
                this.annotTypes.setSelectedItem(currentAnnotType);
            } else if (this.annotTypes.getModel().getSize() > 0) {
                this.annotTypes.setSelectedIndex(0);
            }
        } else {
            this.explicitCall = false;
            this.annotSets.setSelectedIndex(0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.annotSets) {
            if (!this.explicitCall) {
                this.annotSetSelectionChanged();
            }
        } else if (ae.getSource() == this.showAnnotations) {
            if (!this.explicitCall) {
                this.showTypeWiseAnnotations();
            }
        } else if (ae.getSource() == this.annotTypes && !this.explicitCall) {
            if (this.typeSpecificHighlightedTags != null) {
                for (int i = 0; i < this.typeSpecificHighlightedTags.size(); ++i) {
                    this.highlighter.removeHighlight(this.typeSpecificHighlightedTags.get(i));
                }
            }
            this.typeSpecificHighlightedTags = null;
            this.showTypeWiseAnnotations();
        }
    }

    private void showTypeWiseAnnotations() {
        if (this.typeSpecificHighlightedTags == null) {
            this.highlightedTypeAnnots = new ArrayList<Annotation>();
            this.typeSpecificHighlightedTags = new ArrayList<Object>();
        }
        if (this.showAnnotations.isSelected()) {
            AnnotationSet set = this.getAnnotationSet((String)this.annotSets.getSelectedItem());
            String type = (String)this.annotTypes.getSelectedItem();
            if (type == null) {
                try {
                    JOptionPane.showMessageDialog(MainFrame.getInstance(), "No annotation type found to display");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.showAnnotations.setSelected(false);
                return;
            }
            Color color = AnnotationSetsView.getColor(this.getAnnotationSet((String)this.annotSets.getSelectedItem()).getName(), type);
            if (type != null) {
                AnnotationSet typeSet = set.get(type);
                for (Annotation ann : typeSet) {
                    this.highlightedTypeAnnots.add(ann);
                    try {
                        this.typeSpecificHighlightedTags.add(this.highlighter.addHighlight(ann.getStartNode().getOffset().intValue(), ann.getEndNode().getOffset().intValue(), new DefaultHighlighter.DefaultHighlightPainter(color)));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            for (int i = 0; i < this.typeSpecificHighlightedTags.size(); ++i) {
                this.highlighter.removeHighlight(this.typeSpecificHighlightedTags.get(i));
            }
            this.typeSpecificHighlightedTags = new ArrayList<Object>();
            this.highlightedTypeAnnots = new ArrayList<Annotation>();
            this.highlightedTypeAnnotsOffsets = null;
        }
        Collections.sort(this.highlightedTypeAnnots, new OffsetComparator());
        this.highlightedTypeAnnotsOffsets = new int[this.highlightedTypeAnnots.size() * 2];
        int i = 0;
        for (int j = 0; j < this.highlightedTypeAnnots.size(); ++j) {
            Annotation ann1 = this.highlightedTypeAnnots.get(j);
            this.highlightedTypeAnnotsOffsets[i] = ann1.getStartNode().getOffset().intValue();
            this.highlightedTypeAnnotsOffsets[i + 1] = ann1.getEndNode().getOffset().intValue();
            i += 2;
        }
    }

    private AnnotationSet getAnnotationSet(String annotSet) {
        return annotSet.equals(DEFAULT_ANNOTSET_NAME) ? this.document.getAnnotations() : this.document.getAnnotations(annotSet);
    }

    private void annotSetSelectionChanged() {
        if (this.annotSets.getModel().getSize() == 0) {
            if (this.popupWindow != null && this.popupWindow.isVisible()) {
                this.popupWindow.setVisible(false);
            }
            this.corefTree.setVisible(false);
            return;
        }
        final String currentAnnotSet = this.annotSets.getSelectedItem() != null ? (String)this.annotSets.getSelectedItem() : this.annotSets.getItemAt(0);
        AnnotationSet temp = this.getAnnotationSet(currentAnnotSet);
        Set<String> types = temp.getAllTypes();
        this.annotTypesModel = new DefaultComboBoxModel();
        if (types != null) {
            this.annotTypesModel = new DefaultComboBoxModel<String>(types.toArray(new String[types.size()]));
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CorefTreeNode annotSetNode;
                CorefEditor.this.annotTypes.setModel(CorefEditor.this.annotTypesModel);
                CorefEditor.this.annotTypes.updateUI();
                if (CorefEditor.this.rootNode.getChildCount() > 0) {
                    CorefEditor.this.rootNode.removeAllChildren();
                }
                if ((annotSetNode = (CorefTreeNode)CorefEditor.this.corefAnnotationSetNodesMap.get(currentAnnotSet)) != null) {
                    CorefEditor.this.rootNode.add(annotSetNode);
                    CorefEditor.this.currentSelections = (Map)CorefEditor.this.selectionChainsMap.get(currentAnnotSet);
                    CorefEditor.this.currentColors = (Map)CorefEditor.this.colorChainsMap.get(currentAnnotSet);
                    if (!CorefEditor.this.corefTree.isVisible()) {
                        if (CorefEditor.this.popupWindow != null && CorefEditor.this.popupWindow.isVisible()) {
                            CorefEditor.this.popupWindow.setVisible(false);
                        }
                        CorefEditor.this.corefTree.setVisible(true);
                    }
                    CorefEditor.this.corefTree.repaint();
                    CorefEditor.this.corefTree.updateUI();
                } else {
                    CorefEditor.this.corefTree.setVisible(false);
                }
            }
        });
    }

    private void initData() {
        Map<String, AnnotationSet> annotSets;
        this.rootNode = new CorefTreeNode("Co-reference Data", true, 0);
        this.corefChains = new HashMap<CorefTreeNode, Map<CorefTreeNode, List<Integer>>>();
        this.selectionChainsMap = new HashMap<String, Map<String, Boolean>>();
        this.currentSelections = new HashMap<String, Boolean>();
        this.colorChainsMap = new HashMap<String, Map<String, Color>>();
        this.currentColors = new HashMap<String, Color>();
        this.corefAnnotationSetNodesMap = new HashMap<String, CorefTreeNode>();
        CorefTreeNode annotSetNode = this.createChain(this.document.getAnnotations(), true);
        if (annotSetNode != null) {
            this.corefAnnotationSetNodesMap.put(DEFAULT_ANNOTSET_NAME, annotSetNode);
        }
        if ((annotSets = this.document.getNamedAnnotationSets()) != null) {
            for (String annotSetName : annotSets.keySet()) {
                annotSetNode = this.createChain(this.document.getAnnotations(annotSetName), false);
                if (annotSetNode == null) continue;
                this.corefAnnotationSetNodesMap.put(annotSetName, annotSetNode);
            }
        }
    }

    private CorefTreeNode createAnnotSetNode(AnnotationSet set, boolean isDefaultSet) {
        String setName = isDefaultSet ? DEFAULT_ANNOTSET_NAME : set.getName();
        CorefTreeNode annotSetNode = new CorefTreeNode(setName, true, 1);
        boolean found = false;
        for (int i = 0; i < this.annotSets.getModel().getSize(); ++i) {
            if (!((String)this.annotSets.getModel().getElementAt(i)).equals(setName)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.explicitCall = true;
            this.annotSets.addItem(setName);
            this.explicitCall = false;
        }
        HashMap chainLinks = new HashMap();
        HashMap selectionMap = new HashMap();
        HashMap colorMap = new HashMap();
        this.corefChains.put(annotSetNode, chainLinks);
        this.selectionChainsMap.put(setName, selectionMap);
        this.colorChainsMap.put(setName, colorMap);
        return annotSetNode;
    }

    private CorefTreeNode createChain(AnnotationSet set, boolean isDefaultSet) {
        String setName = isDefaultSet ? DEFAULT_ANNOTSET_NAME : set.getName();
        CorefTreeNode annotSetNode = new CorefTreeNode(setName, true, 1);
        boolean found = false;
        for (int i = 0; i < this.annotSets.getModel().getSize(); ++i) {
            if (!((String)this.annotSets.getModel().getElementAt(i)).equals(setName)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.explicitCall = true;
            this.annotSets.addItem(setName);
            this.explicitCall = false;
        }
        HashMap<CorefTreeNode, ArrayList<Integer>> chainLinks = new HashMap<CorefTreeNode, ArrayList<Integer>>();
        HashMap<String, Boolean> selectionMap = new HashMap<String, Boolean>();
        HashMap<String, Color> colorMap = new HashMap<String, Color>();
        Map matchesMap = null;
        Object matchesMapObject = this.document.getFeatures().get("MatchesAnnots");
        if (matchesMapObject instanceof Map) {
            matchesMap = (Map)matchesMapObject;
        }
        if (matchesMap == null) {
            this.corefChains.put(annotSetNode, chainLinks);
            this.selectionChainsMap.put(setName, selectionMap);
            this.colorChainsMap.put(setName, colorMap);
            return annotSetNode;
        }
        List matches1 = (List)matchesMap.get(isDefaultSet ? "" : setName);
        if (matches1 == null) {
            this.corefChains.put(annotSetNode, chainLinks);
            this.selectionChainsMap.put(setName, selectionMap);
            this.colorChainsMap.put(setName, colorMap);
            return annotSetNode;
        }
        for (ArrayList<Integer> matches : matches1) {
            if (matches == null) {
                matches = new ArrayList<Integer>();
            }
            if (matches.size() <= 0 || set.size() <= 0) continue;
            String longestString = this.getString(this.findOutTheLongestAnnotation(matches, set));
            CorefTreeNode chainNode = new CorefTreeNode(longestString, false, 2);
            annotSetNode.add(chainNode);
            chainLinks.put(chainNode, matches);
            selectionMap.put(chainNode.toString(), false);
            float[] components = this.colorGenerator.getNextColor().getComponents(null);
            Color color = new Color(components[0], components[1], components[2], 0.5f);
            colorMap.put(chainNode.toString(), color);
        }
        this.corefChains.put(annotSetNode, chainLinks);
        this.selectionChainsMap.put(setName, selectionMap);
        this.colorChainsMap.put(setName, colorMap);
        return annotSetNode;
    }

    public String getString(Annotation ann) {
        return this.document.getContent().toString().substring(ann.getStartNode().getOffset().intValue(), ann.getEndNode().getOffset().intValue()).replaceAll("\\r\\n|\\r|\\n", " ");
    }

    public void removeChainReference(Annotation annot, CorefTreeNode chainHead) {
        int index;
        List<Integer> ids = this.corefChains.get(this.corefAnnotationSetNodesMap.get(this.annotSets.getSelectedItem())).get(chainHead);
        String currentSet = (String)this.annotSets.getSelectedItem();
        currentSet = currentSet.equals(DEFAULT_ANNOTSET_NAME) ? "" : currentSet;
        HashMap matchesMap = null;
        ArrayList<List<Integer>> matches = null;
        Object matchesMapObject = this.document.getFeatures().get("MatchesAnnots");
        if (matchesMapObject instanceof Map) {
            matchesMap = (HashMap)matchesMapObject;
            matches = (ArrayList<List<Integer>>)matchesMap.get(currentSet);
        } else {
            matchesMap = new HashMap();
        }
        if (matches == null) {
            matches = new ArrayList<List<Integer>>();
        }
        if ((index = matches.indexOf(ids)) != -1) {
            ids.remove(annot.getId());
            matches.set(index, ids);
            matchesMap.put(currentSet, matches);
            this.document.getFeatures().put("MatchesAnnots", matchesMap);
        }
    }

    private CorefTreeNode findOutTheChainHead(Annotation ann, String set) {
        Map<CorefTreeNode, List<Integer>> chains = this.corefChains.get(this.corefAnnotationSetNodesMap.get(set));
        if (chains == null) {
            return null;
        }
        for (CorefTreeNode head : chains.keySet()) {
            if (!chains.get(head).contains(ann.getId())) continue;
            return head;
        }
        return null;
    }

    public void highlightAnnotations() {
        if (this.highlightedTags == null) {
            this.highlightedTags = new HashMap<CorefTreeNode, List<Object>>();
            this.highlightedChainAnnots = new ArrayList<Annotation>();
        }
        AnnotationSet annotSet = this.getAnnotationSet((String)this.annotSets.getSelectedItem());
        CorefTreeNode annotSetNode = this.corefAnnotationSetNodesMap.get(this.annotSets.getSelectedItem());
        if (annotSetNode == null) {
            return;
        }
        Map<CorefTreeNode, List<Integer>> chainMap = this.corefChains.get(annotSetNode);
        for (CorefTreeNode currentNode : chainMap.keySet()) {
            Annotation ann;
            int i;
            if (this.currentSelections.get(currentNode.toString()).booleanValue()) {
                if (this.highlightedTags.containsKey(currentNode)) continue;
                List<Integer> ids = chainMap.get(currentNode);
                ArrayList<Object> highlighTag = new ArrayList<Object>();
                if (ids == null) continue;
                for (i = 0; i < ids.size(); ++i) {
                    ann = annotSet.get(ids.get(i));
                    this.highlightedChainAnnots.add(ann);
                    Color color = this.currentColors.get(currentNode.toString());
                    try {
                        highlighTag.add(this.highlighter.addHighlight(ann.getStartNode().getOffset().intValue(), ann.getEndNode().getOffset().intValue(), new DefaultHighlighter.DefaultHighlightPainter(color)));
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.highlightedTags.put(currentNode, highlighTag);
                continue;
            }
            if (!this.highlightedTags.containsKey(currentNode)) continue;
            List<Object> highlights = this.highlightedTags.get(currentNode);
            for (int i2 = 0; i2 < highlights.size(); ++i2) {
                this.highlighter.removeHighlight(highlights.get(i2));
            }
            this.highlightedTags.remove(currentNode);
            List<Integer> ids = chainMap.get(currentNode);
            if (ids == null) continue;
            for (i = 0; i < ids.size(); ++i) {
                ann = annotSet.get(ids.get(i));
                this.highlightedChainAnnots.remove(ann);
            }
        }
        Collections.sort(this.highlightedChainAnnots, new OffsetComparator());
        this.highlightedChainAnnotsOffsets = new int[this.highlightedChainAnnots.size() * 2];
        int i = 0;
        for (int j = 0; j < this.highlightedChainAnnots.size(); ++j) {
            Annotation ann1 = this.highlightedChainAnnots.get(j);
            this.highlightedChainAnnotsOffsets[i] = ann1.getStartNode().getOffset().intValue();
            this.highlightedChainAnnotsOffsets[i + 1] = ann1.getEndNode().getOffset().intValue();
            i += 2;
        }
    }

    @Override
    protected void registerHooks() {
        this.textPane.addMouseListener(this.textPaneMouseListener);
        this.textPane.addMouseMotionListener(this.textPaneMouseListener);
    }

    @Override
    protected void unregisterHooks() {
        this.textPane.removeMouseListener(this.textPaneMouseListener);
        this.textPane.removeMouseMotionListener(this.textPaneMouseListener);
    }

    @Override
    public Component getGUI() {
        return this.mainPanel;
    }

    @Override
    public int getType() {
        return 1;
    }

    public void mouseClicked(MouseEvent me) {
        if (this.popupWindow != null && this.popupWindow.isVisible()) {
            this.popupWindow.setVisible(false);
        }
    }

    public CorefTreeNode findOutChainNode(String chainNodeString, String set) {
        if (this.corefChains == null || this.corefAnnotationSetNodesMap == null) {
            return null;
        }
        Map<CorefTreeNode, List<Integer>> chains = this.corefChains.get(this.corefAnnotationSetNodesMap.get(set));
        if (chains == null) {
            return null;
        }
        for (CorefTreeNode currentNode : chains.keySet()) {
            if (!currentNode.toString().equals(chainNodeString)) continue;
            return currentNode;
        }
        return null;
    }

    protected class CorefTreeCellRenderer
    extends JPanel
    implements TreeCellRenderer {
        private JCheckBox check;
        private JLabel label;

        public CorefTreeCellRenderer() {
            this.setOpaque(true);
            this.check = new JCheckBox();
            this.check.setBackground(Color.white);
            this.label = new JLabel();
            this.setLayout(new BorderLayout(5, 10));
            this.add((Component)this.check, "West");
            this.add((Component)this.label, "Center");
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            CorefTreeNode userObject = (CorefTreeNode)value;
            this.label.setText(userObject.toString());
            this.setSize(this.label.getWidth(), this.label.getFontMetrics(this.label.getFont()).getHeight() * 2);
            tree.expandRow(row);
            if (userObject.getType() == 0 || userObject.getType() == 1) {
                this.setBackground(Color.white);
                this.check.setVisible(false);
                return this;
            }
            this.setBackground((Color)CorefEditor.this.currentColors.get(userObject.toString()));
            this.check.setVisible(true);
            this.check.setBackground(Color.white);
            boolean selected = (Boolean)CorefEditor.this.currentSelections.get(userObject.toString());
            this.check.setSelected(selected);
            return this;
        }
    }

    protected class CorefTreeMouseListener
    extends MouseAdapter {
        protected CorefTreeMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent me) {
        }

        @Override
        public void mouseReleased(MouseEvent me) {
        }

        @Override
        public void mousePressed(MouseEvent me) {
            if (CorefEditor.this.popupWindow != null && CorefEditor.this.popupWindow.isVisible()) {
                CorefEditor.this.popupWindow.setVisible(false);
            }
            CorefEditor.this.textPane.removeAll();
            int x = me.getX();
            int y = me.getY();
            int row = CorefEditor.this.corefTree.getRowForLocation(x, y);
            TreePath path = CorefEditor.this.corefTree.getPathForRow(row);
            if (path != null) {
                final CorefTreeNode node = (CorefTreeNode)path.getLastPathComponent();
                if (node.getType() != 2) {
                    return;
                }
                if (SwingUtilities.isRightMouseButton(me)) {
                    final JPopupMenu popup = new JPopupMenu();
                    JButton delete = new JButton("Delete");
                    delete.setToolTipText("Delete Chain");
                    ToolTipManager.sharedInstance().registerComponent(delete);
                    JButton cancel = new JButton("Close");
                    cancel.setToolTipText("Closes this popup");
                    JButton changeColor = new JButton("Change Color");
                    changeColor.setToolTipText("Changes Color");
                    ToolTipManager.sharedInstance().registerComponent(cancel);
                    ToolTipManager.sharedInstance().registerComponent(changeColor);
                    JPanel panel = new JPanel(new FlowLayout(0));
                    panel.setOpaque(false);
                    panel.add(changeColor);
                    panel.add(delete);
                    panel.add(cancel);
                    popup.setLayout(new BorderLayout());
                    popup.setOpaque(true);
                    popup.setBackground(UIManager.getLookAndFeelDefaults().getColor("ToolTip.background"));
                    popup.add((Component)new JLabel("Chain \"" + node.toString() + "\""), "North");
                    popup.add((Component)panel, "South");
                    changeColor.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            String currentAnnotSet = (String)CorefEditor.this.annotSets.getSelectedItem();
                            CorefEditor.this.currentColors = (Map)CorefEditor.this.colorChainsMap.get(currentAnnotSet);
                            Color colour = (Color)CorefEditor.this.currentColors.get(node.toString());
                            Color col = JColorChooser.showDialog(CorefEditor.this.getGUI(), "Select colour for \"" + node.toString() + "\"", colour);
                            if (col != null) {
                                Color colAlpha = new Color(col.getRed(), col.getGreen(), col.getBlue(), 128);
                                CorefEditor.this.currentColors.put(node.toString(), colAlpha);
                                CorefEditor.this.colorChainsMap.put(currentAnnotSet, CorefEditor.this.currentColors);
                                CorefEditor.this.corefTree.repaint();
                                ArrayList allHighlights = new ArrayList();
                                if (CorefEditor.this.typeSpecificHighlightedTags != null) {
                                    allHighlights.addAll(CorefEditor.this.typeSpecificHighlightedTags);
                                }
                                if (CorefEditor.this.highlightedTags != null) {
                                    for (List highlights : CorefEditor.this.highlightedTags.values()) {
                                        allHighlights.addAll(highlights);
                                    }
                                }
                                for (int i = 0; i < allHighlights.size(); ++i) {
                                    CorefEditor.this.highlighter.removeHighlight(allHighlights.get(i));
                                }
                                CorefEditor.this.highlightedTags = null;
                                CorefEditor.this.highlightAnnotations();
                                CorefEditor.this.typeSpecificHighlightedTags = null;
                                CorefEditor.this.showTypeWiseAnnotations();
                            }
                            popup.setVisible(false);
                        }
                    });
                    delete.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            int index;
                            Map chains = (Map)CorefEditor.this.corefChains.get(CorefEditor.this.corefAnnotationSetNodesMap.get(CorefEditor.this.annotSets.getSelectedItem()));
                            List ids = (List)chains.get(node);
                            String currentSet = (String)CorefEditor.this.annotSets.getSelectedItem();
                            currentSet = currentSet.equals(CorefEditor.DEFAULT_ANNOTSET_NAME) ? "" : currentSet;
                            HashMap matchesMap = null;
                            ArrayList matches = null;
                            Object matchesMapObject = CorefEditor.this.document.getFeatures().get("MatchesAnnots");
                            if (matchesMapObject instanceof Map) {
                                matchesMap = (HashMap)matchesMapObject;
                                matches = (List)matchesMap.get(currentSet);
                            }
                            if (matchesMap == null) {
                                matchesMap = new HashMap();
                            }
                            if (matches == null) {
                                matches = new ArrayList();
                            }
                            if ((index = matches.indexOf(ids)) != -1) {
                                matches.remove(index);
                                matchesMap.put(currentSet, matches);
                                CorefEditor.this.document.getFeatures().put("MatchesAnnots", matchesMap);
                            }
                            popup.setVisible(false);
                        }
                    });
                    cancel.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            popup.setVisible(false);
                        }
                    });
                    popup.setVisible(true);
                    popup.show(CorefEditor.this.corefTree, x, y);
                    return;
                }
                boolean isSelected = (Boolean)CorefEditor.this.currentSelections.get(node.toString()) == false;
                CorefEditor.this.currentSelections.put(node.toString(), isSelected);
                CorefEditor.this.highlightAnnotations();
                CorefEditor.this.corefTree.repaint();
                CorefEditor.this.corefTree.updateUI();
                CorefEditor.this.corefTree.repaint();
                CorefEditor.this.corefTree.updateUI();
            }
        }
    }

    protected class CorefTreeNode
    extends DefaultMutableTreeNode {
        public static final int ROOT_NODE = 0;
        public static final int ANNOTSET_NODE = 1;
        public static final int CHAIN_NODE = 2;
        private int type;

        public CorefTreeNode(Object value, boolean allowsChildren, int type) {
            super(value, allowsChildren);
            this.type = type;
        }

        public int getType() {
            return this.type;
        }
    }

    protected class ChainToolTipAction
    extends AbstractAction {
        int textLocation;
        Point mousePoint;
        JPopupMenu popup = new JPopupMenu();

        public ChainToolTipAction() {
            this.popup.setBackground(UIManager.getLookAndFeelDefaults().getColor("ToolTip.background"));
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            int index = -1;
            if (CorefEditor.this.highlightedChainAnnotsOffsets != null) {
                for (int i = 0; i < CorefEditor.this.highlightedChainAnnotsOffsets.length; i += 2) {
                    if (this.textLocation < CorefEditor.this.highlightedChainAnnotsOffsets[i] || this.textLocation > CorefEditor.this.highlightedChainAnnotsOffsets[i + 1]) continue;
                    index = i == 0 ? i : i / 2;
                    break;
                }
            }
            if (CorefEditor.this.highlightedChainAnnotsOffsets != null && index < CorefEditor.this.highlightedChainAnnotsOffsets.length && index >= 0) {
                if (CorefEditor.this.popupWindow != null && CorefEditor.this.popupWindow.isVisible()) {
                    CorefEditor.this.popupWindow.setVisible(false);
                }
                this.popup.setVisible(false);
                this.popup.removeAll();
                final int tempIndex = index;
                CorefTreeNode chainHead = CorefEditor.this.findOutTheChainHead((Annotation)CorefEditor.this.highlightedChainAnnots.get(index), (String)CorefEditor.this.annotSets.getSelectedItem());
                final HashMap<String, CorefTreeNode> tempMap = new HashMap<String, CorefTreeNode>();
                this.popup.setLayout(new FlowLayout(0));
                if (chainHead != null) {
                    JPanel tempPanel = new JPanel();
                    tempPanel.setLayout(new FlowLayout(0));
                    tempPanel.add(new JLabel(chainHead.toString()));
                    tempPanel.setBackground(UIManager.getLookAndFeelDefaults().getColor("ToolTip.background"));
                    final JButton deleteButton = new JButton("Delete");
                    tempPanel.add(deleteButton);
                    this.popup.add(tempPanel);
                    deleteButton.setActionCommand(chainHead.toString());
                    tempMap.put(chainHead.toString(), chainHead);
                    deleteButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            try {
                                int confirm = JOptionPane.showConfirmDialog(MainFrame.getInstance(), "Are you sure?", "Removing reference...", 0);
                                if (confirm == 0) {
                                    ChainToolTipAction.this.popup.setVisible(false);
                                    CorefEditor.this.removeChainReference((Annotation)CorefEditor.this.highlightedChainAnnots.get(tempIndex), (CorefTreeNode)tempMap.get(deleteButton.getActionCommand()));
                                }
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                            }
                        }
                    });
                }
                this.popup.revalidate();
                if (CorefEditor.this.popupWindow != null && CorefEditor.this.popupWindow.isVisible()) {
                    CorefEditor.this.popupWindow.setVisible(false);
                }
                this.popup.setVisible(true);
                this.popup.show(CorefEditor.this.textPane, (int)this.mousePoint.getX(), (int)this.mousePoint.getY());
            }
        }

        public void setTextLocation(int textLocation) {
            this.textLocation = textLocation;
        }

        public void setMousePointer(Point point) {
            this.mousePoint = point;
        }
    }

    protected class NewCorefAction
    implements ActionListener {
        int textLocation;
        Point mousePoint;
        JLabel label = new JLabel();
        JPanel panel = new JPanel();
        JPanel subPanel = new JPanel();
        String field = "";
        JButton add = new JButton("OK");
        JButton cancel = new JButton("Cancel");
        JComboBox<String> list = new JComboBox();
        JPanel mainPanel = new JPanel();
        JPopupMenu popup1 = new JPopupMenu();
        ListEditor listEditor = null;
        ComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        boolean firstTime = true;

        public NewCorefAction() {
            CorefEditor.this.popupWindow = new JWindow(SwingUtilities.getWindowAncestor(CorefEditor.this.textView.getGUI()));
            CorefEditor.this.popupWindow.setBackground(UIManager.getLookAndFeelDefaults().getColor("ToolTip.background"));
            this.mainPanel.setLayout(new BorderLayout());
            this.mainPanel.setOpaque(true);
            this.mainPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
            this.mainPanel.setBackground(UIManager.getLookAndFeelDefaults().getColor("ToolTip.background"));
            CorefEditor.this.popupWindow.setContentPane(this.mainPanel);
            this.panel.setLayout(new BorderLayout());
            this.panel.setOpaque(false);
            this.panel.add((Component)new JScrollPane(this.list), "Center");
            this.subPanel.setLayout(new FlowLayout(0));
            this.subPanel.add(this.add);
            this.subPanel.add(this.cancel);
            this.subPanel.setOpaque(false);
            this.panel.add((Component)this.subPanel, "South");
            this.mainPanel.add((Component)this.label, "North");
            this.mainPanel.add((Component)this.panel, "Center");
            AddAction action = new AddAction();
            this.add.addActionListener(action);
            this.cancel.addActionListener(action);
            this.listEditor = new ListEditor(action);
            this.list.setMaximumRowCount(5);
            this.list.setEditable(true);
            this.list.setEditor(this.listEditor);
            this.list.setModel(this.model);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            int i;
            int index = -1;
            if (CorefEditor.this.highlightedChainAnnotsOffsets != null) {
                for (i = 0; i < CorefEditor.this.highlightedChainAnnotsOffsets.length; i += 2) {
                    if (this.textLocation < CorefEditor.this.highlightedChainAnnotsOffsets[i] || this.textLocation > CorefEditor.this.highlightedChainAnnotsOffsets[i + 1]) continue;
                    index = i == 0 ? i : i / 2;
                    break;
                }
            }
            if (CorefEditor.this.highlightedChainAnnotsOffsets != null && index < CorefEditor.this.highlightedChainAnnotsOffsets.length && index >= 0) {
                return;
            }
            if (CorefEditor.this.highlightedTypeAnnotsOffsets != null) {
                for (i = 0; i < CorefEditor.this.highlightedTypeAnnotsOffsets.length; i += 2) {
                    if (this.textLocation < CorefEditor.this.highlightedTypeAnnotsOffsets[i] || this.textLocation > CorefEditor.this.highlightedTypeAnnotsOffsets[i + 1]) continue;
                    index = i == 0 ? i : i / 2;
                    break;
                }
            }
            if (CorefEditor.this.highlightedTypeAnnotsOffsets != null && index < CorefEditor.this.highlightedTypeAnnotsOffsets.length && index >= 0) {
                CorefEditor.this.textPane.removeAll();
                CorefEditor.this.annotToConsiderForChain = (Annotation)CorefEditor.this.highlightedTypeAnnots.get(index);
                CorefTreeNode headNode = CorefEditor.this.findOutTheChainHead(CorefEditor.this.annotToConsiderForChain, (String)CorefEditor.this.annotSets.getSelectedItem());
                if (headNode != null) {
                    this.popup1 = new JPopupMenu();
                    this.popup1.setBackground(UIManager.getLookAndFeelDefaults().getColor("ToolTip.background"));
                    JLabel label1 = new JLabel("Annotation co-referenced to : \"" + headNode.toString() + "\"");
                    this.popup1.setLayout(new FlowLayout());
                    this.popup1.add(label1);
                    if (CorefEditor.this.popupWindow != null && CorefEditor.this.popupWindow.isVisible()) {
                        CorefEditor.this.popupWindow.setVisible(false);
                    }
                    this.popup1.setVisible(true);
                    this.popup1.show(CorefEditor.this.textPane, (int)this.mousePoint.getX(), (int)this.mousePoint.getY());
                } else {
                    CorefEditor.this.popupWindow.setVisible(false);
                    ArrayList set = new ArrayList(CorefEditor.this.currentSelections.keySet());
                    Collections.sort(set);
                    set.add(0, "[New Chain]");
                    this.model = new DefaultComboBoxModel<String>(set.toArray(new String[set.size()]));
                    this.list.setModel(this.model);
                    this.listEditor.setItem("");
                    this.label.setText("Add \"" + CorefEditor.this.getString(CorefEditor.this.annotToConsiderForChain) + "\" to ");
                    Point topLeft = CorefEditor.this.textPane.getLocationOnScreen();
                    int x = topLeft.x + (int)this.mousePoint.getX();
                    int y = topLeft.y + (int)this.mousePoint.getY();
                    CorefEditor.this.popupWindow.setLocation(x, y);
                    if (this.popup1.isVisible()) {
                        this.popup1.setVisible(false);
                    }
                    CorefEditor.this.popupWindow.pack();
                    CorefEditor.this.popupWindow.setVisible(true);
                    this.listEditor.requestFocus();
                    if (this.firstTime) {
                        this.firstTime = false;
                        CorefEditor.this.popupWindow.pack();
                        CorefEditor.this.popupWindow.repaint();
                        this.listEditor.requestFocus();
                    }
                }
            }
        }

        public void setTextLocation(int textLocation) {
            this.textLocation = textLocation;
        }

        public void setMousePointer(Point point) {
            this.mousePoint = point;
        }

        private class AddAction
        extends AbstractAction {
            private AddAction() {
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (ae.getSource() == NewCorefAction.this.cancel) {
                    CorefEditor.this.popupWindow.setVisible(false);
                    return;
                }
                if (ae.getSource() == NewCorefAction.this.add) {
                    int index;
                    String currentSet;
                    ArrayList<List> matches;
                    if (NewCorefAction.this.field.length() == 0) {
                        try {
                            JOptionPane.showMessageDialog(MainFrame.getInstance(), "No Chain Selected", "New Chain - Error", 0);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        return;
                    }
                    Annotation ann = CorefEditor.this.annotToConsiderForChain;
                    if (ann == null) {
                        return;
                    }
                    if (NewCorefAction.this.field.equals("[New Chain]")) {
                        CorefTreeNode chainNode = CorefEditor.this.findOutChainNode(CorefEditor.this.getString(ann), (String)CorefEditor.this.annotSets.getSelectedItem());
                        if (chainNode != null) {
                            try {
                                JOptionPane.showMessageDialog(MainFrame.getInstance(), "Chain with " + CorefEditor.this.getString(ann) + " title already exists", "New Chain - Error", 0);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            return;
                        }
                        CorefEditor.this.popupWindow.setVisible(false);
                        String currentSet2 = (String)CorefEditor.this.annotSets.getSelectedItem();
                        currentSet2 = currentSet2.equals(CorefEditor.DEFAULT_ANNOTSET_NAME) ? "" : currentSet2;
                        HashMap matchesMap = null;
                        Object matchesMapObject = CorefEditor.this.document.getFeatures().get("MatchesAnnots");
                        if (matchesMapObject instanceof Map) {
                            matchesMap = (HashMap)matchesMapObject;
                        }
                        if (matchesMap == null) {
                            matchesMap = new HashMap();
                        }
                        ArrayList matches2 = (ArrayList)matchesMap.get(currentSet2);
                        ArrayList<Integer> tempList = new ArrayList<Integer>();
                        tempList.add(ann.getId());
                        if (matches2 == null) {
                            matches2 = new ArrayList();
                        }
                        matches2.add(tempList);
                        matchesMap.put(currentSet2, matches2);
                        CorefEditor.this.document.getFeatures().put("MatchesAnnots", matchesMap);
                        return;
                    }
                    CorefTreeNode chainNode = CorefEditor.this.findOutChainNode(NewCorefAction.this.field, (String)CorefEditor.this.annotSets.getSelectedItem());
                    Map chains = (Map)CorefEditor.this.corefChains.get(CorefEditor.this.corefAnnotationSetNodesMap.get(CorefEditor.this.annotSets.getSelectedItem()));
                    if (chainNode == null) {
                        try {
                            JOptionPane.showMessageDialog(MainFrame.getInstance(), "Incorrect Chain Title", "New Chain - Error", 0);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        return;
                    }
                    CorefEditor.this.popupWindow.setVisible(false);
                    List ids = (List)chains.get(chainNode);
                    HashMap matchesMap = null;
                    Object matchesMapObject = CorefEditor.this.document.getFeatures().get("MatchesAnnots");
                    if (matchesMapObject instanceof Map) {
                        matchesMap = (HashMap)matchesMapObject;
                    }
                    if (matchesMap == null) {
                        matchesMap = new HashMap();
                    }
                    if ((matches = (ArrayList<List>)matchesMap.get(currentSet = (currentSet = (String)CorefEditor.this.annotSets.getSelectedItem()).equals(CorefEditor.DEFAULT_ANNOTSET_NAME) ? "" : currentSet)) == null) {
                        matches = new ArrayList<List>();
                    }
                    if ((index = matches.indexOf(ids)) != -1) {
                        List tempIds = (List)matches.get(index);
                        tempIds.add(ann.getId());
                        matches.set(index, tempIds);
                        matchesMap.put(currentSet, matches);
                        CorefEditor.this.document.getFeatures().put("MatchesAnnots", matchesMap);
                    }
                    return;
                }
            }
        }

        private class ListEditor
        extends KeyAdapter
        implements ComboBoxEditor {
            JTextField myField = new JTextField(20);
            AddAction action = null;
            Vector<String> myList = new Vector();

            public ListEditor(AddAction action) {
                this.action = action;
                this.myField.addKeyListener(this);
            }

            @Override
            public void addActionListener(ActionListener al) {
                this.myField.addActionListener(al);
            }

            @Override
            public void removeActionListener(ActionListener al) {
                this.myField.removeActionListener(al);
            }

            @Override
            public Component getEditorComponent() {
                return this.myField;
            }

            @Override
            public Object getItem() {
                return this.myField.getText();
            }

            @Override
            public void selectAll() {
                if (this.myField.getText() != null && this.myField.getText().length() > 0) {
                    this.myField.setSelectionStart(0);
                    this.myField.setSelectionEnd(this.myField.getText().length());
                }
            }

            @Override
            public void setItem(Object item) {
                this.myField.setText((String)item);
                NewCorefAction.this.field = this.myField.getText();
            }

            public void requestFocus() {
                this.myField.requestFocus();
            }

            @Override
            public void keyReleased(KeyEvent ke) {
                if (this.myField.getText() == null) {
                    this.myField.setText("");
                    NewCorefAction.this.field = this.myField.getText();
                }
                if (ke.getKeyCode() == 40) {
                    if (this.myList.size() == 1) {
                        this.myField.setText(this.myList.get(0));
                    } else if (NewCorefAction.this.list.getSelectedIndex() < NewCorefAction.this.list.getModel().getSize() - 1) {
                        NewCorefAction.this.list.setSelectedIndex(NewCorefAction.this.list.getSelectedIndex());
                        this.myField.setText((String)NewCorefAction.this.list.getSelectedItem());
                    }
                    NewCorefAction.this.field = this.myField.getText();
                    this.myField.requestFocus();
                    return;
                }
                if (ke.getKeyCode() == 38) {
                    if (NewCorefAction.this.list.getSelectedIndex() > 0) {
                        NewCorefAction.this.list.setSelectedIndex(NewCorefAction.this.list.getSelectedIndex());
                    }
                    this.myField.setText((String)NewCorefAction.this.list.getSelectedItem());
                    NewCorefAction.this.field = this.myField.getText();
                    return;
                }
                if (ke.getKeyCode() == 10) {
                    NewCorefAction.this.field = this.myField.getText();
                    this.action.actionPerformed(new ActionEvent(NewCorefAction.this.add, 1001, "add"));
                    return;
                }
                if (!(ke.getKeyCode() == 8 || Character.isJavaIdentifierPart(ke.getKeyChar()) || Character.isSpaceChar(ke.getKeyChar()) || Character.isDefined(ke.getKeyChar()))) {
                    return;
                }
                String startWith = this.myField.getText();
                this.myList = new Vector();
                ArrayList set = new ArrayList(CorefEditor.this.currentSelections.keySet());
                Collections.sort(set);
                set.add(0, "[New Chain]");
                boolean first = true;
                for (int i = 0; i < set.size(); ++i) {
                    String currString = (String)set.get(i);
                    if (!currString.toLowerCase().startsWith(startWith.toLowerCase())) continue;
                    if (first) {
                        this.myField.setText(currString.substring(0, startWith.length()));
                        first = false;
                    }
                    this.myList.add(currString);
                }
                DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(this.myList);
                NewCorefAction.this.list.setModel(model);
                this.myField.setText(startWith);
                NewCorefAction.this.field = this.myField.getText();
                NewCorefAction.this.list.showPopup();
            }
        }
    }

    protected class TextPaneMouseListener
    extends MouseInputAdapter {
        public TextPaneMouseListener() {
            CorefEditor.this.chainToolTipTimer.setRepeats(false);
            CorefEditor.this.newCorefActionTimer.setRepeats(false);
        }

        @Override
        public void mouseMoved(MouseEvent me) {
            int textLocation = CorefEditor.this.textPane.viewToModel(me.getPoint());
            CorefEditor.this.chainToolTipAction.setTextLocation(textLocation);
            CorefEditor.this.chainToolTipAction.setMousePointer(me.getPoint());
            CorefEditor.this.chainToolTipTimer.restart();
            CorefEditor.this.newCorefAction.setTextLocation(textLocation);
            CorefEditor.this.newCorefAction.setMousePointer(me.getPoint());
            CorefEditor.this.newCorefActionTimer.restart();
        }
    }
}

