/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;

public class Splash
extends JDialog {
    public Splash(Window owner, GraphicsConfiguration gc, JComponent content) {
        super(owner, "About...", Dialog.ModalityType.APPLICATION_MODAL, gc);
        this.getContentPane().setLayout(new BorderLayout());
        content.setBorder(BorderFactory.createEtchedBorder(0));
        this.getContentPane().add((Component)content, "Center");
        content.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Splash.this.setVisible(false);
            }
        });
        this.validate();
        this.pack();
    }

    public Splash(Window owner, JComponent content) {
        this(owner, null, content);
    }

    public Splash(String imageResourcePath) {
        this((Window)null, imageResourcePath);
    }

    public Splash(JComponent content) {
        this(null, content);
    }

    public Splash(Window owner, String imageResourcePath) {
        this(owner, new JLabel(new ImageIcon(Splash.class.getResource(imageResourcePath))));
    }

    public void showSplash() {
        Point ownerLocation;
        Dimension ownerSize;
        Rectangle screenBounds = this.getGraphicsConfiguration().getBounds();
        if (this.getOwner() == null) {
            ownerSize = screenBounds.getSize();
            ownerLocation = screenBounds.getLocation();
        } else {
            ownerSize = this.getOwner().getSize();
            ownerLocation = this.getOwner().getLocation();
            if (ownerSize.height == 0 || ownerSize.width == 0 || !this.getOwner().isVisible()) {
                ownerSize = screenBounds.getSize();
                ownerLocation = screenBounds.getLocation();
            }
        }
        Dimension frameSize = this.getSize();
        if (frameSize.height > ownerSize.height) {
            frameSize.height = ownerSize.height;
        }
        if (frameSize.width > ownerSize.width) {
            frameSize.width = ownerSize.width;
        }
        this.setLocation(ownerLocation.x + (ownerSize.width - frameSize.width) / 2, ownerLocation.y + (ownerSize.height - frameSize.height) / 2);
        super.setVisible(true);
    }
}

