/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Controller;
import gate.Corpus;
import gate.CorpusController;
import gate.Gate;
import gate.LanguageResource;
import gate.ProcessingResource;
import gate.Resource;
import gate.VisualResource;
import gate.creole.AbstractVisualResource;
import gate.creole.AnalyserRunningStrategy;
import gate.creole.ConditionalController;
import gate.creole.ConditionalSerialAnalyserController;
import gate.creole.ExecutionException;
import gate.creole.ExecutionInterruptedException;
import gate.creole.Parameter;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.creole.RunningStrategy;
import gate.creole.SerialAnalyserController;
import gate.creole.SerialController;
import gate.creole.metadata.CreoleResource;
import gate.creole.metadata.GuiType;
import gate.event.ControllerEvent;
import gate.event.ControllerListener;
import gate.event.CreoleEvent;
import gate.event.CreoleListener;
import gate.event.ProgressListener;
import gate.event.StatusListener;
import gate.gui.ActionsPublisher;
import gate.gui.Handle;
import gate.gui.MainFrame;
import gate.gui.ResourceParametersEditor;
import gate.gui.ResourceRenderer;
import gate.swing.XJPopupMenu;
import gate.swing.XJTable;
import gate.util.Benchmark;
import gate.util.Err;
import gate.util.GateException;
import gate.util.GateRuntimeException;
import gate.util.NameComparator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.border.TitledBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

@CreoleResource(name="Serial Application Editor", guiType=GuiType.LARGE, resourceDisplayed="gate.creole.SerialController", mainViewer=true)
public class SerialControllerEditor
extends AbstractVisualResource
implements CreoleListener,
ControllerListener,
ActionsPublisher {
    protected SerialController controller;
    protected List<Action> actionList;
    protected XJTable loadedPRsTable;
    protected LoadedPRsTableModel loadedPRsTableModel;
    protected XJTable memberPRsTable;
    protected MemberPRsTableModel memberPRsTableModel;
    protected JButton addButton;
    protected JButton removeButton;
    protected JButton moveUpButton;
    protected JButton moveDownButton;
    protected ResourceParametersEditor parametersEditor;
    protected JPanel parametersPanel;
    protected TitledBorder parametersBorder;
    protected JPanel strategyPanel;
    protected TitledBorder strategyBorder;
    protected JRadioButton yes_RunRBtn;
    protected JRadioButton no_RunRBtn;
    protected JRadioButton conditional_RunRBtn;
    protected ButtonGroup runBtnGrp;
    protected JTextField featureNameTextField;
    protected JTextField featureValueTextField;
    protected JComboBox corpusCombo;
    protected CorporaComboModel corpusComboModel;
    protected RunAction runAction;
    protected boolean corpusControllerMode = false;
    protected boolean analyserMode = false;
    protected boolean conditionalMode = false;
    protected ProcessingResource selectedPR = null;
    protected RunningStrategy selectedPRRunStrategy = null;
    private transient Vector<StatusListener> statusListeners;
    private transient Vector<ProgressListener> progressListeners;
    private AddPRAction addPRAction;
    private RemovePRAction removePRAction;

    public static void clearAllSelections() {
        List<VisualResource> controllerEditors = Gate.getCreoleRegister().getVrInstances("gate.gui.SerialControllerEditor");
        if (controllerEditors != null) {
            for (Resource resource : controllerEditors) {
                ((SerialControllerEditor)resource).refreshPRLists();
            }
        }
    }

    @Override
    public void setTarget(Object target) {
        if (!(target instanceof SerialController)) {
            throw new IllegalArgumentException("gate.gui.ApplicationViewer can only be used for serial controllers\n" + target.getClass().toString() + " is not a gate.creole.SerialController!");
        }
        if (this.controller != null) {
            this.controller.removeControllerListener(this);
        }
        this.controller = (SerialController)target;
        this.controller.addControllerListener(this);
        this.corpusControllerMode = this.controller instanceof CorpusController;
        this.analyserMode = this.controller instanceof SerialAnalyserController || this.controller instanceof ConditionalSerialAnalyserController;
        this.conditionalMode = this.controller instanceof ConditionalController;
        this.initLocalData();
        this.initGuiComponents();
        this.initListeners();
        this.loadedPRsTableModel.fireTableDataChanged();
        this.memberPRsTableModel.fireTableDataChanged();
    }

    @Override
    public void setHandle(Handle handle) {
        this.handle = handle;
        this.addStatusListener(handle);
        this.addProgressListener(handle);
    }

    @Override
    public Resource init() throws ResourceInstantiationException {
        super.init();
        return this;
    }

    protected void initLocalData() {
        this.actionList = new ArrayList<Action>();
        this.runAction = new RunAction();
        this.actionList.add(null);
        this.actionList.add(this.runAction);
        this.addPRAction = new AddPRAction();
        this.removePRAction = new RemovePRAction();
    }

    protected void initGuiComponents() {
        this.setLayout(new BorderLayout());
        JPanel topSplit = new JPanel();
        topSplit.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.gridy = 0;
        this.loadedPRsTableModel = new LoadedPRsTableModel();
        this.loadedPRsTable = new XJTable();
        this.loadedPRsTable.setAutoResizeMode(3);
        this.loadedPRsTable.setSortable(false);
        this.loadedPRsTable.setModel(this.loadedPRsTableModel);
        this.loadedPRsTable.setDragEnabled(true);
        this.loadedPRsTable.setDefaultRenderer(ProcessingResource.class, new ResourceRenderer());
        this.loadedPRsTable.setDefaultRenderer(String.class, new DefaultTableCellRenderer(){

            @Override
            public Dimension getMaximumSize() {
                Dimension dim = super.getMaximumSize();
                if (dim != null) {
                    dim.width = Integer.MAX_VALUE;
                    this.setMaximumSize(dim);
                }
                return dim;
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        });
        final int width1 = new JLabel((String)"Loaded Processing resources").getPreferredSize().width + 30;
        JScrollPane scroller = new JScrollPane(){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.width = Math.max(dim.width, width1);
                return dim;
            }

            @Override
            public Dimension getMinimumSize() {
                Dimension dim = super.getMinimumSize();
                dim.width = Math.max(dim.width, width1);
                return dim;
            }
        };
        scroller.getViewport().setView(this.loadedPRsTable);
        scroller.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Loaded Processing resources "));
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(0, 0, 0, 5);
        topSplit.add((Component)scroller, constraints);
        this.addButton = new JButton(this.addPRAction);
        this.addButton.setText("");
        this.addButton.setEnabled(false);
        this.removeButton = new JButton(this.removePRAction);
        this.removeButton.setText("");
        this.removeButton.setEnabled(false);
        Box buttonsBox = Box.createVerticalBox();
        buttonsBox.add(Box.createVerticalGlue());
        buttonsBox.add(this.addButton);
        buttonsBox.add(Box.createVerticalStrut(5));
        buttonsBox.add(this.removeButton);
        buttonsBox.add(Box.createVerticalGlue());
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(0, 0, 0, 5);
        topSplit.add((Component)buttonsBox, constraints);
        this.memberPRsTableModel = new MemberPRsTableModel();
        this.memberPRsTable = new XJTable();
        this.memberPRsTable.setSortable(false);
        this.memberPRsTable.setModel(this.memberPRsTableModel);
        this.memberPRsTable.setAutoResizeMode(3);
        this.memberPRsTable.setDefaultRenderer(ProcessingResource.class, new ResourceRenderer());
        this.memberPRsTable.setDefaultRenderer(String.class, new DefaultTableCellRenderer(){

            @Override
            public Dimension getMaximumSize() {
                Dimension dim = super.getMaximumSize();
                if (dim != null) {
                    dim.width = Integer.MAX_VALUE;
                    this.setMaximumSize(dim);
                }
                return dim;
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        });
        this.memberPRsTable.setDefaultRenderer(Icon.class, new IconRenderer());
        this.memberPRsTable.setDragEnabled(true);
        final int width2 = new JLabel((String)"Selected Processing resources").getPreferredSize().width + 30;
        scroller = new JScrollPane(){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.width = Math.max(dim.width, width2);
                return dim;
            }

            @Override
            public Dimension getMinimumSize() {
                Dimension dim = super.getMinimumSize();
                dim.width = Math.max(dim.width, width2);
                return dim;
            }
        };
        scroller.getViewport().setView(this.memberPRsTable);
        scroller.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Selected Processing resources "));
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(0, 0, 0, 5);
        topSplit.add((Component)scroller, constraints);
        this.moveUpButton = new JButton(MainFrame.getIcon("up"));
        this.moveUpButton.setMnemonic(38);
        this.moveUpButton.setToolTipText("Move the selected resources up.");
        this.moveUpButton.setEnabled(false);
        this.moveDownButton = new JButton(MainFrame.getIcon("down"));
        this.moveDownButton.setMnemonic(40);
        this.moveDownButton.setToolTipText("Move the selected resources down.");
        this.moveDownButton.setEnabled(false);
        buttonsBox = Box.createVerticalBox();
        buttonsBox.add(Box.createVerticalGlue());
        buttonsBox.add(this.moveUpButton);
        buttonsBox.add(Box.createVerticalStrut(5));
        buttonsBox.add(this.moveDownButton);
        buttonsBox.add(Box.createVerticalGlue());
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(0, 0, 0, 0);
        topSplit.add((Component)buttonsBox, constraints);
        JPanel bottomSplit = new JPanel();
        bottomSplit.setLayout(new GridBagLayout());
        constraints.gridy = 0;
        if (this.conditionalMode) {
            this.strategyPanel = new JPanel();
            this.strategyPanel.setLayout(new BoxLayout(this.strategyPanel, 0));
            this.strategyPanel.setAlignmentX(0.0f);
            this.runBtnGrp = new ButtonGroup();
            this.yes_RunRBtn = new JRadioButton("Yes", true);
            this.yes_RunRBtn.setHorizontalTextPosition(2);
            this.runBtnGrp.add(this.yes_RunRBtn);
            this.no_RunRBtn = new JRadioButton("No", false);
            this.no_RunRBtn.setHorizontalTextPosition(2);
            this.runBtnGrp.add(this.no_RunRBtn);
            this.conditional_RunRBtn = new JRadioButton("If value of feature", false);
            this.conditional_RunRBtn.setHorizontalTextPosition(2);
            this.runBtnGrp.add(this.conditional_RunRBtn);
            this.featureNameTextField = new JTextField("", 25);
            this.featureNameTextField.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.featureNameTextField.getPreferredSize().height));
            this.featureValueTextField = new JTextField("", 25);
            this.featureValueTextField.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.featureValueTextField.getPreferredSize().height));
            this.strategyPanel.add(new JLabel(MainFrame.getIcon("greenBall")));
            this.strategyPanel.add(this.yes_RunRBtn);
            this.strategyPanel.add(Box.createHorizontalStrut(5));
            this.strategyPanel.add(new JLabel(MainFrame.getIcon("redBall")));
            this.strategyPanel.add(this.no_RunRBtn);
            this.strategyPanel.add(Box.createHorizontalStrut(5));
            this.strategyPanel.add(new JLabel(MainFrame.getIcon("yellowBall")));
            this.strategyPanel.add(this.conditional_RunRBtn);
            this.strategyPanel.add(Box.createHorizontalStrut(5));
            this.strategyPanel.add(this.featureNameTextField);
            this.strategyPanel.add(Box.createHorizontalStrut(5));
            this.strategyPanel.add(new JLabel("is"));
            this.strategyPanel.add(Box.createHorizontalStrut(5));
            this.strategyPanel.add(this.featureValueTextField);
            this.strategyPanel.add(Box.createHorizontalStrut(5));
            this.strategyBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " No processing resource selected... ");
            this.strategyPanel.setBorder(this.strategyBorder);
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            constraints.insets = new Insets(0, 0, 0, 0);
            bottomSplit.add((Component)this.strategyPanel, constraints);
            ++constraints.gridy;
        }
        if (this.corpusControllerMode) {
            this.corpusComboModel = new CorporaComboModel();
            this.corpusCombo = new JComboBox(this.corpusComboModel);
            this.corpusCombo.setRenderer(new ResourceRenderer());
            this.corpusCombo.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.corpusCombo.getPreferredSize().height));
            Corpus corpus = null;
            if (!(this.controller instanceof CorpusController)) {
                throw new GateRuntimeException("Controller editor in corpus controller mode but the target controller is not an CorpusController!");
            }
            corpus = ((CorpusController)((Object)this.controller)).getCorpus();
            if (corpus != null) {
                this.corpusCombo.setSelectedItem(corpus);
            } else if (this.corpusCombo.getModel().getSize() > 1) {
                this.corpusCombo.setSelectedIndex(1);
            } else {
                this.corpusCombo.setSelectedIndex(0);
            }
            JPanel horBox = new JPanel();
            horBox.setLayout(new BoxLayout(horBox, 0));
            horBox.setAlignmentX(0.0f);
            horBox.add(new JLabel("Corpus:"));
            horBox.add(Box.createHorizontalStrut(5));
            horBox.add(this.corpusCombo);
            horBox.add(Box.createHorizontalStrut(5));
            constraints.weightx = 1.0;
            constraints.anchor = 17;
            constraints.fill = 1;
            constraints.weighty = 0.0;
            constraints.insets = new Insets(0, 0, 0, 0);
            bottomSplit.add((Component)horBox, constraints);
            constraints.gridwidth = 1;
            ++constraints.gridy;
        }
        this.parametersPanel = new JPanel();
        this.parametersPanel.setLayout(new BoxLayout(this.parametersPanel, 1));
        this.parametersPanel.setAlignmentX(0.0f);
        this.parametersBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " No selected processing resource ");
        this.parametersPanel.setBorder(this.parametersBorder);
        this.parametersEditor = new ResourceParametersEditor();
        this.parametersEditor.init(null, null);
        this.parametersPanel.add(new JScrollPane(this.parametersEditor));
        constraints.weighty = 1.0;
        constraints.weightx = 1.0;
        constraints.anchor = 10;
        constraints.fill = 1;
        constraints.insets = new Insets(0, 0, 0, 0);
        bottomSplit.add((Component)this.parametersPanel, constraints);
        ++constraints.gridy;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 10;
        bottomSplit.add((Component)new JButton(this.runAction), constraints);
        final JSplitPane splitPane = new JSplitPane(0, topSplit, bottomSplit);
        splitPane.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorAdded(AncestorEvent event) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        splitPane.setDividerLocation(0.5);
                    }
                });
                splitPane.removeAncestorListener(this);
            }
        });
        this.add((Component)splitPane, "Center");
    }

    protected void initListeners() {
        Gate.getCreoleRegister().addCreoleListener(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.processMouseEvent(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.processMouseEvent(e);
            }

            protected void processMouseEvent(MouseEvent e) {
                if (e.isPopupTrigger() && SerialControllerEditor.this.handle != null && SerialControllerEditor.this.handle.getPopup() != null) {
                    SerialControllerEditor.this.handle.getPopup().show(SerialControllerEditor.this, e.getX(), e.getY());
                }
            }
        });
        this.moveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] rows = SerialControllerEditor.this.memberPRsTable.getSelectedRows();
                if (rows == null || rows.length == 0) {
                    JOptionPane.showMessageDialog(SerialControllerEditor.this, "Please select some components to be moved from the list of used components!\n", "GATE", 0);
                } else {
                    Arrays.sort(rows);
                    for (int row : rows) {
                        if (row <= 0) continue;
                        ArrayList<RunningStrategy> strategies = null;
                        if (SerialControllerEditor.this.conditionalMode) {
                            strategies = new ArrayList<RunningStrategy>(((ConditionalController)((Object)SerialControllerEditor.this.controller)).getRunningStrategies());
                            RunningStrategy straegy = (RunningStrategy)strategies.remove(row);
                            strategies.add(row - 1, straegy);
                        }
                        ProcessingResource value = SerialControllerEditor.this.controller.remove(row);
                        SerialControllerEditor.this.controller.add(row - 1, value);
                        if (!SerialControllerEditor.this.conditionalMode) continue;
                        ((ConditionalController)((Object)SerialControllerEditor.this.controller)).setRunningStrategies(strategies);
                    }
                    for (int row : rows) {
                        int newRow = row > 0 ? row - 1 : row;
                        SerialControllerEditor.this.memberPRsTable.addRowSelectionInterval(newRow, newRow);
                    }
                    SerialControllerEditor.this.memberPRsTable.requestFocusInWindow();
                }
            }
        });
        this.moveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] rows = SerialControllerEditor.this.memberPRsTable.getSelectedRows();
                if (rows == null || rows.length == 0) {
                    JOptionPane.showMessageDialog(SerialControllerEditor.this, "Please select some components to be moved from the list of used components!\n", "GATE", 0);
                } else {
                    Arrays.sort(rows);
                    for (int i = rows.length - 1; i >= 0; --i) {
                        int row = rows[i];
                        if (row >= SerialControllerEditor.this.controller.getPRs().size() - 1) continue;
                        ArrayList<RunningStrategy> strategies = null;
                        if (SerialControllerEditor.this.conditionalMode) {
                            strategies = new ArrayList<RunningStrategy>(((ConditionalController)((Object)SerialControllerEditor.this.controller)).getRunningStrategies());
                            RunningStrategy straegy = (RunningStrategy)strategies.remove(row);
                            strategies.add(row + 1, straegy);
                        }
                        ProcessingResource value = SerialControllerEditor.this.controller.remove(row);
                        SerialControllerEditor.this.controller.add(row + 1, value);
                        if (!SerialControllerEditor.this.conditionalMode) continue;
                        ((ConditionalController)((Object)SerialControllerEditor.this.controller)).setRunningStrategies(strategies);
                    }
                    for (int row : rows) {
                        int newRow = row < SerialControllerEditor.this.controller.getPRs().size() - 1 ? row + 1 : row;
                        SerialControllerEditor.this.memberPRsTable.addRowSelectionInterval(newRow, newRow);
                    }
                    SerialControllerEditor.this.memberPRsTable.requestFocusInWindow();
                }
            }
        });
        this.loadedPRsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.processMouseEvent(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.processMouseEvent(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                this.processMouseEvent(e);
            }

            protected void processMouseEvent(MouseEvent e) {
                int row = SerialControllerEditor.this.loadedPRsTable.rowAtPoint(e.getPoint());
                if (row == -1) {
                    return;
                }
                if (e.isPopupTrigger()) {
                    if (!SerialControllerEditor.this.loadedPRsTable.isRowSelected(row)) {
                        SerialControllerEditor.this.loadedPRsTable.getSelectionModel().setSelectionInterval(row, row);
                    }
                    XJPopupMenu popup = new XJPopupMenu();
                    popup.add(SerialControllerEditor.this.addPRAction);
                    popup.show(SerialControllerEditor.this.loadedPRsTable, e.getPoint().x, e.getPoint().y);
                } else if (e.getID() == 500 && e.getClickCount() == 2) {
                    SerialControllerEditor.this.addPRAction.actionPerformed(null);
                }
            }
        });
        this.loadedPRsTable.setTransferHandler(new TransferHandler(){
            String source = "";

            @Override
            public int getSourceActions(JComponent c) {
                return 2;
            }

            @Override
            protected Transferable createTransferable(JComponent c) {
                return new StringSelection("loadedPRsTable");
            }

            @Override
            protected void exportDone(JComponent c, Transferable data, int action) {
            }

            @Override
            public boolean canImport(JComponent c, DataFlavor[] flavors) {
                for (DataFlavor flavor : flavors) {
                    if (!DataFlavor.stringFlavor.equals(flavor)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean importData(JComponent c, Transferable t) {
                if (this.canImport(c, t.getTransferDataFlavors())) {
                    try {
                        this.source = (String)t.getTransferData(DataFlavor.stringFlavor);
                        if (this.source.startsWith("memberPRsTable")) {
                            SerialControllerEditor.this.removePRAction.actionPerformed(null);
                            return true;
                        }
                        return false;
                    }
                    catch (UnsupportedFlavorException unsupportedFlavorException) {
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return false;
            }
        });
        this.memberPRsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.processMouseEvent(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.processMouseEvent(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                this.processMouseEvent(e);
            }

            protected void processMouseEvent(MouseEvent e) {
                int row = SerialControllerEditor.this.memberPRsTable.rowAtPoint(e.getPoint());
                if (row == -1) {
                    return;
                }
                if (e.isPopupTrigger()) {
                    if (!SerialControllerEditor.this.memberPRsTable.isRowSelected(row)) {
                        SerialControllerEditor.this.memberPRsTable.getSelectionModel().setSelectionInterval(row, row);
                    }
                    XJPopupMenu popup = new XJPopupMenu();
                    popup.add(SerialControllerEditor.this.removePRAction);
                    popup.show(SerialControllerEditor.this.memberPRsTable, e.getPoint().x, e.getPoint().y);
                } else if (e.getID() == 500 && e.getClickCount() == 2) {
                    ProcessingResource res;
                    Component root = SwingUtilities.getRoot(SerialControllerEditor.this);
                    if (!(root instanceof MainFrame)) {
                        return;
                    }
                    MainFrame mainFrame = (MainFrame)root;
                    if (SerialControllerEditor.this.controller != null && (res = (ProcessingResource)SerialControllerEditor.this.controller.getPRs().get(row)) != null) {
                        mainFrame.select(res);
                    }
                }
            }
        });
        this.memberPRsTable.setTransferHandler(new TransferHandler(){
            String source = "";

            @Override
            public int getSourceActions(JComponent c) {
                return 2;
            }

            @Override
            protected Transferable createTransferable(JComponent c) {
                int[] selectedRows = SerialControllerEditor.this.memberPRsTable.getSelectedRows();
                Arrays.sort(selectedRows);
                return new StringSelection("memberPRsTable" + Arrays.toString(selectedRows));
            }

            @Override
            protected void exportDone(JComponent c, Transferable data, int action) {
            }

            @Override
            public boolean canImport(JComponent c, DataFlavor[] flavors) {
                for (DataFlavor flavor : flavors) {
                    if (!DataFlavor.stringFlavor.equals(flavor)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean importData(JComponent c, Transferable t) {
                if (!this.canImport(c, t.getTransferDataFlavors())) {
                    return false;
                }
                try {
                    this.source = (String)t.getTransferData(DataFlavor.stringFlavor);
                    if (this.source.startsWith("memberPRsTable")) {
                        int insertion;
                        int initialInsertion = insertion = SerialControllerEditor.this.memberPRsTable.getSelectedRow();
                        ArrayList<ProcessingResource> prs = new ArrayList<ProcessingResource>();
                        this.source = this.source.replaceFirst("^memberPRsTable\\[", "");
                        this.source = this.source.replaceFirst("\\]$", "");
                        String[] selectedRows = this.source.split(", ");
                        if (Integer.parseInt(selectedRows[0]) < insertion) {
                            ++insertion;
                        }
                        for (String row : selectedRows) {
                            if (Integer.parseInt(row) == initialInsertion) {
                                return false;
                            }
                            prs.add((ProcessingResource)SerialControllerEditor.this.memberPRsTable.getValueAt(Integer.parseInt(row), SerialControllerEditor.this.memberPRsTable.convertColumnIndexToView(1)));
                            if (Integer.parseInt(row) >= initialInsertion) continue;
                            --insertion;
                        }
                        for (ProcessingResource pr : prs) {
                            SerialControllerEditor.this.controller.remove(pr);
                        }
                        for (ProcessingResource pr : prs) {
                            SerialControllerEditor.this.controller.add(insertion, pr);
                            ++insertion;
                        }
                        SerialControllerEditor.this.memberPRsTable.addRowSelectionInterval(insertion - selectedRows.length, insertion - 1);
                        return true;
                    }
                    if (this.source.equals("loadedPRsTable")) {
                        SerialControllerEditor.this.addPRAction.actionPerformed(null);
                        return true;
                    }
                    return false;
                }
                catch (UnsupportedFlavorException ufe) {
                    return false;
                }
                catch (IOException ioe) {
                    return false;
                }
            }
        });
        this.loadedPRsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SerialControllerEditor.this.addButton.setEnabled(SerialControllerEditor.this.loadedPRsTable.getSelectedRowCount() > 0);
            }
        });
        this.memberPRsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SerialControllerEditor.this.removeButton.setEnabled(SerialControllerEditor.this.memberPRsTable.getSelectedRowCount() > 0);
                SerialControllerEditor.this.moveUpButton.setEnabled(SerialControllerEditor.this.memberPRsTable.getSelectedRowCount() > 0 && !SerialControllerEditor.this.memberPRsTable.isRowSelected(0));
                SerialControllerEditor.this.moveDownButton.setEnabled(SerialControllerEditor.this.memberPRsTable.getSelectedRowCount() > 0 && !SerialControllerEditor.this.memberPRsTable.isRowSelected(SerialControllerEditor.this.memberPRsTable.getRowCount() - 1));
                if (SerialControllerEditor.this.memberPRsTable.getSelectedRowCount() == 1) {
                    SerialControllerEditor.this.selectPR(SerialControllerEditor.this.memberPRsTable.getSelectedRow());
                } else {
                    SerialControllerEditor.this.selectPR(-1);
                }
            }
        });
        if (this.conditionalMode) {
            ItemListener strategyModeListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (SerialControllerEditor.this.selectedPRRunStrategy != null) {
                        if (SerialControllerEditor.this.selectedPRRunStrategy instanceof AnalyserRunningStrategy) {
                            AnalyserRunningStrategy strategy = (AnalyserRunningStrategy)SerialControllerEditor.this.selectedPRRunStrategy;
                            if (SerialControllerEditor.this.yes_RunRBtn.isSelected()) {
                                strategy.setRunMode(1);
                            } else if (SerialControllerEditor.this.no_RunRBtn.isSelected()) {
                                strategy.setRunMode(2);
                            } else if (SerialControllerEditor.this.conditional_RunRBtn.isSelected()) {
                                strategy.setRunMode(4);
                            }
                        } else if (SerialControllerEditor.this.selectedPRRunStrategy instanceof RunningStrategy.UnconditionalRunningStrategy) {
                            RunningStrategy.UnconditionalRunningStrategy strategy = (RunningStrategy.UnconditionalRunningStrategy)SerialControllerEditor.this.selectedPRRunStrategy;
                            if (SerialControllerEditor.this.yes_RunRBtn.isSelected()) {
                                strategy.shouldRun(true);
                            } else if (SerialControllerEditor.this.no_RunRBtn.isSelected()) {
                                strategy.shouldRun(false);
                            }
                        }
                    }
                    SerialControllerEditor.this.memberPRsTable.repaint();
                }
            };
            this.yes_RunRBtn.addItemListener(strategyModeListener);
            this.no_RunRBtn.addItemListener(strategyModeListener);
            this.conditional_RunRBtn.addItemListener(strategyModeListener);
            this.featureNameTextField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.changeOccured(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.changeOccured(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.changeOccured(e);
                }

                protected void changeOccured(DocumentEvent e) {
                    if (SerialControllerEditor.this.selectedPRRunStrategy != null && SerialControllerEditor.this.selectedPRRunStrategy instanceof AnalyserRunningStrategy) {
                        AnalyserRunningStrategy strategy = (AnalyserRunningStrategy)SerialControllerEditor.this.selectedPRRunStrategy;
                        strategy.setFeatureName(SerialControllerEditor.this.featureNameTextField.getText());
                    }
                    SerialControllerEditor.this.conditional_RunRBtn.setSelected(true);
                }
            });
            this.featureValueTextField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.changeOccured(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.changeOccured(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.changeOccured(e);
                }

                protected void changeOccured(DocumentEvent e) {
                    if (SerialControllerEditor.this.selectedPRRunStrategy != null && SerialControllerEditor.this.selectedPRRunStrategy instanceof AnalyserRunningStrategy) {
                        AnalyserRunningStrategy strategy = (AnalyserRunningStrategy)SerialControllerEditor.this.selectedPRRunStrategy;
                        strategy.setFeatureValue(SerialControllerEditor.this.featureValueTextField.getText());
                    }
                    SerialControllerEditor.this.conditional_RunRBtn.setSelected(true);
                }
            });
        }
        if (this.corpusControllerMode) {
            this.corpusCombo.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    SerialControllerEditor.this.corpusComboModel.fireDataChanged();
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
        }
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                SerialControllerEditor.this.loadedPRsTableModel.fireTableDataChanged();
                SerialControllerEditor.this.memberPRsTableModel.fireTableDataChanged();
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
        this.getInputMap(1).put(KeyStroke.getKeyStroke("F3"), "Run");
        this.getActionMap().put("Run", this.runAction);
    }

    @Override
    public List<Action> getActions() {
        return this.actionList;
    }

    @Override
    public void cleanup() {
        Gate.getCreoleRegister().removeCreoleListener(this);
        this.controller.removeControllerListener(this);
        this.controller = null;
        this.progressListeners.clear();
        this.statusListeners.clear();
        this.parametersEditor.cleanup();
        this.handle = null;
    }

    protected void selectPR(int index) {
        if (this.parametersEditor.getResource() != null) {
            try {
                this.parametersEditor.setParameters();
            }
            catch (ResourceInstantiationException rie) {
                JOptionPane.showMessageDialog(this, "Failed to set parameters for \"" + this.parametersEditor.getResource().getName() + "\"!\n", "GATE", 0);
                rie.printStackTrace(Err.getPrintWriter());
            }
            if (this.conditionalMode) {
                if (this.selectedPRRunStrategy != null && this.selectedPRRunStrategy instanceof AnalyserRunningStrategy) {
                    AnalyserRunningStrategy strategy = (AnalyserRunningStrategy)this.selectedPRRunStrategy;
                    strategy.setFeatureName(this.featureNameTextField.getText());
                    strategy.setFeatureValue(this.featureValueTextField.getText());
                }
                this.selectedPRRunStrategy = null;
            }
        }
        Object pr = null;
        if (index >= 0 && index < this.controller.getPRs().size()) {
            pr = (ProcessingResource)this.controller.getPRs().get(index);
        }
        if (pr != null) {
            ResourceData rData = (ResourceData)Gate.getCreoleRegister().get(pr.getClass().getName());
            this.parametersBorder.setTitle(" Runtime Parameters for the \"" + pr.getName() + "\" " + rData.getName() + ": ");
            List<List<Parameter>> parameters = rData.getParameterList().getRuntimeParameters();
            if (this.corpusControllerMode) {
                List<List<Parameter>> oldParameters = parameters;
                parameters = new ArrayList<List<Parameter>>();
                for (List<Parameter> aDisjunction : oldParameters) {
                    ArrayList<Parameter> newDisjunction = new ArrayList<Parameter>();
                    for (Parameter parameter : aDisjunction) {
                        if (parameter.getName().equals("corpus") || parameter.getName().equals("document")) continue;
                        newDisjunction.add(parameter);
                    }
                    if (newDisjunction.isEmpty()) continue;
                    parameters.add(newDisjunction);
                }
            }
            this.parametersEditor.init((Resource)pr, parameters);
            if (this.conditionalMode) {
                this.strategyBorder.setTitle(" Run \"" + pr.getName() + "\"? ");
                this.yes_RunRBtn.setEnabled(true);
                this.no_RunRBtn.setEnabled(true);
                this.conditional_RunRBtn.setEnabled(true);
                this.selectedPRRunStrategy = null;
                RunningStrategy newStrategy = ((ConditionalController)((Object)this.controller)).getRunningStrategies().get(index);
                if (newStrategy instanceof AnalyserRunningStrategy) {
                    this.featureNameTextField.setEnabled(true);
                    this.featureValueTextField.setEnabled(true);
                    this.conditional_RunRBtn.setEnabled(true);
                    this.featureNameTextField.setText(((AnalyserRunningStrategy)newStrategy).getFeatureName());
                    this.featureValueTextField.setText(((AnalyserRunningStrategy)newStrategy).getFeatureValue());
                } else {
                    this.featureNameTextField.setEnabled(false);
                    this.featureValueTextField.setEnabled(false);
                    this.conditional_RunRBtn.setEnabled(false);
                }
                switch (newStrategy.getRunMode()) {
                    case 1: {
                        this.yes_RunRBtn.setSelected(true);
                        break;
                    }
                    case 2: {
                        this.no_RunRBtn.setSelected(true);
                        break;
                    }
                    case 4: {
                        this.conditional_RunRBtn.setSelected(true);
                    }
                }
                this.selectedPRRunStrategy = newStrategy;
            }
        } else {
            this.parametersBorder.setTitle(" No processing resource selected... ");
            this.parametersEditor.init(null, null);
            if (this.conditionalMode) {
                this.strategyBorder.setTitle(" No processing resource selected... ");
                this.yes_RunRBtn.setEnabled(false);
                this.no_RunRBtn.setEnabled(false);
                this.conditional_RunRBtn.setEnabled(false);
                this.featureNameTextField.setText("");
                this.featureNameTextField.setEnabled(false);
                this.featureValueTextField.setText("");
                this.featureValueTextField.setEnabled(false);
            }
        }
        this.repaint(100L);
    }

    private void refreshPRLists() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.loadedPRsTableModel.fireTableDataChanged();
            this.memberPRsTableModel.fireTableDataChanged();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SerialControllerEditor.this.loadedPRsTableModel.fireTableDataChanged();
                    SerialControllerEditor.this.memberPRsTableModel.fireTableDataChanged();
                }
            });
        }
    }

    @Override
    public void resourceLoaded(CreoleEvent e) {
        if (Gate.getHiddenAttribute(e.getResource().getFeatures())) {
            return;
        }
        if (e.getResource() instanceof ProcessingResource) {
            this.refreshPRLists();
        } else if (e.getResource() instanceof LanguageResource && e.getResource() instanceof Corpus && this.corpusControllerMode) {
            this.corpusComboModel.fireDataChanged();
        }
    }

    @Override
    public void resourceUnloaded(CreoleEvent e) {
        if (Gate.getHiddenAttribute(e.getResource().getFeatures())) {
            return;
        }
        if (e.getResource() instanceof ProcessingResource) {
            ProcessingResource pr = (ProcessingResource)e.getResource();
            if (this.controller != null && this.controller.getPRs().contains(pr)) {
                this.controller.remove(pr);
            }
            this.refreshPRLists();
        } else if (e.getResource() instanceof LanguageResource && e.getResource() instanceof Corpus && this.corpusControllerMode) {
            Corpus c = (Corpus)e.getResource();
            if (this.controller instanceof CorpusController) {
                if (c == ((CorpusController)((Object)this.controller)).getCorpus()) {
                    ((CorpusController)((Object)this.controller)).setCorpus(null);
                }
            } else {
                throw new GateRuntimeException("Controller editor in analyser mode but the target controller is not an analyser!");
            }
            this.corpusComboModel.fireDataChanged();
        }
    }

    @Override
    public void resourceRenamed(Resource resource, String oldName, String newName) {
        if (Gate.getHiddenAttribute(resource.getFeatures())) {
            return;
        }
        if (resource instanceof ProcessingResource) {
            this.repaint(100L);
        }
    }

    @Override
    public void datastoreOpened(CreoleEvent e) {
    }

    @Override
    public void datastoreCreated(CreoleEvent e) {
    }

    @Override
    public void datastoreClosed(CreoleEvent e) {
    }

    public synchronized void removeStatusListener(StatusListener l) {
        if (this.statusListeners != null && this.statusListeners.contains(l)) {
            Vector v = (Vector)this.statusListeners.clone();
            v.removeElement(l);
            this.statusListeners = v;
        }
    }

    @Override
    public void resourceAdded(ControllerEvent evt) {
        this.refreshPRLists();
    }

    @Override
    public void resourceRemoved(ControllerEvent evt) {
        this.refreshPRLists();
    }

    public synchronized void addStatusListener(StatusListener l) {
        Vector v;
        Vector vector = v = this.statusListeners == null ? new Vector(2) : (Vector)this.statusListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.statusListeners = v;
        }
    }

    private boolean firstIncludesOrEqualsSecond(Controller first, Controller second) {
        if (first.equals(second)) {
            return true;
        }
        for (ProcessingResource object : first.getPRs()) {
            if (!(object instanceof Controller) || !this.firstIncludesOrEqualsSecond((Controller)((Object)object), second)) continue;
            return true;
        }
        return false;
    }

    protected void fireStatusChanged(String e) {
        if (this.statusListeners != null) {
            Vector<StatusListener> listeners = this.statusListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).statusChanged(e);
            }
        }
    }

    public synchronized void removeProgressListener(ProgressListener l) {
        if (this.progressListeners != null && this.progressListeners.contains(l)) {
            Vector v = (Vector)this.progressListeners.clone();
            v.removeElement(l);
            this.progressListeners = v;
        }
    }

    public synchronized void addProgressListener(ProgressListener l) {
        Vector v;
        Vector vector = v = this.progressListeners == null ? new Vector(2) : (Vector)this.progressListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.progressListeners = v;
        }
    }

    protected void fireProgressChanged(int e) {
        if (this.progressListeners != null) {
            Vector<ProgressListener> listeners = this.progressListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).progressChanged(e);
            }
        }
    }

    protected void fireProcessFinished() {
        if (this.progressListeners != null) {
            Vector<ProgressListener> listeners = this.progressListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).processFinished();
            }
        }
    }

    protected class InternalStatusListener
    implements StatusListener {
        protected InternalStatusListener() {
        }

        @Override
        public void statusChanged(String message) {
            SerialControllerEditor.this.fireStatusChanged(message);
        }
    }

    protected class InternalProgressListener
    implements ProgressListener {
        protected InternalProgressListener() {
        }

        @Override
        public void progressChanged(int i) {
            SerialControllerEditor.this.fireProgressChanged(i);
        }

        @Override
        public void processFinished() {
            SerialControllerEditor.this.fireProcessFinished();
        }
    }

    class RunAction
    extends AbstractAction {
        RunAction() {
            super("Run this Application");
            super.putValue("ShortDescription", "<html>Run this application&nbsp;&nbsp;<font color=#667799><small>F3&nbsp;&nbsp;</small></font></html>");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SerialControllerEditor.this.memberPRsTable.getRowCount() == 0) {
                JOptionPane.showMessageDialog(SerialControllerEditor.this, "Add at least one processing resource in the right table\nthat contains the resources of the application to be run.", "GATE", 0);
                return;
            }
            try {
                SerialControllerEditor.this.parametersEditor.setParameters();
            }
            catch (ResourceInstantiationException rie) {
                JOptionPane.showMessageDialog(SerialControllerEditor.this, "Could not set parameters for the \"" + SerialControllerEditor.this.parametersEditor.getResource().getName() + "\" processing resource:\nSee \"Messages\" tab for details!", "GATE", 0);
                rie.printStackTrace(Err.getPrintWriter());
                return;
            }
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Corpus corpus;
                    List<ProcessingResource> badPRs;
                    if (SerialControllerEditor.this.corpusControllerMode) {
                        Corpus corpus2;
                        Object value = SerialControllerEditor.this.corpusCombo.getSelectedItem();
                        Corpus corpus3 = corpus2 = value.equals("<none>") ? null : (Corpus)value;
                        if (SerialControllerEditor.this.analyserMode && corpus2 == null) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    JOptionPane.showMessageDialog(SerialControllerEditor.this, "No corpus provided!\nPlease select a corpus and try again!", "GATE", 0);
                                    SerialControllerEditor.this.corpusCombo.requestFocusInWindow();
                                }
                            });
                            return;
                        }
                        if (SerialControllerEditor.this.controller instanceof CorpusController) {
                            ((CorpusController)((Object)SerialControllerEditor.this.controller)).setCorpus(corpus2);
                        }
                    }
                    try {
                        badPRs = SerialControllerEditor.this.controller.getOffendingPocessingResources();
                    }
                    catch (ResourceInstantiationException rie) {
                        JOptionPane.showMessageDialog(SerialControllerEditor.this, "Could not check runtime parameters for the processing resources:\n" + rie.toString(), "GATE", 0);
                        return;
                    }
                    if (badPRs != null && !badPRs.isEmpty()) {
                        String badPRsString = "";
                        for (ProcessingResource badPR : badPRs) {
                            badPRsString = badPRsString + "- " + badPR.getName() + "\n";
                        }
                        JOptionPane.showMessageDialog(SerialControllerEditor.this, "Some required runtime parameters are not set\nin the following resources:\n" + badPRsString, "GATE", 0);
                        return;
                    }
                    InternalStatusListener sListener = new InternalStatusListener();
                    InternalProgressListener pListener = new InternalProgressListener();
                    SerialControllerEditor.this.controller.addStatusListener(sListener);
                    SerialControllerEditor.this.controller.addProgressListener(pListener);
                    Gate.setExecutable(SerialControllerEditor.this.controller);
                    int corpusSize = 1;
                    if (SerialControllerEditor.this.controller instanceof CorpusController && (corpus = ((CorpusController)((Object)SerialControllerEditor.this.controller)).getCorpus()) != null) {
                        corpusSize = corpus.size();
                    }
                    MainFrame.lockGUI("Running " + SerialControllerEditor.this.controller.getName() + " on " + corpusSize + (corpusSize == 1 ? " document" : " documents"));
                    long startTime = System.currentTimeMillis();
                    SerialControllerEditor.this.fireStatusChanged("Start running " + SerialControllerEditor.this.controller.getName() + " on " + corpusSize + (corpusSize == 1 ? " document" : " documents"));
                    SerialControllerEditor.this.fireProgressChanged(0);
                    try {
                        Benchmark.executeWithBenchmarking(SerialControllerEditor.this.controller, Benchmark.createBenchmarkId(SerialControllerEditor.this.controller.getName(), null), RunAction.this, null);
                    }
                    catch (ExecutionInterruptedException eie) {
                        MainFrame.unlockGUI();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                JOptionPane.showMessageDialog(SerialControllerEditor.this, "Interrupted!\n" + eie.toString(), "GATE", 0);
                            }
                        });
                    }
                    catch (ExecutionException ee) {
                        ee.printStackTrace(Err.getPrintWriter());
                        MainFrame.unlockGUI();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                JOptionPane.showMessageDialog(SerialControllerEditor.this, "Execution error while running \"" + SerialControllerEditor.this.controller.getName() + "\" :\nSee \"Messages\" tab for details!", "GATE", 0);
                            }
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace(Err.getPrintWriter());
                        MainFrame.unlockGUI();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                JOptionPane.showMessageDialog(SerialControllerEditor.this, "Unhandled execution error!\n See \"Messages\" tab for details!", "GATE", 0);
                            }
                        });
                    }
                    finally {
                        MainFrame.unlockGUI();
                        Gate.setExecutable(null);
                    }
                    SerialControllerEditor.this.controller.removeStatusListener(sListener);
                    SerialControllerEditor.this.controller.removeProgressListener(pListener);
                    long endTime = System.currentTimeMillis();
                    SerialControllerEditor.this.fireProcessFinished();
                    SerialControllerEditor.this.fireStatusChanged(SerialControllerEditor.this.controller.getName() + " run in " + NumberFormat.getInstance().format((double)(endTime - startTime) / 1000.0) + " seconds");
                }
            };
            Thread thread = new Thread(Thread.currentThread().getThreadGroup(), runnable, "ApplicationViewer1");
            thread.setPriority(1);
            thread.start();
        }
    }

    class RemovePRAction
    extends AbstractAction {
        RemovePRAction() {
            this.putValue("Name", "Remove selected resouces from the application");
            this.putValue("ShortDescription", "Remove selected resouces from the application");
            this.putValue("SmallIcon", MainFrame.getIcon("left-arrow"));
            this.putValue("MnemonicKey", 37);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ArrayList<ProcessingResource> prs = new ArrayList<ProcessingResource>();
            for (int row : SerialControllerEditor.this.memberPRsTable.getSelectedRows()) {
                prs.add((ProcessingResource)SerialControllerEditor.this.memberPRsTable.getValueAt(row, SerialControllerEditor.this.memberPRsTable.convertColumnIndexToView(1)));
            }
            Object object = prs.iterator();
            while (object.hasNext()) {
                ProcessingResource pr = (ProcessingResource)object.next();
                SerialControllerEditor.this.controller.remove(pr);
            }
            for (ProcessingResource pr : prs) {
                for (int row = 0; row < SerialControllerEditor.this.loadedPRsTable.getRowCount(); ++row) {
                    if (SerialControllerEditor.this.loadedPRsTable.getValueAt(row, SerialControllerEditor.this.loadedPRsTable.convertColumnIndexToView(0)) != pr) continue;
                    SerialControllerEditor.this.loadedPRsTable.addRowSelectionInterval(row, row);
                }
            }
            SerialControllerEditor.this.loadedPRsTable.requestFocusInWindow();
            if (SerialControllerEditor.this.memberPRsTable.getSelectedRowCount() == 0) {
                SerialControllerEditor.this.parametersEditor.init(null, null);
                SerialControllerEditor.this.parametersBorder.setTitle("No selected processing resource");
            }
        }
    }

    class AddPRAction
    extends AbstractAction {
        AddPRAction() {
            this.putValue("Name", "Add selected resources to the application");
            this.putValue("ShortDescription", "Add selected resources to the application");
            this.putValue("SmallIcon", MainFrame.getIcon("right-arrow"));
            this.putValue("MnemonicKey", 39);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                ArrayList<ProcessingResource> prs = new ArrayList<ProcessingResource>();
                int[] selectedRows = SerialControllerEditor.this.loadedPRsTable.getSelectedRows();
                Arrays.sort(selectedRows);
                for (int row : selectedRows) {
                    prs.add((ProcessingResource)SerialControllerEditor.this.loadedPRsTable.getValueAt(row, SerialControllerEditor.this.loadedPRsTable.convertColumnIndexToView(0)));
                }
                selectedRows = SerialControllerEditor.this.memberPRsTable.getSelectedRows();
                Arrays.sort(selectedRows);
                int insertion = selectedRows.length == 0 ? SerialControllerEditor.this.memberPRsTable.getRowCount() : selectedRows[selectedRows.length - 1] + 1;
                for (ProcessingResource pr : prs) {
                    SerialControllerEditor.this.controller.add(insertion, pr);
                    ++insertion;
                }
                for (ProcessingResource pr : prs) {
                    for (int row = 0; row < SerialControllerEditor.this.memberPRsTable.getRowCount(); ++row) {
                        if (SerialControllerEditor.this.memberPRsTable.getValueAt(row, SerialControllerEditor.this.memberPRsTable.convertColumnIndexToView(1)) != pr) continue;
                        SerialControllerEditor.this.memberPRsTable.addRowSelectionInterval(row, row);
                    }
                }
                SerialControllerEditor.this.memberPRsTable.requestFocusInWindow();
            }
            catch (GateRuntimeException ex) {
                JOptionPane.showMessageDialog(SerialControllerEditor.this, "Could not add PR to pipeline:\n" + ex.getMessage(), "GATE", 0);
                return;
            }
        }
    }

    class MemberPRsTableModel
    extends AbstractTableModel {
        protected Icon green = MainFrame.getIcon("greenBall");
        protected Icon red = MainFrame.getIcon("redBall");
        protected Icon yellow = MainFrame.getIcon("yellowBall");

        @Override
        public int getRowCount() {
            return SerialControllerEditor.this.controller == null ? 0 : SerialControllerEditor.this.controller.getPRs().size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            ProcessingResource pr = (ProcessingResource)SerialControllerEditor.this.controller.getPRs().get(row);
            switch (column) {
                case 0: {
                    if (SerialControllerEditor.this.conditionalMode) {
                        RunningStrategy strategy = ((ConditionalController)((Object)SerialControllerEditor.this.controller)).getRunningStrategies().get(row);
                        switch (strategy.getRunMode()) {
                            case 1: {
                                return this.green;
                            }
                            case 2: {
                                return this.red;
                            }
                            case 4: {
                                return this.yellow;
                            }
                        }
                    }
                    return this.green;
                }
                case 1: {
                    return pr;
                }
                case 2: {
                    ResourceData rData = (ResourceData)Gate.getCreoleRegister().get(pr.getClass().getName());
                    if (rData == null) {
                        return pr.getClass();
                    }
                    return rData.getName();
                }
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "!";
                }
                case 1: {
                    return "Name";
                }
                case 2: {
                    return "Type";
                }
            }
            return "?";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Icon.class;
                }
                case 1: {
                    return ProcessingResource.class;
                }
                case 2: {
                    return String.class;
                }
            }
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }
    }

    class IconRenderer
    extends DefaultTableCellRenderer {
        IconRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, "", isSelected, hasFocus, row, column);
            this.setIcon((Icon)value);
            return this;
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }

    protected class CorporaComboModel
    extends AbstractListModel
    implements ComboBoxModel {
        protected CorporaComboModel() {
        }

        @Override
        public int getSize() {
            List<Resource> loadedCorpora = null;
            try {
                loadedCorpora = Gate.getCreoleRegister().getAllInstances("gate.Corpus");
            }
            catch (GateException ge) {
                ge.printStackTrace(Err.getPrintWriter());
            }
            return loadedCorpora == null ? 1 : loadedCorpora.size() + 1;
        }

        @Override
        public Object getElementAt(int index) {
            if (index == 0) {
                return "<none>";
            }
            List<Resource> loadedCorpora = null;
            try {
                loadedCorpora = Gate.getCreoleRegister().getAllInstances("gate.Corpus");
            }
            catch (GateException ge) {
                ge.printStackTrace(Err.getPrintWriter());
            }
            return loadedCorpora == null || index > loadedCorpora.size() ? "" : loadedCorpora.get(index - 1);
        }

        @Override
        public void setSelectedItem(Object anItem) {
            if (SerialControllerEditor.this.controller instanceof CorpusController) {
                ((CorpusController)((Object)SerialControllerEditor.this.controller)).setCorpus((Corpus)(anItem.equals("<none>") ? null : anItem));
            }
        }

        @Override
        public Object getSelectedItem() {
            Corpus corpus = null;
            if (!(SerialControllerEditor.this.controller instanceof CorpusController)) {
                throw new GateRuntimeException("Controller editor in corpus controller mode but the target controller is not a CorpusController!");
            }
            corpus = ((CorpusController)((Object)SerialControllerEditor.this.controller)).getCorpus();
            return corpus == null ? "<none>" : corpus;
        }

        void fireDataChanged() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CorporaComboModel.this.fireContentsChanged(this, 0, CorporaComboModel.this.getSize());
                }
            });
        }
    }

    class LoadedPRsTableModel
    extends AbstractTableModel {
        NameComparator nameComparator = new NameComparator();

        LoadedPRsTableModel() {
        }

        @Override
        public int getRowCount() {
            ArrayList<ProcessingResource> loadedPRs = new ArrayList<ProcessingResource>(Gate.getCreoleRegister().getPrInstances());
            if (SerialControllerEditor.this.controller != null) {
                loadedPRs.removeAll(SerialControllerEditor.this.controller.getPRs());
            }
            Iterator prsIter = loadedPRs.iterator();
            while (prsIter.hasNext()) {
                ProcessingResource aPR = (ProcessingResource)prsIter.next();
                if (!Gate.getHiddenAttribute(aPR.getFeatures()) && (!(aPR instanceof Controller) || !SerialControllerEditor.this.firstIncludesOrEqualsSecond((Controller)((Object)aPR), SerialControllerEditor.this.controller))) continue;
                prsIter.remove();
            }
            return loadedPRs.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            ArrayList<ProcessingResource> loadedPRs = new ArrayList<ProcessingResource>(Gate.getCreoleRegister().getPrInstances());
            if (SerialControllerEditor.this.controller != null) {
                loadedPRs.removeAll(SerialControllerEditor.this.controller.getPRs());
            }
            Iterator prsIter = loadedPRs.iterator();
            while (prsIter.hasNext()) {
                ProcessingResource aPR = (ProcessingResource)prsIter.next();
                if (!Gate.getHiddenAttribute(aPR.getFeatures()) && (!(aPR instanceof Controller) || !SerialControllerEditor.this.firstIncludesOrEqualsSecond((Controller)((Object)aPR), SerialControllerEditor.this.controller))) continue;
                prsIter.remove();
            }
            Collections.sort(loadedPRs, this.nameComparator);
            ProcessingResource pr = (ProcessingResource)loadedPRs.get(row);
            switch (column) {
                case 0: {
                    return pr;
                }
                case 1: {
                    ResourceData rData = (ResourceData)Gate.getCreoleRegister().get(pr.getClass().getName());
                    if (rData == null) {
                        return pr.getClass();
                    }
                    return rData.getName();
                }
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Type";
                }
            }
            return "?";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ProcessingResource.class;
                }
                case 1: {
                    return String.class;
                }
            }
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }
    }
}

