/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Gate;
import gate.Resource;
import gate.creole.ResourceData;
import gate.gui.MainFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public class ResourceRenderer
extends JLabel
implements ListCellRenderer,
TableCellRenderer,
TreeCellRenderer {
    public ResourceRenderer() {
        this.setOpaque(true);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.prepareRendererList(list, value, isSelected, this.hasFocus());
        return this;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.prepareRendererTable(table, value, isSelected, hasFocus, row, column);
        return this;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.prepareRendererTree(tree, value, selected, hasFocus);
        return this;
    }

    private void prepareRendererTable(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setName("Table.cellRenderer");
        if (isSelected) {
            super.setForeground(table.getSelectionForeground());
            super.setBackground(table.getSelectionBackground());
        } else {
            Color alternateColor;
            Color background = table.getBackground();
            if ((background == null || background instanceof UIResource) && (alternateColor = UIManager.getColor("Table.alternateRowColor")) != null && row % 2 == 0) {
                background = alternateColor;
            }
            super.setForeground(table.getForeground());
            super.setBackground(background);
        }
        if (hasFocus) {
            Border border = null;
            if (isSelected) {
                border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIManager.getBorder("Table.focusCellHighlightBorder");
            }
            this.setBorder(border);
        } else {
            this.setBorder(UIManager.getBorder("Table.cellNoFocusBorder"));
        }
        this.prepareRendererCommon(table, value, isSelected, hasFocus);
    }

    private void prepareRendererList(JList list, Object value, boolean isSelected, boolean hasFocus) {
        if (isSelected) {
            this.setForeground(list.getSelectionForeground());
            this.setBackground(list.getSelectionBackground());
        } else {
            this.setForeground(list.getForeground());
            this.setBackground(list.getBackground());
        }
        this.prepareRendererCommon(list, value, isSelected, hasFocus);
    }

    private void prepareRendererTree(JTree tree, Object value, boolean isSelected, boolean hasFocus) {
        if (isSelected) {
            this.setForeground(UIManager.getColor("Tree.selectionForeground"));
            this.setBackground(UIManager.getColor("Tree.selectionBackground"));
        } else {
            this.setForeground(tree.getForeground());
            this.setBackground(tree.getBackground());
        }
        this.prepareRendererCommon(tree, value, isSelected, hasFocus);
    }

    private void prepareRendererCommon(JComponent ownerComponent, Object value, boolean isSelected, boolean hasFocus) {
        Icon icon;
        String toolTipText;
        String text;
        this.setFont(ownerComponent.getFont());
        ResourceData rData = null;
        if (value instanceof Resource) {
            text = ((Resource)value).getName();
            rData = (ResourceData)Gate.getCreoleRegister().get(value.getClass().getName());
        } else {
            String string = text = value == null ? "<null>" : value.toString();
            if (value == null) {
                this.setForeground(Color.red);
            }
        }
        if (rData != null) {
            toolTipText = "<HTML>Type: <b>" + rData.getName() + "</b></HTML>";
            icon = MainFrame.getIcon(rData.getIcon(), rData.getResourceClassLoader());
        } else {
            icon = null;
            toolTipText = null;
        }
        this.setText(text);
        this.setIcon(icon);
        this.setToolTipText(toolTipText);
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension dim = super.getMaximumSize();
        if (dim != null) {
            dim.width = Integer.MAX_VALUE;
            this.setMaximumSize(dim);
        }
        return dim;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public boolean isOpaque() {
        Color back = this.getBackground();
        Container p = this.getParent();
        if (p != null) {
            p = p.getParent();
        }
        boolean colorMatch = back != null && p != null && back.equals(p.getBackground()) && p.isOpaque();
        return !colorMatch && super.isOpaque();
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    public void repaint() {
    }
}

