/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Gate;
import gate.Resource;
import gate.creole.ResourceData;
import gate.gui.MainFrame;
import gate.gui.ResourceRenderer;
import gate.util.Err;
import gate.util.GateException;
import gate.util.GateRuntimeException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class ListEditorDialog
extends JDialog {
    String itemType;
    Class itemTypeClass;
    JList listComponent;
    JComboBox combo;
    JTextField textField;
    JButton removeBtn;
    JButton addBtn;
    JButton moveUpBtn;
    JButton moveDownBtn;
    DefaultListModel listModel;
    boolean finiteType;
    Action addAction;
    Action removeAction;
    JButton okButton;
    JButton cancelButton;
    boolean userCancelled;
    boolean allowDuplicates;
    Comparator comparator;

    public ListEditorDialog(Component owner, Collection<?> data, String itemType) {
        this(owner, data, null, itemType);
    }

    public ListEditorDialog(Component owner, Collection<?> data, Class<?> collectionType, String itemType) {
        super(MainFrame.getInstance());
        if (collectionType == null) {
            collectionType = data != null ? data.getClass() : List.class;
        }
        this.itemType = itemType == null ? "java.lang.String" : itemType;
        this.setLocationRelativeTo(owner);
        this.initLocalData(data, collectionType);
        this.initGuiComponents();
        this.initListeners();
    }

    protected void initLocalData(Collection<?> data, Class<?> collectionType) {
        ResourceData rData;
        try {
            rData = (ResourceData)Gate.getCreoleRegister().get(this.itemType);
            this.itemTypeClass = rData == null ? Class.forName(this.itemType, true, Gate.getClassLoader()) : rData.getResourceClass();
        }
        catch (ClassNotFoundException cnfe) {
            throw new GateRuntimeException(cnfe.toString());
        }
        this.finiteType = Gate.isGateType(this.itemType);
        rData = (ResourceData)Gate.getCreoleRegister().get(this.itemType);
        String typeDescription = null;
        if (List.class.isAssignableFrom(collectionType)) {
            typeDescription = "List";
            this.allowDuplicates = true;
        } else {
            if (Set.class.isAssignableFrom(collectionType)) {
                typeDescription = "Set";
                this.allowDuplicates = false;
            } else {
                typeDescription = "Collection";
                this.allowDuplicates = true;
            }
            if (SortedSet.class.isAssignableFrom(collectionType) && data != null) {
                this.comparator = ((SortedSet)data).comparator();
            }
            if (this.comparator == null) {
                this.comparator = new NaturalComparator();
            }
        }
        this.listModel = new DefaultListModel();
        if (data != null) {
            if (this.comparator == null) {
                for (Object elt : data) {
                    this.listModel.addElement(elt);
                }
            } else {
                Object[] dataArray = data.toArray();
                Arrays.sort(dataArray, this.comparator);
                for (Object elt : dataArray) {
                    this.listModel.addElement(elt);
                }
            }
        }
        this.setTitle(typeDescription + " of " + (rData == null ? this.itemType : rData.getName()));
        this.addAction = new AddAction();
        this.removeAction = new RemoveAction();
    }

    protected void initGuiComponents() {
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JComponent editComp = null;
        if (this.finiteType) {
            this.combo = new JComboBox(new ResourceComboModel());
            editComp = this.combo;
            this.combo.setRenderer(new ResourceRenderer());
            if (this.combo.getModel().getSize() > 0) {
                this.combo.getModel().setSelectedItem(this.combo.getModel().getElementAt(0));
            }
        } else {
            editComp = this.textField = new JTextField(20);
        }
        this.getContentPane().add(editComp);
        this.getContentPane().add(Box.createVerticalStrut(5));
        Box buttonsBox = Box.createHorizontalBox();
        this.addBtn = new JButton(this.addAction);
        this.addBtn.setMnemonic(65);
        this.removeBtn = new JButton(this.removeAction);
        this.removeBtn.setMnemonic(82);
        buttonsBox.add(Box.createHorizontalGlue());
        buttonsBox.add(this.addBtn);
        buttonsBox.add(Box.createHorizontalStrut(5));
        buttonsBox.add(this.removeBtn);
        buttonsBox.add(Box.createHorizontalGlue());
        this.getContentPane().add(buttonsBox);
        this.getContentPane().add(Box.createVerticalStrut(5));
        Box horBox = Box.createHorizontalBox();
        this.listComponent = new JList(this.listModel);
        this.listComponent.setSelectionMode(2);
        this.listComponent.setCellRenderer(new ResourceRenderer());
        horBox.add(new JScrollPane(this.listComponent));
        if (this.comparator == null) {
            Box verBox = Box.createVerticalBox();
            verBox.add(Box.createVerticalGlue());
            this.moveUpBtn = new JButton(MainFrame.getIcon("up"));
            verBox.add(this.moveUpBtn);
            verBox.add(Box.createVerticalStrut(5));
            this.moveDownBtn = new JButton(MainFrame.getIcon("down"));
            verBox.add(this.moveDownBtn);
            verBox.add(Box.createVerticalGlue());
            horBox.add(Box.createHorizontalStrut(3));
            horBox.add(verBox);
        }
        horBox.add(Box.createHorizontalStrut(3));
        this.getContentPane().add(horBox);
        this.getContentPane().add(Box.createVerticalStrut(5));
        buttonsBox = Box.createHorizontalBox();
        buttonsBox.add(Box.createHorizontalGlue());
        this.okButton = new JButton("OK");
        buttonsBox.add(this.okButton);
        buttonsBox.add(Box.createHorizontalStrut(5));
        this.cancelButton = new JButton("Cancel");
        buttonsBox.add(this.cancelButton);
        buttonsBox.add(Box.createHorizontalGlue());
        this.getContentPane().add(buttonsBox);
    }

    protected void initListeners() {
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListEditorDialog.this.userCancelled = false;
                ListEditorDialog.this.setVisible(false);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListEditorDialog.this.userCancelled = true;
                ListEditorDialog.this.setVisible(false);
            }
        });
        InputMap inputMap = ((JComponent)this.getContentPane()).getInputMap(2);
        ActionMap actionMap = ((JComponent)this.getContentPane()).getActionMap();
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), "Apply");
        actionMap.put("Apply", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListEditorDialog.this.okButton.doClick();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), "Cancel");
        actionMap.put("Cancel", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListEditorDialog.this.cancelButton.doClick();
            }
        });
        if (this.moveUpBtn != null) {
            this.moveUpBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int[] rows = ListEditorDialog.this.listComponent.getSelectedIndices();
                    if (rows == null || rows.length == 0) {
                        JOptionPane.showMessageDialog(ListEditorDialog.this, "Please select some items to be moved ", "GATE", 0);
                    } else {
                        int i;
                        Arrays.sort(rows);
                        for (i = 0; i < rows.length; ++i) {
                            int row = rows[i];
                            if (row <= 0) continue;
                            Object value = ListEditorDialog.this.listModel.remove(row);
                            ListEditorDialog.this.listModel.add(row - 1, value);
                        }
                        for (i = 0; i < rows.length; ++i) {
                            int newRow = -1;
                            newRow = rows[i] > 0 ? rows[i] - 1 : rows[i];
                            ListEditorDialog.this.listComponent.addSelectionInterval(newRow, newRow);
                        }
                    }
                }
            });
        }
        if (this.moveDownBtn != null) {
            this.moveDownBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int[] rows = ListEditorDialog.this.listComponent.getSelectedIndices();
                    if (rows == null || rows.length == 0) {
                        JOptionPane.showMessageDialog(ListEditorDialog.this, "Please select some items to be moved ", "GATE", 0);
                    } else {
                        int i;
                        Arrays.sort(rows);
                        for (i = rows.length - 1; i >= 0; --i) {
                            int row = rows[i];
                            if (row >= ListEditorDialog.this.listModel.size() - 1) continue;
                            Object value = ListEditorDialog.this.listModel.remove(row);
                            ListEditorDialog.this.listModel.add(row + 1, value);
                        }
                        for (i = 0; i < rows.length; ++i) {
                            int newRow = -1;
                            newRow = rows[i] < ListEditorDialog.this.listModel.size() - 1 ? rows[i] + 1 : rows[i];
                            ListEditorDialog.this.listComponent.addSelectionInterval(newRow, newRow);
                        }
                    }
                }
            });
        }
    }

    public List showDialog() {
        this.pack();
        this.userCancelled = true;
        this.setModal(true);
        super.setVisible(true);
        return this.userCancelled ? null : Arrays.asList(this.listModel.toArray());
    }

    public static void main(String[] args) {
        try {
            Gate.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JFrame frame = new JFrame("Foo frame");
        ListEditorDialog dialog = new ListEditorDialog((Component)frame, new ArrayList(), "java.lang.Integer");
        frame.setSize(300, 300);
        frame.setVisible(true);
        System.out.println(dialog.showDialog());
    }

    protected class NaturalComparator
    implements Comparator {
        protected NaturalComparator() {
        }

        public int compare(Object a, Object b) {
            if (a == null) {
                if (b == null) {
                    return 0;
                }
                return -1;
            }
            if (b == null) {
                return 1;
            }
            if (Comparable.class.isAssignableFrom(ListEditorDialog.this.itemTypeClass)) {
                return ((Comparable)a).compareTo(b);
            }
            return a.toString().compareTo(b.toString());
        }
    }

    protected class ResourceComboModel
    extends AbstractListModel
    implements ComboBoxModel {
        Object selectedItem = null;

        protected ResourceComboModel() {
        }

        @Override
        public int getSize() {
            List<Resource> loadedResources = null;
            try {
                loadedResources = Gate.getCreoleRegister().getAllInstances(ListEditorDialog.this.itemType);
            }
            catch (GateException ge) {
                ge.printStackTrace(Err.getPrintWriter());
            }
            return loadedResources == null ? 0 : loadedResources.size();
        }

        @Override
        public Object getElementAt(int index) {
            List<Resource> loadedResources = null;
            try {
                loadedResources = Gate.getCreoleRegister().getAllInstances(ListEditorDialog.this.itemType);
            }
            catch (GateException ge) {
                ge.printStackTrace(Err.getPrintWriter());
            }
            return loadedResources == null ? null : loadedResources.get(index);
        }

        @Override
        public void setSelectedItem(Object anItem) {
            this.selectedItem = anItem == null ? null : anItem;
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedItem;
        }

        void fireDataChanged() {
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }

    protected class RemoveAction
    extends AbstractAction {
        RemoveAction() {
            super("Remove");
            this.putValue("ShortDescription", "Remove the selected value(s) from the list");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] indices = ListEditorDialog.this.listComponent.getSelectedIndices();
            Arrays.sort(indices);
            for (int i = indices.length - 1; i >= 0; --i) {
                ListEditorDialog.this.listModel.remove(indices[i]);
            }
        }
    }

    protected class AddAction
    extends AbstractAction {
        AddAction() {
            super("Add");
            this.putValue("ShortDescription", "Add the edited value to the list");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ListEditorDialog.this.finiteType) {
                ListEditorDialog.this.listModel.addElement(ListEditorDialog.this.combo.getSelectedItem());
            } else {
                String value = null;
                String stringValue = ListEditorDialog.this.textField.getText();
                if (stringValue == null || stringValue.length() == 0) {
                    stringValue = null;
                }
                if (ListEditorDialog.this.itemTypeClass.isAssignableFrom(String.class)) {
                    value = stringValue;
                } else {
                    try {
                        value = ListEditorDialog.this.itemTypeClass.getConstructor(String.class).newInstance(stringValue);
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(ListEditorDialog.this, "Invalid value!\nIs it the right type?", "GATE", 0);
                        return;
                    }
                }
                if (ListEditorDialog.this.comparator == null) {
                    ListEditorDialog.this.listModel.addElement(value);
                } else {
                    int index;
                    for (index = 0; index < ListEditorDialog.this.listModel.size() && ListEditorDialog.this.comparator.compare(value, ListEditorDialog.this.listModel.get(index)) > 0; ++index) {
                    }
                    if (index == ListEditorDialog.this.listModel.size()) {
                        ListEditorDialog.this.listModel.addElement(value);
                    } else if (ListEditorDialog.this.allowDuplicates || ListEditorDialog.this.comparator.compare(value, ListEditorDialog.this.listModel.get(index)) < 0) {
                        ListEditorDialog.this.listModel.add(index, value);
                    }
                }
                ListEditorDialog.this.textField.setText("");
                ListEditorDialog.this.textField.requestFocus();
            }
        }
    }
}

