/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.lucene;

import gate.creole.ir.SearchException;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class SubQueryParser {
    public static void main(String[] args) {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            block2: while (true) {
                System.out.print("Query: ");
                String line = in.readLine();
                if (line.length() != -1) {
                    List<String> queries = SubQueryParser.parseQuery(line);
                    int i = 0;
                    while (true) {
                        if (i >= queries.size()) continue block2;
                        System.out.println("=>" + queries.get(i));
                        ++i;
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String findWildCardString(int brClPos, String query) {
        String wcs = "";
        if (brClPos + 1 < query.length() && (query.charAt(brClPos + 1) == '*' || query.charAt(brClPos + 1) == '+' || query.charAt(brClPos + 1) == '?')) {
            wcs = query.charAt(brClPos + 1) + "";
            for (int i = brClPos + 2; i < query.length() && Character.isDigit(query.charAt(i)); ++i) {
                wcs = wcs + query.charAt(i);
            }
        }
        return wcs;
    }

    private static String extractWildcards(String query) throws SearchException {
        block0: while (true) {
            char ch = ' ';
            char pre = ' ';
            for (int i = 0; i < query.length(); ++i) {
                pre = ch;
                ch = query.charAt(i);
                if (!SubQueryParser.isOpenBracket(ch, pre)) continue;
                int brClPos = SubQueryParser.findBracketClosingPosition(i + 1, query);
                if (brClPos == -1) {
                    throw new SearchException("unbalanced brackets", "a closing bracket ()) is missing for this opening bracket", query, i);
                }
                String wildCardString = SubQueryParser.findWildCardString(brClPos, query);
                int wcsLen = 0;
                boolean atLeastOne = false;
                int repeatClause = 1;
                if (wildCardString.length() == 0) continue;
                if (wildCardString.length() == 1) {
                    wcsLen = 1;
                } else {
                    atLeastOne = wildCardString.charAt(0) != '*' && wildCardString.charAt(0) != '?';
                    repeatClause = Integer.parseInt(wildCardString.substring(1, wildCardString.length()));
                    wcsLen = wildCardString.length();
                }
                String previous = query.substring(0, i);
                String after = query.substring(brClPos + wcsLen + 1, query.length());
                String sToRepeat = query.substring(i, brClPos + 1);
                String newString = "(";
                for (int k = 1; k <= repeatClause; ++k) {
                    newString = newString + "(";
                    for (int subK = 0; subK < k; ++subK) {
                        newString = newString + sToRepeat;
                    }
                    newString = newString + ")";
                    if (k + 1 > repeatClause) continue;
                    newString = newString + " | ";
                }
                if (!atLeastOne) {
                    newString = newString + "| {__o__}";
                }
                newString = newString + ")";
                query = previous + newString + after;
                continue block0;
            }
            break;
        }
        return query;
    }

    public static List<String> parseQuery(String q1) throws SearchException {
        List<String> queries = new ArrayList<String>();
        q1 = q1.trim();
        q1 = "( " + q1 + " )";
        q1 = SubQueryParser.extractWildcards(q1);
        queries.add(q1);
        for (int index = 0; index < queries.size(); ++index) {
            String query = (String)queries.get(index);
            char ch = ' ';
            char pre = ' ';
            boolean duplicated = false;
            int dupliSize = 0;
            String data = "";
            for (int i = 0; i < query.length(); ++i) {
                pre = ch;
                ch = query.charAt(i);
                if (SubQueryParser.isOpenBracket(ch, pre)) {
                    int brClPos = SubQueryParser.findBracketClosingPosition(i + 1, query);
                    if (brClPos == -1) {
                        throw new SearchException("unbalanced brackets", "a closing bracket ()) is missing for this opening bracket", query, i);
                    }
                    ArrayList<String> orTokens = SubQueryParser.findOrTokens(query.substring(i + 1, brClPos));
                    if (orTokens.size() > 1) {
                        String text = "";
                        if (!duplicated && data.length() > 0) {
                            text = data;
                            data = "";
                        } else {
                            text = index == queries.size() - 1 ? "" : queries.get(queries.size() - 1);
                        }
                        queries = SubQueryParser.duplicate(queries, text, dupliSize, orTokens.size());
                        queries = SubQueryParser.writeTokens(orTokens, queries, dupliSize);
                        duplicated = true;
                        if (dupliSize == 0) {
                            dupliSize = 1;
                        }
                        dupliSize *= orTokens.size();
                    } else {
                        if (dupliSize == 0) {
                            if (data.length() == 0) {
                                queries.add("");
                            } else {
                                queries.add(data);
                            }
                            duplicated = true;
                            data = "";
                            dupliSize = 1;
                        }
                        queries = SubQueryParser.writeStringInAll(query.substring(i + 1, brClPos), dupliSize, queries);
                    }
                    i = brClPos;
                    continue;
                }
                if (SubQueryParser.isClosingBracket(ch, pre)) {
                    throw new SearchException("unbalanced brackets", "a opening bracket (() is missing for this closing bracket", query, i);
                }
                if (duplicated) {
                    queries = SubQueryParser.writeCharInAll(ch, dupliSize, queries);
                    continue;
                }
                data = data + "" + ch;
            }
            boolean scan = SubQueryParser.scanQueryForOrOrBracket(query);
            if (!scan) continue;
            queries.remove(index);
            --index;
        }
        ArrayList<String> queriesToReturn = new ArrayList<String>();
        for (int i = 0; i < queries.size(); ++i) {
            String q = (String)queries.get(i);
            if (q.trim().length() == 0 || queriesToReturn.contains(q.trim())) continue;
            queriesToReturn.add(q.trim());
        }
        return queriesToReturn;
    }

    public static boolean scanQueryForOrOrBracket(String query) {
        int index = 0;
        int index1 = 0;
        do {
            if ((index = query.indexOf(124, index)) == 0) {
                return true;
            }
            if (index > 0 && query.charAt(index - 1) != '\\') {
                return true;
            }
            if ((index1 = query.indexOf(40, index1)) == 0) {
                return true;
            }
            if (index1 <= 0 || query.charAt(index1 - 1) == '\\') continue;
            return true;
        } while (index >= 0 && index1 >= 0);
        return false;
    }

    private static List<String> writeTokens(List<String> tokens, List<String> queries, int dupliSize) {
        if (dupliSize == 0) {
            dupliSize = 1;
        }
        ArrayList<String> qToRemove = new ArrayList<String>();
        for (int j = 0; j < dupliSize; ++j) {
            for (int i = 1; i <= tokens.size(); ++i) {
                String token = tokens.get(i - 1);
                if (token.trim().equals("{__o__}")) {
                    token = " ";
                }
                String s = queries.get(queries.size() - (j * tokens.size() + i));
                qToRemove.add(s);
                s = s + token;
                queries.set(queries.size() - (j * tokens.size() + i), s);
            }
        }
        for (int i = 0; i < qToRemove.size(); ++i) {
            queries.remove(qToRemove.get(i));
        }
        return queries;
    }

    private static List<String> duplicate(List<String> queries, String s, int dupliSize, int no) {
        int i;
        if (s == null) {
            s = "";
        }
        ArrayList<String> strings = new ArrayList<String>();
        if (dupliSize == 0) {
            strings.add(s);
        } else {
            for (i = 0; i < dupliSize; ++i) {
                strings.add(queries.get(queries.size() - (i + 1)));
            }
        }
        for (i = 0; i < strings.size(); ++i) {
            for (int j = 0; j < no; ++j) {
                queries.add((String)strings.get(i));
            }
        }
        return queries;
    }

    public static ArrayList<String> findOrTokens(String query) {
        int balance = 0;
        char pre = ' ';
        char ch = ' ';
        ArrayList<String> ors = new ArrayList<String>();
        String s = "";
        for (int i = 0; i < query.length(); ++i) {
            pre = ch;
            ch = query.charAt(i);
            if (SubQueryParser.isOpenBracket(ch, pre)) {
                ++balance;
                s = s + "" + ch;
                continue;
            }
            if (SubQueryParser.isClosingBracket(ch, pre) && balance > 0) {
                --balance;
                s = s + "" + ch;
                continue;
            }
            if (SubQueryParser.isOrSym(ch, pre)) {
                if (balance > 0) {
                    s = s + "" + ch;
                    continue;
                }
                ors.add(s);
                s = "";
                continue;
            }
            s = s + "" + ch;
        }
        if (s.length() > 0) {
            ors.add(s);
        }
        return ors;
    }

    private static int findBracketClosingPosition(int startFrom, String query) {
        int balance = 0;
        char pre = ' ';
        char ch = ' ';
        for (int i = startFrom; i < query.length(); ++i) {
            pre = ch;
            ch = query.charAt(i);
            if (SubQueryParser.isOpenBracket(ch, pre)) {
                ++balance;
                continue;
            }
            if (!SubQueryParser.isClosingBracket(ch, pre)) continue;
            if (balance > 0) {
                --balance;
                continue;
            }
            return i;
        }
        return -1;
    }

    private static List<String> writeCharInAll(char c, int no, List<String> queries) {
        for (int i = 0; i < no; ++i) {
            String s = queries.get(queries.size() - (i + 1));
            s = s + "" + c;
            queries.set(queries.size() - (i + 1), s);
        }
        return queries;
    }

    private static List<String> writeStringInAll(String c, int no, List<String> queries) {
        for (int i = 0; i < no; ++i) {
            String s = queries.get(queries.size() - (i + 1));
            s = s + "" + c;
            queries.set(queries.size() - (i + 1), s);
        }
        return queries;
    }

    private static boolean isOpenBracket(char ch, char pre) {
        return ch == '(' && pre != '\\';
    }

    private static boolean isClosingBracket(char ch, char pre) {
        return ch == ')' && pre != '\\';
    }

    private static boolean isOrSym(char ch, char pre) {
        return ch == '|' && pre != '\\';
    }
}

