/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.lucene;

import gate.creole.annic.apache.lucene.index.Term;
import gate.creole.annic.apache.lucene.search.BooleanQuery;
import gate.creole.annic.apache.lucene.search.PhraseQuery;
import gate.creole.annic.apache.lucene.search.Query;
import gate.creole.annic.apache.lucene.search.TermQuery;
import gate.creole.annic.lucene.SubQueryParser;
import gate.creole.ir.SearchException;
import java.util.ArrayList;
import java.util.List;

public class QueryParser {
    private List<String> queries = new ArrayList<String>();
    private String field = "";
    private String baseTokenAnnotationType = "Token";
    private boolean needValidation = true;
    public int position = 0;
    boolean areAllTermsTokens = false;

    public static void main(String[] args) {
        System.out.println(QueryParser.isValidQuery(args[0]));
    }

    public static boolean isValidQuery(String query) {
        QueryParser qp = new QueryParser();
        try {
            qp.parse("contents", query, "Token", null, null);
        }
        catch (SearchException se) {
            return false;
        }
        return true;
    }

    public Query[] parse(String field, String query, String baseTokenAnnotationType, String corpusID, String annotationSetToSearchIn) throws SearchException {
        this.field = field;
        this.baseTokenAnnotationType = baseTokenAnnotationType;
        this.position = 0;
        this.queries = SubQueryParser.parseQuery(query);
        Query[] q = new Query[this.queries.size()];
        for (int i = 0; i < this.queries.size(); ++i) {
            TermQuery tQuery;
            Term t;
            BooleanQuery booleanQuery;
            Query phraseQuery = this.createPhraseQuery(this.queries.get(i));
            if (corpusID == null && annotationSetToSearchIn == null) {
                booleanQuery = new BooleanQuery();
                t = new Term("ANNOTATION_SET_ID", "Combined sets");
                tQuery = new TermQuery(t);
                booleanQuery.add(tQuery, false, true);
                booleanQuery.add(phraseQuery, true, false);
                q[i] = booleanQuery;
                continue;
            }
            booleanQuery = new BooleanQuery();
            booleanQuery.add(phraseQuery, true, false);
            if (corpusID != null) {
                t = new Term("CORPUS_ID", corpusID);
                tQuery = new TermQuery(t);
                booleanQuery.add(tQuery, true, false);
            }
            if (annotationSetToSearchIn != null) {
                t = new Term("ANNOTATION_SET_ID", annotationSetToSearchIn);
                tQuery = new TermQuery(t);
                booleanQuery.add(tQuery, true, false);
            } else {
                t = new Term("ANNOTATION_SET_ID", "Combined sets");
                tQuery = new TermQuery(t);
                booleanQuery.add(tQuery, false, true);
            }
            q[i] = booleanQuery;
        }
        return q;
    }

    public String getQueryString(int i) {
        return this.queries.get(i);
    }

    private Query createPhraseQuery(String query) throws SearchException {
        this.position = 0;
        PhraseQuery phQuery = new PhraseQuery();
        List<String> tokens = this.findTokens(query);
        if (tokens.size() == 1) {
            List<?>[] termsPos = this.createTerms(tokens.get(0));
            List<?> terms = termsPos[0];
            if (terms.size() == 1) {
                this.needValidation = !this.areAllTermsTokens;
                return new TermQuery((Term)terms.get(0));
            }
            this.position = 0;
        }
        int totalTerms = 0;
        boolean hadPreviousTermsAToken = true;
        this.needValidation = false;
        for (int i = 0; i < tokens.size(); ++i) {
            Term t;
            int k;
            List<?>[] termpositions = this.createTerms(tokens.get(i));
            List<?> terms = termpositions[0];
            List<?> pos = termpositions[1];
            List<?> consider = termpositions[2];
            boolean allTermsTokens = true;
            for (k = 0; k < terms.size(); ++k) {
                t = (Term)terms.get(k);
                if (!allTermsTokens) continue;
                allTermsTokens = this.isBaseTokenTerm(t);
            }
            if (!hadPreviousTermsAToken) {
                this.needValidation = true;
                break;
            }
            if (!allTermsTokens) {
                this.needValidation = true;
                if (i > 0) break;
            }
            for (k = 0; k < terms.size(); ++k) {
                t = (Term)terms.get(k);
                boolean considerValue = (Boolean)consider.get(k);
                phQuery.add(t, (Integer)pos.get(k), considerValue);
                if (!considerValue) continue;
                ++totalTerms;
            }
            hadPreviousTermsAToken = allTermsTokens;
        }
        phQuery.setTotalTerms(totalTerms);
        return phQuery;
    }

    private boolean isBaseTokenTerm(Term t) {
        if (t.text().equals(this.baseTokenAnnotationType) && t.type().equals("*")) {
            return true;
        }
        return t.type().startsWith(this.baseTokenAnnotationType + ".");
    }

    public List<String> findTokens(String query) throws SearchException {
        ArrayList<String> tokens = new ArrayList<String>();
        String token = "";
        char ch = ' ';
        char prev = ' ';
        int balance = 0;
        for (int i = 0; i < query.length(); ++i) {
            prev = ch;
            ch = query.charAt(i);
            if (this.isOpeneningBrace(ch, prev)) {
                if (balance != 0) {
                    throw new SearchException("unbalanced braces", "a closing brace (}) is missing before this opening brace", query, i);
                }
                if (!token.trim().equals("")) {
                    tokens.add(token.trim());
                }
                ++balance;
                token = "{";
                continue;
            }
            if (this.isClosingBrace(ch, prev)) {
                if (--balance != 0) {
                    throw new SearchException("unbalanced braces", "an opening brace ({) is missing before this closing brace", query, i);
                }
                token = token + "}";
                tokens.add(token.trim());
                token = "";
                continue;
            }
            token = token + ch;
        }
        if (balance != 0) {
            if (balance > 0) {
                throw new SearchException("unbalanced braces", "One closing brace (}) is missing in this expression", query);
            }
            throw new SearchException("unbalanced braces", "One opening brace ({) is missing in this expression", query);
        }
        if (!token.trim().equals("")) {
            tokens.add(token);
        }
        return tokens;
    }

    private boolean isOpeneningBrace(char ch, char pre) {
        return ch == '{' && pre != '\\';
    }

    private boolean isClosingBrace(char ch, char pre) {
        return ch == '}' && pre != '\\';
    }

    private boolean isEscapeSequence(String element, int index) {
        if (index > 0) {
            return element.charAt(index - 1) == '\\';
        }
        return false;
    }

    private ArrayList<String> splitString(String string, char with, boolean normalize) {
        ArrayList<String> strings = new ArrayList<String>();
        StringBuffer newString = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (i == 0) {
                newString.append(string.charAt(0));
                continue;
            }
            if (string.charAt(i) == with) {
                if (string.charAt(i - 1) == '\\') {
                    newString.append(with);
                    continue;
                }
                if (normalize) {
                    strings.add(this.norm(newString.toString()));
                } else {
                    strings.add(newString.toString());
                }
                newString = new StringBuffer();
                continue;
            }
            newString.append(string.charAt(i));
        }
        if (newString.length() > 0) {
            if (normalize) {
                strings.add(this.norm(newString.toString()).trim());
            } else {
                strings.add(newString.toString().trim());
            }
        }
        return strings;
    }

    private int findIndexOf(String element, char ch) {
        int index1 = -1;
        int start = -1;
        while (this.isEscapeSequence(element, index1 = element.indexOf(ch, start))) {
            start = index1 + 1;
        }
        return index1;
    }

    private String norm(String string) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char ch;
            if (string.charAt(i) == '\\' && i + 1 <= string.length() - 1 && ((ch = string.charAt(i + 1)) == ',' || ch == '.' || ch == '(' || ch == ')' || ch == '{' || ch == '}' || ch == '\"' || ch == '\\')) continue;
            sb.append(string.charAt(i));
        }
        return sb.toString();
    }

    public List<?>[] createTerms(String elem) throws SearchException {
        ArrayList<Boolean> consider;
        ArrayList<Integer> pos;
        ArrayList<Term> terms;
        block26: {
            block24: {
                int index1;
                int index;
                block27: {
                    block25: {
                        this.areAllTermsTokens = true;
                        terms = new ArrayList<Term>();
                        pos = new ArrayList<Integer>();
                        consider = new ArrayList<Boolean>();
                        if ((elem = elem.trim()).charAt(0) != '{' || elem.charAt(elem.length() - 1) != '}') break block24;
                        elem = elem.substring(1, elem.length() - 1);
                        index = elem.indexOf("==");
                        index1 = this.findIndexOf(elem, '.');
                        if (index != -1 || index1 != -1) break block25;
                        ArrayList<String> fields = this.splitString(elem, ',', true);
                        for (int p = 0; p < fields.size(); ++p) {
                            if (this.areAllTermsTokens && !fields.get(p).equals(this.baseTokenAnnotationType)) {
                                this.areAllTermsTokens = false;
                            }
                            terms.add(new Term(this.field, this.norm(fields.get(p)), "*"));
                            pos.add(this.position);
                            consider.add(p == 0);
                        }
                        ++this.position;
                        break block26;
                    }
                    if (index == -1 || index1 != -1) break block27;
                    ArrayList<String> fields = this.splitString(elem, ',', false);
                    for (int p = 0; p < fields.size(); ++p) {
                        index = fields.get(p).indexOf("==");
                        if (index != -1) {
                            String annotType = this.norm(fields.get(p).substring(0, index).trim());
                            String annotText = this.norm(fields.get(p).substring(index + 2, fields.get(p).length()).trim());
                            if (annotText.length() > 2 && annotText.charAt(0) == '\"' && annotText.charAt(annotText.length() - 1) == '\"') {
                                annotText = annotText.substring(1, annotText.length() - 1);
                            }
                            if (!annotType.trim().equals(this.baseTokenAnnotationType)) {
                                this.areAllTermsTokens = false;
                            }
                            terms.add(new Term(this.field, annotText, annotType + ".string"));
                            pos.add(this.position);
                            consider.add(p == 0);
                            continue;
                        }
                        if (!this.norm(fields.get(p)).equals(this.baseTokenAnnotationType)) {
                            this.areAllTermsTokens = false;
                        }
                        terms.add(new Term(this.field, this.norm(fields.get(p)), "*"));
                        pos.add(this.position);
                        consider.add(p == 0);
                    }
                    ++this.position;
                    break block26;
                }
                if (index == -1 && index1 != -1) {
                    throw new SearchException("missing operator", "an equal operator (==) is missing", elem, elem.indexOf("=", index1) != -1 ? elem.indexOf("=", index1) : elem.length());
                }
                if (index == -1 || index1 == -1) break block26;
                int index2 = this.findIndexOf(elem, ',');
                String[] subElems = null;
                if (index2 == -1) {
                    subElems = new String[]{elem};
                } else {
                    ArrayList<String> list = this.splitString(elem, ',', false);
                    subElems = new String[list.size()];
                    for (int k = 0; k < list.size(); ++k) {
                        subElems[k] = list.get(k);
                    }
                }
                int lengthTravelledSoFar = 0;
                for (int j = 0; j < subElems.length; ++j) {
                    String annotType;
                    index = subElems[j].indexOf("==");
                    index1 = this.findIndexOf(subElems[j], '.');
                    if (index == -1 && index1 == -1) {
                        if (!this.norm(subElems[j].trim()).equals(this.baseTokenAnnotationType)) {
                            this.areAllTermsTokens = false;
                        }
                        terms.add(new Term(this.field, this.norm(subElems[j].trim()), "*"));
                        pos.add(this.position);
                        consider.add(j == 0);
                    } else if (index != -1 && index1 == -1) {
                        annotType = this.norm(subElems[j].substring(0, index).trim());
                        String annotText = this.norm(subElems[j].substring(index + 2, subElems[j].length()).trim());
                        if (annotText.charAt(0) == '\"' && annotText.charAt(annotText.length() - 1) == '\"') {
                            annotText = annotText.substring(1, annotText.length() - 1);
                        }
                        if (!annotType.trim().equals(this.baseTokenAnnotationType)) {
                            this.areAllTermsTokens = false;
                        }
                        terms.add(new Term(this.field, annotText, annotType + ".string"));
                        pos.add(this.position);
                        consider.add(j == 0);
                    } else {
                        if (index == -1 && index1 != -1) {
                            throw new SearchException("missing operator", "an equal operator (==) is missing", elem, elem.indexOf("=", lengthTravelledSoFar) != -1 ? elem.indexOf("=", lengthTravelledSoFar) : elem.length());
                        }
                        annotType = this.norm(subElems[j].substring(0, index1).trim());
                        String featureType = this.norm(subElems[j].substring(index1 + 1, index).trim());
                        String featureText = this.norm(subElems[j].substring(index + 2, subElems[j].length()).trim());
                        if (featureText.length() > 2 && featureText.charAt(0) == '\"' && featureText.charAt(featureText.length() - 1) == '\"') {
                            featureText = featureText.substring(1, featureText.length() - 1);
                        }
                        if (!annotType.trim().equals(this.baseTokenAnnotationType)) {
                            this.areAllTermsTokens = false;
                        }
                        terms.add(new Term(this.field, featureText, annotType + "." + featureType));
                        pos.add(this.position);
                        consider.add(j == 0);
                    }
                    lengthTravelledSoFar += subElems[j].length() + 1;
                }
                ++this.position;
                break block26;
            }
            StringBuilder newString = new StringBuilder();
            char prev = ' ';
            char ch = ' ';
            for (int i = 0; i < elem.length(); ++i) {
                prev = ch;
                ch = elem.charAt(i);
                if (ch == '\"' && prev != '\\') continue;
                newString.append(ch);
            }
            String[] subTokens = this.norm(newString.toString()).split("( )+");
            for (int k = 0; k < subTokens.length; ++k) {
                if (subTokens[k].trim().length() <= 0) continue;
                terms.add(new Term(this.field, this.norm(subTokens[k]), this.baseTokenAnnotationType + ".string"));
                pos.add(this.position);
                consider.add(Boolean.TRUE);
                ++this.position;
            }
        }
        return new List[]{terms, pos, consider};
    }

    public boolean needValidation() {
        return this.needValidation;
    }
}

