/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.lucene;

import gate.creole.annic.Hit;
import gate.creole.annic.Pattern;
import gate.creole.annic.SearchException;
import gate.creole.annic.Searcher;
import gate.creole.annic.apache.lucene.document.Document;
import gate.creole.annic.apache.lucene.index.IndexReader;
import gate.creole.annic.apache.lucene.index.Term;
import gate.creole.annic.apache.lucene.index.TermEnum;
import gate.creole.annic.apache.lucene.search.BooleanQuery;
import gate.creole.annic.apache.lucene.search.Hits;
import gate.creole.annic.apache.lucene.search.IndexSearcher;
import gate.creole.annic.apache.lucene.search.TermQuery;
import gate.creole.annic.lucene.LuceneSearchThread;
import gate.creole.annic.lucene.StatsCalculator;
import gate.persist.LuceneDataStoreImpl;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LuceneSearcher
implements Searcher {
    private List<String> indexLocations = null;
    private String query = null;
    private int contextWindow = 5;
    private List<Pattern> annicPatterns = new ArrayList<Pattern>();
    public Map<String, List<String>> annotationTypesMap = new HashMap<String, List<String>>();
    private Map<String, Object> parameters = null;
    private String corpusToSearchIn = null;
    private String annotationSetToSearchIn = null;
    private Hits luceneHits = null;
    private boolean wasDeleteQuery = false;
    private List<LuceneSearchThread> luceneSearchThreads = null;
    private boolean success = false;
    private int luceneSearchThreadIndex = 0;
    private boolean fwdIterationEnded = false;
    private LuceneDataStoreImpl datastore;
    private Map<String, List<String>> queryTokens = new HashMap<String, List<String>>();

    @Override
    public Hit[] next(int numberOfHits) throws SearchException {
        this.annicPatterns = new ArrayList<Pattern>();
        if (!this.success) {
            this.annicPatterns = new ArrayList<Pattern>();
            return this.getHits();
        }
        if (this.fwdIterationEnded) {
            this.annicPatterns = new ArrayList<Pattern>();
            return this.getHits();
        }
        try {
            if (this.wasDeleteQuery) {
                ArrayList<String> docIDs = new ArrayList<String>();
                ArrayList<String> setNames = new ArrayList<String>();
                for (int i = 0; i < this.luceneHits.length(); ++i) {
                    Document luceneDoc = this.luceneHits.doc(i);
                    String documentID = luceneDoc.get("DOCUMENT_ID");
                    String annotationSetID = luceneDoc.get("ANNOTATION_SET_ID");
                    int index = docIDs.indexOf(documentID);
                    if (index == -1) {
                        docIDs.add(documentID);
                        setNames.add(annotationSetID);
                        continue;
                    }
                    if (((String)setNames.get(index)).equals(annotationSetID)) continue;
                    docIDs.add(documentID);
                    setNames.add(annotationSetID);
                }
                Hit[] toReturn = new Hit[docIDs.size()];
                for (int i = 0; i < toReturn.length; ++i) {
                    toReturn[i] = new Hit((String)docIDs.get(i), (String)setNames.get(i), 0, 0, "");
                }
                return toReturn;
            }
            while (this.luceneSearchThreadIndex < this.luceneSearchThreads.size()) {
                LuceneSearchThread lst = this.luceneSearchThreads.get(this.luceneSearchThreadIndex);
                List<Pattern> results = lst.next(numberOfHits);
                if (results != null) {
                    if (numberOfHits != -1) {
                        numberOfHits -= results.size();
                    }
                    this.annicPatterns.addAll(results);
                    if (numberOfHits == 0) {
                        return this.getHits();
                    }
                }
                ++this.luceneSearchThreadIndex;
            }
            this.fwdIterationEnded = true;
            return this.getHits();
        }
        catch (Exception e) {
            throw new SearchException(e);
        }
    }

    @Override
    public boolean search(String query, Map<String, Object> parameters) throws SearchException {
        this.luceneHits = null;
        this.annicPatterns = new ArrayList<Pattern>();
        this.annotationTypesMap = new HashMap<String, List<String>>();
        this.luceneSearchThreads = new ArrayList<LuceneSearchThread>();
        this.luceneSearchThreadIndex = 0;
        this.success = false;
        this.fwdIterationEnded = false;
        this.wasDeleteQuery = false;
        if (parameters == null) {
            throw new SearchException("Parameters cannot be null");
        }
        this.parameters = parameters;
        if (parameters.size() == 2 && parameters.get("INDEX_LOCATION_URL") != null) {
            String corpusID = (String)parameters.get("CORPUS_ID");
            String indexLocation = null;
            try {
                indexLocation = new File(((URL)parameters.get("INDEX_LOCATION_URL")).toURI()).getAbsolutePath();
            }
            catch (URISyntaxException use) {
                indexLocation = new File(((URL)parameters.get("INDEX_LOCATION_URL")).getFile()).getAbsolutePath();
            }
            if (corpusID != null && indexLocation != null) {
                this.wasDeleteQuery = true;
                Term term = new Term("CORPUS_ID", corpusID);
                TermQuery tq = new TermQuery(term);
                try {
                    IndexSearcher searcher = new IndexSearcher(indexLocation);
                    this.luceneHits = searcher.search(tq);
                    this.success = this.luceneHits.length() > 0;
                    return this.success;
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    throw new SearchException(ioe);
                }
            }
        }
        if (parameters.get("INDEX_LOCATIONS") == null) {
            String indexLocation;
            try {
                indexLocation = new File(((URL)this.datastore.getIndexer().getParameters().get("INDEX_LOCATION_URL")).toURI()).getAbsolutePath();
            }
            catch (URISyntaxException use) {
                indexLocation = new File(((URL)this.datastore.getIndexer().getParameters().get("INDEX_LOCATION_URL")).getFile()).getAbsolutePath();
            }
            ArrayList<String> indexLocations = new ArrayList<String>();
            indexLocations.add(indexLocation);
            parameters.put("INDEX_LOCATIONS", indexLocations);
        }
        this.indexLocations = new ArrayList<String>((List)parameters.get("INDEX_LOCATIONS"));
        if (this.indexLocations.size() == 0) {
            throw new SearchException("Corpus is not initialized");
        }
        if (parameters.get("CONTEXT_WINDOW") == null) {
            throw new SearchException("Parameter CONTEXT_WINDOW is not provided!");
        }
        this.contextWindow = (Integer)parameters.get("CONTEXT_WINDOW");
        if (this.getContextWindow() <= 0) {
            throw new SearchException("Context Window must be atleast 1 or > 1");
        }
        if (query == null) {
            throw new SearchException("Query is not initialized");
        }
        this.query = query;
        this.corpusToSearchIn = (String)parameters.get("CORPUS_ID");
        this.annotationSetToSearchIn = (String)parameters.get("ANNOTATION_SET_ID");
        this.annicPatterns = new ArrayList<Pattern>();
        this.annotationTypesMap = new HashMap<String, List<String>>();
        this.luceneSearchThreads = new ArrayList<LuceneSearchThread>();
        for (int indexCounter = 0; indexCounter < this.indexLocations.size(); ++indexCounter) {
            LuceneSearchThread lst = new LuceneSearchThread();
            String location = this.indexLocations.get(indexCounter);
            if (!lst.search(query, this.contextWindow, location, this.corpusToSearchIn, this.annotationSetToSearchIn, this)) continue;
            this.luceneSearchThreads.add(lst);
        }
        this.success = this.luceneSearchThreads.size() > 0;
        return this.success;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    public Integer getContextWindow() {
        return this.contextWindow;
    }

    @Override
    public Hit[] getHits() {
        if (this.annicPatterns == null) {
            this.annicPatterns = new ArrayList<Pattern>();
        }
        Hit[] hits = new Hit[this.annicPatterns.size()];
        for (int i = 0; i < this.annicPatterns.size(); ++i) {
            hits[i] = this.annicPatterns.get(i);
        }
        return hits;
    }

    @Override
    public Map<String, List<String>> getAnnotationTypesMap() {
        return this.annotationTypesMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String[] getIndexedAnnotationSetNames() throws SearchException {
        String indexLocation;
        try {
            indexLocation = new File(((URL)this.datastore.getIndexer().getParameters().get("INDEX_LOCATION_URL")).toURI()).getAbsolutePath();
        }
        catch (URISyntaxException use) {
            indexLocation = new File(((URL)this.datastore.getIndexer().getParameters().get("INDEX_LOCATION_URL")).getFile()).getAbsolutePath();
        }
        this.annotationTypesMap = new HashMap<String, List<String>>();
        HashSet<String> toReturn = new HashSet<String>();
        try (IndexReader reader = IndexReader.open(indexLocation);){
            TermEnum terms = reader.terms(new Term("ANNOTATION_SET_ID", ""));
            if (terms == null) {
                String[] stringArray = new String[]{};
                return stringArray;
            }
            HashSet<String> annotSets = new HashSet<String>();
            boolean foundAnnotSet = false;
            do {
                Term t;
                if ((t = terms.term()) == null) continue;
                if (t.field().equals("ANNOTATION_SET_ID")) {
                    annotSets.add(t.text());
                    foundAnnotSet = true;
                    continue;
                }
                if (foundAnnotSet) break;
            } while (terms.next());
            Iterator iterator = annotSets.iterator();
            block17: while (iterator.hasNext()) {
                String annotSet = (String)iterator.next();
                Term term = new Term("ANNOTATION_SET_ID", annotSet);
                TermQuery tq = new TermQuery(term);
                try (IndexSearcher searcher = new IndexSearcher(indexLocation);){
                    Hits annotSetHits = searcher.search(tq);
                    int i = 0;
                    while (true) {
                        if (i >= annotSetHits.length()) continue block17;
                        Document luceneDoc = annotSetHits.doc(i);
                        String corpusID = luceneDoc.get("CORPUS_ID");
                        if (corpusID == null) {
                            corpusID = "";
                        }
                        toReturn.add(corpusID + ";" + annotSet);
                        Term annotSetTerm = new Term("ANNOTATION_SET_ID", annotSet);
                        TermQuery atq = new TermQuery(annotSetTerm);
                        BooleanQuery bq = new BooleanQuery();
                        bq.add(tq, true, false);
                        bq.add(atq, true, false);
                        try (IndexSearcher indexFeatureSearcher = new IndexSearcher(indexLocation);){
                            Hits indexFeaturesHits = searcher.search(bq);
                            for (int j = 0; j < indexFeaturesHits.length(); ++j) {
                                String[] features;
                                Document aDoc = indexFeaturesHits.doc(j);
                                String indexedFeatures = aDoc.get("INDEXED_FEATURES");
                                if (indexedFeatures == null) continue;
                                for (String aFeature : features = indexedFeatures.split(";")) {
                                    int index = aFeature.indexOf(".");
                                    if (index == -1) continue;
                                    String type = aFeature.substring(0, index);
                                    String featureName = aFeature.substring(index + 1);
                                    String key = corpusID + ";" + annotSet + ";" + type;
                                    List<String> listOfFeatures = this.annotationTypesMap.get(key);
                                    if (listOfFeatures == null) {
                                        listOfFeatures = new ArrayList<String>();
                                        this.annotationTypesMap.put(key, listOfFeatures);
                                    }
                                    if (listOfFeatures.contains(featureName)) continue;
                                    listOfFeatures.add(featureName);
                                }
                            }
                        }
                        ++i;
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    throw new SearchException(ioe);
                }
            }
            return toReturn.toArray(new String[0]);
        }
        catch (IOException ioe) {
            throw new SearchException(ioe);
        }
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public synchronized List<String> getQueryTokens(String query) {
        return this.queryTokens.get(query);
    }

    public synchronized void addQueryTokens(String query, List<String> queryTokens) {
        this.queryTokens.put(query, queryTokens);
    }

    @Override
    public void exportResults(File outputFile) {
        throw new RuntimeException("ExportResults method is not implemented yet!");
    }

    @Override
    public int freq(String corpusToSearchIn, String annotationSetToSearchIn, String annotationType, String featureName, String value) throws SearchException {
        IndexSearcher indexSearcher;
        String indexLocation;
        try {
            indexLocation = new File(((URL)this.datastore.getIndexer().getParameters().get("INDEX_LOCATION_URL")).toURI()).getAbsolutePath();
        }
        catch (URISyntaxException use) {
            indexLocation = new File(((URL)this.datastore.getIndexer().getParameters().get("INDEX_LOCATION_URL")).getFile()).getAbsolutePath();
        }
        try {
            indexSearcher = new IndexSearcher(indexLocation);
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
        int result = StatsCalculator.freq(indexSearcher, corpusToSearchIn, annotationSetToSearchIn, annotationType, featureName, value);
        try {
            indexSearcher.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return -1;
        }
        return result;
    }

    @Override
    public int freq(String corpusToSearchIn, String annotationSetToSearchIn, String annotationType) throws SearchException {
        return this.freq(corpusToSearchIn, annotationSetToSearchIn, annotationType, null, null);
    }

    @Override
    public int freq(String corpusToSearchIn, String annotationSetToSearchIn, String annotationType, String featureName) throws SearchException {
        return this.freq(corpusToSearchIn, annotationSetToSearchIn, annotationType, featureName, null);
    }

    @Override
    public int freq(List<Hit> patternsToSearchIn, String annotationType, String feature, String value, boolean inMatchedSpan, boolean inContext) throws SearchException {
        return StatsCalculator.freq(patternsToSearchIn, annotationType, feature, value, inMatchedSpan, inContext);
    }

    @Override
    public int freq(List<Hit> patternsToSearchIn, String annotationType, boolean inMatchedSpan, boolean inContext) throws SearchException {
        return StatsCalculator.freq(patternsToSearchIn, annotationType, inMatchedSpan, inContext);
    }

    @Override
    public Map<String, Integer> freqForAllValues(List<Hit> patternsToSearchIn, String annotationType, String feature, boolean inMatchedSpan, boolean inContext) throws SearchException {
        return StatsCalculator.freqForAllValues(patternsToSearchIn, annotationType, feature, inMatchedSpan, inContext);
    }

    public void setLuceneDatastore(LuceneDataStoreImpl datastore) {
        this.datastore = datastore;
    }
}

