/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.store;

import gate.creole.annic.apache.lucene.store.Directory;
import gate.creole.annic.apache.lucene.store.FSInputStream;
import gate.creole.annic.apache.lucene.store.FSOutputStream;
import gate.creole.annic.apache.lucene.store.InputStream;
import gate.creole.annic.apache.lucene.store.Lock;
import gate.creole.annic.apache.lucene.store.OutputStream;
import gate.creole.annic.apache.lucene.util.Constants;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;

public final class FSDirectory
extends Directory {
    private static final Hashtable DIRECTORIES = new Hashtable();
    private static final boolean DISABLE_LOCKS = Boolean.getBoolean("disableLuceneLocks") || Constants.JAVA_1_1;
    public static final String LOCK_DIR = System.getProperty("gate.creole.annic.apache.lucene.lockdir", System.getProperty("java.io.tmpdir"));
    private static MessageDigest DIGESTER;
    private byte[] buffer = null;
    private File directory = null;
    private int refCount;
    private File lockDir;
    private static final char[] HEX_DIGITS;

    public static FSDirectory getDirectory(String path, boolean create) throws IOException {
        return FSDirectory.getDirectory(new File(path), create);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FSDirectory getDirectory(File file, boolean create) throws IOException {
        FSDirectory dir;
        file = new File(file.getCanonicalPath());
        Object object = DIRECTORIES;
        synchronized (object) {
            dir = (FSDirectory)DIRECTORIES.get(file);
            if (dir == null) {
                dir = new FSDirectory(file, create);
                DIRECTORIES.put(file, dir);
            } else if (create) {
                dir.create();
            }
        }
        object = dir;
        synchronized (object) {
            ++dir.refCount;
        }
        return dir;
    }

    private FSDirectory(File path, boolean create) throws IOException {
        this.directory = path;
        this.lockDir = LOCK_DIR == null ? this.directory : new File(LOCK_DIR);
        if (create) {
            this.create();
        }
        if (!this.directory.isDirectory()) {
            throw new IOException(path + " not a directory");
        }
    }

    private synchronized void create() throws IOException {
        if (!this.directory.exists() && !this.directory.mkdirs()) {
            throw new IOException("Cannot create directory: " + this.directory);
        }
        String[] files = this.directory.list();
        for (int i = 0; i < files.length; ++i) {
            File file = new File(this.directory, files[i]);
            if (file.isDirectory() || file.delete()) continue;
            throw new IOException("Cannot delete " + files[i]);
        }
        String lockPrefix = this.getLockPrefix().toString();
        files = this.lockDir.list();
        for (int i = 0; i < files.length; ++i) {
            File lockFile;
            if (!files[i].startsWith(lockPrefix) || (lockFile = new File(this.lockDir, files[i])).delete()) continue;
            throw new IOException("Cannot delete " + files[i]);
        }
    }

    @Override
    public final String[] list() throws IOException {
        return this.directory.list();
    }

    @Override
    public final boolean fileExists(String name) throws IOException {
        File file = new File(this.directory, name);
        return file.exists();
    }

    @Override
    public final long fileModified(String name) throws IOException {
        File file = new File(this.directory, name);
        return file.lastModified();
    }

    public static final long fileModified(File directory, String name) throws IOException {
        File file = new File(directory, name);
        return file.lastModified();
    }

    @Override
    public void touchFile(String name) throws IOException {
        File file = new File(this.directory, name);
        file.setLastModified(System.currentTimeMillis());
    }

    @Override
    public final long fileLength(String name) throws IOException {
        File file = new File(this.directory, name);
        return file.length();
    }

    @Override
    public final void deleteFile(String name) throws IOException {
        File file = new File(this.directory, name);
        if (!file.delete()) {
            throw new IOException("Cannot delete " + name);
        }
    }

    @Override
    public final synchronized void renameFile(String from, String to) throws IOException {
        File old = new File(this.directory, from);
        File nu = new File(this.directory, to);
        if (nu.exists() && !nu.delete()) {
            throw new IOException("Cannot delete " + to);
        }
        if (!old.renameTo(nu)) {
            FileInputStream in = null;
            java.io.OutputStream out = null;
            try {
                int len;
                in = new FileInputStream(old);
                out = new FileOutputStream(nu);
                if (this.buffer == null) {
                    this.buffer = new byte[1024];
                }
                while ((len = ((java.io.InputStream)in).read(this.buffer)) >= 0) {
                    out.write(this.buffer, 0, len);
                }
                old.delete();
            }
            catch (IOException ioe) {
                throw new IOException("Cannot rename " + from + " to " + to);
            }
            finally {
                if (in != null) {
                    try {
                        ((java.io.InputStream)in).close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Cannot close input stream: " + e.getMessage());
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Cannot close output stream: " + e.getMessage());
                    }
                }
            }
        }
    }

    @Override
    public final OutputStream createFile(String name) throws IOException {
        return new FSOutputStream(new File(this.directory, name));
    }

    @Override
    public final InputStream openFile(String name) throws IOException {
        return new FSInputStream(new File(this.directory, name));
    }

    @Override
    public final Lock makeLock(String name) {
        StringBuffer buf = this.getLockPrefix();
        buf.append("-");
        buf.append(name);
        final File lockFile = new File(this.lockDir, buf.toString());
        return new Lock(){

            @Override
            public boolean obtain() throws IOException {
                if (DISABLE_LOCKS) {
                    return true;
                }
                if (!FSDirectory.this.lockDir.exists() && !FSDirectory.this.lockDir.mkdirs()) {
                    throw new IOException("Cannot create lock directory: " + FSDirectory.this.lockDir);
                }
                return lockFile.createNewFile();
            }

            @Override
            public void release() {
                if (DISABLE_LOCKS) {
                    return;
                }
                lockFile.delete();
            }

            @Override
            public boolean isLocked() {
                if (DISABLE_LOCKS) {
                    return false;
                }
                return lockFile.exists();
            }

            public String toString() {
                return "Lock@" + lockFile;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer getLockPrefix() {
        byte[] digest;
        String dirName;
        try {
            dirName = this.directory.getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
        MessageDigest messageDigest = DIGESTER;
        synchronized (messageDigest) {
            digest = DIGESTER.digest(dirName.getBytes());
        }
        StringBuffer buf = new StringBuffer();
        buf.append("lucene-");
        for (int i = 0; i < digest.length; ++i) {
            byte b = digest[i];
            buf.append(HEX_DIGITS[b >> 4 & 0xF]);
            buf.append(HEX_DIGITS[b & 0xF]);
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized void close() throws IOException {
        if (--this.refCount <= 0) {
            Hashtable hashtable = DIRECTORIES;
            synchronized (hashtable) {
                DIRECTORIES.remove(this.directory);
            }
        }
    }

    public File getFile() {
        return this.directory;
    }

    public String toString() {
        return "FSDirectory@" + this.directory;
    }

    static {
        try {
            DIGESTER = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.toString());
        }
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }
}

