/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.search;

import gate.creole.annic.apache.lucene.index.IndexReader;
import gate.creole.annic.apache.lucene.index.Term;
import gate.creole.annic.apache.lucene.index.TermDocs;
import gate.creole.annic.apache.lucene.search.Explanation;
import gate.creole.annic.apache.lucene.search.Query;
import gate.creole.annic.apache.lucene.search.Scorer;
import gate.creole.annic.apache.lucene.search.Searcher;
import gate.creole.annic.apache.lucene.search.Similarity;
import gate.creole.annic.apache.lucene.search.TermScorer;
import gate.creole.annic.apache.lucene.search.Weight;
import java.io.IOException;

public class TermQuery
extends Query {
    private Term term;

    public TermQuery(Term t) {
        this.term = t;
    }

    public Term getTerm() {
        return this.term;
    }

    @Override
    protected Weight createWeight(Searcher searcher) {
        return new TermWeight(searcher);
    }

    @Override
    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        if (!this.term.field().equals(field)) {
            buffer.append(this.term.field());
            buffer.append(":");
        }
        buffer.append(this.term.text());
        if (this.getBoost() != 1.0f) {
            buffer.append("^");
            buffer.append(Float.toString(this.getBoost()));
        }
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof TermQuery)) {
            return false;
        }
        TermQuery other = (TermQuery)o;
        try {
            throw new Exception("My Error");
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.getBoost() == other.getBoost() && this.term.equals(other.term);
        }
    }

    public int hashCode() {
        return Float.floatToIntBits(this.getBoost()) ^ this.term.hashCode();
    }

    private class TermWeight
    implements Weight {
        private Searcher searcher;
        private float value;
        private float idf;
        private float queryNorm;
        private float queryWeight;

        public TermWeight(Searcher searcher) {
            this.searcher = searcher;
        }

        public String toString() {
            return "weight(" + TermQuery.this + ")";
        }

        @Override
        public Query getQuery() {
            return TermQuery.this;
        }

        @Override
        public float getValue() {
            return this.value;
        }

        @Override
        public float sumOfSquaredWeights() throws IOException {
            this.idf = TermQuery.this.getSimilarity(this.searcher).idf(TermQuery.this.term, this.searcher);
            this.queryWeight = this.idf * TermQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        @Override
        public void normalize(float queryNorm) {
            this.queryNorm = queryNorm;
            this.queryWeight *= queryNorm;
            this.value = this.queryWeight * this.idf;
        }

        @Override
        public Scorer scorer(IndexReader reader, Searcher searcher) throws IOException {
            this.searcher = searcher;
            TermDocs termDocs = reader.termDocs(TermQuery.this.term);
            if (termDocs == null) {
                return null;
            }
            return new TermScorer(this, termDocs, TermQuery.this.getSimilarity(searcher), reader.norms(TermQuery.this.term.field()), TermQuery.this.term);
        }

        @Override
        public Explanation explain(IndexReader reader, int doc) throws IOException {
            Explanation result = new Explanation();
            result.setDescription("weight(" + this.getQuery() + " in " + doc + "), product of:");
            Explanation idfExpl = new Explanation(this.idf, "idf(docFreq=" + this.searcher.docFreq(TermQuery.this.term) + ")");
            Explanation queryExpl = new Explanation();
            queryExpl.setDescription("queryWeight(" + this.getQuery() + "), product of:");
            Explanation boostExpl = new Explanation(TermQuery.this.getBoost(), "boost");
            if (TermQuery.this.getBoost() != 1.0f) {
                queryExpl.addDetail(boostExpl);
            }
            queryExpl.addDetail(idfExpl);
            Explanation queryNormExpl = new Explanation(this.queryNorm, "queryNorm");
            queryExpl.addDetail(queryNormExpl);
            queryExpl.setValue(boostExpl.getValue() * idfExpl.getValue() * queryNormExpl.getValue());
            result.addDetail(queryExpl);
            String field = TermQuery.this.term.field();
            Explanation fieldExpl = new Explanation();
            fieldExpl.setDescription("fieldWeight(" + TermQuery.this.term + " in " + doc + "), product of:");
            Explanation tfExpl = this.scorer(reader, this.searcher).explain(doc);
            fieldExpl.addDetail(tfExpl);
            fieldExpl.addDetail(idfExpl);
            Explanation fieldNormExpl = new Explanation();
            byte[] fieldNorms = reader.norms(field);
            float fieldNorm = fieldNorms != null ? Similarity.decodeNorm(fieldNorms[doc]) : 0.0f;
            fieldNormExpl.setValue(fieldNorm);
            fieldNormExpl.setDescription("fieldNorm(field=" + field + ", doc=" + doc + ")");
            fieldExpl.addDetail(fieldNormExpl);
            fieldExpl.setValue(tfExpl.getValue() * idfExpl.getValue() * fieldNormExpl.getValue());
            result.addDetail(fieldExpl);
            result.setValue(queryExpl.getValue() * fieldExpl.getValue());
            if (queryExpl.getValue() == 1.0f) {
                return fieldExpl;
            }
            return result;
        }
    }
}

