/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.index;

import gate.creole.annic.apache.lucene.document.Document;
import gate.creole.annic.apache.lucene.index.IndexReader;
import gate.creole.annic.apache.lucene.index.MultiTermDocs;
import gate.creole.annic.apache.lucene.index.MultiTermEnum;
import gate.creole.annic.apache.lucene.index.MultiTermPositions;
import gate.creole.annic.apache.lucene.index.SegmentInfos;
import gate.creole.annic.apache.lucene.index.Term;
import gate.creole.annic.apache.lucene.index.TermDocs;
import gate.creole.annic.apache.lucene.index.TermEnum;
import gate.creole.annic.apache.lucene.index.TermFreqVector;
import gate.creole.annic.apache.lucene.index.TermPositions;
import gate.creole.annic.apache.lucene.store.Directory;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;

public class MultiReader
extends IndexReader {
    private IndexReader[] subReaders;
    private int[] starts;
    private Hashtable normsCache = new Hashtable();
    private int maxDoc = 0;
    private int numDocs = -1;
    private boolean hasDeletions = false;

    public MultiReader(IndexReader[] subReaders) throws IOException {
        super(subReaders.length == 0 ? null : subReaders[0].directory());
        this.initialize(subReaders);
    }

    MultiReader(Directory directory, SegmentInfos sis, boolean closeDirectory, IndexReader[] subReaders) throws IOException {
        super(directory, sis, closeDirectory);
        this.initialize(subReaders);
    }

    private void initialize(IndexReader[] subReaders) throws IOException {
        this.subReaders = subReaders;
        this.starts = new int[subReaders.length + 1];
        for (int i = 0; i < subReaders.length; ++i) {
            this.starts[i] = this.maxDoc;
            this.maxDoc += subReaders[i].maxDoc();
            if (!subReaders[i].hasDeletions()) continue;
            this.hasDeletions = true;
        }
        this.starts[subReaders.length] = this.maxDoc;
    }

    @Override
    public TermFreqVector[] getTermFreqVectors(int n) throws IOException {
        int i = this.readerIndex(n);
        return this.subReaders[i].getTermFreqVectors(n - this.starts[i]);
    }

    @Override
    public TermFreqVector getTermFreqVector(int n, String field) throws IOException {
        int i = this.readerIndex(n);
        return this.subReaders[i].getTermFreqVector(n - this.starts[i], field);
    }

    @Override
    public synchronized int numDocs() {
        if (this.numDocs == -1) {
            int n = 0;
            for (int i = 0; i < this.subReaders.length; ++i) {
                n += this.subReaders[i].numDocs();
            }
            this.numDocs = n;
        }
        return this.numDocs;
    }

    @Override
    public int maxDoc() {
        return this.maxDoc;
    }

    @Override
    public Document document(int n) throws IOException {
        int i = this.readerIndex(n);
        return this.subReaders[i].document(n - this.starts[i]);
    }

    @Override
    public boolean isDeleted(int n) {
        int i = this.readerIndex(n);
        return this.subReaders[i].isDeleted(n - this.starts[i]);
    }

    @Override
    public boolean hasDeletions() {
        return this.hasDeletions;
    }

    @Override
    protected void doDelete(int n) throws IOException {
        this.numDocs = -1;
        int i = this.readerIndex(n);
        this.subReaders[i].delete(n - this.starts[i]);
        this.hasDeletions = true;
    }

    @Override
    protected void doUndeleteAll() throws IOException {
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].undeleteAll();
        }
        this.hasDeletions = false;
    }

    private int readerIndex(int n) {
        int lo = 0;
        int hi = this.subReaders.length - 1;
        while (hi >= lo) {
            int mid = lo + hi >>> 1;
            int midValue = this.starts[mid];
            if (n < midValue) {
                hi = mid - 1;
                continue;
            }
            if (n > midValue) {
                lo = mid + 1;
                continue;
            }
            while (mid + 1 < this.subReaders.length && this.starts[mid + 1] == midValue) {
                ++mid;
            }
            return mid;
        }
        return hi;
    }

    @Override
    public synchronized byte[] norms(String field) throws IOException {
        byte[] bytes = (byte[])this.normsCache.get(field);
        if (bytes != null) {
            return bytes;
        }
        bytes = new byte[this.maxDoc()];
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].norms(field, bytes, this.starts[i]);
        }
        this.normsCache.put(field, bytes);
        return bytes;
    }

    @Override
    public synchronized void norms(String field, byte[] result, int offset) throws IOException {
        byte[] bytes = (byte[])this.normsCache.get(field);
        if (bytes != null) {
            System.arraycopy(bytes, 0, result, offset, this.maxDoc());
        }
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].norms(field, result, offset + this.starts[i]);
        }
    }

    @Override
    protected void doSetNorm(int n, String field, byte value) throws IOException {
        this.normsCache.remove(field);
        int i = this.readerIndex(n);
        this.subReaders[i].setNorm(n - this.starts[i], field, value);
    }

    @Override
    public TermEnum terms() throws IOException {
        return new MultiTermEnum(this.subReaders, this.starts, null);
    }

    @Override
    public TermEnum terms(Term term) throws IOException {
        return new MultiTermEnum(this.subReaders, this.starts, term);
    }

    @Override
    public int docFreq(Term t) throws IOException {
        int total = 0;
        for (int i = 0; i < this.subReaders.length; ++i) {
            total += this.subReaders[i].docFreq(t);
        }
        return total;
    }

    @Override
    public TermDocs termDocs() throws IOException {
        return new MultiTermDocs(this.subReaders, this.starts);
    }

    @Override
    public TermPositions termPositions() throws IOException {
        return new MultiTermPositions(this.subReaders, this.starts);
    }

    @Override
    protected void doCommit() throws IOException {
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].commit();
        }
    }

    @Override
    protected synchronized void doClose() throws IOException {
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].close();
        }
    }

    @Override
    public Collection getFieldNames() throws IOException {
        HashSet<String> fieldSet = new HashSet<String>();
        for (int i = 0; i < this.subReaders.length; ++i) {
            IndexReader reader = this.subReaders[i];
            Collection names = reader.getFieldNames();
            for (String s : names) {
                fieldSet.add(s);
            }
        }
        return fieldSet;
    }

    @Override
    public Collection getFieldNames(boolean indexed) throws IOException {
        HashSet fieldSet = new HashSet();
        for (int i = 0; i < this.subReaders.length; ++i) {
            IndexReader reader = this.subReaders[i];
            Collection names = reader.getFieldNames(indexed);
            fieldSet.addAll(names);
        }
        return fieldSet;
    }

    @Override
    public Collection getIndexedFieldNames(boolean storedTermVector) {
        HashSet fieldSet = new HashSet();
        for (int i = 0; i < this.subReaders.length; ++i) {
            IndexReader reader = this.subReaders[i];
            Collection names = reader.getIndexedFieldNames(storedTermVector);
            fieldSet.addAll(names);
        }
        return fieldSet;
    }
}

