/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import gate.Document;
import gate.Executable;
import gate.Factory;
import gate.LanguageAnalyser;
import gate.Resource;
import gate.creole.ExecutionException;
import gate.creole.ExecutionInterruptedException;
import gate.creole.ResourceInstantiationException;
import gate.creole.SerialAnalyserController;
import gate.creole.metadata.CreoleParameter;
import gate.creole.metadata.CreoleResource;
import gate.creole.metadata.Optional;
import gate.util.Err;
import gate.util.profile.Profiler;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CreoleResource(name="Real-Time Corpus Pipeline", comment="A serial controller for PR pipelines over corpora which limits the run time of each PR.", icon="application-realtime", helpURL="http://gate.ac.uk/userguide/sec:creole-model:applications")
public class RealtimeCorpusController
extends SerialAnalyserController {
    private static final long serialVersionUID = -676170588997880008L;
    private static final boolean DEBUG = false;
    private static final Logger logger = LoggerFactory.getLogger(RealtimeCorpusController.class);
    protected Profiler prof;
    protected HashMap<String, Long> timeMap;
    protected ExecutorService threadSource;
    protected volatile Thread currentWorkingThread;
    protected volatile boolean threadDying;
    Long actualTimeout;
    Long actualGraceful;
    protected Long timeout;
    protected Long graceful;
    protected boolean suppressExceptions = true;

    @Override
    public void cleanup() {
        this.threadSource.shutdownNow();
        super.cleanup();
    }

    @Override
    public Resource init() throws ResourceInstantiationException {
        String propTimeout = System.getProperty("gate.creole.RealtimeCorpusController.timeout");
        this.actualTimeout = propTimeout != null ? Long.valueOf(Long.parseLong(propTimeout)) : this.timeout;
        String propGraceful = System.getProperty("gate.creole.RealtimeCorpusController.graceful");
        this.actualGraceful = propGraceful != null ? Long.valueOf(Long.parseLong(propGraceful)) : this.graceful;
        this.threadSource = Executors.newSingleThreadExecutor(new ThreadFactory(){
            private ThreadFactory dtf = Executors.defaultThreadFactory();

            @Override
            public Thread newThread(Runnable r) {
                Thread t = this.dtf.newThread(r);
                t.setDaemon(true);
                return t;
            }
        });
        return super.init();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void executeImpl() throws ExecutionException {
        this.interrupted = false;
        haveTimeout = null;
        if (this.corpus == null) {
            throw new ExecutionException("(SerialAnalyserController) \"" + this.getName() + "\":\nThe corpus supplied for execution was null!");
        }
        for (i = 0; i < this.corpus.size(); ++i) {
            block32: {
                if (this.isInterrupted()) {
                    throw new ExecutionInterruptedException("The execution of the " + this.getName() + " application has been abruptly interrupted!");
                }
                docWasLoaded = this.corpus.isDocumentLoaded(i);
                doc = (Document)this.corpus.get(i);
                this.threadDying = false;
                docRunnerFuture = this.threadSource.submit(new DocRunner(doc));
                waitSoFar = 0L;
                if (this.actualGraceful != -1L && (this.actualTimeout == -1L || this.actualGraceful < this.actualTimeout)) {
                    try {
                        docRunnerFuture.get(this.actualGraceful, TimeUnit.MILLISECONDS);
                    }
                    catch (TimeoutException e) {
                        this.threadDying = true;
                        waitSoFar += this.actualGraceful.longValue();
                        haveTimeout = "Execution timeout, attempting to gracefully stop worker thread...";
                        RealtimeCorpusController.logger.info(haveTimeout);
                        t = this.currentWorkingThread;
                        if (t != null) {
                            t.interrupt();
                        }
                        for (j = 0; j < this.prList.size(); ++j) {
                            ((Executable)this.prList.get(j)).interrupt();
                        }
                        waitTime = this.actualTimeout != -1L ? (this.actualTimeout - this.actualGraceful) / 2L : this.actualGraceful / 2L;
                        try {
                            docRunnerFuture.get(waitTime, TimeUnit.MILLISECONDS);
                        }
                        catch (TimeoutException e1) {
                            this.threadDying = true;
                            waitSoFar += waitTime;
                            haveTimeout = "Execution timeout, attempting to induce exception in order to stop worker thread...";
                            RealtimeCorpusController.logger.info(haveTimeout);
                            for (j = 0; j < this.prList.size(); ++j) {
                                ((LanguageAnalyser)this.prList.get(j)).setDocument(null);
                                ((LanguageAnalyser)this.prList.get(j)).setCorpus(null);
                            }
                        }
                        catch (InterruptedException e1) {
                            Thread.currentThread().interrupt();
                        }
                        catch (java.util.concurrent.ExecutionException e2) {
                            throw new ExecutionException(e2);
                        }
                    }
                    catch (java.util.concurrent.ExecutionException e) {
                        throw new ExecutionException(e);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (this.actualTimeout != -1L) {
                    waitTime = this.actualTimeout - waitSoFar;
                    if (waitTime > 0L) {
                        try {
                            docRunnerFuture.get(waitTime, TimeUnit.MILLISECONDS);
                        }
                        catch (TimeoutException e) {
                            this.threadDying = true;
                            haveTimeout = "Execution timeout, worker thread will be forcibly terminated!";
                            RealtimeCorpusController.logger.info(haveTimeout);
                            theThread = this.currentWorkingThread;
                            if (theThread == null) ** GOTO lbl102
                            theThread.stop();
                            try {
                                docRunnerFuture.get();
                            }
                            catch (InterruptedException e2) {
                                Thread.currentThread().interrupt();
                            }
                            catch (java.util.concurrent.ExecutionException ee) {
                                if (ee.getCause() instanceof ThreadDeath) ** GOTO lbl102
                                RealtimeCorpusController.logger.error("Real Time Controller Malfunction", (Throwable)ee);
                                haveTimeout = "Real Time Controller Malfunction: " + ee.getMessage();
                            }
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        catch (java.util.concurrent.ExecutionException e) {
                            throw new ExecutionException(e);
                        }
                    } else {
                        this.threadDying = true;
                        haveTimeout = "Execution timeout, worker thread will be forcibly terminated!";
                        RealtimeCorpusController.logger.info(haveTimeout);
                        theThread = this.currentWorkingThread;
                        if (theThread != null) {
                            theThread.stop();
                            try {
                                docRunnerFuture.get();
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                            catch (java.util.concurrent.ExecutionException ee) {
                                if (ee.getCause() instanceof ThreadDeath) break block32;
                                RealtimeCorpusController.logger.error("Real Time Controller Malfunction", (Throwable)ee);
                                haveTimeout = "Real Time Controller Malfunction: " + ee.getMessage();
                            }
                        }
                    }
                }
            }
            docName = doc.getName();
            if (!docWasLoaded) {
                this.getCorpus().unloadDocument(doc);
                Factory.deleteResource(doc);
            }
            if (!this.suppressExceptions && haveTimeout != null) {
                throw new ExecutionException("Execution timeout occurred");
            }
            this.fireStatusChanged("Finished running " + this.getName() + " on document " + docName);
        }
    }

    public Long getTimeout() {
        return this.timeout;
    }

    @CreoleParameter(defaultValue="60000", comment="Timeout in milliseconds before execution on a document is forcibly stopped (forcibly stopping execution may result in memory leaks and/or unexpected behaviour)")
    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    public Long getGracefulTimeout() {
        return this.graceful;
    }

    @CreoleParameter(defaultValue="-1", comment="Timeout in milliseconds before execution on a document is gracefully stopped. Defaults to -1 which disables this functionality and relies, as previously, on forcibly stoping execution.")
    public void setGracefulTimeout(Long graceful) {
        this.graceful = graceful;
    }

    @Optional
    @CreoleParameter(defaultValue="true", comment="Should all exceptions be suppressed and just a message be written to standard logger.info?")
    public void setSuppressExceptions(Boolean yesno) {
        this.suppressExceptions = yesno;
    }

    public Boolean getSuppressExceptions() {
        return this.suppressExceptions;
    }

    protected class DocRunner
    implements Callable<Object> {
        private Document document;

        public DocRunner(Document document) {
            this.document = document;
        }

        @Override
        public Object call() throws Exception {
            try {
                int j;
                RealtimeCorpusController.this.currentWorkingThread = Thread.currentThread();
                for (j = 0; j < RealtimeCorpusController.this.prList.size(); ++j) {
                    ((LanguageAnalyser)RealtimeCorpusController.this.prList.get(j)).setDocument(this.document);
                    ((LanguageAnalyser)RealtimeCorpusController.this.prList.get(j)).setCorpus(RealtimeCorpusController.this.corpus);
                }
                RealtimeCorpusController.this.interrupted = false;
                RealtimeCorpusController.this.checkParameters();
                RealtimeCorpusController.this.interrupted = false;
                for (j = 0; j < RealtimeCorpusController.this.prList.size(); ++j) {
                    if (RealtimeCorpusController.this.isInterrupted()) {
                        throw new ExecutionInterruptedException("The execution of the " + RealtimeCorpusController.this.getName() + " application has been abruptly interrupted!");
                    }
                    if (Thread.currentThread().isInterrupted()) {
                        Err.println("Execution on document " + this.document.getName() + " has been stopped");
                        break;
                    }
                    try {
                        RealtimeCorpusController.this.runComponent(j);
                        continue;
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable e) {
                        if (RealtimeCorpusController.this.threadDying) {
                            Err.println("Execution on document " + this.document.getName() + " has been stopped");
                            break;
                        }
                        throw e;
                    }
                }
            }
            catch (ThreadDeath td) {
                Err.prln("Execution on document " + this.document.getName() + " has been stopped");
                throw td;
            }
            catch (Throwable cause) {
                if (RealtimeCorpusController.this.suppressExceptions) {
                    logger.info("Execution on document " + this.document.getName() + " has caused an error (ignored):\n=========================", cause);
                    logger.info("=========================\nError ignored...\n");
                }
                if (cause instanceof Exception) {
                    throw (Exception)cause;
                }
                throw new Exception(cause);
            }
            finally {
                RealtimeCorpusController.this.currentWorkingThread = null;
                for (int j = 0; j < RealtimeCorpusController.this.prList.size(); ++j) {
                    ((LanguageAnalyser)RealtimeCorpusController.this.prList.get(j)).setDocument(null);
                    ((LanguageAnalyser)RealtimeCorpusController.this.prList.get(j)).setCorpus(null);
                }
            }
            return null;
        }
    }
}

