/*
 * Decompiled with CFR 0.152.
 */
package gate.corpora;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import gate.Gate;
import gate.util.xml.XML11StaxDriver;
import java.io.StringWriter;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectWrapper {
    protected Object value;
    private static final XStream xstream = new XStream((HierarchicalStreamDriver)new XML11StaxDriver());
    protected static final Logger log;

    public ObjectWrapper(Object value) {
        this.value = value;
    }

    public ObjectWrapper(String xmlSerialisation) {
        Object other = xstream.fromXML(xmlSerialisation);
        if (other instanceof ObjectWrapper) {
            this.value = ((ObjectWrapper)other).value;
        } else {
            log.error("Value de-serialised from XML is of type \"" + other.getClass().getName() + "\", instead of expected \"" + ObjectWrapper.class.getName() + ". Value was lost.");
            this.value = null;
        }
    }

    public String toString() {
        StringWriter out = new StringWriter();
        xstream.toXML((Object)this, (Writer)out);
        return out.toString();
    }

    public Object getValue() {
        return this.value;
    }

    static {
        Gate.configureXStreamSecurity(xstream);
        log = LoggerFactory.getLogger(ObjectWrapper.class);
    }
}

