/*
 * Decompiled with CFR 0.152.
 */
package gate.annotation;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Corpus;
import gate.Document;
import gate.FeatureMap;
import gate.Resource;
import gate.creole.AbstractResource;
import gate.creole.AbstractVisualResource;
import gate.creole.AnnotationSchema;
import gate.creole.ResourceInstantiationException;
import gate.swing.XJTable;
import gate.util.Err;
import gate.util.InvalidOffsetException;
import gate.util.Out;
import gate.util.Strings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;

public class CorpusAnnotationDiff
extends AbstractVisualResource
implements Scrollable {
    private static final long serialVersionUID = 334626622328431740L;
    protected int maxUnitIncrement = 10;
    private static final boolean DEBUG = false;
    private Document keyDocument = null;
    private Corpus keyCorpus = null;
    private String keyAnnotationSetName = null;
    private Document responseDocument = null;
    private Corpus responseCorpus = null;
    private String responseAnnotationSetName = null;
    private String responseAnnotationSetNameFalsePoz = null;
    private AnnotationSchema annotationSchema = null;
    private Set<?> keyFeatureNamesSet = null;
    private double precisionStrict = 0.0;
    private double precisionLenient = 0.0;
    private double precisionAverage = 0.0;
    private double recallStrict = 0.0;
    private double recallLenient = 0.0;
    private double recallAverage = 0.0;
    private double falsePositiveStrict = 0.0;
    private double falsePositiveLenient = 0.0;
    private double falsePositiveAverage = 0.0;
    private double fMeasureStrict = 0.0;
    private double fMeasureLenient = 0.0;
    private double fMeasureAverage = 0.0;
    public static double weight = 0.5;
    private String annotationTypeForFalsePositive = null;
    private static NumberFormat formatter = NumberFormat.getInstance();
    private XJTable diffTable = null;
    private Set<DiffSetElement> diffSet = null;
    private Set<Annotation> keyPartiallySet = null;
    private Set<Annotation> responsePartiallySet = null;
    private List<Annotation> keyAnnotList = null;
    private List<Annotation> responseAnnotList = null;
    private boolean textMode = false;
    public static final int MAX_TYPES = 5;
    public static final int DEFAULT_TYPE = 0;
    public static final int CORRECT_TYPE = 1;
    public static final int PARTIALLY_CORRECT_TYPE = 2;
    public static final int SPURIOUS_TYPE = 3;
    public static final int MISSING_TYPE = 4;
    private final Color RED = new Color(255, 173, 181);
    private final Color GREEN = new Color(173, 255, 214);
    private final Color WHITE = new Color(255, 255, 255);
    private final Color BLUE = new Color(173, 215, 255);
    private final Color YELLOW = new Color(255, 231, 173);
    private final int NULL_TYPE = -1;
    private final Color BLACK = new Color(0, 0, 0);
    private Color[] colors = new Color[5];
    private int[] typeCounter = new int[5];

    public void setAnnotationTypeForFalsePositive(String anAnnotType) {
        this.annotationTypeForFalsePositive = anAnnotType;
    }

    public String getAnnotationTypeForFalsePositive() {
        return this.annotationTypeForFalsePositive;
    }

    public void setKeyCorpus(Corpus aKeyCorpus) {
        this.keyCorpus = aKeyCorpus;
    }

    public Corpus getKeyCorpus() {
        return this.keyCorpus;
    }

    public void setKeyAnnotationSetName(String aKeyAnnotationSetName) {
        this.keyAnnotationSetName = aKeyAnnotationSetName;
    }

    public String getKeyAnnotationSetName() {
        return this.keyAnnotationSetName;
    }

    public void setKeyFeatureNamesSet(Set<?> aKeyFeatureNamesSet) {
        this.keyFeatureNamesSet = aKeyFeatureNamesSet;
    }

    public Set<?> getKeyFeatureNamesSet() {
        return this.keyFeatureNamesSet;
    }

    public void setResponseAnnotationSetName(String aResponseAnnotationSetName) {
        this.responseAnnotationSetName = aResponseAnnotationSetName;
    }

    public String getResponseAnnotationSetName() {
        return this.responseAnnotationSetName;
    }

    public void setResponseAnnotationSetNameFalsePoz(String aResponseAnnotationSetNameFalsePoz) {
        this.responseAnnotationSetNameFalsePoz = aResponseAnnotationSetNameFalsePoz;
    }

    public String getResponseAnnotationSetNameFalsePoz() {
        return this.responseAnnotationSetNameFalsePoz;
    }

    public void setTextMode(Boolean aTextMode) {
        this.textMode = aTextMode;
    }

    public boolean isTextMode() {
        return this.textMode;
    }

    public Set<Annotation> getAnnotationsOfType(int annotType) {
        HashSet<Annotation> results = new HashSet<Annotation>();
        if (this.diffSet == null) {
            return results;
        }
        for (DiffSetElement diffElem : this.diffSet) {
            switch (annotType) {
                case 1: {
                    if (diffElem.getRightType() != 1) break;
                    results.add(diffElem.getRightAnnotation());
                    break;
                }
                case 2: {
                    if (diffElem.getRightType() != 2) break;
                    results.add(diffElem.getRightAnnotation());
                    break;
                }
                case 3: {
                    if (diffElem.getRightType() != 3) break;
                    results.add(diffElem.getRightAnnotation());
                    break;
                }
                case 4: {
                    if (diffElem.getLeftType() != 4) break;
                    results.add(diffElem.getLeftAnnotation());
                    break;
                }
                case 0: {
                    if (diffElem.getLeftType() != 0) break;
                    results.add(diffElem.getLeftAnnotation());
                }
            }
        }
        return results;
    }

    @Override
    public Object getParameterValue(String paramaterName) throws ResourceInstantiationException {
        return AbstractResource.getParameterValue(this, paramaterName);
    }

    @Override
    public void setParameterValue(String paramaterName, Object parameterValue) throws ResourceInstantiationException {
        BeanInfo resBeanInf = null;
        try {
            resBeanInf = Introspector.getBeanInfo(this.getClass(), Object.class);
        }
        catch (Exception e) {
            throw new ResourceInstantiationException("Couldn't get bean info for resource " + this.getClass().getName() + Strings.getNl() + "Introspector exception was: " + e);
        }
        AbstractResource.setParameterValue(this, resBeanInf, paramaterName, parameterValue);
    }

    @Override
    public void setParameterValues(FeatureMap parameters) throws ResourceInstantiationException {
        AbstractResource.setParameterValues(this, parameters);
    }

    public double getPrecisionStrict() {
        return this.precisionStrict;
    }

    public double getPrecisionLenient() {
        return this.precisionLenient;
    }

    public double getPrecisionAverage() {
        return this.precisionAverage;
    }

    public double getFMeasureStrict() {
        return this.fMeasureStrict;
    }

    public double getFMeasureLenient() {
        return this.fMeasureLenient;
    }

    public double getFMeasureAverage() {
        return this.fMeasureAverage;
    }

    public double getRecallStrict() {
        return this.recallStrict;
    }

    public double getRecallLenient() {
        return this.recallLenient;
    }

    public double getRecallAverage() {
        return this.recallAverage;
    }

    public double getFalsePositiveStrict() {
        return this.falsePositiveStrict;
    }

    public double getFalsePositiveLenient() {
        return this.falsePositiveLenient;
    }

    public double getFalsePositiveAverage() {
        return this.falsePositiveAverage;
    }

    public void setResponseCorpus(Corpus aResponseCorpus) {
        this.responseCorpus = aResponseCorpus;
    }

    public void setAnnotationSchema(AnnotationSchema anAnnotationSchema) {
        this.annotationSchema = anAnnotationSchema;
    }

    public AnnotationSchema getAnnotationSchema() {
        return this.annotationSchema;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.maxUnitIncrement;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 0) {
            return visibleRect.width - this.maxUnitIncrement;
        }
        return visibleRect.height - this.maxUnitIncrement;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public Resource init() throws ResourceInstantiationException {
        this.colors[0] = this.WHITE;
        this.colors[1] = this.GREEN;
        this.colors[3] = this.RED;
        this.colors[2] = this.BLUE;
        this.colors[4] = this.YELLOW;
        this.keyPartiallySet = new HashSet<Annotation>();
        this.responsePartiallySet = new HashSet<Annotation>();
        AnnotationSet keyAnnotSet = null;
        AnnotationSet responseAnnotSet = null;
        if (this.annotationSchema == null) {
            throw new ResourceInstantiationException("No annotation schema defined !");
        }
        if (this.keyCorpus == null || 0 == this.keyCorpus.size()) {
            throw new ResourceInstantiationException("No key corpus or empty defined !");
        }
        if (this.responseCorpus == null || 0 == this.responseCorpus.size()) {
            throw new ResourceInstantiationException("No response corpus or empty defined !");
        }
        for (int type = 0; type < 5; ++type) {
            this.typeCounter[type] = 0;
        }
        this.diffSet = new HashSet<DiffSetElement>();
        for (int i = 0; i < this.keyCorpus.size(); ++i) {
            this.keyDocument = (Document)this.keyCorpus.get(i);
            this.responseDocument = null;
            for (int j = 0; j < this.responseCorpus.size(); ++j) {
                Document doc = (Document)this.responseCorpus.get(j);
                if (0 != doc.getName().compareTo(this.keyDocument.getName()) && 0 != doc.getSourceUrl().getFile().compareTo(this.keyDocument.getSourceUrl().getFile())) continue;
                this.responseDocument = doc;
                break;
            }
            if (null == this.responseDocument) {
                Out.prln("There is no mach in responce corpus for document '" + this.keyDocument.getName() + "' from key corpus");
                continue;
            }
            keyAnnotSet = this.keyAnnotationSetName == null ? this.keyDocument.getAnnotations().get(this.annotationSchema.getAnnotationName()) : this.keyDocument.getAnnotations(this.keyAnnotationSetName).get(this.annotationSchema.getAnnotationName());
            this.keyAnnotList = keyAnnotSet == null ? new LinkedList<Annotation>() : new LinkedList<Annotation>(keyAnnotSet);
            responseAnnotSet = this.responseAnnotationSetName == null ? this.responseDocument.getAnnotations().get(this.annotationSchema.getAnnotationName()) : this.responseDocument.getAnnotations(this.responseAnnotationSetName).get(this.annotationSchema.getAnnotationName());
            this.responseAnnotList = responseAnnotSet == null ? new LinkedList<Annotation>() : new LinkedList<Annotation>(responseAnnotSet);
            AnnotationSetComparator asComparator = new AnnotationSetComparator();
            Collections.sort(this.keyAnnotList, asComparator);
            Collections.sort(this.responseAnnotList, asComparator);
            this.doDiff(this.keyAnnotList, this.responseAnnotList);
        }
        if (this.textMode) {
            return this;
        }
        formatter.setMaximumIntegerDigits(1);
        formatter.setMinimumFractionDigits(4);
        formatter.setMinimumFractionDigits(4);
        AnnotationDiffTableModel diffModel = new AnnotationDiffTableModel(this.diffSet);
        this.diffTable = new XJTable(diffModel);
        this.diffTable.setAlignmentX(0.0f);
        AnnotationDiffCellRenderer cellRenderer = new AnnotationDiffCellRenderer();
        this.diffTable.setDefaultRenderer(String.class, cellRenderer);
        this.diffTable.setDefaultRenderer(Long.class, cellRenderer);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CorpusAnnotationDiff.this.arangeAllComponents();
            }
        });
        return this;
    }

    protected void arangeAllComponents() {
        this.removeAll();
        BoxLayout boxLayout = new BoxLayout(this, 1);
        this.setLayout(boxLayout);
        JTableHeader tableHeader = this.diffTable.getTableHeader();
        tableHeader.setAlignmentX(0.0f);
        this.add(tableHeader);
        this.diffTable.setAlignmentX(0.0f);
        this.add(this.diffTable);
        JPanel infoBox = new JPanel();
        infoBox.setLayout(new BoxLayout(infoBox, 0));
        infoBox.setAlignmentX(0.0f);
        Box box = new Box(1);
        JLabel jLabel = new JLabel("LEGEND");
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        jLabel.setOpaque(true);
        jLabel.setAlignmentX(0.0f);
        box.add(jLabel);
        jLabel = new JLabel("Missing (present in Key but not in Response):  " + this.typeCounter[4]);
        jLabel.setForeground(this.BLACK);
        jLabel.setBackground(this.colors[4]);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        jLabel.setOpaque(true);
        jLabel.setAlignmentX(0.0f);
        box.add(jLabel);
        box.add(Box.createRigidArea(new Dimension(0, 5)));
        jLabel = new JLabel("Correct (total match):  " + this.typeCounter[1]);
        jLabel.setForeground(this.BLACK);
        jLabel.setBackground(this.colors[1]);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        jLabel.setOpaque(true);
        jLabel.setAlignmentX(0.0f);
        box.add(jLabel);
        box.add(Box.createRigidArea(new Dimension(0, 5)));
        jLabel = new JLabel("Partially correct (overlap in Key and Response):  " + this.typeCounter[2]);
        jLabel.setForeground(this.BLACK);
        jLabel.setBackground(this.colors[2]);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        jLabel.setOpaque(true);
        jLabel.setAlignmentX(0.0f);
        box.add(jLabel);
        box.add(Box.createRigidArea(new Dimension(0, 5)));
        jLabel = new JLabel("Spurious (present in Response but not in Key):  " + this.typeCounter[3]);
        jLabel.setForeground(this.BLACK);
        jLabel.setBackground(this.colors[3]);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        jLabel.setOpaque(true);
        jLabel.setAlignmentX(0.0f);
        box.add(jLabel);
        infoBox.add(box);
        infoBox.add(Box.createRigidArea(new Dimension(40, 0)));
        box = new Box(1);
        jLabel = new JLabel("Precision strict: " + formatter.format(this.precisionStrict));
        jLabel.setAlignmentX(0.0f);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        box.add(jLabel);
        jLabel = new JLabel("Precision average: " + formatter.format(this.precisionAverage));
        jLabel.setAlignmentX(0.0f);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        box.add(jLabel);
        jLabel = new JLabel("Precision lenient: " + formatter.format(this.precisionLenient));
        jLabel.setAlignmentX(0.0f);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        box.add(jLabel);
        infoBox.add(box);
        infoBox.add(Box.createRigidArea(new Dimension(40, 0)));
        box = new Box(1);
        jLabel = new JLabel("Recall strict: " + formatter.format(this.recallStrict));
        jLabel.setAlignmentX(0.0f);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        box.add(jLabel);
        jLabel = new JLabel("Recall average: " + formatter.format(this.recallAverage));
        jLabel.setAlignmentX(0.0f);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        box.add(jLabel);
        jLabel = new JLabel("Recall lenient: " + formatter.format(this.recallLenient));
        jLabel.setAlignmentX(0.0f);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        box.add(jLabel);
        infoBox.add(box);
        infoBox.add(Box.createRigidArea(new Dimension(40, 0)));
        box = new Box(1);
        jLabel = new JLabel("F-Measure strict: " + formatter.format(this.fMeasureStrict));
        jLabel.setAlignmentX(0.0f);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        box.add(jLabel);
        jLabel = new JLabel("F-Measure average: " + formatter.format(this.fMeasureAverage));
        jLabel.setAlignmentX(0.0f);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        box.add(jLabel);
        jLabel = new JLabel("F-Measure lenient: " + formatter.format(this.fMeasureLenient));
        jLabel.setAlignmentX(0.0f);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        box.add(jLabel);
        infoBox.add(box);
        infoBox.add(Box.createRigidArea(new Dimension(40, 0)));
        box = new Box(1);
        jLabel = new JLabel("False positive strict: " + formatter.format(this.falsePositiveStrict));
        jLabel.setAlignmentX(0.0f);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        box.add(jLabel);
        jLabel = new JLabel("False positive average: " + formatter.format(this.falsePositiveAverage));
        jLabel.setAlignmentX(0.0f);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        box.add(jLabel);
        jLabel = new JLabel("False positive lenient: " + formatter.format(this.falsePositiveLenient));
        jLabel.setAlignmentX(0.0f);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        box.add(jLabel);
        infoBox.add(box);
        infoBox.add(Box.createRigidArea(new Dimension(10, 0)));
        this.add(infoBox);
    }

    protected void printStructure(Set<DiffSetElement> aDiffSet) {
        Iterator<DiffSetElement> iterator = aDiffSet.iterator();
        String leftAnnot = null;
        String rightAnnot = null;
        while (iterator.hasNext()) {
            DiffSetElement diffElem = iterator.next();
            leftAnnot = diffElem.getLeftAnnotation() == null ? "NULL " : diffElem.getLeftAnnotation().toString();
            rightAnnot = diffElem.getRightAnnotation() == null ? " NULL" : diffElem.getRightAnnotation().toString();
            Out.prln(leftAnnot + "|" + rightAnnot);
        }
    }

    protected void doDiff(List<Annotation> aKeyAnnotList, List<Annotation> aResponseAnnotList) {
        double denominator;
        if (aKeyAnnotList == null || aResponseAnnotList == null) {
            return;
        }
        Iterator<Annotation> keyIterator = aKeyAnnotList.iterator();
        while (keyIterator.hasNext()) {
            Annotation keyAnnot = keyIterator.next();
            Iterator<Annotation> responseIterator = aResponseAnnotList.iterator();
            DiffSetElement diffElement = null;
            while (responseIterator.hasNext()) {
                Annotation responseAnnot = responseIterator.next();
                if (keyAnnot.isPartiallyCompatible(responseAnnot, this.keyFeatureNamesSet)) {
                    this.keyPartiallySet.add(keyAnnot);
                    this.responsePartiallySet.add(responseAnnot);
                    if (keyAnnot.coextensive(responseAnnot)) {
                        diffElement = new DiffSetElement(keyAnnot, responseAnnot, 0, 1, this.keyDocument, this.responseDocument);
                        this.addToDiffset(diffElement);
                    }
                } else if (keyAnnot.coextensive(responseAnnot)) {
                    diffElement = new DiffSetElement(keyAnnot, responseAnnot, this.detectKeyType(keyAnnot), this.detectResponseType(responseAnnot), this.keyDocument, this.responseDocument);
                    this.addToDiffset(diffElement);
                }
                if (diffElement == null) continue;
                responseIterator.remove();
                break;
            }
            if (diffElement == null) {
                if (this.keyPartiallySet.contains(keyAnnot)) {
                    diffElement = new DiffSetElement(keyAnnot, null, 0, -1, this.keyDocument, this.responseDocument);
                } else {
                    for (DiffSetElement diffElem : this.diffSet) {
                        Annotation respAnnot = diffElem.getRightAnnotation();
                        if (respAnnot == null || !keyAnnot.isPartiallyCompatible(respAnnot, this.keyFeatureNamesSet)) continue;
                        diffElement = new DiffSetElement(keyAnnot, null, 0, -1, this.keyDocument, this.responseDocument);
                        break;
                    }
                    if (diffElement == null) {
                        diffElement = new DiffSetElement(keyAnnot, null, 4, -1, this.keyDocument, this.responseDocument);
                    }
                }
                this.addToDiffset(diffElement);
            }
            keyIterator.remove();
        }
        DiffSetElement diffElem = null;
        Iterator<Annotation> responseIter = aResponseAnnotList.iterator();
        while (responseIter.hasNext()) {
            Annotation respAnnot = responseIter.next();
            diffElem = this.responsePartiallySet.contains(respAnnot) ? new DiffSetElement(null, respAnnot, -1, 2, this.keyDocument, this.responseDocument) : new DiffSetElement(null, respAnnot, -1, 3, this.keyDocument, this.responseDocument);
            this.addToDiffset(diffElem);
            responseIter.remove();
        }
        int possible = this.typeCounter[1] + this.typeCounter[2] + this.typeCounter[4];
        int actual = this.typeCounter[1] + this.typeCounter[2] + this.typeCounter[3];
        if (actual != 0) {
            this.precisionStrict = (double)this.typeCounter[1] / (double)actual;
            this.precisionLenient = (double)(this.typeCounter[1] + this.typeCounter[2]) / (double)actual;
            this.precisionAverage = (this.precisionStrict + this.precisionLenient) / 2.0;
        }
        if (possible != 0) {
            this.recallStrict = (double)this.typeCounter[1] / (double)possible;
            this.recallLenient = (double)(this.typeCounter[1] + this.typeCounter[2]) / (double)possible;
            this.recallAverage = (this.recallStrict + this.recallLenient) / 2.0;
        }
        int no = 0;
        if (this.annotationTypeForFalsePositive != null) {
            AnnotationSet aSet;
            if (this.responseAnnotationSetNameFalsePoz == null) {
                aSet = this.responseDocument.getAnnotations().get(this.annotationTypeForFalsePositive);
                no = aSet == null ? 0 : aSet.size();
            } else {
                aSet = this.responseDocument.getAnnotations(this.responseAnnotationSetNameFalsePoz).get(this.annotationTypeForFalsePositive);
                int n = no = aSet == null ? 0 : aSet.size();
            }
        }
        if (no != 0) {
            this.falsePositiveStrict = (double)(this.typeCounter[3] + this.typeCounter[2]) / (double)no;
            this.falsePositiveLenient = (double)this.typeCounter[3] / (double)no;
            this.falsePositiveAverage = (this.falsePositiveStrict + this.falsePositiveLenient) / 2.0;
        }
        this.fMeasureStrict = (denominator = weight * (this.precisionStrict + this.recallStrict)) != 0.0 ? this.precisionStrict * this.recallStrict / denominator : 0.0;
        denominator = weight * (this.precisionLenient + this.recallLenient);
        this.fMeasureLenient = denominator != 0.0 ? this.precisionLenient * this.recallLenient / denominator : 0.0;
        this.fMeasureAverage = (this.fMeasureStrict + this.fMeasureLenient) / 2.0;
    }

    private int detectKeyType(Annotation anAnnot) {
        if (anAnnot == null) {
            return -1;
        }
        if (this.keyPartiallySet.contains(anAnnot)) {
            return 0;
        }
        for (Annotation a : this.responsePartiallySet) {
            if (!anAnnot.isPartiallyCompatible(a, this.keyFeatureNamesSet)) continue;
            return 0;
        }
        for (Annotation a : this.responseAnnotList) {
            if (!anAnnot.isPartiallyCompatible(a, this.keyFeatureNamesSet)) continue;
            this.responsePartiallySet.add(a);
            this.keyPartiallySet.add(anAnnot);
            return 0;
        }
        return 4;
    }

    private int detectResponseType(Annotation anAnnot) {
        if (anAnnot == null) {
            return -1;
        }
        if (this.responsePartiallySet.contains(anAnnot)) {
            return 2;
        }
        for (Annotation a : this.keyPartiallySet) {
            if (!a.isPartiallyCompatible(anAnnot, this.keyFeatureNamesSet)) continue;
            return 2;
        }
        for (Annotation a : this.keyAnnotList) {
            if (!a.isPartiallyCompatible(anAnnot, this.keyFeatureNamesSet)) continue;
            this.responsePartiallySet.add(anAnnot);
            this.keyPartiallySet.add(a);
            return 2;
        }
        return 3;
    }

    private void addToDiffset(DiffSetElement aDiffSetElement) {
        if (aDiffSetElement == null) {
            return;
        }
        this.diffSet.add(aDiffSetElement);
        if (-1 != aDiffSetElement.getRightType()) {
            int n = aDiffSetElement.getRightType();
            this.typeCounter[n] = this.typeCounter[n] + 1;
        }
        if (-1 != aDiffSetElement.getLeftType() && 1 != aDiffSetElement.getLeftType()) {
            int n = aDiffSetElement.getLeftType();
            this.typeCounter[n] = this.typeCounter[n] + 1;
        }
    }

    protected class DiffSetElement {
        private Annotation leftAnnotation = null;
        private Annotation rightAnnotation = null;
        private int leftType = 0;
        private int rightType = 0;
        private Document keyDocument;
        private Document respDocument;

        public DiffSetElement() {
        }

        public DiffSetElement(Annotation aLeftAnnotation, Annotation aRightAnnotation, int aLeftType, int aRightType) {
            this.leftAnnotation = aLeftAnnotation;
            this.rightAnnotation = aRightAnnotation;
            this.leftType = aLeftType;
            this.rightType = aRightType;
            this.keyDocument = null;
            this.respDocument = null;
        }

        public DiffSetElement(Annotation aLeftAnnotation, Annotation aRightAnnotation, int aLeftType, int aRightType, Document kDocument, Document rDocument) {
            this.leftAnnotation = aLeftAnnotation;
            this.rightAnnotation = aRightAnnotation;
            this.leftType = aLeftType;
            this.rightType = aRightType;
            this.keyDocument = kDocument;
            this.respDocument = rDocument;
        }

        public void setLeftAnnotation(Annotation aLeftAnnotation) {
            this.leftAnnotation = aLeftAnnotation;
        }

        public Annotation getLeftAnnotation() {
            return this.leftAnnotation;
        }

        public void setRightAnnotation(Annotation aRightAnnotation) {
            this.rightAnnotation = aRightAnnotation;
        }

        public Annotation getRightAnnotation() {
            return this.rightAnnotation;
        }

        public void setLeftType(int aLeftType) {
            this.leftType = aLeftType;
        }

        public int getLeftType() {
            return this.leftType;
        }

        public void setRightType(int aRightType) {
            this.rightType = aRightType;
        }

        public int getRightType() {
            return this.rightType;
        }

        public Document getKeyDocument() {
            return this.keyDocument;
        }

        public void setKeyDocument(Document aDoc) {
            this.keyDocument = aDoc;
        }

        public Document getResponseDocument() {
            return this.respDocument;
        }

        public void setResponseDocument(Document aDoc) {
            this.respDocument = aDoc;
        }
    }

    class AnnotationSetComparator
    implements Comparator<Annotation> {
        @Override
        public int compare(Annotation a1, Annotation a2) {
            Long l1 = a1.getStartNode().getOffset();
            Long l2 = a2.getStartNode().getOffset();
            if (l1 != null) {
                return l1.compareTo(l2);
            }
            return -1;
        }
    }

    public class AnnotationDiffCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -7804261826021343001L;
        private Color background;

        public AnnotationDiffCellRenderer() {
            this.background = CorpusAnnotationDiff.this.WHITE;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent defaultComp = null;
            defaultComp = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (column == 4 || value == null) {
                return new JPanel();
            }
            if (!(table.getModel().getValueAt(row, 10) instanceof DiffSetElement)) {
                return defaultComp;
            }
            DiffSetElement diffSetElement = (DiffSetElement)table.getModel().getValueAt(row, 10);
            if (diffSetElement == null) {
                return defaultComp;
            }
            if (column < 4) {
                if (-1 == diffSetElement.getLeftType()) return new JPanel();
                this.background = CorpusAnnotationDiff.this.colors[diffSetElement.getLeftType()];
            } else if (column < 10) {
                if (-1 == diffSetElement.getRightType()) return new JPanel();
                this.background = CorpusAnnotationDiff.this.colors[diffSetElement.getRightType()];
            }
            defaultComp.setBackground(this.background);
            defaultComp.setForeground(CorpusAnnotationDiff.this.BLACK);
            defaultComp.setOpaque(true);
            return defaultComp;
        }
    }

    protected class AnnotationDiffTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1410683181803904176L;
        private List<DiffSetElement> modelData = new ArrayList<DiffSetElement>();

        public AnnotationDiffTableModel(Collection<DiffSetElement> data) {
            this.modelData.addAll(data);
        }

        public AnnotationDiffTableModel() {
        }

        @Override
        public int getRowCount() {
            return this.modelData.size();
        }

        @Override
        public int getColumnCount() {
            return 10;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "String - Key";
                }
                case 1: {
                    return "Start - Key";
                }
                case 2: {
                    return "End - Key";
                }
                case 3: {
                    return "Features - Key";
                }
                case 4: {
                    return "   ";
                }
                case 5: {
                    return "String - Response";
                }
                case 6: {
                    return "Start - Response";
                }
                case 7: {
                    return "End -Response";
                }
                case 8: {
                    return "Features - Response";
                }
                case 9: {
                    return "Document";
                }
            }
            return "?";
        }

        @Override
        public Class<?> getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Long.class;
                }
                case 2: {
                    return Long.class;
                }
                case 3: {
                    return String.class;
                }
                case 4: {
                    return String.class;
                }
                case 5: {
                    return String.class;
                }
                case 6: {
                    return Long.class;
                }
                case 7: {
                    return Long.class;
                }
                case 8: {
                    return String.class;
                }
                case 9: {
                    return String.class;
                }
            }
            return Object.class;
        }

        @Override
        public Object getValueAt(int row, int column) {
            DiffSetElement diffSetElement = this.modelData.get(row);
            if (diffSetElement == null) {
                return null;
            }
            switch (column) {
                case 0: {
                    if (diffSetElement.getLeftAnnotation() == null) {
                        return null;
                    }
                    Annotation annot = diffSetElement.getLeftAnnotation();
                    String theString = "";
                    try {
                        theString = diffSetElement.getKeyDocument().getContent().getContent(annot.getStartNode().getOffset(), annot.getEndNode().getOffset()).toString();
                    }
                    catch (InvalidOffsetException ex) {
                        Err.prln(ex.getMessage());
                    }
                    return theString;
                }
                case 1: {
                    if (diffSetElement.getLeftAnnotation() == null) {
                        return null;
                    }
                    return diffSetElement.getLeftAnnotation().getStartNode().getOffset();
                }
                case 2: {
                    if (diffSetElement.getLeftAnnotation() == null) {
                        return null;
                    }
                    return diffSetElement.getLeftAnnotation().getEndNode().getOffset();
                }
                case 3: {
                    if (diffSetElement.getLeftAnnotation() == null) {
                        return null;
                    }
                    if (diffSetElement.getLeftAnnotation().getFeatures() == null) {
                        return null;
                    }
                    return diffSetElement.getLeftAnnotation().getFeatures().toString();
                }
                case 4: {
                    return "   ";
                }
                case 5: {
                    if (diffSetElement.getRightAnnotation() == null) {
                        return null;
                    }
                    Annotation annot = diffSetElement.getRightAnnotation();
                    String theString = "";
                    try {
                        theString = diffSetElement.getResponseDocument().getContent().getContent(annot.getStartNode().getOffset(), annot.getEndNode().getOffset()).toString();
                    }
                    catch (InvalidOffsetException ex) {
                        Err.prln(ex.getMessage());
                    }
                    return theString;
                }
                case 6: {
                    if (diffSetElement.getRightAnnotation() == null) {
                        return null;
                    }
                    return diffSetElement.getRightAnnotation().getStartNode().getOffset();
                }
                case 7: {
                    if (diffSetElement.getRightAnnotation() == null) {
                        return null;
                    }
                    return diffSetElement.getRightAnnotation().getEndNode().getOffset();
                }
                case 8: {
                    if (diffSetElement.getRightAnnotation() == null) {
                        return null;
                    }
                    return diffSetElement.getRightAnnotation().getFeatures().toString();
                }
                case 9: {
                    return diffSetElement.getKeyDocument().getName();
                }
                case 10: {
                    return diffSetElement;
                }
            }
            return null;
        }

        public Object getRawObject(int row) {
            return this.modelData.get(row);
        }
    }
}

