/*
 * Decompiled with CFR 0.152.
 */
package gate;

import com.thoughtworks.xstream.XStream;
import gate.CreoleRegister;
import gate.DataStoreRegister;
import gate.Executable;
import gate.Factory;
import gate.FeatureMap;
import gate.GateConstants;
import gate.Resource;
import gate.config.ConfigDataProcessor;
import gate.creole.CreoleRegisterImpl;
import gate.creole.Plugin;
import gate.creole.ir.IREngine;
import gate.event.CreoleListener;
import gate.gui.creole.manager.PluginUpdateManager;
import gate.util.Benchmark;
import gate.util.BomStrippingInputStreamReader;
import gate.util.Files;
import gate.util.GateClassLoader;
import gate.util.GateException;
import gate.util.GateRuntimeException;
import gate.util.OptionsMap;
import gate.util.Strings;
import gate.util.persistence.XStreamSecurity;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Gate
implements GateConstants {
    protected static final Logger log;
    public static final int STRINGBUFFER_SIZE = 1024;
    public static final int HASH_STH_SIZE = 4;
    public static final String URI = "http://www.gate.ac.uk";
    protected static final String MIN_JDK_VERSION = "1.8";
    protected static final String ENABLE_BENCHMARKING_FEATURE_NAME = "gate.enable.benchmark";
    public static final String VERSION_STRING;
    public static final String BUILD;
    public static final Version VERSION;
    private static boolean sandboxed;
    protected static boolean initFinished;
    private static int lastSym;
    private static Set<String> registeredIREngines;
    private static GateClassLoader classLoader;
    private static CreoleRegister creoleRegister;
    private static DataStoreRegister dataStoreRegister;
    private static Executable currentExecutable;
    private static OptionsMap userConfig;
    private static OptionsMap originalUserConfig;
    private static String userConfigElement;
    private static String nl;
    private static String emptyConfigFile;
    protected static File gateHome;
    private static File siteConfigFile;
    private static File userConfigFile;
    protected static File pluginsHome;
    protected static URL builtinCreoleDir;
    protected static File userSessionFile;
    private static Set<Plugin> knownPlugins;
    protected static List<Plugin> autoloadPlugins;
    private static boolean useXMLSerialization;
    private static final Map<String, EventListener> listeners;
    private static XStreamSecurity xStreamSecurity;

    public static boolean isSandboxed() {
        return sandboxed;
    }

    public static void runInSandbox(boolean sandboxed) {
        if (initFinished) {
            throw new IllegalStateException("Sandbox status cannot be changed after GATE has been initialised!");
        }
        Gate.sandboxed = sandboxed;
    }

    public static String getMinJdkVersion() {
        return MIN_JDK_VERSION;
    }

    public static void init() throws GateException {
        if (!sandboxed) {
            Gate.initLocalPaths();
        }
        if (System.getProperty(ENABLE_BENCHMARKING_FEATURE_NAME) != null && System.getProperty(ENABLE_BENCHMARKING_FEATURE_NAME).equalsIgnoreCase("true")) {
            Benchmark.setBenchmarkingEnabled(true);
        }
        if (builtinCreoleDir == null) {
            String builtinCreoleDirPropertyValue = System.getProperty("gate.builtin.creole.dir");
            if (builtinCreoleDirPropertyValue == null) {
                builtinCreoleDir = Files.getGateResource("/creole/");
            } else {
                String builtinCreoleDirPath = builtinCreoleDirPropertyValue;
                if (!builtinCreoleDirPath.endsWith("/")) {
                    builtinCreoleDirPath = builtinCreoleDirPath + "/";
                }
                try {
                    builtinCreoleDir = new URL(builtinCreoleDirPath);
                }
                catch (MalformedURLException mue) {
                    throw new GateRuntimeException("gate.builtin.creole.dir value \"" + builtinCreoleDirPropertyValue + "\" could not be parsed as either a URL or a file path.");
                }
                log.info("Using " + builtinCreoleDir + " as built-in CREOLE directory URL");
            }
        }
        lastSym = 0;
        if (classLoader == null) {
            classLoader = new GateClassLoader("Top-Level GATE ClassLoader", Gate.class.getClassLoader());
        }
        if (creoleRegister == null) {
            creoleRegister = new CreoleRegisterImpl();
        }
        if (knownPlugins == null) {
            knownPlugins = new HashSet<Plugin>();
        }
        if (autoloadPlugins == null) {
            autoloadPlugins = new ArrayList<Plugin>();
        }
        Gate.initCreoleRegister();
        Gate.initDataStoreRegister();
        if (!sandboxed) {
            Gate.initConfigData();
        }
        if (!sandboxed) {
            Gate.initCreoleRepositories();
        }
        dataStoreRegister.addCreoleListener(creoleRegister);
        Factory.addCreoleListener(creoleRegister);
        if (System.getProperty("java.version").compareTo(MIN_JDK_VERSION) < 0) {
            throw new GateException("GATE requires JDK 1.8 or newer");
        }
        initFinished = true;
    }

    public static boolean isInitialised() {
        return initFinished;
    }

    protected static void initLocalPaths() {
        if (userConfigFile == null) {
            String userConfigStr = System.getProperty("gate.user.config");
            userConfigFile = userConfigStr != null && userConfigStr.length() > 0 ? new File(userConfigStr) : new File(Gate.getDefaultUserConfigFileName());
        }
        log.info("Using " + userConfigFile + " as user configuration file");
        if (userSessionFile == null) {
            String userSessionStr = System.getProperty("gate.user.session");
            userSessionFile = userSessionStr != null && userSessionStr.length() > 0 ? new File(userSessionStr) : new File(Gate.getDefaultUserSessionFileName());
        }
        log.info("Using " + userSessionFile + " as user session file");
    }

    protected static void initCreoleRepositories() {
        Pattern mavenPluginPattern = Pattern.compile("\\[(.*?):(.*?):(.*?)]");
        String knownPluginsPath = (String)Gate.getUserConfig().get("Known_plugin_path");
        if (knownPluginsPath != null) {
            knownPluginsPath = knownPluginsPath.trim();
        }
        if (knownPluginsPath != null && knownPluginsPath.length() > 0) {
            StringTokenizer strTok = new StringTokenizer(knownPluginsPath, ";", false);
            while (strTok.hasMoreTokens()) {
                String aKnownPluginPath = strTok.nextToken().trim();
                Matcher m = mavenPluginPattern.matcher(aKnownPluginPath);
                if (m.matches()) {
                    Gate.addKnownPlugin(new Plugin.Maven(m.group(1), m.group(2), m.group(3)));
                    continue;
                }
                try {
                    URL aPluginURL = new URL(aKnownPluginPath);
                    Gate.addKnownPlugin(new Plugin.Directory(aPluginURL));
                }
                catch (MalformedURLException mue) {
                    log.error("Plugin error: " + aKnownPluginPath + " is an invalid URL!");
                }
            }
        }
        if (pluginsHome != null) {
            File[] dirs = pluginsHome.listFiles();
            for (int i = 0; i < dirs.length; ++i) {
                File creoleFile = new File(dirs[i], "creole.xml");
                if (!creoleFile.exists()) continue;
                try {
                    URL pluginURL = dirs[i].toURI().toURL();
                    Gate.addKnownPlugin(new Plugin.Directory(pluginURL));
                    continue;
                }
                catch (MalformedURLException mue) {
                    throw new GateRuntimeException(mue);
                }
            }
        }
        String pluginPath = Gate.getUserConfig().getString("Load_plugin_path");
        String prop = System.getProperty("load.plugin.path");
        if (prop != null && prop.length() > 0) {
            pluginPath = prop;
        }
        if (pluginPath != null) {
            pluginPath = pluginPath.trim();
        }
        if (pluginPath == null || pluginPath.length() == 0) {
            return;
        }
        StringTokenizer strTok = new StringTokenizer(pluginPath, ";", false);
        while (strTok.hasMoreTokens()) {
            String aDir = strTok.nextToken().trim();
            Matcher m = mavenPluginPattern.matcher(aDir);
            if (m.matches()) {
                Gate.addAutoloadPlugin(new Plugin.Maven(m.group(1), m.group(2), m.group(3)));
            } else {
                try {
                    URL aPluginURL = new URL(aDir);
                    Plugin.Directory plugin = new Plugin.Directory(aPluginURL);
                    Gate.addAutoloadPlugin(plugin);
                }
                catch (MalformedURLException mue) {
                    log.error("Cannot load " + aDir + " CREOLE repository.", (Throwable)mue);
                }
            }
            try {
                Iterator<Plugin> loadPluginsIter = Gate.getAutoloadPlugins().iterator();
                while (loadPluginsIter.hasNext()) {
                    Gate.getCreoleRegister().registerPlugin(loadPluginsIter.next());
                }
            }
            catch (GateException ge) {
                log.error("Cannot load " + aDir + " CREOLE repository.", (Throwable)ge);
            }
        }
    }

    public static void initCreoleRegister() throws GateException {
        creoleRegister.registerBuiltins();
    }

    public static void initDataStoreRegister() {
        dataStoreRegister = new DataStoreRegister();
    }

    public static void initConfigData() throws GateException {
        Throwable throwable;
        FileInputStream configStream;
        URL configURL;
        ConfigDataProcessor configProcessor = new ConfigDataProcessor();
        if (siteConfigFile != null && siteConfigFile.exists()) {
            try {
                configURL = siteConfigFile.toURI().toURL();
            }
            catch (MalformedURLException mue) {
                throw new GateRuntimeException(mue);
            }
            try {
                configStream = new FileInputStream(siteConfigFile);
                throwable = null;
                try {
                    configProcessor.parseConfigFile(configStream, configURL);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (configStream != null) {
                        if (throwable != null) {
                            try {
                                ((InputStream)configStream).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((InputStream)configStream).close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new GateException("Couldn't open site configuration file: " + configURL + " " + e);
            }
        }
        if (userConfigFile != null && userConfigFile.exists()) {
            try {
                configURL = userConfigFile.toURI().toURL();
            }
            catch (MalformedURLException mue) {
                throw new GateRuntimeException(mue);
            }
            try {
                configStream = new FileInputStream(userConfigFile);
                throwable = null;
                try {
                    configProcessor.parseConfigFile(configStream, configURL);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (configStream != null) {
                        if (throwable != null) {
                            try {
                                ((InputStream)configStream).close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            ((InputStream)configStream).close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new GateException("Couldn't open user configuration file: " + configURL + " " + e);
            }
        }
        originalUserConfig.putAll(userConfig);
    }

    public static void registerIREngine(String className) throws GateException, ClassNotFoundException {
        Class<?> aClass = Class.forName(className, true, Gate.getClassLoader());
        if (!IREngine.class.isAssignableFrom(aClass)) {
            throw new GateException(className + " does not implement the " + IREngine.class.getName() + " interface!");
        }
        registeredIREngines.add(className);
    }

    public static boolean unregisterIREngine(String className) {
        return registeredIREngines.remove(className);
    }

    public static Set<String> getRegisteredIREngines() {
        return Collections.unmodifiableSet(registeredIREngines);
    }

    public static File getGateHome() {
        return gateHome;
    }

    public static boolean isGateType(String classname) {
        boolean res = Gate.getCreoleRegister().containsKey(classname);
        if (!res) {
            try {
                Class<?> aClass = Class.forName(classname, true, Gate.getClassLoader());
                res = Resource.class.isAssignableFrom(aClass);
            }
            catch (ClassNotFoundException cnfe) {
                return false;
            }
        }
        return res;
    }

    public static boolean getHiddenAttribute(FeatureMap fm) {
        if (fm == null) {
            return false;
        }
        Object value = fm.get("gate.HIDDEN");
        return value != null && value instanceof String && ((String)value).equals("true");
    }

    public static void setHiddenAttribute(FeatureMap fm, boolean hidden) {
        if (hidden) {
            fm.put("gate.HIDDEN", "true");
        } else {
            fm.remove("gate.HIDDEN");
        }
    }

    public static synchronized void addCreoleListener(CreoleListener l) {
        creoleRegister.addCreoleListener(l);
    }

    public static GateClassLoader getClassLoader() {
        return classLoader;
    }

    public static CreoleRegister getCreoleRegister() {
        return creoleRegister;
    }

    public static DataStoreRegister getDataStoreRegister() {
        return dataStoreRegister;
    }

    public static synchronized void setExecutable(Executable executable) {
        if (executable == null) {
            currentExecutable = executable;
        } else {
            while (Gate.getExecutable() != null) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException ie) {
                    throw new GateRuntimeException(ie.toString());
                }
            }
            currentExecutable = executable;
        }
    }

    public static synchronized Executable getExecutable() {
        return currentExecutable;
    }

    public static synchronized String genSym() {
        StringBuffer buff = new StringBuffer(Integer.toHexString(lastSym++).toUpperCase());
        for (int i = buff.length(); i <= 4; ++i) {
            buff.insert(0, '0');
        }
        return buff.toString();
    }

    public static String getUserConfigElement() {
        return userConfigElement;
    }

    public static File getSiteConfigFile() {
        String gateConfigProperty;
        if (siteConfigFile == null && (gateConfigProperty = System.getProperty("gate.config")) != null) {
            siteConfigFile = new File(gateConfigProperty);
        }
        return siteConfigFile;
    }

    public static void setSiteConfigFile(File siteConfigFile) {
        Gate.siteConfigFile = siteConfigFile;
    }

    public static String getEmptyConfigFile() {
        return emptyConfigFile;
    }

    public static OptionsMap getUserConfig() {
        return userConfig;
    }

    public static OptionsMap getOriginalUserConfig() {
        return originalUserConfig;
    }

    public static void writeUserConfig() throws GateException {
        if (sandboxed) {
            return;
        }
        String pluginsHomeStr = null;
        if (pluginsHome != null) {
            try {
                pluginsHomeStr = pluginsHome.getCanonicalPath();
            }
            catch (IOException ioe) {
                throw new GateRuntimeException("Problem while locating the plug-ins home!", ioe);
            }
        }
        String knownPluginPath = "";
        Set<Plugin> defaultPlugins = PluginUpdateManager.getDefaultPlugins();
        for (Plugin aPlugin : Gate.getKnownPlugins()) {
            String pluginStr = null;
            if (aPlugin instanceof Plugin.Maven) {
                Plugin.Maven mavenPlugin = (Plugin.Maven)aPlugin;
                if (!defaultPlugins.contains(aPlugin)) {
                    pluginStr = "[" + mavenPlugin.getGroup() + ":" + mavenPlugin.getArtifact() + ":" + mavenPlugin.getVersion() + "]";
                }
            } else if (aPlugin instanceof Plugin.Directory) {
                URL aPluginURL = aPlugin.getBaseURL();
                if (aPluginURL.getProtocol().equals("file")) {
                    File pluginDirectory = Files.fileFromURL(aPluginURL);
                    try {
                        if (pluginsHomeStr != null && pluginDirectory.getCanonicalPath().startsWith(pluginsHomeStr)) {
                            continue;
                        }
                    }
                    catch (IOException ioe) {
                        throw new GateRuntimeException("Problem while locating the plug-in" + aPluginURL.toString(), ioe);
                    }
                }
                pluginStr = aPluginURL.toExternalForm();
            }
            if (pluginStr == null) continue;
            if (knownPluginPath.length() > 0) {
                knownPluginPath = knownPluginPath + ";";
            }
            knownPluginPath = knownPluginPath + pluginStr;
        }
        Gate.getUserConfig().put((Object)"Known_plugin_path", knownPluginPath);
        String loadPluginPath = "";
        for (Plugin aPlugin : Gate.getAutoloadPlugins()) {
            String pluginStr = null;
            if (aPlugin instanceof Plugin.Maven) {
                Plugin.Maven mavenPlugin = (Plugin.Maven)aPlugin;
                pluginStr = "[" + mavenPlugin.getGroup() + ":" + mavenPlugin.getArtifact() + ":" + mavenPlugin.getVersion() + "]";
            } else {
                pluginStr = aPlugin.getBaseURL().toExternalForm();
            }
            if (loadPluginPath.length() > 0) {
                loadPluginPath = loadPluginPath + ";";
            }
            loadPluginPath = loadPluginPath + pluginStr;
        }
        Gate.getUserConfig().put((Object)"Load_plugin_path", loadPluginPath);
        File configFile = Gate.getUserConfigFile();
        try {
            if (!configFile.exists()) {
                FileOutputStream fos = new FileOutputStream(configFile);
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                writer.write(emptyConfigFile);
                writer.close();
            }
            Files.updateXmlElement(configFile, userConfigElement, userConfig.getStringMap());
        }
        catch (IOException e) {
            throw new GateException("problem writing user gate.xml: " + nl + e.toString());
        }
    }

    public static String getDefaultUserConfigFileName() {
        String filePrefix = "";
        if (Gate.runningOnUnix()) {
            filePrefix = ".";
        }
        String userConfigName = System.getProperty("user.home") + Strings.getFileSep() + filePrefix + "gate.xml";
        return userConfigName;
    }

    public static String getDefaultUserSessionFileName() {
        String filePrefix = "";
        if (Gate.runningOnUnix()) {
            filePrefix = ".";
        }
        String userSessionName = System.getProperty("user.home") + Strings.getFileSep() + filePrefix + "gate.session";
        return userSessionName;
    }

    public static boolean runningOnUnix() {
        return Strings.getFileSep().equals("/");
    }

    public static boolean runningOnMac() {
        return System.getProperty("os.name").toLowerCase().startsWith("mac os x");
    }

    public static Set<Plugin> getKnownPlugins() {
        HashSet<Plugin> plugins = new HashSet<Plugin>();
        plugins.addAll(knownPlugins);
        plugins.addAll(PluginUpdateManager.getDefaultPlugins());
        return plugins;
    }

    public static void addKnownPlugin(Plugin plugin) {
        if (knownPlugins.contains(plugin)) {
            return;
        }
        if (PluginUpdateManager.getDefaultPlugins().contains(plugin)) {
            return;
        }
        knownPlugins.add(plugin);
    }

    public static URL normaliseCreoleUrl(URL url) {
        String separator;
        String urlName = url.toExternalForm();
        if (urlName.endsWith(separator = "/")) {
            return url;
        }
        urlName = urlName + separator;
        try {
            return new URL(urlName);
        }
        catch (MalformedURLException mue) {
            throw new GateRuntimeException(mue);
        }
    }

    public static List<Plugin> getAutoloadPlugins() {
        return autoloadPlugins;
    }

    public static void addAutoloadPlugin(Plugin plugin) {
        if (autoloadPlugins.contains(plugin)) {
            return;
        }
        Gate.addKnownPlugin(plugin);
        autoloadPlugins.add(plugin);
    }

    public static Set<Plugin> getPlugins(String resourceClassName) {
        HashSet<Plugin> dirs = new HashSet<Plugin>();
        for (Plugin plugin : Gate.getKnownPlugins()) {
            for (ResourceInfo rInfo : plugin.getResourceInfoList()) {
                if (!rInfo.resourceClassName.equals(resourceClassName)) continue;
                dirs.add(plugin);
            }
        }
        return dirs;
    }

    public static void removeKnownPlugin(Plugin plugin) {
        knownPlugins.remove(plugin);
        autoloadPlugins.remove(plugin);
        creoleRegister.unregisterPlugin(plugin);
    }

    public static void removeAutoloadPlugin(Plugin plugin) {
        autoloadPlugins.remove(plugin);
    }

    public static void setGateHome(File gateHome) {
        if (Gate.gateHome != null) {
            throw new IllegalStateException("gateHome has already been set");
        }
        Gate.gateHome = gateHome;
    }

    public static void setPluginsHome(File pluginsHome) {
        if (Gate.pluginsHome != null) {
            throw new IllegalStateException("pluginsHome has already been set");
        }
        Gate.pluginsHome = pluginsHome;
    }

    public static File getPluginsHome() {
        return pluginsHome;
    }

    public static void setUserConfigFile(File userConfigFile) {
        if (Gate.userConfigFile != null) {
            throw new IllegalStateException("userConfigFile has already been set");
        }
        Gate.userConfigFile = userConfigFile;
    }

    public static File getUserConfigFile() {
        return userConfigFile;
    }

    public static void setBuiltinCreoleDir(URL builtinCreoleDir) {
        if (Gate.builtinCreoleDir != null) {
            throw new IllegalStateException("builtinCreoleDir has already been set");
        }
        Gate.builtinCreoleDir = builtinCreoleDir;
    }

    public static URL getBuiltinCreoleDir() {
        return builtinCreoleDir;
    }

    public static void setUserSessionFile(File newUserSessionFile) {
        if (userSessionFile != null) {
            throw new IllegalStateException("userSessionFile has already been set");
        }
        userSessionFile = newUserSessionFile;
    }

    public static File getUserSessionFile() {
        return userSessionFile;
    }

    public static void setUseXMLSerialization(boolean useXMLSerialization) {
        Gate.useXMLSerialization = useXMLSerialization;
    }

    public static boolean getUseXMLSerialization() {
        return useXMLSerialization;
    }

    public static Map<String, EventListener> getListeners() {
        return listeners;
    }

    public static XStreamSecurity getXStreamSecurity() {
        return xStreamSecurity;
    }

    public static void setXStreamSecurity(XStreamSecurity xStreamSecurity) {
        if (Gate.isInitialised()) {
            throw new IllegalStateException("XStream security must be set prior to initializing GATE");
        }
        Gate.xStreamSecurity = xStreamSecurity;
    }

    public static void configureXStreamSecurity(XStream xstream) {
        if (xStreamSecurity == null) {
            return;
        }
        xStreamSecurity.configure(xstream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String temp;
        log = LoggerFactory.getLogger(Gate.class);
        BomStrippingInputStreamReader reader = null;
        try {
            InputStream ver = Files.getGateResourceAsStream("version.txt");
            if (ver == null) {
                throw new IOException();
            }
            reader = new BomStrippingInputStreamReader(ver, "UTF-8");
            temp = ((BufferedReader)reader).readLine();
            IOUtils.closeQuietly((Reader)reader);
        }
        catch (IOException ioe) {
            temp = "VERSION UNKNOWN";
        }
        finally {
            IOUtils.closeQuietly(reader);
        }
        VERSION_STRING = temp;
        try {
            InputStream build = Files.getGateResourceAsStream("build.txt");
            if (build == null) {
                throw new IOException();
            }
            reader = new BomStrippingInputStreamReader(build, "UTF-8");
            temp = ((BufferedReader)reader).readLine();
        }
        catch (IOException ioe) {
            temp = "0000";
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
        BUILD = temp;
        Version tmpGateVersion = null;
        try {
            tmpGateVersion = new GenericVersionScheme().parseVersion(VERSION_STRING);
        }
        catch (InvalidVersionSpecificationException e) {
            log.error("Unable to parse GATE version number");
        }
        VERSION = tmpGateVersion;
        sandboxed = true;
        initFinished = false;
        registeredIREngines = new HashSet<String>();
        classLoader = null;
        creoleRegister = null;
        dataStoreRegister = null;
        userConfig = new OptionsMap();
        originalUserConfig = new OptionsMap();
        userConfigElement = "GATECONFIG";
        nl = Strings.getNl();
        emptyConfigFile = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + nl + "<!-- " + "gate.xml" + ": GATE configuration data -->" + nl + "<GATE>" + nl + "" + nl + "<!-- NOTE: the next element may be overwritten by the GUI!!! -->" + nl + "<" + userConfigElement + "/>" + nl + "" + nl + "</GATE>" + nl;
        useXMLSerialization = true;
        listeners = new HashMap<String, EventListener>();
        xStreamSecurity = new XStreamSecurity.MinimalBlacklist();
    }

    public static class ResourceInfo {
        protected String resourceClassName;
        protected String resourceName;
        protected String resourceComment;
        protected String helpURL;

        public ResourceInfo(String name, String className, String comment) {
            this.resourceClassName = className;
            this.resourceName = name;
            this.resourceComment = comment;
        }

        public ResourceInfo(String name, String className, String comment, String helpURL) {
            this.resourceClassName = className;
            this.resourceName = name;
            this.resourceComment = comment;
            this.helpURL = helpURL;
        }

        public String toString() {
            return this.resourceName + " (" + this.resourceClassName + ")";
        }

        public String getResourceClassName() {
            return this.resourceClassName;
        }

        public String getResourceComment() {
            return this.resourceComment;
        }

        public void setResourceComment(String resourceComment) {
            this.resourceComment = resourceComment;
        }

        public String getResourceName() {
            return this.resourceName;
        }

        public void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        public String getHelpURL() {
            return this.helpURL;
        }

        public void setHelpURL(String helpURL) {
            this.helpURL = helpURL;
        }
    }
}

