/*
 * Decompiled with CFR 0.152.
 */
package gate.util.persistence;

import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.Resource;
import gate.creole.Parameter;
import gate.creole.ParameterException;
import gate.creole.ParameterList;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.persist.PersistenceException;
import gate.util.persistence.AbstractPersistence;
import gate.util.persistence.PersistenceManager;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

class ResourcePersistence
extends AbstractPersistence {
    protected static final Logger log = Logger.getLogger(ResourcePersistence.class);
    protected String resourceType;
    protected String resourceName;
    protected Object initParams;
    protected Object features;
    static final long serialVersionUID = -3196664486112887875L;

    ResourcePersistence() {
    }

    @Override
    public void extractDataFromSource(Object source) throws PersistenceException {
        if (!(source instanceof Resource)) {
            throw new UnsupportedOperationException(this.getClass().getName() + " can only be used for " + Resource.class.getName() + " objects!\n" + source.getClass().getName() + " is not a " + Resource.class.getName());
        }
        Resource res = (Resource)source;
        this.resourceType = res.getClass().getName();
        this.resourceName = res.getName();
        ResourceData rData = (ResourceData)Gate.getCreoleRegister().get(this.resourceType);
        if (rData == null) {
            throw new PersistenceException("Could not find CREOLE data for " + this.resourceType);
        }
        ParameterList params = rData.getParameterList();
        try {
            this.initParams = Factory.newFeatureMap();
            Iterator<List<Parameter>> parDisjIter = params.getInitimeParameters().iterator();
            while (parDisjIter.hasNext()) {
                for (Parameter parameter : parDisjIter.next()) {
                    String parName = parameter.getName();
                    Object parValue = res.getParameterValue(parName);
                    if (!ResourcePersistence.storeParameterValue(parValue, parameter.getDefaultValue())) continue;
                    ((FeatureMap)this.initParams).put(parName, parValue);
                }
            }
            this.initParams = PersistenceManager.getPersistentRepresentation(this.initParams);
            if (res.getFeatures() != null) {
                this.features = Factory.newFeatureMap();
                ((FeatureMap)this.features).putAll(res.getFeatures());
                this.features = PersistenceManager.getPersistentRepresentation(this.features);
            }
        }
        catch (ParameterException | ResourceInstantiationException rie) {
            throw new PersistenceException(rie);
        }
    }

    protected static boolean storeParameterValue(Object value, Object defaultValue) {
        if (value == null && defaultValue == null) {
            return false;
        }
        if (value == null || defaultValue == null) {
            return true;
        }
        if (value == defaultValue) {
            return false;
        }
        return !value.equals(defaultValue);
    }

    @Override
    public Object createObject() throws PersistenceException, ResourceInstantiationException {
        String containingControllerNameToUse;
        String resourceId;
        if (this.initParams != null) {
            this.initParams = PersistenceManager.getTransientRepresentation(this.initParams, this.containingControllerName, this.initParamOverrides);
        }
        if (this.features != null) {
            this.features = PersistenceManager.getTransientRepresentation(this.features, this.containingControllerName, this.initParamOverrides);
        }
        if (this.initParamOverrides != null && this.initParamOverrides.containsKey(resourceId = (containingControllerNameToUse = this.containingControllerName == null ? "" : this.containingControllerName) + "\t" + this.resourceName)) {
            Map parmOverrides = (Map)this.initParamOverrides.get(resourceId);
            if (this.initParams instanceof FeatureMap) {
                FeatureMap fm = (FeatureMap)this.initParams;
                for (String name : parmOverrides.keySet()) {
                    Object obj = parmOverrides.get(name);
                    log.info((Object)("Overriding init parameter " + name + " for " + containingControllerNameToUse + "//" + this.resourceName + " with " + obj));
                    fm.put(name, obj);
                }
            }
        }
        Resource res = Factory.createResource(this.resourceType, (FeatureMap)this.initParams, (FeatureMap)this.features, this.resourceName);
        return res;
    }
}

