/*
 * Decompiled with CFR 0.152.
 */
package gate.util.persistence;

import gate.DataStore;
import gate.Factory;
import gate.Gate;
import gate.creole.ResourceInstantiationException;
import gate.persist.PersistenceException;
import gate.util.persistence.AbstractPersistence;
import gate.util.persistence.PersistenceManager;
import java.net.MalformedURLException;
import java.net.URL;

public class DSPersistence
extends AbstractPersistence {
    protected String className;
    protected String storageUrlString;
    protected Object storageUrl;
    static final long serialVersionUID = 5952924943977701708L;

    @Override
    public void extractDataFromSource(Object source) throws PersistenceException {
        if (!(source instanceof DataStore)) {
            throw new UnsupportedOperationException(this.getClass().getName() + " can only be used for " + DataStore.class.getName() + " objects!\n" + source.getClass().getName() + " is not a " + DataStore.class.getName());
        }
        DataStore ds = (DataStore)source;
        this.className = ds.getClass().getName();
        this.storageUrlString = ds.getStorageUrl();
        try {
            this.storageUrl = PersistenceManager.getPersistentRepresentation(new URL(this.storageUrlString));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    @Override
    public Object createObject() throws PersistenceException, ResourceInstantiationException {
        if (this.storageUrl != null) {
            this.storageUrlString = ((URL)PersistenceManager.getTransientRepresentation(this.storageUrl)).toExternalForm();
        }
        for (DataStore aDS : Gate.getDataStoreRegister()) {
            if (!aDS.getStorageUrl().equals(this.storageUrlString)) continue;
            return aDS;
        }
        return Factory.openDataStore(this.className, this.storageUrlString);
    }
}

