/*
 * Decompiled with CFR 0.152.
 */
package gate.util.maven;

import gate.util.maven.Utils;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.repository.WorkspaceRepository;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;

public class SimpleMavenCache
implements WorkspaceReader,
Serializable {
    private static final long serialVersionUID = 8612094868614282978L;
    private File head;
    private SimpleMavenCache tail;
    private transient WorkspaceRepository repo;

    public SimpleMavenCache(File ... dir) {
        if (dir == null || dir.length == 0) {
            throw new NullPointerException("At least one workspace directory must be specified");
        }
        this.head = dir[0];
        if (dir.length > 1) {
            this.tail = new SimpleMavenCache(Arrays.copyOfRange(dir, 1, dir.length));
        }
    }

    private File getArtifactFile(Artifact artifact) {
        File file = this.head;
        for (String part : artifact.getGroupId().split("\\.")) {
            file = new File(file, part);
        }
        file = new File(file, artifact.getArtifactId());
        file = new File(file, artifact.getVersion());
        file = "".equals(artifact.getClassifier()) ? new File(file, artifact.getArtifactId() + "-" + artifact.getVersion() + "." + artifact.getExtension()) : new File(file, artifact.getArtifactId() + "-" + artifact.getVersion() + "-" + artifact.getClassifier() + "." + artifact.getExtension());
        return file;
    }

    public File findArtifact(Artifact artifact) {
        File file = this.getArtifactFile(artifact);
        if (file.exists()) {
            return file;
        }
        if (this.tail == null) {
            return null;
        }
        return this.tail.findArtifact(artifact);
    }

    public List<String> findVersions(Artifact artifact) {
        File file;
        ArrayList<String> versions = new ArrayList<String>();
        if (this.tail != null) {
            versions.addAll(this.tail.findVersions(artifact));
        }
        if (!(file = this.getArtifactFile(artifact).getParentFile().getParentFile()).exists() || !file.isDirectory()) {
            return versions;
        }
        for (File version : file.listFiles()) {
            if (!version.isDirectory()) continue;
            versions.add(version.getName());
        }
        return versions;
    }

    public void cacheArtifact(Artifact artifact) throws IOException, SettingsBuildingException, DependencyCollectionException, DependencyResolutionException, ArtifactResolutionException, ModelBuildingException {
        List<RemoteRepository> repos = Utils.getRepositoryList();
        RepositorySystem repoSystem = Utils.getRepositorySystem();
        DefaultRepositorySystemSession repoSession = Utils.getRepositorySession(repoSystem, null);
        RemoteRepository localAsRemote = new RemoteRepository.Builder("localAsRemote", "default", repoSession.getLocalRepository().getBasedir().toURI().toString()).setPolicy(new RepositoryPolicy(true, "never", "ignore")).build();
        repos.add(0, localAsRemote);
        repoSession.setLocalRepositoryManager(repoSystem.newLocalRepositoryManager((RepositorySystemSession)repoSession, new LocalRepository(this.head.getAbsolutePath())));
        Dependency dependency = new Dependency(artifact, "runtime");
        CollectRequest collectRequest = new CollectRequest(dependency, repos);
        DependencyNode node = repoSystem.collectDependencies((RepositorySystemSession)repoSession, collectRequest).getRoot();
        DependencyRequest dependencyRequest = new DependencyRequest();
        dependencyRequest.setRoot(node);
        repoSystem.resolveDependencies((RepositorySystemSession)repoSession, dependencyRequest);
    }

    public void compact() throws IOException {
        Files.walkFileTree(this.head.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String filename = file.getFileName().toString();
                if (!filename.endsWith(".jar") && !filename.endsWith(".pom") || !filename.contains(file.getParent().getFileName().toString())) {
                    Files.delete(file);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public WorkspaceRepository getRepository() {
        if (this.repo == null) {
            this.repo = new WorkspaceRepository();
        }
        return this.repo;
    }

    public static void main(String[] args) throws Exception {
        for (RemoteRepository repo : Utils.getRepositoryList()) {
            System.out.println(repo);
        }
        DefaultArtifact artifactObj = new DefaultArtifact("uk.ac.gate.plugins", "annie", "jar", "8.5-SNAPSHOT");
        SimpleMavenCache reader = new SimpleMavenCache(new File("repo"));
        System.out.println(reader.findArtifact((Artifact)artifactObj));
        System.out.println(reader.findVersions((Artifact)artifactObj));
        reader.cacheArtifact((Artifact)artifactObj);
        System.out.println(reader.findArtifact((Artifact)artifactObj));
        System.out.println(reader.findVersions((Artifact)artifactObj));
        reader = new SimpleMavenCache(new File("repo2"), new File("repo"));
        System.out.println(reader.findArtifact((Artifact)artifactObj));
        System.out.println(reader.findVersions((Artifact)artifactObj));
    }
}

