/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

class SimpleMapImpl
implements Map<Object, Object>,
Cloneable,
Serializable {
    int capacity = 3;
    int count = 0;
    Object[] theKeys = new Object[this.capacity];
    Object[] theValues = new Object[this.capacity];
    static final long serialVersionUID = -6747241616127229116L;
    static transient Object nullKey = new NullKey();
    public static transient ConcurrentHashMap<Object, Object> theKeysHere = new ConcurrentHashMap();

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public Collection<Object> values() {
        throw new UnsupportedOperationException("SimpleMapImpl.values() not implemented!");
    }

    @Override
    public Set<Object> keySet() {
        HashSet<Object> s = new HashSet<Object>(this.size());
        for (int i = 0; i < this.count; ++i) {
            Object k = this.theKeys[i];
            if (k == nullKey) {
                s.add(null);
                continue;
            }
            s.add(k);
        }
        return s;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.count; ++i) {
            this.theKeys[i] = null;
            this.theValues[i] = null;
        }
        this.count = 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getPostionByKey(key) != -1;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getPostionByValue(value) != -1;
    }

    @Override
    public Object get(Object key) {
        int pos = this.getPostionByKey(key);
        return pos == -1 ? null : this.theValues[pos];
    }

    @Override
    public Object put(Object key, Object value) {
        Object gKey;
        if (key == null) {
            key = nullKey;
            gKey = nullKey;
        } else {
            gKey = theKeysHere.putIfAbsent(key, key);
        }
        if (gKey != null) {
            for (int i = 0; i < this.count; ++i) {
                if (gKey != this.theKeys[i]) continue;
                Object oldVal = this.theValues[i];
                this.theValues[i] = value;
                return oldVal;
            }
        } else {
            gKey = key;
        }
        if (this.count == this.capacity) {
            this.increaseCapacity();
        }
        this.theKeys[this.count] = gKey;
        this.theValues[this.count] = value;
        ++this.count;
        return null;
    }

    @Override
    public Object remove(Object key) {
        int pos = this.getPostionByKey(key);
        if (pos == -1) {
            return null;
        }
        Object oldVal = this.theValues[pos];
        --this.count;
        if (this.count != 0) {
            this.theKeys[pos] = this.theKeys[this.count];
            this.theValues[pos] = this.theValues[this.count];
        }
        this.theKeys[this.count] = null;
        this.theValues[this.count] = null;
        return oldVal;
    }

    @Override
    public void putAll(Map<? extends Object, ? extends Object> t) {
        if (t == null) {
            throw new UnsupportedOperationException("SimpleMapImpl.putAll argument is null");
        }
        if (t instanceof SimpleMapImpl) {
            SimpleMapImpl sfm = (SimpleMapImpl)t;
            for (int i = 0; i < sfm.count; ++i) {
                Object key = sfm.theKeys[i];
                this.put(key, sfm.theValues[i]);
            }
        } else {
            for (Map.Entry<? extends Object, ? extends Object> e : t.entrySet()) {
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    private int getPostionByKey(Object key) {
        if (key == null) {
            key = nullKey;
        }
        if ((key = theKeysHere.get(key)) == null) {
            return -1;
        }
        for (int i = 0; i < this.count; ++i) {
            if (key != this.theKeys[i]) continue;
            return i;
        }
        return -1;
    }

    protected int getSubsumeKey(Object key) {
        for (int i = 0; i < this.count; ++i) {
            if (key != this.theKeys[i]) continue;
            return i;
        }
        return -1;
    }

    private int getPostionByValue(Object value) {
        for (int i = 0; i < this.count; ++i) {
            Object av = this.theValues[i];
            if (!(value == null ? av == null : value.equals(av))) continue;
            return i;
        }
        return -1;
    }

    private void increaseCapacity() {
        int oldCapacity = this.capacity;
        this.capacity *= 2;
        Object[] oldKeys = this.theKeys;
        this.theKeys = new Object[this.capacity];
        Object[] oldValues = this.theValues;
        this.theValues = new Object[this.capacity];
        System.arraycopy(oldKeys, 0, this.theKeys, 0, oldCapacity);
        System.arraycopy(oldValues, 0, this.theValues, 0, oldCapacity);
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        HashSet<Map.Entry<Object, Object>> s = new HashSet<Map.Entry<Object, Object>>(this.size());
        for (int i = 0; i < this.count; ++i) {
            Object k = this.theKeys[i];
            s.add(new Entry(k.hashCode(), k == nullKey ? null : k, this.theValues[i]));
        }
        return s;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.count) {
            return false;
        }
        for (int i = 0; i < this.count; ++i) {
            Object k = this.theKeys[i];
            Object v = m.get(k);
            if (!(v == null ? this.theValues[i] != null : !v.equals(this.theValues[i]))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int h = 0;
        Iterator<Map.Entry<Object, Object>> i = this.entrySet().iterator();
        while (i.hasNext()) {
            h += i.next().hashCode();
        }
        return h;
    }

    public Object clone() {
        SimpleMapImpl newMap;
        try {
            newMap = (SimpleMapImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
        newMap.count = this.count;
        newMap.theKeys = new Object[this.capacity];
        System.arraycopy(this.theKeys, 0, newMap.theKeys, 0, this.capacity);
        newMap.theValues = new Object[this.capacity];
        System.arraycopy(this.theValues, 0, newMap.theValues, 0, this.capacity);
        return newMap;
    }

    public String toString() {
        int max = this.size() - 1;
        StringBuffer buf = new StringBuffer();
        Iterator<Map.Entry<Object, Object>> i = this.entrySet().iterator();
        buf.append("{");
        for (int j = 0; j <= max; ++j) {
            Map.Entry<Object, Object> e = i.next();
            buf.append(e.getKey() + "=" + e.getValue());
            if (j >= max) continue;
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        for (int i = 0; i < this.theKeys.length; ++i) {
            Object o;
            if (this.theKeys[i] instanceof NullKey) {
                this.theKeys[i] = nullKey;
                continue;
            }
            if (this.theKeys[i] == null || (o = theKeysHere.putIfAbsent(this.theKeys[i], this.theKeys[i])) == null) continue;
            this.theKeys[i] = o;
        }
    }

    static {
        theKeysHere.put(nullKey, nullKey);
    }

    private static class Entry
    implements Map.Entry<Object, Object> {
        int hash;
        Object key;
        Object value;

        Entry(int hash, Object key, Object value) {
            this.hash = hash;
            this.key = key;
            this.value = value;
        }

        protected Object clone() {
            return new Entry(this.hash, this.key, this.value);
        }

        @Override
        public Object getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Object setValue(Object value) {
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return (this.key == null ? e.getKey() == null : this.key.equals(e.getKey())) && (this.value == null ? e.getValue() == null : this.value.equals(e.getValue()));
        }

        @Override
        public int hashCode() {
            return this.hash ^ (this.key == null ? 0 : this.key.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    private static class NullKey
    implements Serializable {
        private static final long serialVersionUID = 6391916290867211345L;

        private NullKey() {
        }
    }
}

