/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import gate.Annotation;
import gate.util.AnnotationDiffer;
import gate.util.BomStrippingInputStreamReader;
import gate.util.Files;
import gate.util.Out;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class OntologyMeasures {
    protected Map<String, Float> bdmByTypeMap = new HashMap<String, Float>();
    protected URL bdmFileUrl;
    protected Map<String, AnnotationDiffer> differByTypeMap = new HashMap<String, AnnotationDiffer>();
    protected Map<String, Float> bdmByConceptsMap;

    public OntologyMeasures() {
    }

    public OntologyMeasures(Collection<OntologyMeasures> measures) {
        HashMap<String, ArrayList<Object>> differsByTypeMap = new HashMap<String, ArrayList<Object>>();
        for (OntologyMeasures ontologyMeasures : measures) {
            for (Map.Entry<String, Float> entry : ontologyMeasures.bdmByTypeMap.entrySet()) {
                float previousBdm = 0.0f;
                if (this.bdmByTypeMap.containsKey(entry.getKey())) {
                    previousBdm = this.bdmByTypeMap.get(entry.getKey()).floatValue();
                }
                this.bdmByTypeMap.put(entry.getKey(), Float.valueOf(previousBdm + entry.getValue().floatValue()));
            }
            for (Map.Entry<String, Object> entry : ontologyMeasures.differByTypeMap.entrySet()) {
                ArrayList<Object> differs = (ArrayList<Object>)differsByTypeMap.get(entry.getKey());
                if (differs == null) {
                    differs = new ArrayList<Object>();
                }
                differs.add(entry.getValue());
                differsByTypeMap.put(entry.getKey(), differs);
            }
        }
        for (Map.Entry entry : differsByTypeMap.entrySet()) {
            this.differByTypeMap.put((String)entry.getKey(), new AnnotationDiffer((Collection)entry.getValue()));
        }
    }

    public void calculateBdm(Collection<AnnotationDiffer> differs) {
        if (this.bdmByConceptsMap == null) {
            this.bdmByConceptsMap = this.read(this.bdmFileUrl);
        }
        HashSet<Annotation> unpairedResponseAnnotations = new HashSet<Annotation>();
        for (AnnotationDiffer differ : differs) {
            unpairedResponseAnnotations.addAll(differ.getAnnotationsOfType(3));
        }
        this.bdmByTypeMap.clear();
        for (AnnotationDiffer differ : differs) {
            Set<Annotation> unpairedKeyAnnotations = differ.getAnnotationsOfType(2);
            if (!this.bdmByTypeMap.containsKey(differ.getAnnotationType())) {
                this.bdmByTypeMap.put(differ.getAnnotationType(), Float.valueOf(0.0f));
            }
            for (Annotation unpairedKeyAnnotation : unpairedKeyAnnotations) {
                String type = unpairedKeyAnnotation.getType();
                Iterator iterator = unpairedResponseAnnotations.iterator();
                while (iterator.hasNext()) {
                    Annotation unpairedResponseAnnotation = (Annotation)iterator.next();
                    float bdm = 0.0f;
                    if (!unpairedKeyAnnotation.coextensive(unpairedResponseAnnotation)) continue;
                    if (differ.getSignificantFeaturesSet() != null) {
                        if (!type.equals(unpairedResponseAnnotation.getType())) continue;
                        for (Object feature : differ.getSignificantFeaturesSet()) {
                            if (unpairedKeyAnnotation.getFeatures() == null || unpairedResponseAnnotation.getFeatures() == null) continue;
                            String keyLabel = (String)unpairedKeyAnnotation.getFeatures().get(feature);
                            String responseLabel = (String)unpairedResponseAnnotation.getFeatures().get(feature);
                            if (keyLabel == null || responseLabel == null) continue;
                            if (this.bdmByConceptsMap.containsKey(keyLabel + ", " + responseLabel)) {
                                bdm += this.bdmByConceptsMap.get(keyLabel + ", " + responseLabel).floatValue();
                                continue;
                            }
                            if (!this.bdmByConceptsMap.containsKey(responseLabel + ", " + keyLabel)) continue;
                            bdm += this.bdmByConceptsMap.get(responseLabel + ", " + keyLabel).floatValue();
                        }
                        bdm /= (float)differ.getSignificantFeaturesSet().size();
                    } else if (this.bdmByConceptsMap.containsKey(type + ',' + unpairedResponseAnnotation.getType())) {
                        bdm = this.bdmByConceptsMap.get(type + ',' + unpairedResponseAnnotation.getType()).floatValue();
                    } else if (this.bdmByConceptsMap.containsKey(unpairedResponseAnnotation.getType() + ", " + type)) {
                        bdm = this.bdmByConceptsMap.get(unpairedResponseAnnotation.getType() + ", " + type).floatValue();
                    }
                    if (!(bdm > 0.0f)) continue;
                    this.bdmByTypeMap.put(type, Float.valueOf(this.bdmByTypeMap.get(type).floatValue() + bdm));
                    iterator.remove();
                }
            }
        }
        this.differByTypeMap.clear();
        HashMap<String, ArrayList<AnnotationDiffer>> differsByTypeMap = new HashMap<String, ArrayList<AnnotationDiffer>>();
        for (AnnotationDiffer annotationDiffer : differs) {
            String type = annotationDiffer.getAnnotationType();
            ArrayList<AnnotationDiffer> differsType = (ArrayList<AnnotationDiffer>)differsByTypeMap.get(type);
            if (differsType == null) {
                differsType = new ArrayList<AnnotationDiffer>();
            }
            differsType.add(annotationDiffer);
            differsByTypeMap.put(type, differsType);
        }
        for (Map.Entry entry : differsByTypeMap.entrySet()) {
            this.differByTypeMap.put((String)entry.getKey(), new AnnotationDiffer((Collection)entry.getValue()));
        }
    }

    public double getPrecisionStrictBdm(String type) {
        AnnotationDiffer differ = this.differByTypeMap.get(type);
        if (differ.getCorrectMatches() + differ.getSpurious() == 0) {
            return 1.0;
        }
        return (this.bdmByTypeMap.get(type).floatValue() + (float)differ.getCorrectMatches()) / (float)(differ.getCorrectMatches() + differ.getSpurious());
    }

    public double getPrecisionStrictBdm() {
        double result = 0.0;
        for (String type : this.differByTypeMap.keySet()) {
            result += this.getPrecisionStrictBdm(type);
        }
        return result / (double)this.differByTypeMap.size();
    }

    public double getRecallStrictBdm(String type) {
        AnnotationDiffer differ = this.differByTypeMap.get(type);
        if (differ.getCorrectMatches() + differ.getMissing() == 0) {
            return 1.0;
        }
        return (this.bdmByTypeMap.get(type).floatValue() + (float)differ.getCorrectMatches()) / (float)(differ.getCorrectMatches() + differ.getMissing());
    }

    public double getRecallStrictBdm() {
        double result = 0.0;
        for (String type : this.differByTypeMap.keySet()) {
            result += this.getRecallStrictBdm(type);
        }
        return result / (double)this.differByTypeMap.size();
    }

    public double getFMeasureStrictBdm(String type, double beta) {
        double recall;
        double betaSq = beta * beta;
        double precision = this.getPrecisionStrictBdm(type);
        double answer = (betaSq + 1.0) * precision * (recall = this.getRecallStrictBdm(type)) / (betaSq * precision + recall);
        if (Double.isNaN(answer)) {
            answer = 0.0;
        }
        return answer;
    }

    public double getFMeasureStrictBdm(double beta) {
        double result = 0.0;
        for (String type : this.differByTypeMap.keySet()) {
            result += this.getFMeasureStrictBdm(type, beta);
        }
        return result / (double)this.differByTypeMap.size();
    }

    public double getPrecisionLenientBdm(String type) {
        AnnotationDiffer differ = this.differByTypeMap.get(type);
        if (differ.getCorrectMatches() + differ.getSpurious() == 0) {
            return 1.0;
        }
        return (this.bdmByTypeMap.get(type).floatValue() + (float)differ.getCorrectMatches() + (float)differ.getPartiallyCorrectMatches()) / (float)(differ.getCorrectMatches() + differ.getSpurious());
    }

    public double getPrecisionLenientBdm() {
        double result = 0.0;
        for (String type : this.differByTypeMap.keySet()) {
            result += this.getPrecisionLenientBdm(type);
        }
        return result / (double)this.differByTypeMap.size();
    }

    public double getRecallLenientBdm(String type) {
        AnnotationDiffer differ = this.differByTypeMap.get(type);
        if (differ.getCorrectMatches() + differ.getMissing() == 0) {
            return 1.0;
        }
        return (this.bdmByTypeMap.get(type).floatValue() + (float)differ.getCorrectMatches() + (float)differ.getPartiallyCorrectMatches()) / (float)(differ.getCorrectMatches() + differ.getMissing());
    }

    public double getRecallLenientBdm() {
        double result = 0.0;
        for (String type : this.differByTypeMap.keySet()) {
            result += this.getRecallLenientBdm(type);
        }
        return result / (double)this.differByTypeMap.size();
    }

    public double getFMeasureLenientBdm(String type, double beta) {
        double recall;
        double betaSq = beta * beta;
        double precision = this.getPrecisionLenientBdm(type);
        double answer = (betaSq + 1.0) * precision * (recall = this.getRecallLenientBdm(type)) / (betaSq * precision + recall);
        if (Double.isNaN(answer)) {
            answer = 0.0;
        }
        return answer;
    }

    public double getFMeasureLenientBdm(double beta) {
        double result = 0.0;
        for (String type : this.differByTypeMap.keySet()) {
            result += this.getFMeasureLenientBdm(type, beta);
        }
        return result / (double)this.differByTypeMap.size();
    }

    public double getPrecisionAverageBdm(String type) {
        return (this.getPrecisionLenientBdm(type) + this.getPrecisionStrictBdm(type)) / 2.0;
    }

    public double getPrecisionAverageBdm() {
        return (this.getPrecisionLenientBdm() + this.getPrecisionStrictBdm()) / 2.0;
    }

    public double getRecallAverageBdm(String type) {
        return (this.getRecallLenientBdm(type) + this.getRecallStrictBdm(type)) / 2.0;
    }

    public double getRecallAverageBdm() {
        return (this.getRecallLenientBdm() + this.getRecallStrictBdm()) / 2.0;
    }

    public double getFMeasureAverageBdm(String type, double beta) {
        return (this.getFMeasureLenientBdm(type, beta) + this.getFMeasureStrictBdm(type, beta)) / 2.0;
    }

    public double getFMeasureAverageBdm(double beta) {
        return (this.getFMeasureLenientBdm(beta) + this.getFMeasureStrictBdm(beta)) / 2.0;
    }

    public void setBdmFile(URL url) {
        this.bdmFileUrl = url;
        this.bdmByConceptsMap = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Float> read(URL bdmFile) {
        HashMap<String, Float> bdmByConceptsMap = new HashMap<String, Float>();
        if (bdmFile == null) {
            Out.prln("There is no BDM file specified.");
            return bdmByConceptsMap;
        }
        BufferedReader bdmResultsReader = null;
        try {
            bdmResultsReader = new BomStrippingInputStreamReader((InputStream)new FileInputStream(Files.fileFromURL(bdmFile)), "UTF-8");
            bdmResultsReader.readLine();
            String line = bdmResultsReader.readLine();
            while (line != null) {
                String[] terms = line.split(", ");
                if (terms.length > 3) {
                    String oneCon = terms[0].substring(4);
                    String anoCon = terms[1].substring(9);
                    String bdmS = terms[2].substring(4);
                    bdmByConceptsMap.put(oneCon + ", " + anoCon, new Float(bdmS));
                } else {
                    Out.prln("File " + bdmFile.toString() + " has incorrect formatfor the line [" + line + "].");
                }
                line = bdmResultsReader.readLine();
            }
        }
        catch (Exception e) {
            Out.prln("There is something wrong with the BDM file.");
            e.printStackTrace();
        }
        finally {
            if (bdmResultsReader != null) {
                try {
                    bdmResultsReader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return bdmByConceptsMap;
    }

    public List<String> getMeasuresRow(Object[] measures, String title) {
        ArrayList<AnnotationDiffer> differs = new ArrayList<AnnotationDiffer>(this.getDifferByTypeMap().values());
        AnnotationDiffer differ = new AnnotationDiffer(differs);
        NumberFormat f = NumberFormat.getInstance(Locale.ENGLISH);
        f.setMaximumFractionDigits(2);
        f.setMinimumFractionDigits(2);
        ArrayList<String> row = new ArrayList<String>();
        row.add(title);
        row.add(Integer.toString(differ.getCorrectMatches()));
        row.add(Integer.toString(differ.getMissing()));
        row.add(Integer.toString(differ.getSpurious()));
        row.add(Integer.toString(differ.getPartiallyCorrectMatches()));
        for (Object object : measures) {
            String measure = (String)object;
            double beta = Double.valueOf(measure.substring(1, measure.indexOf(45)));
            if (measure.endsWith("strict")) {
                row.add(f.format(differ.getPrecisionStrict()));
                row.add(f.format(differ.getRecallStrict()));
                row.add(f.format(differ.getFMeasureStrict(beta)));
                continue;
            }
            if (measure.endsWith("strict BDM")) {
                row.add(f.format(this.getPrecisionStrictBdm()));
                row.add(f.format(this.getRecallStrictBdm()));
                row.add(f.format(this.getFMeasureStrictBdm(beta)));
                continue;
            }
            if (measure.endsWith("lenient")) {
                row.add(f.format(differ.getPrecisionLenient()));
                row.add(f.format(differ.getRecallLenient()));
                row.add(f.format(differ.getFMeasureLenient(beta)));
                continue;
            }
            if (measure.endsWith("lenient BDM")) {
                row.add(f.format(this.getPrecisionLenientBdm()));
                row.add(f.format(this.getRecallLenientBdm()));
                row.add(f.format(this.getFMeasureLenientBdm(beta)));
                continue;
            }
            if (measure.endsWith("average")) {
                row.add(f.format(differ.getPrecisionAverage()));
                row.add(f.format(differ.getRecallAverage()));
                row.add(f.format(differ.getFMeasureAverage(beta)));
                continue;
            }
            if (!measure.endsWith("average BDM")) continue;
            row.add(f.format(this.getPrecisionAverageBdm()));
            row.add(f.format(this.getRecallAverageBdm()));
            row.add(f.format(this.getFMeasureAverageBdm(beta)));
        }
        return row;
    }

    public Map<String, AnnotationDiffer> getDifferByTypeMap() {
        return this.differByTypeMap;
    }
}

