/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import gate.Corpus;
import gate.Document;
import gate.Factory;
import gate.LanguageAnalyser;
import gate.util.DocumentProcessor;
import gate.util.GateException;

public class LanguageAnalyserDocumentProcessor
implements DocumentProcessor {
    protected LanguageAnalyser analyser;
    private Corpus corpus;

    public void setAnalyser(LanguageAnalyser a) {
        this.analyser = a;
    }

    public LanguageAnalyser getAnalyser() {
        return this.analyser;
    }

    @Override
    public synchronized void processDocument(Document doc) throws GateException {
        if (this.corpus == null) {
            this.corpus = Factory.newCorpus("DocumentProcessor corpus");
        }
        try {
            this.corpus.add(doc);
            this.analyser.setCorpus(this.corpus);
            this.analyser.setDocument(doc);
            this.analyser.execute();
        }
        finally {
            this.analyser.setCorpus(null);
            this.analyser.setDocument(null);
            this.corpus.clear();
        }
    }

    public synchronized void cleanup() {
        Factory.deleteResource(this.analyser);
        if (this.corpus != null) {
            Factory.deleteResource(this.corpus);
        }
    }
}

