/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import gate.Gate;
import gate.corpora.DocumentXmlUtils;
import gate.util.BomStrippingInputStreamReader;
import gate.util.Err;
import gate.util.GateClassLoader;
import gate.util.Strings;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;

public class Files {
    private static final boolean DEBUG = false;
    static long resourceIndex = 0L;
    protected static final String resourcePath = "/gate/resources";

    public static String getResourcePath() {
        return resourcePath;
    }

    public static String getLastPathComponent(String path) {
        if (path == null || path.length() == 0) {
            return "";
        }
        int index = path.lastIndexOf(47);
        if (index == -1) {
            index = path.lastIndexOf(92);
        }
        if (index == -1) {
            return path;
        }
        return path.substring(index + 1);
    }

    public static String getString(String fileName) throws IOException {
        return Files.getString(new File(fileName));
    }

    public static String getString(File textFile) throws IOException {
        FileInputStream fis = new FileInputStream(textFile);
        int len = (int)textFile.length();
        byte[] textBytes = new byte[len];
        fis.read(textBytes, 0, len);
        fis.close();
        return new String(textBytes);
    }

    public static byte[] getByteArray(File binaryFile) throws IOException {
        FileInputStream fis = new FileInputStream(binaryFile);
        int len = (int)binaryFile.length();
        byte[] bytes = new byte[len];
        fis.read(bytes, 0, len);
        fis.close();
        return bytes;
    }

    public static String getResourceAsString(String resourceName) throws IOException {
        return Files.getResourceAsString(resourceName, null);
    }

    public static String getResourceAsString(String resourceName, String encoding) throws IOException {
        int i;
        InputStream resourceStream = Files.getResourceAsStream(resourceName);
        if (resourceStream == null) {
            return null;
        }
        BomStrippingInputStreamReader resourceReader = encoding == null ? new BomStrippingInputStreamReader(resourceStream) : new BomStrippingInputStreamReader(resourceStream, encoding);
        StringBuffer resourceBuffer = new StringBuffer();
        int charsRead = 0;
        int size = 1024;
        char[] charArray = new char[1024];
        while ((charsRead = ((BufferedReader)resourceReader).read(charArray, 0, 1024)) != -1) {
            resourceBuffer.append(charArray, 0, charsRead);
        }
        while ((i = ((BufferedReader)resourceReader).read()) != -1) {
            resourceBuffer.append((char)i);
        }
        ((BufferedReader)resourceReader).close();
        return resourceBuffer.toString();
    }

    public static String getGateResourceAsString(String resourceName) throws IOException {
        InputStream resourceStream = Files.getGateResourceAsStream(resourceName);
        if (resourceStream == null) {
            throw new IOException("No such resource on classpath: " + resourceName);
        }
        try {
            String string = IOUtils.toString((InputStream)resourceStream);
            return string;
        }
        finally {
            resourceStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File writeTempFile(InputStream contentStream) throws IOException {
        FileOutputStream resourceFileOutputStream;
        File resourceFile;
        block4: {
            resourceFile = null;
            resourceFileOutputStream = null;
            resourceFile = File.createTempFile("gateResource", ".tmp");
            resourceFileOutputStream = new FileOutputStream(resourceFile);
            resourceFile.deleteOnExit();
            if (contentStream != null) break block4;
            File file = resourceFile;
            IOUtils.closeQuietly((OutputStream)resourceFileOutputStream);
            IOUtils.closeQuietly((InputStream)contentStream);
            return file;
        }
        try {
            int bytesRead = 0;
            int readSize = 1024;
            byte[] bytes = new byte[1024];
            while ((bytesRead = contentStream.read(bytes, 0, 1024)) != -1) {
                resourceFileOutputStream.write(bytes, 0, bytesRead);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(resourceFileOutputStream);
            IOUtils.closeQuietly((InputStream)contentStream);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)resourceFileOutputStream);
        IOUtils.closeQuietly((InputStream)contentStream);
        return resourceFile;
    }

    public static File writeTempFile(String aString, String anEncoding) throws UnsupportedEncodingException, IOException {
        File resourceFile = null;
        OutputStreamWriter writer = null;
        resourceFile = File.createTempFile("gateResource", ".tmp");
        resourceFile.deleteOnExit();
        if (aString == null) {
            return resourceFile;
        }
        writer = anEncoding == null ? new OutputStreamWriter(new FileOutputStream(resourceFile)) : new OutputStreamWriter((OutputStream)new FileOutputStream(resourceFile), anEncoding);
        writer.write(aString);
        writer.flush();
        writer.close();
        return resourceFile;
    }

    public static File writeTempFile(String aString) throws IOException {
        return Files.writeTempFile(aString, null);
    }

    public static byte[] getResourceAsByteArray(String resourceName) throws IOException, IndexOutOfBoundsException, ArrayStoreException {
        byte b;
        InputStream resourceInputStream = Files.getResourceAsStream(resourceName);
        BufferedInputStream resourceStream = new BufferedInputStream(resourceInputStream);
        int bufSize = 1024;
        byte[] buf = new byte[1024];
        int i = 0;
        while ((b = (byte)resourceStream.read()) != -1) {
            if (i == buf.length) {
                byte[] newBuf = new byte[buf.length * 2];
                System.arraycopy(buf, 0, newBuf, 0, i);
                buf = newBuf;
            }
            buf[i++] = b;
        }
        resourceStream.close();
        byte[] bytes = new byte[i];
        System.arraycopy(buf, 0, bytes, 0, i);
        return bytes;
    }

    public static byte[] getGateResourceAsByteArray(String resourceName) throws IOException, IndexOutOfBoundsException, ArrayStoreException {
        byte b;
        InputStream resourceInputStream = Files.getGateResourceAsStream(resourceName);
        BufferedInputStream resourceStream = new BufferedInputStream(resourceInputStream);
        int bufSize = 1024;
        byte[] buf = new byte[1024];
        int i = 0;
        while ((b = (byte)resourceStream.read()) != -1) {
            if (i == buf.length) {
                byte[] newBuf = new byte[buf.length * 2];
                System.arraycopy(buf, 0, newBuf, 0, i);
                buf = newBuf;
            }
            buf[i++] = b;
        }
        resourceStream.close();
        byte[] bytes = new byte[i];
        System.arraycopy(buf, 0, bytes, 0, i);
        return bytes;
    }

    public static InputStream getResourceAsStream(String resourceName) throws IOException {
        GateClassLoader gcl;
        if (resourceName.charAt(0) == '/') {
            resourceName = resourceName.substring(1);
        }
        if ((gcl = Gate.getClassLoader()) == null) {
            return Files.class.getClassLoader().getResourceAsStream(resourceName);
        }
        return ((ClassLoader)gcl).getResourceAsStream(resourceName);
    }

    public static InputStream getGateResourceAsStream(String resourceName) throws IOException {
        if (resourceName.startsWith("/") || resourceName.startsWith("\\")) {
            return Files.getResourceAsStream(resourcePath + resourceName);
        }
        return Files.getResourceAsStream("/gate/resources/" + resourceName);
    }

    public static URL getResource(String resourceName) {
        GateClassLoader gcl;
        if (resourceName.charAt(0) == '/') {
            resourceName = resourceName.substring(1);
        }
        if ((gcl = Gate.getClassLoader()) == null) {
            return Files.class.getClassLoader().getResource(resourceName);
        }
        return ((ClassLoader)gcl).getResource(resourceName);
    }

    public static URL getGateResource(String resourceName) {
        if (resourceName.startsWith("/") || resourceName.startsWith("\\")) {
            return Files.getResource(resourcePath + resourceName);
        }
        return Files.getResource("/gate/resources/" + resourceName);
    }

    public static Set<String> Find(String regex, String pathFile) {
        Matcher matcher;
        HashSet<String> regexfinal = new HashSet<String>();
        File file = null;
        try {
            file = new File(pathFile);
        }
        catch (NullPointerException npe) {
            npe.printStackTrace(Err.getPrintWriter());
        }
        Pattern pattern = Pattern.compile("^" + regex);
        if (file.isDirectory()) {
            String[] tab = file.list();
            for (int i = 0; i <= tab.length - 1; ++i) {
                String finalPath = pathFile + "/" + tab[i];
                Matcher matcher2 = pattern.matcher(finalPath);
                if (!matcher2.matches()) continue;
                regexfinal.add(finalPath);
            }
        } else if (file.isFile() && (matcher = pattern.matcher(pathFile)).matches()) {
            regexfinal.add(pathFile);
        }
        return regexfinal;
    }

    public static boolean rmdir(File dir) {
        if (dir == null || !dir.isDirectory()) {
            return false;
        }
        String[] members = dir.list();
        boolean succeeded = true;
        for (int i = 0; i < members.length; ++i) {
            File member = new File(dir, members[i]);
            if (member.isFile()) {
                if (member.delete()) continue;
                succeeded = false;
                continue;
            }
            if (Files.rmdir(member)) continue;
            succeeded = false;
        }
        dir.delete();
        return succeeded;
    }

    public static String updateXmlElement(BufferedReader xml, String elementName, Map<String, String> newAttrs) throws IOException {
        String line = null;
        String nl = Strings.getNl();
        StringBuffer newXml = new StringBuffer();
        while ((line = xml.readLine()) != null) {
            newXml.append(line);
            newXml.append(nl);
        }
        int start = newXml.toString().indexOf("<" + elementName);
        if (start == -1) {
            return newXml.toString();
        }
        int end = newXml.toString().indexOf(">", start);
        if (end == -1) {
            return newXml.toString();
        }
        boolean isEmpty = false;
        if (newXml.toString().charAt(end - 1) == '/') {
            isEmpty = true;
        }
        StringBuffer newElement = new StringBuffer();
        newElement.append("<");
        newElement.append(elementName);
        for (Map.Entry<String, String> entry : newAttrs.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            newElement.append(" ");
            newElement.append(DocumentXmlUtils.combinedNormalisation(key));
            newElement.append("=\"");
            newElement.append(DocumentXmlUtils.combinedNormalisation(value));
            newElement.append("\"" + nl);
        }
        if (isEmpty) {
            newElement.append("/");
        }
        newElement.append(">");
        newXml.replace(start, end + 1, newElement.toString());
        return newXml.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String updateXmlElement(File xmlFile, String elementName, Map<String, String> newAttrs) throws IOException {
        String newXml = null;
        BufferedReader utfFileReader = null;
        BufferedReader platformFileReader = null;
        Charset utfCharset = Charset.forName("UTF-8");
        try {
            FileInputStream fis = new FileInputStream(xmlFile);
            CharsetDecoder decoder = utfCharset.newDecoder().onUnmappableCharacter(CodingErrorAction.REPORT).onMalformedInput(CodingErrorAction.REPORT);
            utfFileReader = new BomStrippingInputStreamReader((InputStream)fis, decoder);
            newXml = Files.updateXmlElement(utfFileReader, elementName, newAttrs);
        }
        catch (CharacterCodingException cce) {
            if (utfFileReader != null) {
                utfFileReader.close();
                utfFileReader = null;
            }
            platformFileReader = new BufferedReader(new FileReader(xmlFile));
            newXml = Files.updateXmlElement(platformFileReader, elementName, newAttrs);
        }
        finally {
            if (utfFileReader != null) {
                utfFileReader.close();
            }
            if (platformFileReader != null) {
                platformFileReader.close();
            }
        }
        newXml = newXml.replaceFirst("\\A<\\?xml (.*)encoding=(?:\"[^\"]*\"|'[^']*')", "<?xml $1encoding=\"UTF-8\"");
        FileOutputStream fos = new FileOutputStream(xmlFile);
        OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)fos, utfCharset);
        fileWriter.write(newXml);
        fileWriter.close();
        return newXml;
    }

    public static File fileFromURL(URL theURL) throws IllegalArgumentException {
        try {
            URI uri = new URI(theURL.toExternalForm());
            return new File(uri);
        }
        catch (URISyntaxException use) {
            try {
                URI uri = new URI(theURL.getProtocol(), null, theURL.getPath(), null, null);
                return new File(uri);
            }
            catch (URISyntaxException use2) {
                throw new IllegalArgumentException("Cannot convert " + theURL + " to a file path");
            }
        }
    }

    public static File[] listFilesRecursively(File directory, FileFilter filter) {
        ArrayList<File> filesList = new ArrayList<File>();
        File[] filesRootArray = directory.listFiles(filter);
        if (filesRootArray == null) {
            return null;
        }
        for (File file : filesRootArray) {
            filesList.add(file);
            if (!file.isDirectory()) continue;
            File[] filesDeepArray = Files.listFilesRecursively(file, filter);
            if (filesDeepArray == null) {
                return null;
            }
            filesList.addAll(Arrays.asList(filesDeepArray));
        }
        return filesList.toArray(new File[filesList.size()]);
    }
}

