/*
 * Decompiled with CFR 0.152.
 */
package gate.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.event.ListDataListener;

public class JChoice<E>
extends JPanel
implements ItemSelectable {
    public static final int DEFAULT_MAX_WIDTH = 500;
    public static final int DEFAULT_MAX_FAST_CHOICES = 10;
    private int maximumFastChoices;
    private Insets defaultButtonMargin;
    private int maximumWidth;
    private FlowLayout layout = new FlowLayout();
    private JComboBox<E> combo;
    private ItemListener sharedItemListener;
    private ComboBoxModel<E> model;
    private Map<AbstractButton, Object> buttonToValueMap;
    private Map<EventListener, ListenerWrapper> listenersMap;

    @Override
    public Object[] getSelectedObjects() {
        return new Object[]{this.getSelectedItem()};
    }

    public JChoice() {
        this(new DefaultComboBoxModel());
    }

    public JChoice(ComboBoxModel<E> model) {
        this.layout.setHgap(0);
        this.layout.setVgap(0);
        this.layout.setAlignment(0);
        this.setLayout(this.layout);
        this.model = model;
        this.setSelectedItem(null);
        this.initLocalData();
        this.buildGui();
    }

    public JChoice(E[] items) {
        this(new DefaultComboBoxModel<E>(items));
    }

    private void initLocalData() {
        this.maximumFastChoices = 10;
        this.maximumWidth = 500;
        this.listenersMap = new HashMap<EventListener, ListenerWrapper>();
        this.combo = new JComboBox<E>(this.model);
        this.buttonToValueMap = new HashMap<AbstractButton, Object>();
        this.sharedItemListener = new ItemListener(){
            private boolean disabled = false;

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (this.disabled) {
                    return;
                }
                if (e.getSource() == JChoice.this.combo) {
                    this.disabled = true;
                    if (e.getStateChange() == 1) {
                        for (AbstractButton aBtn : JChoice.this.buttonToValueMap.keySet()) {
                            Object aValue = JChoice.this.buttonToValueMap.get(aBtn);
                            if (aValue.equals(e.getItem())) {
                                if (aBtn.isSelected()) continue;
                                aBtn.setSelected(true);
                                aBtn.requestFocusInWindow();
                                continue;
                            }
                            if (!aBtn.isSelected()) continue;
                            aBtn.setSelected(false);
                        }
                    } else if (e.getStateChange() == 2) {
                        for (AbstractButton aBtn : JChoice.this.buttonToValueMap.keySet()) {
                            Object aValue = JChoice.this.buttonToValueMap.get(aBtn);
                            if (!aValue.equals(e.getItem()) || !aBtn.isSelected()) continue;
                            aBtn.setSelected(false);
                        }
                    }
                    this.disabled = false;
                } else if (e.getSource() instanceof AbstractButton && JChoice.this.buttonToValueMap.containsKey(e.getSource())) {
                    Object value = JChoice.this.buttonToValueMap.get(e.getSource());
                    if (e.getStateChange() == 1) {
                        JChoice.this.model.setSelectedItem(value);
                    } else if (e.getStateChange() == 2) {
                        JChoice.this.model.setSelectedItem(null);
                    }
                }
            }
        };
        this.combo.addItemListener(this.sharedItemListener);
    }

    public static void main(String[] args) {
        final JChoice<String> fChoice = new JChoice<String>(new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"});
        fChoice.setMaximumFastChoices(20);
        fChoice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Action (" + e.getActionCommand() + ") :" + fChoice.getSelectedItem() + " selected!");
            }
        });
        fChoice.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                System.out.println("Item " + e.getItem().toString() + (e.getStateChange() == 1 ? " selected!" : " deselected!"));
            }
        });
        JFrame aFrame = new JFrame("Fast Chioce Test Frame");
        aFrame.getContentPane().add(fChoice);
        Box topBox = Box.createHorizontalBox();
        JButton aButn = new JButton("Clear");
        aButn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Clearing");
                fChoice.setSelectedItem(null);
            }
        });
        topBox.add(Box.createHorizontalStrut(10));
        topBox.add(aButn);
        topBox.add(Box.createHorizontalStrut(10));
        topBox.add(new JToggleButton("GAGA"));
        aFrame.add((Component)topBox, "North");
        aFrame.pack();
        aFrame.setDefaultCloseOperation(2);
        aFrame.setVisible(true);
    }

    public void removeActionListener(ActionListener l) {
        ListenerWrapper wrapper = this.listenersMap.remove(l);
        this.combo.removeActionListener(wrapper);
    }

    @Override
    public void removeItemListener(ItemListener listener) {
        ListenerWrapper wrapper = this.listenersMap.remove(listener);
        this.combo.removeActionListener(wrapper);
    }

    public void addActionListener(ActionListener l) {
        this.combo.addActionListener(new ListenerWrapper(l));
    }

    @Override
    public void addItemListener(ItemListener listener) {
        this.combo.addItemListener(new ListenerWrapper(listener));
    }

    private void buildGui() {
        this.removeAll();
        if (this.model != null && this.model.getSize() > 0) {
            if (this.model.getSize() > this.maximumFastChoices) {
                this.add(this.combo);
            } else {
                if (this.buttonToValueMap.size() > 0) {
                    for (AbstractButton aBtn : this.buttonToValueMap.keySet()) {
                        aBtn.removeItemListener(this.sharedItemListener);
                    }
                }
                this.buttonToValueMap.clear();
                for (int i = 0; i < this.model.getSize(); ++i) {
                    Object aValue = this.model.getElementAt(i);
                    JToggleButton aButton = new JToggleButton(aValue.toString());
                    if (this.defaultButtonMargin != null) {
                        aButton.setMargin(this.defaultButtonMargin);
                    }
                    aButton.addItemListener(this.sharedItemListener);
                    this.buttonToValueMap.put(aButton, aValue);
                    this.add(aButton);
                }
            }
        }
        this.revalidate();
    }

    public void addListDataListener(ListDataListener l) {
        this.model.addListDataListener(l);
    }

    public Object getElementAt(int index) {
        return this.model.getElementAt(index);
    }

    public Object getSelectedItem() {
        return this.model.getSelectedItem();
    }

    public int getItemCount() {
        return this.model.getSize();
    }

    public void removeListDataListener(ListDataListener l) {
        this.model.removeListDataListener(l);
    }

    public void setSelectedItem(Object anItem) {
        this.model.setSelectedItem(anItem);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (this.getItemCount() <= this.maximumFastChoices && size.width > this.maximumWidth) {
            this.setSize(this.maximumWidth, Integer.MAX_VALUE);
            this.doLayout();
            int compCnt = this.getComponentCount();
            if (compCnt > 0) {
                Component lastComp = this.getComponent(compCnt - 1);
                Point compLoc = lastComp.getLocation();
                Dimension compSize = lastComp.getSize();
                size.width = this.maximumWidth;
                size.height = compLoc.y + compSize.height + this.getInsets().bottom;
            }
        }
        return size;
    }

    public int getMaximumFastChoices() {
        return this.maximumFastChoices;
    }

    public void setMaximumFastChoices(int maximumFastChoices) {
        this.maximumFastChoices = maximumFastChoices;
        this.buildGui();
    }

    public ComboBoxModel<E> getModel() {
        return this.model;
    }

    public void setModel(ComboBoxModel<E> model) {
        this.model = model;
        this.combo.setModel(model);
        this.buildGui();
    }

    public int getMaximumWidth() {
        return this.maximumWidth;
    }

    public void setMaximumWidth(int maximumWidth) {
        this.maximumWidth = maximumWidth;
    }

    public Insets getDefaultButtonMargin() {
        return this.defaultButtonMargin;
    }

    public void setDefaultButtonMargin(Insets defaultButtonMargin) {
        this.defaultButtonMargin = defaultButtonMargin;
        this.buildGui();
    }

    private class ListenerWrapper
    implements ActionListener,
    ItemListener {
        private EventListener originalListener;

        public ListenerWrapper(EventListener originalListener) {
            this.originalListener = originalListener;
            JChoice.this.listenersMap.put(originalListener, this);
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            ((ItemListener)this.originalListener).itemStateChanged(new ItemEvent(JChoice.this, e.getID(), e.getItem(), e.getStateChange()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((ActionListener)this.originalListener).actionPerformed(new ActionEvent(JChoice.this, e.getID(), e.getActionCommand(), e.getWhen(), e.getModifiers()));
        }
    }
}

