/*
 * Decompiled with CFR 0.152.
 */
package gate.swing;

import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

public class CheckBoxTableCellRenderer
extends JCheckBox
implements TableCellRenderer {
    private static final Border NO_FOCUS = BorderFactory.createEmptyBorder(1, 1, 1, 1);

    public CheckBoxTableCellRenderer() {
        this.setHorizontalAlignment(0);
        this.setBorderPainted(true);
        this.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color alternate = UIManager.getColor("Table.alternateRowColor");
        Color normal = new Color(table.getBackground().getRGB());
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setForeground(table.getForeground());
            this.setBackground(alternate != null && row % 2 == 0 ? alternate : normal);
        }
        this.setEnabled(table.isCellEditable(row, column));
        this.setSelected(value != null && (Boolean)value != false);
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        } else {
            this.setBorder(NO_FOCUS);
        }
        return this;
    }
}

