/*
 * Decompiled with CFR 0.152.
 */
package gate.resources.img.svg;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class OpenApplicationIcon
implements Icon {
    int width;
    int height;
    boolean disabled = false;

    private static Color getColor(int red, int green, int blue, int alpha, boolean disabled) {
        if (!disabled) {
            return new Color(red, green, blue, alpha);
        }
        int gray = (int)((0.3f * (float)red + 0.59f * (float)green + 0.11f * (float)blue) / 3.0f);
        gray = Math.min(255, Math.max(0, gray));
        int percent = 50;
        gray = 255 - (255 - gray) * (100 - percent) / 100;
        return new Color(gray, gray, gray, alpha);
    }

    public static void paint(Graphics2D g, boolean disabled) {
        AlphaComposite origAlphaComposite;
        Shape shape = null;
        Paint paint = null;
        BasicStroke stroke = null;
        Area clip = null;
        float origAlpha = 1.0f;
        Composite origComposite = g.getComposite();
        if (origComposite instanceof AlphaComposite && (origAlphaComposite = (AlphaComposite)origComposite).getRule() == 3) {
            origAlpha = origAlphaComposite.getAlpha();
        }
        Shape clip_ = g.getClip();
        AffineTransform defaultTransform_ = g.getTransform();
        float alpha__0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0 = g.getClip();
        AffineTransform defaultTransform__0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        clip = new Area(g.getClip());
        clip.intersect(new Area(new Rectangle2D.Double(0.0, 0.0, 64.0, 64.0)));
        g.setClip(clip);
        float alpha__0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0 = g.getClip();
        AffineTransform defaultTransform__0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        float alpha__0_0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_0 = g.getClip();
        AffineTransform defaultTransform__0_0_0 = g.getTransform();
        g.transform(new AffineTransform(-0.880954f, -0.473203f, 0.365772f, -0.930705f, 0.0f, 0.0f));
        paint = OpenApplicationIcon.getColor(255, 97, 0, 255, disabled);
        shape = new Rectangle2D.Double(-65.68597412109375, -33.63661575317383, 48.274662017822266, 40.721622467041016);
        g.setPaint(paint);
        g.fill(shape);
        paint = OpenApplicationIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.1889937f, 0, 0, 4.0f, null, 0.0f);
        shape = new Rectangle2D.Double(-65.68597412109375, -33.63661575317383, 48.274662017822266, 40.721622467041016);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_0;
        g.setTransform(defaultTransform__0_0_0);
        g.setClip(clip__0_0_0);
        float alpha__0_0_1 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_1 = g.getClip();
        AffineTransform defaultTransform__0_0_1 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 18.7677f, -2.230747f));
        float alpha__0_0_1_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_1_0 = g.getClip();
        AffineTransform defaultTransform__0_0_1_0 = g.getTransform();
        g.transform(new AffineTransform(0.549601f, 0.706207f, -0.697781f, 0.556238f, 26.52363f, -19.78882f));
        paint = OpenApplicationIcon.getColor(0, 0, 0, 255, disabled);
        shape = new Ellipse2D.Double(29.454544067382812, 28.545455932617188, 6.0, 6.181818008422852);
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_1_0;
        g.setTransform(defaultTransform__0_0_1_0);
        g.setClip(clip__0_0_1_0);
        float alpha__0_0_1_1 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_1_1 = g.getClip();
        AffineTransform defaultTransform__0_0_1_1 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = OpenApplicationIcon.getColor(255, 0, 0, 255, disabled);
        shape = new GeneralPath();
        ((GeneralPath)shape).moveTo(17.09375, 4.59375);
        ((GeneralPath)shape).curveTo(13.244158, 5.781618, 21.069134, 13.490205, 17.96875, 16.0625);
        ((GeneralPath)shape).curveTo(14.868366, 18.634794, 8.760565, 9.471451, 6.875, 13.03125);
        ((GeneralPath)shape).curveTo(4.9894347, 16.59105, 16.003635, 16.488544, 15.625, 20.5);
        ((GeneralPath)shape).curveTo(15.246366, 24.511457, 4.4121246, 22.367374, 5.59375, 26.21875);
        ((GeneralPath)shape).curveTo(6.7753754, 30.070126, 14.528686, 22.238714, 17.09375, 25.34375);
        ((GeneralPath)shape).curveTo(19.658813, 28.448786, 10.503517, 34.54975, 14.0625, 36.4375);
        ((GeneralPath)shape).curveTo(17.621483, 38.325253, 17.52045, 27.313276, 21.53125, 27.6875);
        ((GeneralPath)shape).curveTo(25.542051, 28.061724, 23.39731, 38.86644, 27.25, 37.6875);
        ((GeneralPath)shape).curveTo(31.102692, 36.50856, 23.274061, 28.788654, 26.375, 26.21875);
        ((GeneralPath)shape).curveTo(29.475939, 23.648846, 35.584667, 32.81367, 37.46875, 29.25);
        ((GeneralPath)shape).curveTo(39.352833, 25.686329, 28.339485, 25.762918, 28.71875, 21.75);
        ((GeneralPath)shape).curveTo(29.098017, 17.737082, 39.876114, 19.880157, 38.6875, 16.03125);
        ((GeneralPath)shape).curveTo(37.498886, 12.182344, 29.817188, 20.04152, 27.25, 16.9375);
        ((GeneralPath)shape).curveTo(24.682814, 13.833482, 33.812073, 7.693837, 30.25, 5.8125);
        ((GeneralPath)shape).curveTo(26.687927, 3.9311628, 26.792248, 14.944821, 22.78125, 14.5625);
        ((GeneralPath)shape).curveTo(18.770252, 14.180179, 20.943342, 3.405882, 17.09375, 4.59375);
        ((GeneralPath)shape).closePath();
        ((GeneralPath)shape).moveTo(22.34375, 15.96875);
        ((GeneralPath)shape).curveTo(25.021523, 15.96875, 27.21875, 18.086975, 27.21875, 20.71875);
        ((GeneralPath)shape).curveTo(27.218752, 23.350523, 25.021523, 25.5, 22.34375, 25.5);
        ((GeneralPath)shape).curveTo(19.665981, 25.5, 17.5, 23.350525, 17.5, 20.71875);
        ((GeneralPath)shape).curveTo(17.5, 18.086975, 19.665981, 15.96875, 22.34375, 15.96875);
        ((GeneralPath)shape).closePath();
        g.setPaint(paint);
        g.fill(shape);
        paint = OpenApplicationIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.02955f, 0, 2, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        ((GeneralPath)shape).moveTo(17.09375, 4.59375);
        ((GeneralPath)shape).curveTo(13.244158, 5.781618, 21.069134, 13.490205, 17.96875, 16.0625);
        ((GeneralPath)shape).curveTo(14.868366, 18.634794, 8.760565, 9.471451, 6.875, 13.03125);
        ((GeneralPath)shape).curveTo(4.9894347, 16.59105, 16.003635, 16.488544, 15.625, 20.5);
        ((GeneralPath)shape).curveTo(15.246366, 24.511457, 4.4121246, 22.367374, 5.59375, 26.21875);
        ((GeneralPath)shape).curveTo(6.7753754, 30.070126, 14.528686, 22.238714, 17.09375, 25.34375);
        ((GeneralPath)shape).curveTo(19.658813, 28.448786, 10.503517, 34.54975, 14.0625, 36.4375);
        ((GeneralPath)shape).curveTo(17.621483, 38.325253, 17.52045, 27.313276, 21.53125, 27.6875);
        ((GeneralPath)shape).curveTo(25.542051, 28.061724, 23.39731, 38.86644, 27.25, 37.6875);
        ((GeneralPath)shape).curveTo(31.102692, 36.50856, 23.274061, 28.788654, 26.375, 26.21875);
        ((GeneralPath)shape).curveTo(29.475939, 23.648846, 35.584667, 32.81367, 37.46875, 29.25);
        ((GeneralPath)shape).curveTo(39.352833, 25.686329, 28.339485, 25.762918, 28.71875, 21.75);
        ((GeneralPath)shape).curveTo(29.098017, 17.737082, 39.876114, 19.880157, 38.6875, 16.03125);
        ((GeneralPath)shape).curveTo(37.498886, 12.182344, 29.817188, 20.04152, 27.25, 16.9375);
        ((GeneralPath)shape).curveTo(24.682814, 13.833482, 33.812073, 7.693837, 30.25, 5.8125);
        ((GeneralPath)shape).curveTo(26.687927, 3.9311628, 26.792248, 14.944821, 22.78125, 14.5625);
        ((GeneralPath)shape).curveTo(18.770252, 14.180179, 20.943342, 3.405882, 17.09375, 4.59375);
        ((GeneralPath)shape).closePath();
        ((GeneralPath)shape).moveTo(22.34375, 15.96875);
        ((GeneralPath)shape).curveTo(25.021523, 15.96875, 27.21875, 18.086975, 27.21875, 20.71875);
        ((GeneralPath)shape).curveTo(27.218752, 23.350523, 25.021523, 25.5, 22.34375, 25.5);
        ((GeneralPath)shape).curveTo(19.665981, 25.5, 17.5, 23.350525, 17.5, 20.71875);
        ((GeneralPath)shape).curveTo(17.5, 18.086975, 19.665981, 15.96875, 22.34375, 15.96875);
        ((GeneralPath)shape).closePath();
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_1_1;
        g.setTransform(defaultTransform__0_0_1_1);
        g.setClip(clip__0_0_1_1);
        origAlpha = alpha__0_0_1;
        g.setTransform(defaultTransform__0_0_1);
        g.setClip(clip__0_0_1);
        float alpha__0_0_2 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_2 = g.getClip();
        AffineTransform defaultTransform__0_0_2 = g.getTransform();
        g.transform(new AffineTransform(-0.882966f, -0.469436f, 0.49617f, -0.868225f, 0.0f, 0.0f));
        paint = OpenApplicationIcon.getColor(245, 176, 134, 255, disabled);
        shape = new Rectangle2D.Double(-70.21683502197266, -33.98326873779297, 48.297786712646484, 36.08956f);
        g.setPaint(paint);
        g.fill(shape);
        paint = OpenApplicationIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.1195971f, 0, 0, 4.0f, null, 0.0f);
        shape = new Rectangle2D.Double(-70.21683502197266, -33.98326873779297, 48.297786712646484, 36.08956f);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_2;
        g.setTransform(defaultTransform__0_0_2);
        g.setClip(clip__0_0_2);
        float alpha__0_0_3 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_3 = g.getClip();
        AffineTransform defaultTransform__0_0_3 = g.getTransform();
        g.transform(new AffineTransform(-0.882966f, -0.469436f, 0.49617f, -0.868225f, 0.0f, 0.0f));
        paint = new LinearGradientPaint(new Point2D.Double(-30.031288146972656, -25.22644805908203), new Point2D.Double(-49.83999f, 1.81808f), new float[]{0.0f, 1.0f}, new Color[]{OpenApplicationIcon.getColor(255, 97, 0, 255, disabled), OpenApplicationIcon.getColor(255, 97, 0, 0, disabled)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        shape = new Rectangle2D.Double(-70.54749298095703, -33.77324676513672, 48.2977180480957, 36.08952713012695);
        g.setPaint(paint);
        g.fill(shape);
        paint = OpenApplicationIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.1195956f, 0, 0, 4.0f, null, 0.0f);
        shape = new Rectangle2D.Double(-70.54749298095703, -33.77324676513672, 48.2977180480957, 36.08952713012695);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_3;
        g.setTransform(defaultTransform__0_0_3);
        g.setClip(clip__0_0_3);
        float alpha__0_0_4 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_4 = g.getClip();
        AffineTransform defaultTransform__0_0_4 = g.getTransform();
        g.transform(new AffineTransform(0.877779f, 0.479065f, -0.437943f, 0.899003f, 0.0f, 0.0f));
        paint = OpenApplicationIcon.getColor(245, 176, 134, 255, disabled);
        shape = new Rectangle2D.Double(21.09636f, 19.323244094848633, 47.253204345703125, 4.883510589599609);
        g.setPaint(paint);
        g.fill(shape);
        paint = OpenApplicationIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(0.96075296f, 0, 0, 4.0f, null, 0.0f);
        shape = new Rectangle2D.Double(21.09636f, 19.323244094848633, 47.253204345703125, 4.883510589599609);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_4;
        g.setTransform(defaultTransform__0_0_4);
        g.setClip(clip__0_0_4);
        origAlpha = alpha__0_0;
        g.setTransform(defaultTransform__0_0);
        g.setClip(clip__0_0);
        origAlpha = alpha__0;
        g.setTransform(defaultTransform__0);
        g.setClip(clip__0);
        g.setTransform(defaultTransform_);
        g.setClip(clip_);
    }

    public Image getImage() {
        BufferedImage image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        Graphics2D g = image.createGraphics();
        this.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    public static int getOrigX() {
        return 2;
    }

    public static int getOrigY() {
        return 1;
    }

    public static int getOrigWidth() {
        return 64;
    }

    public static int getOrigHeight() {
        return 64;
    }

    public OpenApplicationIcon() {
        this(OpenApplicationIcon.getOrigWidth(), OpenApplicationIcon.getOrigHeight(), false);
    }

    public OpenApplicationIcon(boolean disabled) {
        this(OpenApplicationIcon.getOrigWidth(), OpenApplicationIcon.getOrigHeight(), disabled);
    }

    public OpenApplicationIcon(Dimension size) {
        this(size.width, size.height, false);
    }

    public OpenApplicationIcon(Dimension size, boolean disabled) {
        this(size.width, size.height, disabled);
    }

    public OpenApplicationIcon(int width, int height) {
        this(width, height, false);
    }

    public OpenApplicationIcon(int width, int height, boolean disabled) {
        this.width = width;
        this.height = height;
        this.disabled = disabled;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    public void setDimension(Dimension newDimension) {
        this.width = newDimension.width;
        this.height = newDimension.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.translate(x, y);
        Area clip = new Area(new Rectangle(0, 0, this.width, this.height));
        if (g2d.getClip() != null) {
            clip.intersect(new Area(g2d.getClip()));
        }
        g2d.setClip(clip);
        double coef1 = (double)this.width / (double)OpenApplicationIcon.getOrigWidth();
        double coef2 = (double)this.height / (double)OpenApplicationIcon.getOrigHeight();
        double coef = Math.min(coef1, coef2);
        g2d.scale(coef, coef);
        OpenApplicationIcon.paint(g2d, this.disabled);
        g2d.dispose();
    }
}

