/*
 * Decompiled with CFR 0.152.
 */
package gate.resources.img.svg;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class OIcon
implements Icon {
    int width;
    int height;
    boolean disabled = false;

    private static Color getColor(int red, int green, int blue, int alpha, boolean disabled) {
        if (!disabled) {
            return new Color(red, green, blue, alpha);
        }
        int gray = (int)((0.3f * (float)red + 0.59f * (float)green + 0.11f * (float)blue) / 3.0f);
        gray = Math.min(255, Math.max(0, gray));
        int percent = 50;
        gray = 255 - (255 - gray) * (100 - percent) / 100;
        return new Color(gray, gray, gray, alpha);
    }

    public static void paint(Graphics2D g, boolean disabled) {
        AlphaComposite origAlphaComposite;
        GeneralPath shape = null;
        Color paint = null;
        Object stroke = null;
        Area clip = null;
        float origAlpha = 1.0f;
        Composite origComposite = g.getComposite();
        if (origComposite instanceof AlphaComposite && (origAlphaComposite = (AlphaComposite)origComposite).getRule() == 3) {
            origAlpha = origAlphaComposite.getAlpha();
        }
        Shape clip_ = g.getClip();
        AffineTransform defaultTransform_ = g.getTransform();
        float alpha__0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0 = g.getClip();
        AffineTransform defaultTransform__0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, -0.0f, -0.0f));
        clip = new Area(g.getClip());
        clip.intersect(new Area(new Rectangle2D.Double(0.0, 0.0, 48.0, 48.0)));
        g.setClip(clip);
        float alpha__0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0 = g.getClip();
        AffineTransform defaultTransform__0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, -1004.3622f));
        float alpha__0_0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_0 = g.getClip();
        AffineTransform defaultTransform__0_0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        shape = new GeneralPath();
        shape.moveTo(43.861607, 1028.659);
        shape.quadTo(43.861607, 1035.4559, 39.496372, 1039.909);
        shape.quadTo(35.131138, 1044.3622, 28.378208, 1044.3622);
        shape.lineTo(19.779575, 1044.3622);
        shape.quadTo(13.070591, 1044.3622, 8.683384, 1039.909);
        shape.quadTo(4.296177, 1035.4559, 4.296177, 1028.659);
        shape.quadTo(4.296177, 1021.9061, 8.639439, 1017.76794);
        shape.quadTo(12.9827, 1013.62976, 19.779575, 1013.62976);
        shape.lineTo(28.378208, 1013.62976);
        shape.quadTo(35.21903, 1013.62976, 39.540318, 1017.76794);
        shape.quadTo(43.861607, 1021.9061, 43.861607, 1028.659);
        shape.closePath();
        shape.moveTo(38.544224, 1029.1132);
        shape.quadTo(38.544224, 1024.6454, 35.68778, 1021.8109);
        shape.quadTo(32.831333, 1018.97644, 28.378208, 1018.97644);
        shape.lineTo(19.779575, 1018.97644);
        shape.quadTo(15.370396, 1018.97644, 12.51395, 1021.8109);
        shape.quadTo(9.657505, 1024.6454, 9.657505, 1029.1132);
        shape.quadTo(9.657505, 1033.5223, 12.51395, 1036.2616);
        shape.quadTo(15.370396, 1039.0009, 19.779575, 1039.0009);
        shape.lineTo(28.378208, 1039.0009);
        shape.quadTo(32.831333, 1039.0009, 35.68778, 1036.2616);
        shape.quadTo(38.544224, 1033.5223, 38.544224, 1029.1132);
        shape.closePath();
        paint = OIcon.getColor(255, 0, 0, 255, disabled);
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_0;
        g.setTransform(defaultTransform__0_0_0);
        g.setClip(clip__0_0_0);
        origAlpha = alpha__0_0;
        g.setTransform(defaultTransform__0_0);
        g.setClip(clip__0_0);
        origAlpha = alpha__0;
        g.setTransform(defaultTransform__0);
        g.setClip(clip__0);
        g.setTransform(defaultTransform_);
        g.setClip(clip_);
    }

    public Image getImage() {
        BufferedImage image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        Graphics2D g = image.createGraphics();
        this.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    public static int getOrigX() {
        return 5;
    }

    public static int getOrigY() {
        return 10;
    }

    public static int getOrigWidth() {
        return 48;
    }

    public static int getOrigHeight() {
        return 48;
    }

    public OIcon() {
        this(OIcon.getOrigWidth(), OIcon.getOrigHeight(), false);
    }

    public OIcon(boolean disabled) {
        this(OIcon.getOrigWidth(), OIcon.getOrigHeight(), disabled);
    }

    public OIcon(Dimension size) {
        this(size.width, size.height, false);
    }

    public OIcon(Dimension size, boolean disabled) {
        this(size.width, size.height, disabled);
    }

    public OIcon(int width, int height) {
        this(width, height, false);
    }

    public OIcon(int width, int height, boolean disabled) {
        this.width = width;
        this.height = height;
        this.disabled = disabled;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    public void setDimension(Dimension newDimension) {
        this.width = newDimension.width;
        this.height = newDimension.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.translate(x, y);
        Area clip = new Area(new Rectangle(0, 0, this.width, this.height));
        if (g2d.getClip() != null) {
            clip.intersect(new Area(g2d.getClip()));
        }
        g2d.setClip(clip);
        double coef1 = (double)this.width / (double)OIcon.getOrigWidth();
        double coef2 = (double)this.height / (double)OIcon.getOrigHeight();
        double coef = Math.min(coef1, coef2);
        g2d.scale(coef, coef);
        OIcon.paint(g2d, this.disabled);
        g2d.dispose();
    }
}

