/*
 * Decompiled with CFR 0.152.
 */
package gate.resources.img.svg;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class NeTransducerIcon
implements Icon {
    int width;
    int height;
    boolean disabled = false;

    private static Color getColor(int red, int green, int blue, int alpha, boolean disabled) {
        if (!disabled) {
            return new Color(red, green, blue, alpha);
        }
        int gray = (int)((0.3f * (float)red + 0.59f * (float)green + 0.11f * (float)blue) / 3.0f);
        gray = Math.min(255, Math.max(0, gray));
        int percent = 50;
        gray = 255 - (255 - gray) * (100 - percent) / 100;
        return new Color(gray, gray, gray, alpha);
    }

    public static void paint(Graphics2D g, boolean disabled) {
        AlphaComposite origAlphaComposite;
        GeneralPath shape = null;
        Color paint = null;
        Object stroke = null;
        Area clip = null;
        float origAlpha = 1.0f;
        Composite origComposite = g.getComposite();
        if (origComposite instanceof AlphaComposite && (origAlphaComposite = (AlphaComposite)origComposite).getRule() == 3) {
            origAlpha = origAlphaComposite.getAlpha();
        }
        Shape clip_ = g.getClip();
        AffineTransform defaultTransform_ = g.getTransform();
        float alpha__0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0 = g.getClip();
        AffineTransform defaultTransform__0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        clip = new Area(g.getClip());
        clip.intersect(new Area(new Rectangle2D.Double(0.0, 0.0, 64.0, 64.0)));
        g.setClip(clip);
        float alpha__0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0 = g.getClip();
        AffineTransform defaultTransform__0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        float alpha__0_0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_0 = g.getClip();
        AffineTransform defaultTransform__0_0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 6.066843f, 2.331973f));
        paint = NeTransducerIcon.getColor(255, 0, 0, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(21.636364, 28.545456);
        shape.curveTo(34.691933, 13.657528, -9.460201, 22.705843, 9.852878, 18.335127);
        shape.curveTo(29.165956, 13.964411, -14.579854, 24.808157, 3.613797, 32.62412);
        shape.curveTo(21.807447, 40.44008, -0.44176996, 1.2449863, 9.683098, 18.26219);
        shape.curveTo(19.807964, 35.279392, -4.023249, -2.974442, -5.834521, 16.744013);
        shape.curveTo(-7.645793, 36.462467, 22.755568, 3.190255, 9.700001, 18.078182);
        shape.curveTo(-3.3555663, 32.966106, 25.661743, -1.519809, 6.3486648, 2.8509066);
        shape.curveTo(-12.964414, 7.2216225, 28.073877, 25.853354, 9.880226, 18.037395);
        shape.curveTo(-8.313426, 10.221436, 33.451473, 27.161802, 23.326605, 10.144599);
        shape.curveTo(13.201738, -6.8726053, 8.163438, 37.91465, 9.9747095, 18.196196);
        shape.curveTo(11.78598, -1.522259, 8.580797, 43.43338, 21.636364, 28.545456);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_0;
        g.setTransform(defaultTransform__0_0_0);
        g.setClip(clip__0_0_0);
        float alpha__0_0_1 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_1 = g.getClip();
        AffineTransform defaultTransform__0_0_1 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        shape = new GeneralPath();
        shape.moveTo(35.902626, 49.474262);
        shape.quadTo(35.902626, 51.32452, 34.635696, 51.32452);
        shape.quadTo(33.715126, 51.32452, 32.56669, 50.176083);
        shape.lineTo(20.307573, 37.85317);
        shape.lineTo(20.307573, 51.124);
        shape.lineTo(16.99898, 51.124);
        shape.lineTo(16.99898, 33.651344);
        shape.quadTo(16.99898, 32.976864, 17.363562, 32.489235);
        shape.quadTo(17.728146, 32.001606, 18.402624, 32.001606);
        shape.quadTo(19.323198, 32.001606, 20.307573, 32.976864);
        shape.lineTo(32.56669, 45.272438);
        shape.lineTo(32.56669, 32.001606);
        shape.lineTo(35.902626, 32.001606);
        shape.lineTo(35.902626, 49.474262);
        shape.closePath();
        shape.moveTo(56.06136, 43.084938);
        shape.lineTo(45.14209, 43.084938);
        shape.lineTo(45.14209, 39.758114);
        shape.lineTo(56.06136, 39.758114);
        shape.lineTo(56.06136, 43.084938);
        shape.closePath();
        shape.moveTo(56.927246, 51.124);
        shape.lineTo(40.41162, 51.124);
        shape.lineTo(40.41162, 32.001606);
        shape.lineTo(56.927246, 32.001606);
        shape.lineTo(56.927246, 35.328426);
        shape.lineTo(43.73844, 35.328426);
        shape.lineTo(43.73844, 47.788063);
        shape.lineTo(56.927246, 47.788063);
        shape.lineTo(56.927246, 51.124);
        shape.closePath();
        paint = NeTransducerIcon.getColor(0, 0, 0, 255, disabled);
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_1;
        g.setTransform(defaultTransform__0_0_1);
        g.setClip(clip__0_0_1);
        origAlpha = alpha__0_0;
        g.setTransform(defaultTransform__0_0);
        g.setClip(clip__0_0);
        origAlpha = alpha__0;
        g.setTransform(defaultTransform__0);
        g.setClip(clip__0);
        g.setTransform(defaultTransform_);
        g.setClip(clip_);
    }

    public Image getImage() {
        BufferedImage image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        Graphics2D g = image.createGraphics();
        this.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    public static int getOrigX() {
        return 0;
    }

    public static int getOrigY() {
        return 0;
    }

    public static int getOrigWidth() {
        return 64;
    }

    public static int getOrigHeight() {
        return 64;
    }

    public NeTransducerIcon() {
        this(NeTransducerIcon.getOrigWidth(), NeTransducerIcon.getOrigHeight(), false);
    }

    public NeTransducerIcon(boolean disabled) {
        this(NeTransducerIcon.getOrigWidth(), NeTransducerIcon.getOrigHeight(), disabled);
    }

    public NeTransducerIcon(Dimension size) {
        this(size.width, size.height, false);
    }

    public NeTransducerIcon(Dimension size, boolean disabled) {
        this(size.width, size.height, disabled);
    }

    public NeTransducerIcon(int width, int height) {
        this(width, height, false);
    }

    public NeTransducerIcon(int width, int height, boolean disabled) {
        this.width = width;
        this.height = height;
        this.disabled = disabled;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    public void setDimension(Dimension newDimension) {
        this.width = newDimension.width;
        this.height = newDimension.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.translate(x, y);
        Area clip = new Area(new Rectangle(0, 0, this.width, this.height));
        if (g2d.getClip() != null) {
            clip.intersect(new Area(g2d.getClip()));
        }
        g2d.setClip(clip);
        double coef1 = (double)this.width / (double)NeTransducerIcon.getOrigWidth();
        double coef2 = (double)this.height / (double)NeTransducerIcon.getOrigHeight();
        double coef = Math.min(coef1, coef2);
        g2d.scale(coef, coef);
        NeTransducerIcon.paint(g2d, this.disabled);
        g2d.dispose();
    }
}

