/*
 * Decompiled with CFR 0.152.
 */
package gate.resources.img.svg;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class LeftArrowIcon
implements Icon {
    int width;
    int height;
    boolean disabled = false;

    private static Color getColor(int red, int green, int blue, int alpha, boolean disabled) {
        if (!disabled) {
            return new Color(red, green, blue, alpha);
        }
        int gray = (int)((0.3f * (float)red + 0.59f * (float)green + 0.11f * (float)blue) / 3.0f);
        gray = Math.min(255, Math.max(0, gray));
        int percent = 50;
        gray = 255 - (255 - gray) * (100 - percent) / 100;
        return new Color(gray, gray, gray, alpha);
    }

    public static void paint(Graphics2D g, boolean disabled) {
        AlphaComposite origAlphaComposite;
        GeneralPath shape = null;
        Color paint = null;
        Object stroke = null;
        Area clip = null;
        float origAlpha = 1.0f;
        Composite origComposite = g.getComposite();
        if (origComposite instanceof AlphaComposite && (origAlphaComposite = (AlphaComposite)origComposite).getRule() == 3) {
            origAlpha = origAlphaComposite.getAlpha();
        }
        Shape clip_ = g.getClip();
        AffineTransform defaultTransform_ = g.getTransform();
        float alpha__0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0 = g.getClip();
        AffineTransform defaultTransform__0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        clip = new Area(g.getClip());
        clip.intersect(new Area(new Rectangle2D.Double(0.0, 0.0, 64.0, 64.0)));
        g.setClip(clip);
        float alpha__0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0 = g.getClip();
        AffineTransform defaultTransform__0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        float alpha__0_0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_0 = g.getClip();
        AffineTransform defaultTransform__0_0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = LeftArrowIcon.getColor(255, 105, 0, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(52.177727, 58.560356);
        shape.curveTo(48.570007, 51.87652, 43.68886, 46.31722, 39.009678, 40.922623);
        shape.curveTo(35.8591, 38.590775, 32.44, 37.236713, 29.272133, 34.97484);
        shape.curveTo(27.901129, 34.09523, 26.517641, 33.272144, 25.15852, 32.368217);
        shape.lineTo(32.43323, 26.000004);
        shape.curveTo(33.78279, 26.82694, 35.118584, 27.691074, 36.47595, 28.49637);
        shape.curveTo(39.678955, 30.855608, 43.220695, 32.06944, 46.26515, 34.827103);
        shape.curveTo(51.03293, 40.64891, 55.942215, 46.55963, 60.03323, 53.19944);
        shape.lineTo(52.177727, 58.560356);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_0;
        g.setTransform(defaultTransform__0_0_0);
        g.setClip(clip__0_0_0);
        float alpha__0_0_1 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_1 = g.getClip();
        AffineTransform defaultTransform__0_0_1 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = LeftArrowIcon.getColor(255, 105, 0, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(52.303017, 5.651286);
        shape.curveTo(48.695297, 12.335126, 43.814156, 17.894424, 39.13497, 23.28902);
        shape.curveTo(35.984394, 25.62087, 32.565292, 26.97493, 29.397427, 29.236805);
        shape.curveTo(28.026428, 30.116411, 26.642935, 30.9395, 25.283813, 31.843426);
        shape.lineTo(32.558525, 38.21164);
        shape.curveTo(33.908085, 37.3847, 35.243877, 36.52057, 36.601246, 35.71527);
        shape.curveTo(39.804253, 33.356033, 43.34599, 32.142204, 46.39044, 29.38454);
        shape.curveTo(51.158222, 23.562733, 56.06751, 17.652012, 60.158524, 11.012201);
        shape.lineTo(52.303017, 5.651286);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_1;
        g.setTransform(defaultTransform__0_0_1);
        g.setClip(clip__0_0_1);
        float alpha__0_0_2 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_2 = g.getClip();
        AffineTransform defaultTransform__0_0_2 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = LeftArrowIcon.getColor(255, 105, 0, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(28.453367, 58.560356);
        shape.curveTo(24.921202, 51.87652, 20.14228, 46.31722, 15.561088, 40.922623);
        shape.curveTo(12.476488, 38.590775, 9.128989, 37.236713, 6.027465, 34.97484);
        shape.curveTo(4.685176, 34.09523, 3.330659, 33.272144, 2.000001, 32.368217);
        shape.lineTo(9.122363, 26.000004);
        shape.curveTo(10.443659, 26.82694, 11.751479, 27.691074, 13.08042, 28.49637);
        shape.curveTo(16.216347, 30.855608, 19.683914, 32.06944, 22.664608, 34.827103);
        shape.curveTo(27.33254, 40.64891, 32.139015, 46.55963, 36.14436, 53.19944);
        shape.lineTo(28.453365, 58.560356);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_2;
        g.setTransform(defaultTransform__0_0_2);
        g.setClip(clip__0_0_2);
        float alpha__0_0_3 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_3 = g.getClip();
        AffineTransform defaultTransform__0_0_3 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = LeftArrowIcon.getColor(255, 105, 0, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(28.611887, 5.651286);
        shape.curveTo(25.079721, 12.335126, 20.3008, 17.894424, 15.719608, 23.28902);
        shape.curveTo(12.635008, 25.62087, 9.287508, 26.97493, 6.1859846, 29.236805);
        shape.curveTo(4.843696, 30.116411, 3.489178, 30.9395, 2.15852, 31.843426);
        shape.lineTo(9.280882, 38.21164);
        shape.curveTo(10.602178, 37.3847, 11.909999, 36.52057, 13.238939, 35.71527);
        shape.curveTo(16.374866, 33.356033, 19.842436, 32.142204, 22.823128, 29.38454);
        shape.curveTo(27.49106, 23.562733, 32.29754, 17.652012, 36.30288, 11.012201);
        shape.lineTo(28.611887, 5.651286);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_3;
        g.setTransform(defaultTransform__0_0_3);
        g.setClip(clip__0_0_3);
        origAlpha = alpha__0_0;
        g.setTransform(defaultTransform__0_0);
        g.setClip(clip__0_0);
        origAlpha = alpha__0;
        g.setTransform(defaultTransform__0);
        g.setClip(clip__0);
        g.setTransform(defaultTransform_);
        g.setClip(clip_);
    }

    public Image getImage() {
        BufferedImage image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        Graphics2D g = image.createGraphics();
        this.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    public static int getOrigX() {
        return 3;
    }

    public static int getOrigY() {
        return 6;
    }

    public static int getOrigWidth() {
        return 64;
    }

    public static int getOrigHeight() {
        return 64;
    }

    public LeftArrowIcon() {
        this(LeftArrowIcon.getOrigWidth(), LeftArrowIcon.getOrigHeight(), false);
    }

    public LeftArrowIcon(boolean disabled) {
        this(LeftArrowIcon.getOrigWidth(), LeftArrowIcon.getOrigHeight(), disabled);
    }

    public LeftArrowIcon(Dimension size) {
        this(size.width, size.height, false);
    }

    public LeftArrowIcon(Dimension size, boolean disabled) {
        this(size.width, size.height, disabled);
    }

    public LeftArrowIcon(int width, int height) {
        this(width, height, false);
    }

    public LeftArrowIcon(int width, int height, boolean disabled) {
        this.width = width;
        this.height = height;
        this.disabled = disabled;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    public void setDimension(Dimension newDimension) {
        this.width = newDimension.width;
        this.height = newDimension.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.translate(x, y);
        Area clip = new Area(new Rectangle(0, 0, this.width, this.height));
        if (g2d.getClip() != null) {
            clip.intersect(new Area(g2d.getClip()));
        }
        g2d.setClip(clip);
        double coef1 = (double)this.width / (double)LeftArrowIcon.getOrigWidth();
        double coef2 = (double)this.height / (double)LeftArrowIcon.getOrigHeight();
        double coef = Math.min(coef1, coef2);
        g2d.scale(coef, coef);
        LeftArrowIcon.paint(g2d, this.disabled);
        g2d.dispose();
    }
}

