/*
 * Decompiled with CFR 0.152.
 */
package gate.relations;

import gate.Factory;
import gate.FeatureMap;
import gate.relations.Relation;
import java.util.Arrays;
import java.util.regex.Matcher;

public class SimpleRelation
implements Relation {
    private static final long serialVersionUID = 6866132107461267866L;
    protected String type;
    protected int[] members;
    protected int id;
    protected FeatureMap features;
    protected Object userData;

    public SimpleRelation(int id, String type, int[] members) {
        this.id = id;
        this.type = type;
        this.members = members;
        this.features = Factory.newFeatureMap();
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public int[] getMembers() {
        return this.members;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.id).append(": ");
        String typeOut = this.type.replaceAll("\\(", Matcher.quoteReplacement("\\(")).replaceAll("\\)", Matcher.quoteReplacement("\\)"));
        str.append(typeOut).append("(");
        for (int i = 0; i < this.members.length; ++i) {
            if (i > 0) {
                str.append(", ");
            }
            str.append(this.members[i]);
        }
        str.append(")");
        if (this.features != null) {
            str.append("#").append(this.features.toString());
        }
        if (this.userData != null) {
            str.append("#").append(this.userData.toString());
        }
        return str.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.features == null ? 0 : this.features.hashCode());
        result = 31 * result + Arrays.hashCode(this.members);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.userData == null ? 0 : this.userData.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleRelation other = (SimpleRelation)obj;
        if (this.features == null ? other.features != null : !this.features.equals(other.features)) {
            return false;
        }
        if (!Arrays.equals(this.members, other.members)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.userData == null ? other.userData != null : !this.userData.equals(other.userData));
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public FeatureMap getFeatures() {
        return this.features;
    }

    @Override
    public void setFeatures(FeatureMap features) {
        this.features = features;
    }

    @Override
    public Object getUserData() {
        return this.userData;
    }

    @Override
    public void setUserData(Object data) {
        this.userData = data;
    }
}

