/*
 * Decompiled with CFR 0.152.
 */
package gate.relations;

import gate.Annotation;
import gate.AnnotationSet;
import gate.corpora.DocumentImpl;
import gate.event.AnnotationSetEvent;
import gate.event.AnnotationSetListener;
import gate.event.RelationSetEvent;
import gate.event.RelationSetListener;
import gate.relations.Relation;
import gate.relations.SimpleRelation;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;

public class RelationSet
implements Serializable,
AnnotationSetListener,
Set<Relation> {
    private static final long serialVersionUID = 8552798130184595465L;
    public static final int ANY = -1;
    protected Map<String, BitSet> indexByType;
    protected Map<Integer, Relation> indexById;
    protected List<Map<Integer, BitSet>> indexesByMember;
    protected AnnotationSet annSet;
    private Vector<RelationSetListener> listeners = null;
    private int maxID = 0;
    private Relation[] relations;

    public AnnotationSet getAnnotationSet() {
        return this.annSet;
    }

    public Collection<Relation> get() {
        return Collections.unmodifiableCollection(this.indexById.values());
    }

    public RelationSet(AnnotationSet annSet) {
        this.annSet = annSet;
        this.indexByType = new HashMap<String, BitSet>();
        this.indexesByMember = new ArrayList<Map<Integer, BitSet>>();
        this.indexById = new HashMap<Integer, Relation>();
        annSet.addAnnotationSetListener(this);
    }

    @Override
    public void clear() {
        for (Relation r : this.indexById.values()) {
            this.fireRelationRemoved(new RelationSetEvent(this, 902, r));
        }
        this.indexByType.clear();
        this.indexesByMember.clear();
        this.indexById.clear();
    }

    @Override
    public int size() {
        return this.indexById.size();
    }

    public Relation addRelation(String type, int ... members) throws IllegalArgumentException {
        if (members.length < 2) {
            throw new IllegalArgumentException("A relation needs to have atleast two members");
        }
        for (int member : members) {
            if (this.indexById.containsKey(member) || this.annSet.get(member) != null) continue;
            throw new IllegalArgumentException("Member must be from within this annotation set");
        }
        if (type == null || type.trim().equals("")) {
            throw new IllegalArgumentException("A relation must have a type");
        }
        SimpleRelation rel = new SimpleRelation(((DocumentImpl)this.annSet.getDocument()).getNextAnnotationId(), type, members);
        this.add(rel);
        return rel;
    }

    @Override
    public boolean add(Relation rel) {
        this.maxID = Math.max(this.maxID, rel.getId());
        this.indexById.put(rel.getId(), rel);
        BitSet sameType = this.indexByType.get(rel.getType());
        if (sameType == null) {
            sameType = new BitSet(rel.getId());
            this.indexByType.put(rel.getType(), sameType);
        }
        sameType.set(rel.getId());
        for (int i = this.indexesByMember.size(); i < rel.getMembers().length; ++i) {
            this.indexesByMember.add(new HashMap());
        }
        for (int memeberPos = 0; memeberPos < rel.getMembers().length; ++memeberPos) {
            int member = rel.getMembers()[memeberPos];
            Map<Integer, BitSet> indexByMember = this.indexesByMember.get(memeberPos);
            BitSet sameMember = indexByMember.get(member);
            if (sameMember == null) {
                sameMember = new BitSet(this.maxID);
                indexByMember.put(member, sameMember);
            }
            sameMember.set(rel.getId());
        }
        this.fireRelationAdded(new RelationSetEvent(this, 901, rel));
        return true;
    }

    public int getMaximumArity() {
        return this.indexesByMember.size();
    }

    public Collection<Relation> getRelations(String type) {
        ArrayList<Relation> res = new ArrayList<Relation>();
        BitSet rels = this.indexByType.get(type);
        if (rels != null) {
            for (int relPos = 0; relPos <= this.maxID; ++relPos) {
                if (!rels.get(relPos)) continue;
                res.add(this.indexById.get(relPos));
            }
        }
        return res;
    }

    public Relation get(Integer id) {
        return this.indexById.get(id);
    }

    public Collection<Relation> getRelations(int ... members) {
        return this.getRelations(null, members);
    }

    public Collection<Relation> getRelations(String type, int ... members) {
        BitSet[] postingLists = new BitSet[this.getMaximumArity() + (type != null ? 1 : 0)];
        for (int i = 0; i < postingLists.length; ++i) {
            postingLists[i] = i < members.length && members[i] >= 0 ? this.indexesByMember.get(i).get(members[i]) : null;
        }
        if (type != null) {
            postingLists[postingLists.length - 1] = this.indexByType.get(type);
        }
        return this.intersection(postingLists);
    }

    public boolean deleteRelation(Relation relation) {
        if (!this.indexById.containsValue(relation)) {
            return false;
        }
        for (Relation r : this.getReferencing(relation.getId())) {
            this.deleteRelation(r);
        }
        this.indexByType.get(relation.getType()).clear(relation.getId());
        this.indexById.remove(relation.getId());
        for (int memeberPos = 0; memeberPos < relation.getMembers().length; ++memeberPos) {
            int member = relation.getMembers()[memeberPos];
            Map<Integer, BitSet> indexByMember = this.indexesByMember.get(memeberPos);
            BitSet sameMember = indexByMember.get(member);
            sameMember.clear(relation.getId());
        }
        this.fireRelationRemoved(new RelationSetEvent(this, 902, relation));
        return true;
    }

    public Collection<Relation> getReferencing(Integer id) {
        HashSet<Relation> relations = new HashSet<Relation>();
        for (int pos = 0; pos < this.getMaximumArity(); ++pos) {
            int[] constraint = new int[pos + 1];
            for (int i = 0; i < pos; ++i) {
                constraint[i] = -1;
            }
            constraint[pos] = id;
            relations.addAll(this.getRelations(null, constraint));
        }
        return relations;
    }

    protected Collection<Relation> intersection(BitSet ... indexLists) {
        HashSet<Relation> res = new HashSet<Relation>();
        BitSet relIds = new BitSet(this.maxID + 1);
        relIds.set(0, this.maxID + 1);
        boolean found = false;
        for (BitSet aList : indexLists) {
            if (aList == null) continue;
            found = true;
            relIds.and(aList);
            if (!relIds.isEmpty()) continue;
            return res;
        }
        if (!found) {
            return res;
        }
        for (int relIdx = 0; relIdx < this.maxID + 1; ++relIdx) {
            if (!relIds.get(relIdx)) continue;
            res.add(this.indexById.get(relIdx));
        }
        return res;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[");
        boolean first = true;
        for (Relation r : this.indexById.values()) {
            if (first) {
                first = false;
            } else {
                str.append("; ");
            }
            String relStr = r.toString();
            relStr = relStr.replaceAll(";", Matcher.quoteReplacement("\\;"));
            if (!r.getClass().equals(SimpleRelation.class)) {
                relStr = "(" + r.getClass().getName() + ")" + relStr;
            }
            str.append(relStr);
        }
        str.append("]");
        return str.toString();
    }

    @Override
    public void annotationAdded(AnnotationSetEvent e) {
    }

    @Override
    public void annotationRemoved(AnnotationSetEvent e) {
        Annotation a = e.getAnnotation();
        for (Relation r : this.getReferencing(a.getId())) {
            this.deleteRelation(r);
        }
    }

    public synchronized void removeRelationSetListener(RelationSetListener l) {
        if (this.listeners != null && this.listeners.contains(l)) {
            Vector v = (Vector)this.listeners.clone();
            v.removeElement(l);
            this.listeners = v;
        }
    }

    public synchronized void addRelationSetListener(RelationSetListener l) {
        Vector v;
        Vector vector = v = this.listeners == null ? new Vector(2) : (Vector)this.listeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.listeners = v;
        }
    }

    protected void fireRelationAdded(RelationSetEvent e) {
        if (this.listeners != null) {
            int count = this.listeners.size();
            for (int i = 0; i < count; ++i) {
                this.listeners.elementAt(i).relationAdded(e);
            }
        }
    }

    protected void fireRelationRemoved(RelationSetEvent e) {
        if (this.listeners != null) {
            int count = this.listeners.size();
            for (int i = 0; i < count; ++i) {
                this.listeners.elementAt(i).relationRemoved(e);
            }
        }
    }

    @Override
    public boolean addAll(Collection<? extends Relation> relations) {
        boolean modified = false;
        for (Relation relation : relations) {
            modified |= this.add(relation);
        }
        return modified;
    }

    @Override
    public boolean contains(Object obj) {
        return this.indexById.containsValue(obj);
    }

    @Override
    public boolean containsAll(Collection<?> relations) {
        boolean all = true;
        for (Object r : relations) {
            all &= this.contains(r);
        }
        return all;
    }

    @Override
    public boolean isEmpty() {
        return this.indexById.isEmpty();
    }

    @Override
    public Iterator<Relation> iterator() {
        final HashSet<Relation> copy = new HashSet<Relation>(this.indexById.values());
        return new Iterator<Relation>(){
            private Relation nextElement;
            private Relation currentElement;
            private boolean hasNext;
            private Iterator<Relation> iterator;
            {
                this.iterator = copy.iterator();
                this.nextMatch();
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public Relation next() {
                if (!this.hasNext) {
                    throw new NoSuchElementException();
                }
                this.currentElement = this.nextMatch();
                return this.currentElement;
            }

            private Relation nextMatch() {
                Relation oldMatch = this.nextElement;
                while (this.iterator.hasNext()) {
                    Relation o = this.iterator.next();
                    if (!RelationSet.this.indexById.containsValue(o)) continue;
                    this.hasNext = true;
                    this.nextElement = o;
                    return oldMatch;
                }
                this.hasNext = false;
                return oldMatch;
            }

            @Override
            public void remove() {
                if (this.currentElement != null) {
                    RelationSet.this.deleteRelation(this.currentElement);
                }
            }
        };
    }

    @Override
    public boolean remove(Object obj) {
        if (!(obj instanceof Relation)) {
            return false;
        }
        return this.deleteRelation((Relation)obj);
    }

    @Override
    public boolean removeAll(Collection<?> relations) {
        boolean modified = false;
        for (Object r : relations) {
            if (!(r instanceof Relation)) continue;
            modified |= this.deleteRelation((Relation)r);
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> relations) {
        boolean modified = false;
        Iterator<Relation> it = this.iterator();
        while (it.hasNext()) {
            Relation r = it.next();
            if (relations.contains(r)) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public Object[] toArray() {
        return this.indexById.values().toArray();
    }

    @Override
    public <T> T[] toArray(T[] store) {
        return this.indexById.values().toArray(store);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        ObjectOutputStream.PutField pf = out.putFields();
        pf.put("annSet", this.annSet);
        pf.put("relations", this.toArray(new Relation[this.size()]));
        out.writeFields();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField gf = in.readFields();
        this.annSet = (AnnotationSet)gf.get("annSet", null);
        this.relations = (Relation[])gf.get("relations", null);
        this.indexByType = new HashMap<String, BitSet>();
        this.indexesByMember = new ArrayList<Map<Integer, BitSet>>();
        this.indexById = new HashMap<Integer, Relation>();
        this.annSet.addAnnotationSetListener(this);
        if (this.relations != null) {
            for (Relation r : this.relations) {
                this.add(r);
            }
        }
        this.relations = null;
    }
}

