/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.docview;

import gate.Annotation;
import gate.corpora.DocumentContentImpl;
import gate.event.DocumentEvent;
import gate.gui.annedit.AnnotationData;
import gate.gui.docview.AbstractDocumentView;
import gate.util.Err;
import gate.util.GateRuntimeException;
import gate.util.InvalidOffsetException;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;

public class TextualDocumentView
extends AbstractDocumentView {
    protected JScrollPane scroller;
    protected GateDocumentListener gateDocListener;
    protected SwingDocumentListener swingDocListener;
    protected Map<AnnotationData, HighlightData> blinkingTagsForAnnotations = new HashMap<AnnotationData, HighlightData>();
    protected List<HighlightData> highlightsToAdd = new LinkedList<HighlightData>();
    protected List<HighlightData> highlightsToRemove = new LinkedList<HighlightData>();
    protected Set<AnnotationData> blinkingHighlightsToRemove = new HashSet<AnnotationData>();
    protected List<AnnotationData> blinkingHighlightsToAdd = new LinkedList<AnnotationData>();
    protected Timer highlightsMinder;
    protected JTextArea textView;
    protected static final int BLINK_DELAY = 400;
    protected static final int HIGHLIGHT_DELAY = 100;

    public TextualDocumentView() {
        this.gateDocListener = new GateDocumentListener();
        this.swingDocListener = new SwingDocumentListener();
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.highlightsMinder.stop();
        if (this.document != null) {
            this.document.removeDocumentListener(this.gateDocListener);
        }
        this.textView.getDocument().removeDocumentListener(this.swingDocListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HighlightData addHighlight(AnnotationData aData, Color colour) {
        HighlightData hData = new HighlightData(aData, colour);
        TextualDocumentView textualDocumentView = this;
        synchronized (textualDocumentView) {
            this.highlightsToAdd.add(hData);
        }
        this.highlightsMinder.restart();
        return hData;
    }

    public List<HighlightData> addHighlights(Collection<AnnotationData> annotations, Color colour) {
        ArrayList<HighlightData> tags = new ArrayList<HighlightData>();
        for (AnnotationData aData : annotations) {
            tags.add(this.addHighlight(aData, colour));
        }
        return tags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHighlight(HighlightData tag) {
        TextualDocumentView textualDocumentView = this;
        synchronized (textualDocumentView) {
            this.highlightsToRemove.add(tag);
        }
        this.highlightsMinder.restart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHighlights(List<HighlightData> list) {
        for (HighlightData highlightData : list) {
            TextualDocumentView textualDocumentView = this;
            synchronized (textualDocumentView) {
                this.highlightsToAdd.add(highlightData);
            }
        }
        this.highlightsMinder.restart();
    }

    public void removeHighlights(Collection<HighlightData> tags) {
        for (HighlightData tag : tags) {
            this.removeHighlight(tag);
        }
    }

    public void changeOrientation(ComponentOrientation orientation) {
        this.textView.setComponentOrientation(orientation);
        try {
            this.document.removeDocumentListener(this.gateDocListener);
            this.textView.insert("a", 0);
            this.textView.replaceRange("", 0, 1);
        }
        finally {
            this.document.addDocumentListener(this.gateDocListener);
        }
    }

    public void scrollAnnotationToVisible(Annotation ann) {
        Rectangle visibleView = this.scroller.getViewport().getViewRect();
        int viewStart = this.textView.viewToModel(visibleView.getLocation());
        Point endPoint = new Point(visibleView.getLocation());
        endPoint.translate(visibleView.width, visibleView.height);
        int viewEnd = this.textView.viewToModel(endPoint);
        int annStart = ann.getStartNode().getOffset().intValue();
        int annEnd = ann.getEndNode().getOffset().intValue();
        if (annEnd < viewStart || viewEnd < annStart) {
            try {
                this.textView.scrollRectToVisible(this.textView.modelToView(annStart));
            }
            catch (BadLocationException ble) {
                throw new GateRuntimeException(ble);
            }
        }
    }

    public void moveHighlight(Object tag, int newStart, int newEnd) throws BadLocationException {
        if (tag instanceof HighlightData) {
            this.textView.getHighlighter().changeHighlight(((HighlightData)tag).tag, newStart, newEnd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSelectedAnnotations(List<AnnotationData> selectedAnnots) {
        Map<AnnotationData, HighlightData> map = this.blinkingTagsForAnnotations;
        synchronized (map) {
            this.blinkingHighlightsToAdd.clear();
            this.blinkingHighlightsToRemove.addAll(this.blinkingTagsForAnnotations.keySet());
            for (AnnotationData aData : selectedAnnots) {
                this.blinkingHighlightsToAdd.add(aData);
            }
            this.highlightsMinder.restart();
        }
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public void setTarget(Object target) {
        if (this.document != null) {
            this.document.removeDocumentListener(this.gateDocListener);
        }
        super.setTarget(target);
        this.document.addDocumentListener(this.gateDocListener);
    }

    public void setEditable(boolean editable) {
        this.textView.setEditable(editable);
    }

    @Override
    protected void initGUI() {
        this.textView = new JTextArea();
        this.textView.setAutoscrolls(false);
        this.textView.setLineWrap(true);
        this.textView.setWrapStyleWord(true);
        this.textView.setCaret(new PermanentSelectionCaret());
        this.scroller = new JScrollPane(this.textView);
        this.textView.setText(this.document.getContent().toString());
        this.textView.getDocument().addDocumentListener(this.swingDocListener);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (TextualDocumentView.this.textView.modelToView(0) != null) {
                        TextualDocumentView.this.textView.scrollRectToVisible(TextualDocumentView.this.textView.modelToView(0));
                    }
                    TextualDocumentView.this.textView.select(0, 0);
                    TextualDocumentView.this.textView.requestFocus();
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
        });
        this.highlightsMinder = new Timer(400, new UpdateHighlightsAction());
        this.highlightsMinder.setInitialDelay(100);
        this.highlightsMinder.setDelay(400);
        this.highlightsMinder.setRepeats(true);
        this.highlightsMinder.setCoalesce(true);
        this.highlightsMinder.start();
        this.initListeners();
    }

    @Override
    public Component getGUI() {
        return this.scroller;
    }

    protected void initListeners() {
        this.textView.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 72 && e.isControlDown()) {
                    TextualDocumentView.this.getGUI().dispatchEvent(e);
                    e.consume();
                }
            }
        });
    }

    @Override
    protected void unregisterHooks() {
    }

    @Override
    protected void registerHooks() {
    }

    public JTextArea getTextView() {
        return this.textView;
    }

    public class PermanentSelectionCaret
    extends DefaultCaret {
        private boolean isFocused;

        @Override
        public void setSelectionVisible(boolean hasFocus) {
            if (hasFocus != this.isFocused) {
                this.isFocused = hasFocus;
                super.setSelectionVisible(false);
                super.setSelectionVisible(true);
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            super.focusGained(e);
            super.setVisible(true);
        }
    }

    protected class SwingDocumentListener
    implements DocumentListener {
        protected SwingDocumentListener() {
        }

        @Override
        public void insertUpdate(javax.swing.event.DocumentEvent e) {
            try {
                TextualDocumentView.this.document.removeDocumentListener(TextualDocumentView.this.gateDocListener);
                TextualDocumentView.this.document.edit(new Long(e.getOffset()), new Long(e.getOffset()), new DocumentContentImpl(e.getDocument().getText(e.getOffset(), e.getLength())));
            }
            catch (BadLocationException ble) {
                ble.printStackTrace(Err.getPrintWriter());
            }
            catch (InvalidOffsetException ioe) {
                ioe.printStackTrace(Err.getPrintWriter());
            }
            finally {
                TextualDocumentView.this.document.addDocumentListener(TextualDocumentView.this.gateDocListener);
            }
        }

        @Override
        public void removeUpdate(javax.swing.event.DocumentEvent e) {
            try {
                TextualDocumentView.this.document.removeDocumentListener(TextualDocumentView.this.gateDocListener);
                TextualDocumentView.this.document.edit(new Long(e.getOffset()), new Long(e.getOffset() + e.getLength()), new DocumentContentImpl(""));
            }
            catch (InvalidOffsetException ioe) {
                ioe.printStackTrace(Err.getPrintWriter());
            }
            finally {
                TextualDocumentView.this.document.addDocumentListener(TextualDocumentView.this.gateDocListener);
            }
        }

        @Override
        public void changedUpdate(javax.swing.event.DocumentEvent e) {
        }
    }

    protected class GateDocumentListener
    implements gate.event.DocumentListener {
        protected GateDocumentListener() {
        }

        @Override
        public void annotationSetAdded(DocumentEvent e) {
        }

        @Override
        public void annotationSetRemoved(DocumentEvent e) {
        }

        @Override
        public void contentEdited(DocumentEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        TextualDocumentView.this.textView.getDocument().removeDocumentListener(TextualDocumentView.this.swingDocListener);
                        TextualDocumentView.this.textView.setText(TextualDocumentView.this.document.getContent().toString());
                    }
                    finally {
                        TextualDocumentView.this.textView.getDocument().addDocumentListener(TextualDocumentView.this.swingDocListener);
                    }
                }
            });
        }
    }

    public static class HighlightData {
        Annotation annotation;
        Color colour;
        Object tag;

        public HighlightData(AnnotationData aData, Color colour) {
            this.annotation = aData.getAnnotation();
            this.colour = colour;
        }
    }

    protected class UpdateHighlightsAction
    extends AbstractAction {
        protected boolean highlightsShown = false;

        protected UpdateHighlightsAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent evt) {
            Map<AnnotationData, HighlightData> map = TextualDocumentView.this.blinkingTagsForAnnotations;
            synchronized (map) {
                this.updateBlinkingHighlights();
                this.updateNormalHighlights();
            }
        }

        protected void updateBlinkingHighlights() {
            HighlightData annTag;
            Object tag;
            Highlighter highlighter = TextualDocumentView.this.textView.getHighlighter();
            for (AnnotationData aData : TextualDocumentView.this.blinkingHighlightsToRemove) {
                HighlightData annTag2 = TextualDocumentView.this.blinkingTagsForAnnotations.remove(aData);
                if (annTag2 == null || (tag = annTag2.tag) == null) continue;
                highlighter.removeHighlight(tag);
                annTag2.tag = null;
            }
            TextualDocumentView.this.blinkingHighlightsToRemove.clear();
            for (AnnotationData aData : TextualDocumentView.this.blinkingHighlightsToAdd) {
                TextualDocumentView.this.blinkingTagsForAnnotations.put(aData, new HighlightData(aData, null));
            }
            TextualDocumentView.this.blinkingHighlightsToAdd.clear();
            if (TextualDocumentView.this.blinkingTagsForAnnotations.isEmpty()) {
                return;
            }
            Iterator<AnnotationData> annIdIter = new ArrayList<AnnotationData>(TextualDocumentView.this.blinkingTagsForAnnotations.keySet()).iterator();
            if (this.highlightsShown) {
                while (annIdIter.hasNext()) {
                    annTag = TextualDocumentView.this.blinkingTagsForAnnotations.get(annIdIter.next());
                    if (annTag == null) continue;
                    Object tag2 = annTag.tag;
                    if (tag2 != null) {
                        highlighter.removeHighlight(tag2);
                    }
                    annTag.tag = null;
                }
                this.highlightsShown = false;
            } else {
                while (annIdIter.hasNext()) {
                    annTag = TextualDocumentView.this.blinkingTagsForAnnotations.get(annIdIter.next());
                    if (annTag == null) continue;
                    Annotation ann = annTag.annotation;
                    try {
                        annTag.tag = tag = highlighter.addHighlight(ann.getStartNode().getOffset().intValue(), ann.getEndNode().getOffset().intValue(), new DefaultHighlighter.DefaultHighlightPainter(TextualDocumentView.this.textView.getSelectionColor()));
                    }
                    catch (BadLocationException ble) {
                        throw new GateRuntimeException(ble);
                    }
                }
                this.highlightsShown = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateNormalHighlights() {
            TextualDocumentView textualDocumentView = TextualDocumentView.this;
            synchronized (textualDocumentView) {
                if (TextualDocumentView.this.highlightsToRemove.size() + TextualDocumentView.this.highlightsToAdd.size() > 0) {
                    HighlightData hData;
                    Highlighter highlighter = TextualDocumentView.this.textView.getHighlighter();
                    while (TextualDocumentView.this.highlightsToAdd.size() > 0) {
                        hData = TextualDocumentView.this.highlightsToAdd.remove(0);
                        try {
                            hData.tag = highlighter.addHighlight(hData.annotation.getStartNode().getOffset().intValue(), hData.annotation.getEndNode().getOffset().intValue(), new DefaultHighlighter.DefaultHighlightPainter(hData.colour));
                        }
                        catch (BadLocationException ble) {
                            ble.printStackTrace();
                        }
                    }
                    while (TextualDocumentView.this.highlightsToRemove.size() > 0) {
                        hData = TextualDocumentView.this.highlightsToRemove.remove(0);
                        if (hData.tag == null) continue;
                        highlighter.removeHighlight(hData.tag);
                    }
                }
            }
        }
    }
}

