/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.docview;

import gate.Document;
import gate.Factory;
import gate.Gate;
import gate.Resource;
import gate.creole.AbstractVisualResource;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.creole.metadata.CreoleResource;
import gate.creole.metadata.GuiType;
import gate.gui.ActionsPublisher;
import gate.gui.MainFrame;
import gate.gui.annedit.AnnotationData;
import gate.gui.annedit.SearchExpressionsAction;
import gate.gui.docview.AnnotationSetsView;
import gate.gui.docview.AnnotationStackView;
import gate.gui.docview.DocumentView;
import gate.gui.docview.TextualDocumentView;
import gate.swing.JMenuButton;
import gate.util.GateRuntimeException;
import gate.util.OptionsMap;
import gate.util.Strings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

@CreoleResource(name="Document Editor", guiType=GuiType.LARGE, resourceDisplayed="gate.Document", mainViewer=true)
public class DocumentEditor
extends AbstractVisualResource
implements ActionsPublisher {
    protected JSplitPane horizontalSplit;
    protected JSplitPane topSplit;
    protected JSplitPane bottomSplit;
    private SearchDialog searchDialog;
    protected Action searchAction;
    private List<AnnotationData> selectedAnnotations = new ArrayList<AnnotationData>();
    protected JToolBar topBar;
    protected Document document;
    protected List<DocumentView> centralViews;
    protected List<DocumentView> verticalViews;
    protected List<DocumentView> horizontalViews;
    protected int centralViewIdx = -1;
    protected int rightViewIdx = -1;
    protected int topViewIdx = -1;
    protected int bottomViewIdx = -1;
    protected boolean viewsInited = false;
    protected int fKeyNumber = 2;

    public void saveSettings() {
        DocumentEditor de = this;
        Gate.getUserConfig().put((Object)(DocumentEditor.class.getName() + ".centralViewIdx"), Strings.toString(de.centralViewIdx));
        Gate.getUserConfig().put((Object)(DocumentEditor.class.getName() + ".rightViewIdx"), Strings.toString(de.rightViewIdx));
        Gate.getUserConfig().put((Object)(DocumentEditor.class.getName() + ".bottomViewIdx"), Strings.toString(de.bottomViewIdx));
        Gate.getUserConfig().put((Object)(DocumentEditor.class.getName() + ".topViewIdx"), Strings.toString(de.topViewIdx));
        LinkedHashSet<String> setTypeSet = new LinkedHashSet<String>();
        DocumentView dv = de.getRightView();
        if (dv instanceof AnnotationSetsView) {
            AnnotationSetsView av = (AnnotationSetsView)dv;
            for (AnnotationSetsView.SetHandler sh : av.setHandlers) {
                for (AnnotationSetsView.TypeHandler th : sh.typeHandlers) {
                    if (!th.isSelected()) continue;
                    setTypeSet.add((sh.set.getName() == null ? "" : sh.set.getName()) + '.' + th.name);
                }
            }
        }
        Gate.getUserConfig().put((Object)(DocumentEditor.class.getName() + ".setTypeSet"), Strings.toString(setTypeSet));
        DocumentView bottomView = de.getBottomView();
        if (bottomView instanceof AnnotationStackView) {
            AnnotationStackView view = (AnnotationStackView)bottomView;
            Gate.getUserConfig().put((Object)(DocumentEditor.class.getName() + ".stackTypesFeatures"), Strings.toString(view.typesFeatures));
            Gate.getUserConfig().put((Object)(DocumentEditor.class.getName() + ".stackTargetSetName"), view.targetSetName);
        }
    }

    public void restoreSettings() {
        DocumentView bottomView;
        DocumentView dv;
        int topViewIdx;
        DocumentEditor de = this;
        Integer value = Gate.getUserConfig().getInt(DocumentEditor.class.getName() + ".centralViewIdx");
        int centralViewIdx = value == null ? 0 : value;
        value = Gate.getUserConfig().getInt(DocumentEditor.class.getName() + ".rightViewIdx");
        int rightViewIdx = value == null ? -1 : value;
        value = Gate.getUserConfig().getInt(DocumentEditor.class.getName() + ".bottomViewIdx");
        int bottomViewIdx = value == null ? -1 : value;
        value = Gate.getUserConfig().getInt(DocumentEditor.class.getName() + ".topViewIdx");
        int n = topViewIdx = value == null ? -1 : value;
        if (de.centralViewIdx != centralViewIdx && this.centralViews.size() > centralViewIdx) {
            de.setCentralView(centralViewIdx);
        }
        if (de.rightViewIdx != rightViewIdx && this.verticalViews.size() > rightViewIdx) {
            de.setRightView(rightViewIdx);
        }
        if (de.bottomViewIdx != bottomViewIdx && this.horizontalViews.size() > centralViewIdx) {
            de.setBottomView(bottomViewIdx);
        }
        if (de.topViewIdx != topViewIdx && this.horizontalViews.size() > centralViewIdx) {
            de.setTopView(topViewIdx);
        }
        if ((dv = de.getRightView()) instanceof AnnotationSetsView) {
            LinkedHashSet<String> setTypeSet = Gate.getUserConfig().getSet(DocumentEditor.class.getName() + ".setTypeSet");
            AnnotationSetsView av = (AnnotationSetsView)dv;
            for (AnnotationSetsView.SetHandler sh : av.setHandlers) {
                for (AnnotationSetsView.TypeHandler th : sh.typeHandlers) {
                    th.setSelected(false);
                    for (String setType : setTypeSet) {
                        String[] values = setType.split("\\.");
                        if (values.length != 2) continue;
                        String setName = values[0].equals("") ? null : values[0];
                        String typeName = values[1];
                        if (av.getSetHandler(setName) == null || av.getSetHandler(setName).getTypeHandler(typeName) == null) continue;
                        av.setTypeSelected(setName, typeName, true);
                    }
                }
            }
        }
        if ((bottomView = de.getBottomView()) instanceof AnnotationStackView) {
            AnnotationStackView view = (AnnotationStackView)bottomView;
            view.typesFeatures = Gate.getUserConfig().getMap(DocumentEditor.class.getName() + ".stackTypesFeatures");
            view.targetSetName = Gate.getUserConfig().getString(DocumentEditor.class.getName() + ".stackTargetSetName");
            view.targetSetLabel.setText("Target set: " + view.targetSetName);
        }
    }

    @Override
    public List<Action> getActions() {
        Iterator<DocumentView> viewIter;
        ArrayList<Action> actions = new ArrayList<Action>();
        if (this.getCentralViews() != null) {
            viewIter = this.getCentralViews().iterator();
            while (viewIter.hasNext()) {
                actions.addAll(viewIter.next().getActions());
            }
        }
        if (this.getHorizontalViews() != null) {
            viewIter = this.getHorizontalViews().iterator();
            while (viewIter.hasNext()) {
                actions.addAll(viewIter.next().getActions());
            }
        }
        if (this.getVerticalViews() != null) {
            viewIter = this.getVerticalViews().iterator();
            while (viewIter.hasNext()) {
                actions.addAll(viewIter.next().getActions());
            }
        }
        return actions;
    }

    @Override
    public Resource init() throws ResourceInstantiationException {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                if (!DocumentEditor.this.viewsInited) {
                    DocumentEditor.this.initViews();
                }
            }

            @Override
            public void componentShown(ComponentEvent e) {
                if (!DocumentEditor.this.viewsInited) {
                    DocumentEditor.this.initViews();
                }
            }
        });
        return this;
    }

    @Override
    public void cleanup() {
        Iterator<DocumentView> viewsIter;
        if (this.centralViews != null) {
            viewsIter = this.centralViews.iterator();
            while (viewsIter.hasNext()) {
                viewsIter.next().cleanup();
            }
            this.centralViews.clear();
        }
        if (this.horizontalViews != null) {
            viewsIter = this.horizontalViews.iterator();
            while (viewsIter.hasNext()) {
                viewsIter.next().cleanup();
            }
            this.horizontalViews.clear();
        }
        if (this.verticalViews != null) {
            viewsIter = this.verticalViews.iterator();
            while (viewsIter.hasNext()) {
                viewsIter.next().cleanup();
            }
            this.verticalViews.clear();
        }
    }

    protected void initViews() {
        this.viewsInited = true;
        this.setLayout(new BorderLayout());
        JProgressBar progressBar = new JProgressBar();
        progressBar.setStringPainted(true);
        progressBar.setMaximumSize(new Dimension(Integer.MAX_VALUE, progressBar.getPreferredSize().height));
        this.add((Component)progressBar, "Center");
        progressBar.setString("Building views");
        progressBar.setValue(10);
        this.topSplit = new JSplitPane(0, null, null);
        this.topSplit.setResizeWeight(0.3);
        this.topSplit.setContinuousLayout(true);
        this.topSplit.setOneTouchExpandable(true);
        this.bottomSplit = new JSplitPane(0, this.topSplit, null);
        this.bottomSplit.setResizeWeight(0.7);
        this.bottomSplit.setContinuousLayout(true);
        this.bottomSplit.setOneTouchExpandable(true);
        this.horizontalSplit = new JSplitPane(1, this.bottomSplit, null);
        this.horizontalSplit.setResizeWeight(0.7);
        this.horizontalSplit.setContinuousLayout(true);
        this.horizontalSplit.setOneTouchExpandable(true);
        this.topBar = new JToolBar(0);
        this.topBar.setFloatable(false);
        this.add((Component)this.topBar, "North");
        progressBar.setValue(40);
        this.centralViews = new ArrayList<DocumentView>();
        this.verticalViews = new ArrayList<DocumentView>();
        this.horizontalViews = new ArrayList<DocumentView>();
        Set<String> vrSet = Gate.getCreoleRegister().getVrTypes();
        ArrayList<ResourceData> viewTypes = new ArrayList<ResourceData>();
        for (String vr : vrSet) {
            ResourceData rData = (ResourceData)Gate.getCreoleRegister().get(vr);
            try {
                if (!DocumentView.class.isAssignableFrom(rData.getResourceClass())) continue;
                viewTypes.add(rData);
            }
            catch (ClassNotFoundException cnfe) {
                cnfe.printStackTrace();
            }
        }
        Collections.sort(viewTypes, new Comparator<ResourceData>(){

            @Override
            public int compare(ResourceData rd1, ResourceData rd2) {
                return rd1.getName().compareTo(rd2.getName());
            }
        });
        for (ResourceData viewType : viewTypes) {
            try {
                DocumentView aView = (DocumentView)Factory.createResource(viewType.getClassName());
                aView.setTarget(this.document);
                aView.setOwner(this);
                this.addView(aView, viewType.getName());
            }
            catch (ResourceInstantiationException rie) {
                rie.printStackTrace();
            }
        }
        if (this.centralViews.size() > 0) {
            this.setCentralView(0);
        }
        this.remove(progressBar);
        this.add((Component)this.horizontalSplit, "Center");
        this.searchAction = new SearchAction();
        JButton searchButton = new JButton(this.searchAction);
        searchButton.setMargin(new Insets(0, 0, 0, 0));
        this.topBar.add(Box.createHorizontalStrut(5));
        this.topBar.add(searchButton);
        this.getInputMap(1).put(KeyStroke.getKeyStroke("control F"), "Search in text");
        this.getActionMap().put("Search in text", this.searchAction);
        final OptionsMap config = Gate.getUserConfig();
        JPopupMenu optionsMenu = new JPopupMenu("Options menu");
        JMenuItem saveCurrentLayoutMenuItem = new JMenuItem(new AbstractAction("Save Current Layout"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentEditor.this.saveSettings();
            }
        });
        optionsMenu.add(saveCurrentLayoutMenuItem);
        final JCheckBoxMenuItem restoreLayoutAutomaticallyMenuItem = new JCheckBoxMenuItem("Restore Layout Automatically");
        restoreLayoutAutomaticallyMenuItem.setSelected(Gate.getUserConfig().getBoolean(DocumentEditor.class.getName() + ".restoreLayoutAutomatically"));
        restoreLayoutAutomaticallyMenuItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                config.put((Object)(DocumentEditor.class.getName() + ".restoreLayoutAutomatically"), (Object)restoreLayoutAutomaticallyMenuItem.isSelected());
            }
        });
        optionsMenu.add(restoreLayoutAutomaticallyMenuItem);
        final JCheckBoxMenuItem readOnly = new JCheckBoxMenuItem("Read-only");
        readOnly.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                config.put((Object)"docedit_read-only", (Object)readOnly.isSelected());
                DocumentEditor.this.setEditable(!readOnly.isSelected());
            }
        });
        readOnly.setSelected(config.getBoolean("docedit_read-only"));
        optionsMenu.addSeparator();
        optionsMenu.add(readOnly);
        final JCheckBoxMenuItem rightToLeftOrientation = new JCheckBoxMenuItem("Right To Left Orientation");
        rightToLeftOrientation.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                config.put((Object)"doc_r2l_orientation", (Object)rightToLeftOrientation.isSelected());
                DocumentEditor.this.setRightToLeftOrientation(rightToLeftOrientation.isSelected());
            }
        });
        optionsMenu.addSeparator();
        optionsMenu.add(rightToLeftOrientation);
        ButtonGroup buttonGroup = new ButtonGroup();
        final JRadioButtonMenuItem insertAppend = new JRadioButtonMenuItem("Insert Append");
        buttonGroup.add(insertAppend);
        insertAppend.setSelected(config.getBoolean("docedit_insert_append"));
        insertAppend.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                config.put((Object)"docedit_insert_append", (Object)insertAppend.isSelected());
            }
        });
        optionsMenu.addSeparator();
        optionsMenu.add(insertAppend);
        final JRadioButtonMenuItem insertPrepend = new JRadioButtonMenuItem("Insert Prepend");
        buttonGroup.add(insertPrepend);
        insertPrepend.setSelected(config.getBoolean("docedit_insert_prepend"));
        insertPrepend.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                config.put((Object)"docedit_insert_prepend", (Object)insertPrepend.isSelected());
            }
        });
        optionsMenu.add(insertPrepend);
        if (!insertAppend.isSelected() && !insertPrepend.isSelected()) {
            insertAppend.setSelected(true);
        }
        JMenuButton menuButton = new JMenuButton(optionsMenu);
        menuButton.setIcon(MainFrame.getIcon("expanded"));
        menuButton.setToolTipText("Options for the document editor");
        menuButton.setMargin(new Insets(0, 0, 0, 1));
        this.topBar.add(Box.createHorizontalGlue());
        this.topBar.add(menuButton);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (Gate.getUserConfig().getBoolean(DocumentEditor.class.getName() + ".restoreLayoutAutomatically").booleanValue()) {
                    DocumentEditor.this.restoreSettings();
                }
            }
        });
        this.validate();
    }

    public List<DocumentView> getCentralViews() {
        return this.centralViews == null ? null : Collections.unmodifiableList(this.centralViews);
    }

    public List<DocumentView> getHorizontalViews() {
        return this.horizontalViews == null ? null : Collections.unmodifiableList(this.horizontalViews);
    }

    public List<DocumentView> getVerticalViews() {
        return this.verticalViews == null ? null : Collections.unmodifiableList(this.verticalViews);
    }

    protected void addView(DocumentView view, String name) {
        this.topBar.add(Box.createHorizontalStrut(5));
        final ViewButton viewButton = new ViewButton(view, name);
        switch (view.getType()) {
            case 0: {
                this.centralViews.add(view);
                this.topBar.add(viewButton);
                break;
            }
            case 1: {
                this.verticalViews.add(view);
                this.topBar.add(viewButton);
                break;
            }
            case 2: {
                this.horizontalViews.add(view);
                this.topBar.add(viewButton);
                break;
            }
            default: {
                throw new GateRuntimeException(this.getClass().getName() + ": Invalid view type");
            }
        }
        if (this.fKeyNumber == 5 || this.fKeyNumber == 7 || this.fKeyNumber == 9) {
            ++this.fKeyNumber;
        }
        this.getInputMap(1).put(KeyStroke.getKeyStroke("F" + (this.fKeyNumber + 1)), "Shows view " + this.fKeyNumber + 1);
        this.getActionMap().put("Shows view " + this.fKeyNumber + 1, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                viewButton.doClick();
            }
        });
        if (view instanceof AnnotationSetsView) {
            this.getInputMap(1).put(KeyStroke.getKeyStroke("shift F" + (this.fKeyNumber + 1)), "Shows view " + this.fKeyNumber + 1);
            viewButton.setToolTipText("<html>Toggle the view of " + name + "&nbsp;&nbsp;<font color=#667799><small>F" + (this.fKeyNumber + 1) + "&nbsp;&nbsp;</small></font><br>Set last selected annotations &nbsp;&nbsp;<font color=#667799><small>Shift+F" + (this.fKeyNumber + 1) + "&nbsp;&nbsp;</small></font></html>");
        } else {
            viewButton.setToolTipText("<html>Toggle the view of " + name + "&nbsp;&nbsp;<font color=#667799><small>F" + (this.fKeyNumber + 1) + "&nbsp;&nbsp;</small></font></html>");
        }
        ++this.fKeyNumber;
    }

    protected DocumentView getTopView() {
        return this.topViewIdx == -1 ? null : this.horizontalViews.get(this.topViewIdx);
    }

    public void setTopView(int index) {
        DocumentView oldView = this.getTopView();
        if (oldView != null) {
            oldView.setActive(false);
        }
        this.topViewIdx = index;
        if (this.topViewIdx == -1) {
            this.setTopView(null);
        } else {
            DocumentView newView = this.horizontalViews.get(this.topViewIdx);
            if (this.bottomViewIdx == this.topViewIdx) {
                this.setBottomView(null);
                this.bottomViewIdx = -1;
            }
            if (!newView.isActive()) {
                newView.setActive(true);
            }
            this.setTopView(newView);
        }
    }

    protected void setTopView(DocumentView view) {
        this.topSplit.setTopComponent(view == null ? null : view.getGUI());
        this.topSplit.resetToPreferredSizes();
        this.updateBar(this.topBar);
        this.validate();
    }

    protected DocumentView getCentralView() {
        return this.centralViewIdx == -1 ? null : this.centralViews.get(this.centralViewIdx);
    }

    public void setCentralView(int index) {
        DocumentView oldView = this.getCentralView();
        if (oldView != null) {
            oldView.setActive(false);
        }
        this.centralViewIdx = index;
        if (this.centralViewIdx == -1) {
            this.setCentralView(null);
        } else {
            DocumentView newView = this.centralViews.get(this.centralViewIdx);
            if (!newView.isActive()) {
                newView.setActive(true);
            }
            this.setCentralView(newView);
        }
    }

    protected void setCentralView(DocumentView view) {
        this.topSplit.setBottomComponent(view == null ? null : view.getGUI());
        this.topSplit.resetToPreferredSizes();
        this.updateBar(this.topBar);
        this.validate();
    }

    protected DocumentView getBottomView() {
        return this.bottomViewIdx == -1 ? null : this.horizontalViews.get(this.bottomViewIdx);
    }

    public void setBottomView(int index) {
        DocumentView oldView = this.getBottomView();
        if (oldView != null) {
            oldView.setActive(false);
        }
        this.bottomViewIdx = index;
        if (this.bottomViewIdx == -1) {
            this.setBottomView(null);
        } else {
            DocumentView newView = this.horizontalViews.get(this.bottomViewIdx);
            if (this.topViewIdx == this.bottomViewIdx) {
                this.setTopView(null);
                this.topViewIdx = -1;
            }
            if (!newView.isActive()) {
                newView.setActive(true);
            }
            this.setBottomView(newView);
        }
    }

    protected void setBottomView(DocumentView view) {
        this.bottomSplit.setBottomComponent(view == null ? null : view.getGUI());
        this.bottomSplit.resetToPreferredSizes();
        this.updateBar(this.topBar);
        this.validate();
    }

    protected DocumentView getRightView() {
        return this.rightViewIdx == -1 ? null : this.verticalViews.get(this.rightViewIdx);
    }

    public void setRightView(int index) {
        DocumentView oldView = this.getRightView();
        if (oldView != null) {
            oldView.setActive(false);
        }
        this.rightViewIdx = index;
        if (this.rightViewIdx == -1) {
            this.setRightView(null);
        } else {
            DocumentView newView = this.verticalViews.get(this.rightViewIdx);
            if (!newView.isActive()) {
                newView.setActive(true);
            }
            this.setRightView(newView);
        }
    }

    protected void setRightView(DocumentView view) {
        this.horizontalSplit.setRightComponent(view == null ? null : view.getGUI());
        this.updateBar(this.topBar);
        this.validate();
    }

    public void setSelectedAnnotations(List<AnnotationData> selectedAnnots) {
        this.selectedAnnotations.clear();
        this.selectedAnnotations.addAll(selectedAnnots);
        for (DocumentView aView : this.centralViews) {
            if (!aView.isActive()) continue;
            aView.setSelectedAnnotations(this.selectedAnnotations);
        }
        for (DocumentView aView : this.horizontalViews) {
            if (!aView.isActive()) continue;
            aView.setSelectedAnnotations(this.selectedAnnotations);
        }
        for (DocumentView aView : this.verticalViews) {
            if (!aView.isActive()) continue;
            aView.setSelectedAnnotations(this.selectedAnnotations);
        }
    }

    public List<AnnotationData> getSelectedAnnotations() {
        return this.selectedAnnotations;
    }

    protected void updateSplitLocation(JSplitPane split, int foo) {
        Component left = split.getLeftComponent();
        Component right = split.getRightComponent();
        if (left == null) {
            split.setDividerLocation(0);
            return;
        }
        if (right == null) {
            split.setDividerLocation(1);
            return;
        }
        Dimension leftPS = left.getPreferredSize();
        Dimension rightPS = right.getPreferredSize();
        double location = split.getOrientation() == 1 ? (double)leftPS.width / (double)(leftPS.width + rightPS.width) : (double)leftPS.height / (double)(leftPS.height + rightPS.height);
        split.setDividerLocation(location);
    }

    @Override
    public void setTarget(Object target) {
        this.document = (Document)target;
    }

    protected void updateBar(JToolBar toolbar) {
        Component[] btns = toolbar.getComponents();
        if (btns != null) {
            for (Component btn : btns) {
                if (!(btn instanceof ViewButton)) continue;
                ((ViewButton)btn).updateSelected();
            }
        }
    }

    protected JTextComponent getTextComponent() {
        return (JTextComponent)((JScrollPane)this.getCentralView().getGUI()).getViewport().getView();
    }

    public void setEditable(boolean editable) {
        this.getTextComponent().setEditable(editable);
    }

    public void setRightToLeftOrientation(boolean set) {
        ComponentOrientation orientation = set ? ComponentOrientation.RIGHT_TO_LEFT : ComponentOrientation.LEFT_TO_RIGHT;
        for (DocumentView aView : this.centralViews) {
            if (!(aView instanceof TextualDocumentView)) continue;
            ((TextualDocumentView)aView).changeOrientation(orientation);
            break;
        }
        for (DocumentView aView : this.verticalViews) {
            if (!(aView instanceof AnnotationSetsView)) continue;
            ((AnnotationSetsView)aView).changeOrientation(orientation);
            break;
        }
    }

    protected class ViewButton
    extends JToggleButton {
        DocumentView view;
        boolean annotationSetsViewFirstTime = true;

        public ViewButton(DocumentView aView, String name) {
            this.setSelected(false);
            this.view = aView;
            this.setText(name);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (ViewButton.this.isSelected()) {
                        switch (ViewButton.this.view.getType()) {
                            case 0: {
                                DocumentEditor.this.setCentralView(DocumentEditor.this.centralViews.indexOf(ViewButton.this.view));
                                break;
                            }
                            case 1: {
                                DocumentEditor.this.setRightView(DocumentEditor.this.verticalViews.indexOf(ViewButton.this.view));
                                break;
                            }
                            case 2: {
                                DocumentEditor.this.setBottomView(DocumentEditor.this.horizontalViews.indexOf(ViewButton.this.view));
                            }
                        }
                        if (ViewButton.this.view instanceof AnnotationSetsView && ViewButton.this.annotationSetsViewFirstTime) {
                            ViewButton.this.annotationSetsViewFirstTime = false;
                            AnnotationSetsView asv = (AnnotationSetsView)ViewButton.this.view;
                            if (evt.getModifiers() == 1 || (long)evt.getModifiers() == 17L) {
                                asv.restoreSavedSelectedTypes();
                            } else {
                                asv.getSetHandler(null).setExpanded(true);
                                if (DocumentEditor.this.document.getAnnotationSetNames() != null) {
                                    for (String setName : DocumentEditor.this.document.getAnnotationSetNames()) {
                                        if (setName.equals("Original markups")) continue;
                                        asv.getSetHandler(setName).setExpanded(true);
                                    }
                                }
                            }
                            ViewButton.this.setToolTipText(ViewButton.this.getToolTipText().replaceFirst("<br>.*</html>$", "</html>"));
                        }
                    } else {
                        switch (ViewButton.this.view.getType()) {
                            case 0: {
                                DocumentEditor.this.setCentralView(-1);
                                break;
                            }
                            case 1: {
                                DocumentEditor.this.setRightView(-1);
                                break;
                            }
                            case 2: {
                                DocumentEditor.this.setBottomView(-1);
                            }
                        }
                    }
                    if (ViewButton.this.view instanceof TextualDocumentView) {
                        DocumentEditor.this.searchAction.setEnabled(ViewButton.this.isSelected());
                    }
                }
            });
        }

        public void updateSelected() {
            switch (this.view.getType()) {
                case 0: {
                    this.setSelected(DocumentEditor.this.getCentralView() == this.view);
                    break;
                }
                case 1: {
                    this.setSelected(DocumentEditor.this.getRightView() == this.view);
                    break;
                }
                case 2: {
                    this.setSelected(DocumentEditor.this.getBottomView() == this.view);
                }
            }
        }
    }

    protected class SearchDialog
    extends JDialog {
        JTextComponent textPane;
        JTextField patternTextField;
        JCheckBox ignoreCaseChk;
        JCheckBox wholeWordsChk;
        JCheckBox regularExpressionChk;
        JCheckBox highlightsChk;
        Pattern pattern;
        int nextMatchStartsFrom;
        Action findFirstAction;
        Action findNextAction;
        Action cancelAction;

        SearchDialog(Frame owner) {
            super(owner, false);
            this.textPane = DocumentEditor.this.getTextComponent();
            this.setTitle("Search in \"" + DocumentEditor.this.document.getName() + "\"");
            this.initLocalData();
            this.initGuiComponents();
            this.initListeners();
        }

        SearchDialog(Dialog owner) {
            super(owner, false);
            this.textPane = DocumentEditor.this.getTextComponent();
            this.setTitle("Search in \"" + DocumentEditor.this.document.getName() + "\"");
            this.initLocalData();
            this.initGuiComponents();
            this.initListeners();
        }

        protected void initLocalData() {
            this.pattern = null;
            this.nextMatchStartsFrom = 0;
            this.findFirstAction = new AbstractAction("Find first"){
                {
                    this.putValue("ShortDescription", "Finds first match");
                    this.putValue("MnemonicKey", 70);
                }

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String content = DocumentEditor.this.document.getContent().toString();
                    SearchDialog.this.refresh();
                    if (!SearchDialog.this.isValidRegularExpression()) {
                        return;
                    }
                    boolean found = false;
                    int start = -1;
                    int end = -1;
                    SearchDialog.this.nextMatchStartsFrom = 0;
                    Matcher matcher = SearchDialog.this.pattern.matcher(content);
                    while (matcher.find(SearchDialog.this.nextMatchStartsFrom) && !found) {
                        start = matcher.start();
                        end = matcher.end();
                        found = false;
                        if (SearchDialog.this.highlightsChk.isSelected()) {
                            Highlighter.Highlight[] highlights;
                            for (Highlighter.Highlight h : highlights = SearchDialog.this.textPane.getHighlighter().getHighlights()) {
                                if (h.getStartOffset() > start || h.getEndOffset() < end) continue;
                                found = true;
                                break;
                            }
                        } else {
                            found = true;
                        }
                        SearchDialog.this.nextMatchStartsFrom = end;
                    }
                    if (found) {
                        SearchDialog.this.setTitle("Found: \"" + content.substring(Math.max(0, start - 13), start).replaceAll("\\s+", " ") + "[" + content.substring(start, end).replaceAll("\\s+", " ") + "]" + content.substring(end, Math.min(content.length(), end + 13)).replaceAll("\\s+", " ") + "\"");
                        SearchDialog.this.textPane.setCaretPosition(start);
                        SearchDialog.this.textPane.moveCaretPosition(end);
                    } else {
                        SearchDialog.this.setTitle("Expression not found at all in the document.");
                        SearchDialog.this.findFirstAction.setEnabled(false);
                        SearchDialog.this.findNextAction.setEnabled(false);
                    }
                    SearchDialog.this.patternTextField.requestFocusInWindow();
                }
            };
            this.findNextAction = new AbstractAction("Find next"){
                {
                    this.putValue("ShortDescription", "Finds next match");
                    this.putValue("MnemonicKey", 78);
                }

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String content = DocumentEditor.this.document.getContent().toString();
                    SearchDialog.this.refresh();
                    if (!SearchDialog.this.isValidRegularExpression()) {
                        return;
                    }
                    boolean found = false;
                    int start = -1;
                    int end = -1;
                    SearchDialog.this.nextMatchStartsFrom = evt == null ? SearchDialog.this.textPane.getSelectionStart() : SearchDialog.this.textPane.getCaretPosition();
                    Matcher matcher = SearchDialog.this.pattern.matcher(content);
                    while (matcher.find(SearchDialog.this.nextMatchStartsFrom) && !found) {
                        start = matcher.start();
                        end = matcher.end();
                        found = false;
                        if (SearchDialog.this.highlightsChk.isSelected()) {
                            Highlighter.Highlight[] highlights;
                            for (Highlighter.Highlight h : highlights = SearchDialog.this.textPane.getHighlighter().getHighlights()) {
                                if (h.getStartOffset() > start || h.getEndOffset() < end) continue;
                                found = true;
                                break;
                            }
                        } else {
                            found = true;
                        }
                        SearchDialog.this.nextMatchStartsFrom = end;
                    }
                    if (found) {
                        SearchDialog.this.setTitle("Found: \"" + content.substring(Math.max(0, start - 13), start).replaceAll("\\s+", " ") + "[" + content.substring(start, end).replaceAll("\\s+", " ") + "]" + content.substring(end, Math.min(content.length(), end + 13)).replaceAll("\\s+", " ") + "\"");
                        SearchDialog.this.textPane.setCaretPosition(start);
                        SearchDialog.this.textPane.moveCaretPosition(end);
                    } else {
                        SearchDialog.this.setTitle("Expression not found after the document caret.");
                        SearchDialog.this.findNextAction.setEnabled(false);
                    }
                    SearchDialog.this.patternTextField.requestFocusInWindow();
                }
            };
            this.cancelAction = new AbstractAction("Cancel"){
                {
                    this.putValue("ShortDescription", "Cancel");
                }

                @Override
                public void actionPerformed(ActionEvent evt) {
                    DocumentEditor.this.searchDialog.setVisible(false);
                }
            };
        }

        protected void initGuiComponents() {
            this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
            this.getContentPane().add(Box.createVerticalStrut(5));
            Box hBox = Box.createHorizontalBox();
            hBox.add(Box.createHorizontalStrut(6));
            hBox.add(new JLabel("Find:"));
            hBox.add(Box.createHorizontalStrut(6));
            this.patternTextField = new JTextField(20);
            hBox.add(this.patternTextField);
            hBox.add(Box.createHorizontalStrut(3));
            JButton helpRegExpButton = new JButton("?");
            helpRegExpButton.setMargin(new Insets(0, 2, 0, 2));
            helpRegExpButton.setToolTipText("GATE search expression builder.");
            hBox.add(helpRegExpButton);
            hBox.add(Box.createHorizontalGlue());
            hBox.add(Box.createHorizontalStrut(6));
            hBox.add(Box.createHorizontalGlue());
            this.getContentPane().add(hBox);
            this.getContentPane().add(Box.createVerticalStrut(5));
            hBox = Box.createHorizontalBox();
            hBox.add(Box.createHorizontalStrut(6));
            this.ignoreCaseChk = new JCheckBox("Ignore case", true);
            hBox.add(this.ignoreCaseChk);
            hBox.add(Box.createHorizontalStrut(6));
            this.wholeWordsChk = new JCheckBox("Whole word", false);
            hBox.add(this.wholeWordsChk);
            hBox.add(Box.createHorizontalStrut(6));
            this.regularExpressionChk = new JCheckBox("Regular Exp.", false);
            hBox.add(this.regularExpressionChk);
            this.regularExpressionChk.setToolTipText("Regular expression search.");
            hBox.add(Box.createHorizontalStrut(6));
            this.highlightsChk = new JCheckBox("Highlights", false);
            hBox.add(this.highlightsChk);
            this.highlightsChk.setToolTipText("Restrict the search on the highlighted annotations.");
            hBox.add(Box.createHorizontalStrut(6));
            hBox.add(Box.createHorizontalGlue());
            this.getContentPane().add(hBox);
            this.getContentPane().add(Box.createVerticalStrut(5));
            hBox = Box.createHorizontalBox();
            hBox.add(Box.createHorizontalGlue());
            JButton findFirstButton = new JButton(this.findFirstAction);
            hBox.add(findFirstButton);
            hBox.add(Box.createHorizontalStrut(6));
            hBox.add(new JButton(this.findNextAction));
            hBox.add(Box.createHorizontalStrut(6));
            hBox.add(new JButton(this.cancelAction));
            hBox.add(Box.createHorizontalGlue());
            this.getContentPane().add(hBox);
            this.getContentPane().add(Box.createVerticalStrut(5));
            this.getRootPane().setDefaultButton(findFirstButton);
            helpRegExpButton.addActionListener(new SearchExpressionsAction(this.patternTextField, this, this.regularExpressionChk));
        }

        protected void initListeners() {
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent e) {
                    SearchDialog.this.refresh();
                }
            });
            this.patternTextField.getDocument().addDocumentListener(new DocumentListener(){
                private Timer timer = new Timer("Document Editor search timer", true);
                private TimerTask timerTask;

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.update();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.update();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    SearchDialog.this.refresh();
                }

                private void update() {
                    if (this.timerTask != null) {
                        this.timerTask.cancel();
                    }
                    SearchDialog.this.refresh();
                    Date timeToRun = new Date(System.currentTimeMillis() + 250L);
                    this.timerTask = new TimerTask(){

                        @Override
                        public void run() {
                            SearchDialog.this.findNextAction.actionPerformed(null);
                        }
                    };
                    this.timer.schedule(this.timerTask, timeToRun);
                }
            });
            this.wholeWordsChk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SearchDialog.this.refresh();
                }
            });
            this.ignoreCaseChk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SearchDialog.this.refresh();
                }
            });
            this.regularExpressionChk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SearchDialog.this.refresh();
                }
            });
            this.highlightsChk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SearchDialog.this.refresh();
                }
            });
            ((JComponent)this.getContentPane()).getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "cancelAction");
            ((JComponent)this.getContentPane()).getActionMap().put("cancelAction", this.cancelAction);
        }

        protected boolean isValidRegularExpression() {
            String patternText = this.patternTextField.getText();
            boolean valid = true;
            try {
                String prefixPattern = this.wholeWordsChk.isSelected() ? "\\b" : "";
                prefixPattern = prefixPattern + (this.regularExpressionChk.isSelected() ? "" : "\\Q");
                String suffixPattern = this.regularExpressionChk.isSelected() ? "" : "\\E";
                suffixPattern = suffixPattern + (this.wholeWordsChk.isSelected() ? "\\b" : "");
                patternText = prefixPattern + patternText + suffixPattern;
                this.pattern = this.ignoreCaseChk.isSelected() ? Pattern.compile(patternText, 2) : Pattern.compile(patternText);
            }
            catch (PatternSyntaxException e) {
                this.setTitle(e.getMessage().replaceFirst("(?s) near index .+$", "."));
                int index = e.getMessage().indexOf(" near index ");
                if (index != -1) {
                    this.patternTextField.setCaretPosition(Integer.parseInt(e.getMessage().substring(index += " near index ".length(), index + 1)));
                }
                this.patternTextField.requestFocusInWindow();
                valid = false;
            }
            return valid;
        }

        protected void refresh() {
            String patternText = this.patternTextField.getText();
            if (patternText != null && patternText.length() > 0) {
                this.findFirstAction.setEnabled(true);
                this.findNextAction.setEnabled(true);
            } else {
                this.findFirstAction.setEnabled(false);
                this.findNextAction.setEnabled(false);
            }
        }
    }

    protected class SearchAction
    extends AbstractAction {
        public SearchAction() {
            this.putValue("ShortDescription", "<html>Search within the document.&nbsp;&nbsp;<font color=#667799><small>Ctrl-F&nbsp;&nbsp;</small></font></html>");
            this.putValue("SmallIcon", MainFrame.getIcon("search"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (DocumentEditor.this.searchDialog == null) {
                Window parent = SwingUtilities.getWindowAncestor(DocumentEditor.this);
                DocumentEditor.this.searchDialog = parent instanceof Dialog ? new SearchDialog((Dialog)parent) : new SearchDialog((Frame)parent);
                DocumentEditor.this.searchDialog.pack();
                DocumentEditor.this.searchDialog.setLocationRelativeTo(DocumentEditor.this);
                DocumentEditor.this.searchDialog.setResizable(true);
                MainFrame.getGuiRoots().add(DocumentEditor.this.searchDialog);
            }
            JTextComponent textPane = DocumentEditor.this.getTextComponent();
            textPane.requestFocusInWindow();
            if (textPane.getSelectedText() != null) {
                ((DocumentEditor)DocumentEditor.this).searchDialog.patternTextField.setText(textPane.getSelectedText());
            }
            if (DocumentEditor.this.searchDialog.isVisible()) {
                DocumentEditor.this.searchDialog.toFront();
            } else {
                DocumentEditor.this.searchDialog.setVisible(true);
            }
            ((DocumentEditor)DocumentEditor.this).searchDialog.patternTextField.selectAll();
            ((DocumentEditor)DocumentEditor.this).searchDialog.patternTextField.requestFocusInWindow();
        }
    }
}

