/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TabHighlighter {
    JTabbedPane tPane;
    int tab;
    Color highlightColour;
    Color oldColour;

    public TabHighlighter(JTabbedPane pane, Component comp, Color highlightColour) {
        this.tPane = pane;
        this.tab = this.tPane.indexOfComponent(comp);
        this.highlightColour = highlightColour;
        this.tPane.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (TabHighlighter.this.tPane.getSelectedIndex() == TabHighlighter.this.tab) {
                    TabHighlighter.this.removeHighlight();
                }
            }
        });
        this.tPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (TabHighlighter.this.tPane.getSelectedIndex() == TabHighlighter.this.tab) {
                    TabHighlighter.this.removeHighlight();
                }
            }
        });
    }

    public void highlight() {
        if (this.tPane.getSelectedIndex() != this.tab) {
            if (this.tPane.getBackgroundAt(this.tab).equals(this.highlightColour)) {
                return;
            }
            this.oldColour = this.tPane.getBackgroundAt(this.tab);
            this.tPane.setBackgroundAt(this.tab, this.highlightColour);
        }
    }

    public void removeHighlight() {
        this.tPane.setBackgroundAt(this.tab, this.oldColour);
    }
}

