/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.ProcessingResource;
import gate.Resource;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.event.ProgressListener;
import gate.event.StatusListener;
import gate.gui.MainFrame;
import gate.gui.ResourceParametersEditor;
import gate.util.Err;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.text.NumberFormat;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;

public class NewResourceDialog
extends JDialog {
    JButton okBtn;
    JButton helpBtn;
    JButton cancelBtn;
    JTextField nameField;
    ResourceParametersEditor parametersEditor;
    JScrollPane tableScroll;
    ResourceData resourceData;
    Resource resource;
    boolean userCanceled;

    public NewResourceDialog(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        MainFrame.getGuiRoots().add(this);
        this.initLocalData();
        this.initGuiComponents();
        this.initListeners();
    }

    protected void initLocalData() {
    }

    protected void initGuiComponents() {
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        Box nameBox = Box.createHorizontalBox();
        nameBox.add(Box.createHorizontalStrut(5));
        nameBox.add(new JLabel("Name: "));
        nameBox.add(Box.createHorizontalStrut(5));
        this.nameField = new JTextField(30);
        this.nameField.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.nameField.getPreferredSize().height));
        this.nameField.setRequestFocusEnabled(true);
        this.nameField.selectAll();
        this.nameField.setVerifyInputWhenFocusTarget(false);
        nameBox.add(this.nameField);
        this.nameField.setToolTipText("Enter a name for the resource");
        nameBox.add(Box.createHorizontalStrut(5));
        nameBox.add(Box.createHorizontalGlue());
        this.getContentPane().add(nameBox);
        this.getContentPane().add(Box.createVerticalStrut(5));
        this.parametersEditor = new ResourceParametersEditor();
        this.tableScroll = new JScrollPane(this.parametersEditor);
        this.getContentPane().add(this.tableScroll);
        this.getContentPane().add(Box.createVerticalStrut(5));
        this.getContentPane().add(Box.createVerticalGlue());
        JPanel buttonsBox = new JPanel();
        buttonsBox.setLayout(new BoxLayout(buttonsBox, 0));
        buttonsBox.add(Box.createHorizontalStrut(10));
        this.okBtn = new JButton("OK");
        buttonsBox.add(this.okBtn);
        buttonsBox.add(Box.createHorizontalStrut(10));
        this.cancelBtn = new JButton("Cancel");
        buttonsBox.add(this.cancelBtn);
        buttonsBox.add(Box.createHorizontalStrut(10));
        this.helpBtn = new JButton("Help");
        buttonsBox.add(this.helpBtn);
        buttonsBox.add(Box.createHorizontalStrut(10));
        this.getContentPane().add(buttonsBox);
        this.getContentPane().add(Box.createVerticalStrut(5));
        this.setSize(400, 300);
        this.getRootPane().setDefaultButton(this.okBtn);
    }

    protected void initListeners() {
        AbstractAction applyAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewResourceDialog.this.userCanceled = false;
                TableCellEditor cellEditor = NewResourceDialog.this.parametersEditor.getCellEditor();
                if (cellEditor != null) {
                    cellEditor.stopCellEditing();
                }
                NewResourceDialog.this.setVisible(false);
            }
        };
        AbstractAction helpAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.getInstance().showHelpFrame(NewResourceDialog.this.resourceData.getHelpURL(), NewResourceDialog.this.resourceData.getClassName());
            }
        };
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewResourceDialog.this.userCanceled = true;
                NewResourceDialog.this.setVisible(false);
            }
        };
        this.okBtn.addActionListener(applyAction);
        this.helpBtn.addActionListener(helpAction);
        this.cancelBtn.addActionListener(cancelAction);
        InputMap im = this.parametersEditor.getInputMap(1);
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        im.put(enter, "none");
        InputMap inputMap = ((JComponent)this.getContentPane()).getInputMap(2);
        ActionMap actionMap = ((JComponent)this.getContentPane()).getActionMap();
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), "Apply");
        actionMap.put("Apply", applyAction);
        inputMap.put(KeyStroke.getKeyStroke("F1"), "Help");
        actionMap.put("Help", helpAction);
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), "Cancel");
        actionMap.put("Cancel", cancelAction);
    }

    public synchronized boolean show(ResourceData rData, String aTitle) {
        this.resourceData = rData;
        if (aTitle != null) {
            this.setTitle(aTitle);
        }
        this.parametersEditor.init(null, rData.getParameterList().getInitimeParameters());
        this.pack();
        this.nameField.requestFocusInWindow();
        this.userCanceled = true;
        this.setModal(true);
        this.setLocationRelativeTo(this.getOwner());
        super.setVisible(true);
        this.dispose();
        return !this.userCanceled;
    }

    public FeatureMap getSelectedParameters() {
        if (this.parametersEditor != null) {
            return this.parametersEditor.getParameterValues();
        }
        return null;
    }

    public String getResourceName() {
        return this.nameField.getText();
    }

    public synchronized void show(ResourceData rData) {
        if (rData != null) {
            this.resourceData = rData;
            String name = "";
            try {
                if (ProcessingResource.class.isAssignableFrom(rData.getResourceClass())) {
                    name = rData.getName() + " " + Gate.genSym();
                }
            }
            catch (ClassNotFoundException e) {
                Err.getPrintWriter().println("Couldn't load input resource class when showing dialogue.");
            }
            this.nameField.setText(name);
            this.parametersEditor.init(null, rData, rData.getParameterList().getInitimeParameters());
            this.pack();
            this.setLocationRelativeTo(this.getOwner());
        }
        this.userCanceled = true;
        this.setVisible(true);
        if (this.userCanceled) {
            this.dispose();
            return;
        }
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            public void run() {
                block20: {
                    block17: {
                        ProgressListener pListener;
                        FeatureMap params = NewResourceDialog.this.parametersEditor.getParameterValues();
                        StatusListener sListener = (StatusListener)Gate.getListeners().get("gate.event.StatusListener");
                        if (sListener != null) {
                            sListener.statusChanged("Loading " + NewResourceDialog.this.nameField.getText() + "...");
                        }
                        if ((pListener = (ProgressListener)Gate.getListeners().get("gate.event.ProgressListener")) != null) {
                            pListener.progressChanged(0);
                        }
                        boolean success = true;
                        try {
                            long startTime = System.currentTimeMillis();
                            FeatureMap features = Factory.newFeatureMap();
                            String name = NewResourceDialog.this.nameField.getText();
                            if (name == null || name.length() == 0) {
                                name = null;
                            }
                            Factory.createResource(NewResourceDialog.this.resourceData.getClassName(), params, features, name);
                            long endTime = System.currentTimeMillis();
                            if (sListener != null) {
                                sListener.statusChanged(NewResourceDialog.this.nameField.getText() + " loaded in " + NumberFormat.getInstance().format((double)(endTime - startTime) / 1000.0) + " seconds");
                            }
                            if (pListener != null) {
                                pListener.processFinished();
                            }
                            if (success) break block17;
                        }
                        catch (ResourceInstantiationException rie) {
                            block18: {
                                success = false;
                                JOptionPane.showMessageDialog(NewResourceDialog.this.getOwner(), "Resource could not be created!\n" + rie.toString(), "GATE", 0);
                                rie.printStackTrace(Err.getPrintWriter());
                                if (sListener != null) {
                                    sListener.statusChanged("Error loading " + NewResourceDialog.this.nameField.getText() + "!");
                                }
                                if (pListener != null) {
                                    pListener.processFinished();
                                }
                                if (success) break block18;
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        NewResourceDialog.this.show(null);
                                    }
                                });
                            }
                            NewResourceDialog.this.dispose();
                        }
                        catch (Throwable thr) {
                            block19: {
                                success = false;
                                JOptionPane.showMessageDialog(NewResourceDialog.this.getOwner(), "Unhandled error!\n" + thr.toString(), "GATE", 0);
                                thr.printStackTrace(Err.getPrintWriter());
                                if (sListener != null) {
                                    sListener.statusChanged("Error loading " + NewResourceDialog.this.nameField.getText() + "!");
                                }
                                if (pListener != null) {
                                    pListener.processFinished();
                                }
                                if (success) break block19;
                                {
                                    catch (Throwable throwable) {
                                        if (!success) {
                                            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                        } else {
                                            NewResourceDialog.this.dispose();
                                        }
                                        throw throwable;
                                    }
                                }
                                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                            }
                            NewResourceDialog.this.dispose();
                        }
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        break block20;
                    }
                    NewResourceDialog.this.dispose();
                }
            }
        };
        Thread thread = new Thread(runnable, "");
        thread.setPriority(1);
        thread.start();
    }

    @Override
    public void dispose() {
        this.resourceData = null;
    }
}

