/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Controller;
import gate.Gate;
import gate.Resource;
import gate.creole.AbstractVisualResource;
import gate.creole.ResourceInstantiationException;
import gate.creole.ResourceReference;
import gate.creole.metadata.CreoleResource;
import gate.creole.metadata.GuiType;
import gate.gui.MainFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.io.StringReader;
import java.net.URI;
import java.net.URL;
import java.util.List;
import javax.swing.JScrollPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.cyberneko.html.HTMLConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xhtmlrenderer.simple.XHTMLPanel;
import org.xhtmlrenderer.swing.BasicPanel;
import org.xhtmlrenderer.swing.FSMouseListener;
import org.xhtmlrenderer.swing.LinkListener;
import org.xhtmlrenderer.util.Configuration;
import org.xml.sax.InputSource;

@CreoleResource(name="About...", guiType=GuiType.LARGE, resourceDisplayed="gate.Controller")
public class ControllerMetadataViewer
extends AbstractVisualResource {
    private static final long serialVersionUID = -1161421403987238291L;
    private XHTMLPanel display = new XHTMLPanel();
    private DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
    private DocumentBuilder builder = null;

    @Override
    public Resource init() throws ResourceInstantiationException {
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane((Component)this.display), "Center");
        try {
            this.builder = this.builderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ResourceInstantiationException("Unable to construct an XML parser", e);
        }
        if (Configuration.isTrue((String)"xr.use.listeners", (boolean)true)) {
            List l = this.display.getMouseTrackingListeners();
            for (FSMouseListener listener : l) {
                if (!(listener instanceof LinkListener)) continue;
                this.display.removeMouseTrackingListener(listener);
            }
            this.display.addMouseTrackingListener((FSMouseListener)new LinkListener(){

                public void linkClicked(BasicPanel panel, String uri) {
                    MainFrame.getInstance().showHelpFrame(uri, null);
                }
            });
        }
        return this;
    }

    @Override
    public void setTarget(Object target) {
        if (target == null) {
            throw new NullPointerException("received a null target");
        }
        if (!(target instanceof Controller)) {
            throw new IllegalArgumentException("not a controller");
        }
        Controller controller = (Controller)target;
        if (!controller.getFeatures().containsKey("gate.app.MetadataURL")) {
            throw new IllegalArgumentException("no gate.app.MetadataURL feature");
        }
        try {
            Object ref = controller.getFeatures().get("gate.app.MetadataURL");
            URL metadata = ref instanceof ResourceReference ? ((ResourceReference)ref).toURL() : (ref instanceof String ? new ResourceReference(new URI((String)ref)).toURL() : (URL)ref);
            URL longDesc = new URL(metadata, "long-desc.html");
            URL iconDesc = new URL(metadata, "icon.png");
            Document document = this.builder.parse(metadata.openStream());
            Node text = document.getDocumentElement().getElementsByTagName("pipeline-name").item(0).getFirstChild();
            Font font = Gate.getUserConfig().getFont("Text_components_font");
            StringBuilder page = new StringBuilder();
            page.append("<!DOCTYPE html>");
            page.append("<html>");
            page.append("<head>");
            page.append("<style type='text/css'>body { font-family: ").append(font.getFamily()).append("; font-size: ").append(font.getSize()).append("pt }</style>");
            page.append("</head>");
            page.append("<body>");
            page.append("<h1><img style='vertical-align: middle;' src='").append(StringEscapeUtils.escapeHtml((String)iconDesc.toString())).append("'/> ").append(StringEscapeUtils.escapeHtml((String)text.getTextContent())).append("</h1>");
            page.append(IOUtils.toString((URL)longDesc, (String)"UTF-8"));
            page.append("</body></html>");
            HTMLConfiguration config = new HTMLConfiguration();
            config.setProperty("http://cyberneko.org/html/properties/names/elems", (Object)"lower");
            DOMParser htmlParser = new DOMParser((XMLParserConfiguration)config);
            htmlParser.parse(new InputSource(new StringReader(page.toString())));
            this.display.setDocument(htmlParser.getDocument(), longDesc.toString());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }
}

