/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

public class CollectionSelectionDialog
extends JDialog {
    DefaultListModel sourceListModel = null;
    DefaultListModel targetListModel = null;
    int buttonPressed = 1;
    JButton removeButton = null;
    JButton addButton = null;
    JList sourceList = null;
    JList targetList = null;
    JButton okButton = null;
    JButton cancelButton = null;
    JLabel sourceLabel = null;
    JLabel targetLabel = null;
    Frame mainFrame = null;

    public CollectionSelectionDialog(Frame aFrame, boolean aModal) {
        super(aFrame, aModal);
        this.setLocationRelativeTo(aFrame);
        this.mainFrame = aFrame;
    }

    public CollectionSelectionDialog() {
        this((Frame)null, true);
    }

    protected void initLocalData(Collection aSourceData) {
        this.targetListModel = new DefaultListModel();
        this.sourceListModel = new DefaultListModel();
        if (aSourceData == null) {
            return;
        }
        ArrayList source = new ArrayList(aSourceData);
        Collections.sort(source);
        Iterator iter = source.iterator();
        while (iter.hasNext()) {
            this.sourceListModel.addElement(iter.next());
        }
    }

    protected void initGuiComponents() {
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.sourceLabel = new JLabel("Source");
        this.sourceLabel.setAlignmentX(0.0f);
        this.sourceList = new JList(this.sourceListModel);
        this.sourceList.setSelectionMode(2);
        this.sourceList.setVisibleRowCount(10);
        this.sourceList.setAlignmentX(0.0f);
        this.targetLabel = new JLabel("Target");
        this.targetLabel.setAlignmentX(0.0f);
        this.targetList = new JList(this.targetListModel);
        this.targetList.setSelectionMode(2);
        this.targetList.setVisibleRowCount(10);
        this.targetList.setAlignmentX(0.0f);
        this.targetList.setPreferredSize(this.sourceList.getPreferredSize());
        this.addButton = new JButton(">>>");
        this.removeButton = new JButton("<<<");
        this.okButton = new JButton("Ok");
        this.cancelButton = new JButton("Cancel");
        Box componentsBox = Box.createVerticalBox();
        componentsBox.add(Box.createRigidArea(new Dimension(0, 5)));
        Box firstLevelBox = Box.createHorizontalBox();
        firstLevelBox.add(Box.createRigidArea(new Dimension(10, 0)));
        Box currentBox = Box.createVerticalBox();
        currentBox.add(this.sourceLabel);
        currentBox.add(new JScrollPane(this.sourceList));
        firstLevelBox.add(currentBox);
        firstLevelBox.add(Box.createRigidArea(new Dimension(10, 0)));
        currentBox = Box.createVerticalBox();
        currentBox.add(this.addButton);
        currentBox.add(Box.createRigidArea(new Dimension(0, 10)));
        currentBox.add(this.removeButton);
        firstLevelBox.add(currentBox);
        firstLevelBox.add(Box.createRigidArea(new Dimension(10, 0)));
        currentBox = Box.createVerticalBox();
        currentBox.add(this.targetLabel);
        currentBox.add(new JScrollPane(this.targetList));
        firstLevelBox.add(currentBox);
        firstLevelBox.add(Box.createRigidArea(new Dimension(20, 0)));
        currentBox = Box.createHorizontalBox();
        currentBox.add(Box.createHorizontalGlue());
        currentBox.add(this.okButton);
        currentBox.add(Box.createRigidArea(new Dimension(25, 0)));
        currentBox.add(this.cancelButton);
        currentBox.add(Box.createHorizontalGlue());
        componentsBox.add(firstLevelBox);
        componentsBox.add(Box.createRigidArea(new Dimension(0, 10)));
        componentsBox.add(currentBox);
        componentsBox.add(Box.createRigidArea(new Dimension(0, 5)));
        this.getContentPane().add(componentsBox);
        this.pack();
    }

    protected void initListeners() {
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CollectionSelectionDialog.this.doOk();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CollectionSelectionDialog.this.doCancel();
            }
        });
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CollectionSelectionDialog.this.doAdd();
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CollectionSelectionDialog.this.doRemove();
            }
        });
    }

    private void doOk() {
        this.buttonPressed = 0;
        this.setVisible(false);
    }

    private void doCancel() {
        this.buttonPressed = 1;
        this.setVisible(false);
    }

    private void doRemove() {
        Object[] selectedItems = this.targetList.getSelectedValues();
        for (int i = 0; i < selectedItems.length; ++i) {
            this.sourceListModel.addElement(selectedItems[i]);
            this.targetListModel.removeElement(selectedItems[i]);
        }
    }

    private void doAdd() {
        Object[] selectedItems = this.sourceList.getSelectedValues();
        for (int i = 0; i < selectedItems.length; ++i) {
            this.targetListModel.addElement(selectedItems[i]);
            this.sourceListModel.removeElement(selectedItems[i]);
        }
    }

    public Collection getSelectedCollection() {
        ArrayList resultsList = new ArrayList();
        for (int i = 0; i < this.targetListModel.getSize(); ++i) {
            resultsList.add(this.targetListModel.getElementAt(i));
        }
        return resultsList;
    }

    public int show(String aTitle, Collection aSourceData) {
        if (aTitle == null) {
            JOptionPane.showMessageDialog(this.mainFrame, "Feature selection dialog coud not been created because title was null!", "GATE", 0);
            return this.buttonPressed;
        }
        if (aSourceData == null) {
            JOptionPane.showMessageDialog(this.mainFrame, "Feature selection dialog coud not been created because data source null!", "GATE", 0);
            return this.buttonPressed;
        }
        this.setTitle(aTitle);
        this.initLocalData(aSourceData);
        this.initGuiComponents();
        this.initListeners();
        super.setVisible(true);
        return this.buttonPressed;
    }
}

