/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import java.awt.Component;
import java.util.EventObject;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;

public class AlternatingTableCellEditor
implements TableCellEditor {
    private TableCellEditor[] editors;
    private int currentEditor = 0;

    public AlternatingTableCellEditor(TableCellEditor ... editors) {
        this.editors = editors;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.currentEditor = (this.currentEditor + 1) % this.editors.length;
        return this.editors[this.currentEditor].getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    @Override
    public Object getCellEditorValue() {
        return this.editors[this.currentEditor].getCellEditorValue();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return this.editors[this.currentEditor].isCellEditable(anEvent);
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return this.editors[this.currentEditor].shouldSelectCell(anEvent);
    }

    @Override
    public boolean stopCellEditing() {
        return this.editors[this.currentEditor].stopCellEditing();
    }

    @Override
    public void cancelCellEditing() {
        this.editors[this.currentEditor].cancelCellEditing();
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        for (TableCellEditor e : this.editors) {
            e.addCellEditorListener(l);
        }
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        for (TableCellEditor e : this.editors) {
            e.removeCellEditorListener(l);
        }
    }
}

