/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.lucene;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import gate.Corpus;
import gate.Document;
import gate.Factory;
import gate.creole.annic.IndexException;
import gate.creole.annic.Indexer;
import gate.creole.annic.apache.lucene.analysis.Analyzer;
import gate.creole.annic.apache.lucene.index.IndexReader;
import gate.creole.annic.apache.lucene.index.IndexWriter;
import gate.creole.annic.apache.lucene.index.Term;
import gate.creole.annic.apache.lucene.search.Hits;
import gate.creole.annic.apache.lucene.search.IndexSearcher;
import gate.creole.annic.apache.lucene.search.TermQuery;
import gate.creole.annic.lucene.LuceneAnalyzer;
import gate.creole.annic.lucene.LuceneDocument;
import gate.util.Files;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;

public class LuceneIndexer
implements Indexer {
    protected boolean DEBUG = false;
    protected Corpus corpus;
    protected Map<String, Object> parameters;

    public LuceneIndexer(URL indexLocationUrl) throws IOException {
        if (indexLocationUrl != null) {
            this.readParametersFromDisk(indexLocationUrl);
        }
    }

    protected void checkIndexParameters(Map<String, Object> parameters) throws IndexException {
        this.parameters = parameters;
        if (parameters == null) {
            throw new IndexException("No parameters provided!");
        }
        URL indexLocation = (URL)parameters.get("INDEX_LOCATION_URL");
        if (indexLocation == null) {
            throw new IndexException("You must provide a URL for INDEX_LOCATION");
        }
        if (!indexLocation.getProtocol().equalsIgnoreCase("file")) {
            throw new IndexException("Index Output Directory must be set to the empty directory on the file system");
        }
        File file = null;
        try {
            file = new File(indexLocation.toURI());
        }
        catch (URISyntaxException use) {
            file = Files.fileFromURL(indexLocation);
        }
        if (file.exists() && !file.isDirectory()) {
            throw new IndexException("Path doesn't exist");
        }
        String baseTokenAnnotationType = (String)parameters.get("BASE_TOKEN_ANNOTATION_TYPE");
        if (baseTokenAnnotationType == null || baseTokenAnnotationType.trim().length() == 0) {
            baseTokenAnnotationType = "Token";
            parameters.put("BASE_TOKEN_ANNOTATION_TYPE", "Token");
        } else if (baseTokenAnnotationType.indexOf(".") > -1 || baseTokenAnnotationType.indexOf("=") > -1 || baseTokenAnnotationType.indexOf(";") > -1 || baseTokenAnnotationType.indexOf(",") > -1) {
            throw new IndexException("Base token annotation type cannot have '.' , '=', ',' or ';; in it");
        }
        String indexUnitAnnotationType = (String)parameters.get("INDEX_UNIT_ANNOTATION_TYPE");
        if (this.DEBUG) {
            System.out.println("BTAT : " + baseTokenAnnotationType);
            System.out.println("IUAT : " + indexUnitAnnotationType);
        }
    }

    protected Map<String, Object> getIndexParameters() {
        return this.parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createIndex(Map<String, Object> indexParameters) throws IndexException {
        this.checkIndexParameters(indexParameters);
        URL indexLocation = (URL)this.parameters.get("INDEX_LOCATION_URL");
        try {
            File file = null;
            try {
                file = new File(indexLocation.toURI());
            }
            catch (URISyntaxException use) {
                file = Files.fileFromURL(indexLocation);
            }
            try (IndexWriter writer = new IndexWriter(file.getAbsolutePath(), (Analyzer)new LuceneAnalyzer(), true);){
                if (this.corpus != null) {
                    for (int i = 0; i < this.corpus.size(); ++i) {
                        Document gateDoc = (Document)this.corpus.get(i);
                        String idToUse = gateDoc.getLRPersistenceId() == null ? gateDoc.getName() : gateDoc.getLRPersistenceId().toString();
                        System.out.print("Indexing : " + idToUse + " ...");
                        String corpusName = this.corpus.getLRPersistenceId() == null ? this.corpus.getName() : this.corpus.getLRPersistenceId().toString();
                        List<gate.creole.annic.apache.lucene.document.Document> luceneDocs = this.getLuceneDocuments(corpusName, gateDoc, indexLocation.toString());
                        if (luceneDocs != null) {
                            for (int j = 0; j < luceneDocs.size(); ++j) {
                                if (luceneDocs.get(j) == null) continue;
                                writer.addDocument(luceneDocs.get(j));
                            }
                        }
                        if (gateDoc.getLRPersistenceId() != null) {
                            Factory.deleteResource(gateDoc);
                        }
                        System.out.println("Done");
                    }
                }
            }
            this.writeParametersToDisk();
        }
        catch (IOException ioe) {
            throw new IndexException(ioe);
        }
    }

    @Override
    public void optimizeIndex() throws IndexException {
        try {
            String location = ((URL)this.parameters.get("INDEX_LOCATION_URL")).toString();
            try (IndexWriter writer = new IndexWriter(location, (Analyzer)new LuceneAnalyzer(), false);){
                writer.optimize();
            }
        }
        catch (IOException ioe) {
            throw new IndexException(ioe);
        }
    }

    @Override
    public void deleteIndex() throws IndexException {
        if (this.parameters == null) {
            return;
        }
        File dir = null;
        try {
            dir = new File(((URL)this.parameters.get("INDEX_LOCATION_URL")).toURI());
        }
        catch (URISyntaxException use) {
            dir = new File(((URL)this.parameters.get("INDEX_LOCATION_URL")).getFile());
        }
        if (!FileUtils.deleteQuietly((File)dir)) {
            throw new IndexException("Can't delete directory" + dir.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(String corpusPersistenceID, List<Document> added) throws IndexException {
        String location = null;
        try {
            location = new File(((URL)this.parameters.get("INDEX_LOCATION_URL")).toURI()).getAbsolutePath();
        }
        catch (URISyntaxException use) {
            location = new File(((URL)this.parameters.get("INDEX_LOCATION_URL")).getFile()).getAbsolutePath();
        }
        try (IndexWriter writer = new IndexWriter(location, (Analyzer)new LuceneAnalyzer(), false);){
            if (added != null) {
                for (int i = 0; i < added.size(); ++i) {
                    Document gateDoc = added.get(i);
                    String idToUse = gateDoc.getLRPersistenceId() == null ? gateDoc.getName() : gateDoc.getLRPersistenceId().toString();
                    System.out.print("Indexing : " + idToUse + " ...");
                    List<gate.creole.annic.apache.lucene.document.Document> docs = this.getLuceneDocuments(corpusPersistenceID, gateDoc, location);
                    if (docs == null) {
                        System.out.println("Done");
                        continue;
                    }
                    for (int j = 0; j < docs.size(); ++j) {
                        writer.addDocument(docs.get(j));
                    }
                    System.out.println("Done");
                }
            }
        }
        catch (IOException ioe) {
            throw new IndexException(ioe);
        }
    }

    private String getCompatibleName(String name) {
        return name.replaceAll("[\\/:\\*\\?\"<>|]", "_");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(List<Object> removedIDs) throws IndexException {
        String location = null;
        try {
            location = new File(((URL)this.parameters.get("INDEX_LOCATION_URL")).toURI()).getAbsolutePath();
        }
        catch (URISyntaxException use) {
            location = new File(((URL)this.parameters.get("INDEX_LOCATION_URL")).getFile()).getAbsolutePath();
        }
        try (IndexReader reader = IndexReader.open(location);){
            if (removedIDs != null) {
                for (int i = 0; i < removedIDs.size(); ++i) {
                    String id = removedIDs.get(i).toString();
                    Set<String> serializedFilesIDs = this.getNamesOfSerializedFiles(id);
                    if (serializedFilesIDs.size() <= 0) continue;
                    System.out.print("Removing => " + id + "...");
                    id = this.getCompatibleName(id);
                    File file = new File(location, "serialized-files");
                    file = new File(file, id);
                    for (String serializedFileID : serializedFilesIDs) {
                        Term term = new Term("DOCUMENT_ID_FOR_SERIALIZED_FILE", serializedFileID);
                        reader.delete(term);
                        File toDelete = new File(file, (serializedFileID = this.getCompatibleName(serializedFileID)) + ".annic");
                        if (!toDelete.exists()) continue;
                        toDelete.delete();
                    }
                    if (file.exists() && file.isDirectory()) {
                        file.delete();
                    }
                    System.out.println("Done ");
                }
            }
        }
        catch (IOException ioe) {
            throw new IndexException(ioe);
        }
    }

    private List<gate.creole.annic.apache.lucene.document.Document> getLuceneDocuments(String corpusPersistenceID, Document gateDoc, String location) throws IndexException {
        String baseTokenAnnotationType = (String)this.parameters.get("BASE_TOKEN_ANNOTATION_TYPE");
        String indexUnitAnnotationType = (String)this.parameters.get("INDEX_UNIT_ANNOTATION_TYPE");
        ArrayList<String> featuresToExclude = new ArrayList<String>((List)this.parameters.get("FEATURES_TO_EXCLUDE"));
        ArrayList<String> featuresToInclude = new ArrayList<String>((List)this.parameters.get("FEATURES_TO_INCLUDE"));
        ArrayList<String> annotationSetsToExclude = new ArrayList<String>((List)this.parameters.get("ANNOTATION_SETS_NAMES_TO_EXCLUDE"));
        ArrayList<String> annotationSetsToInclude = new ArrayList<String>((List)this.parameters.get("ANNOTATION_SETS_NAMES_TO_INCLUDE"));
        Boolean createTokensAutomatically = (Boolean)this.parameters.get("CREATE_TOKENS_AUTOMATICALLY");
        if (createTokensAutomatically == null) {
            createTokensAutomatically = Boolean.TRUE;
        }
        String idToUse = gateDoc.getLRPersistenceId() == null ? gateDoc.getName() : gateDoc.getLRPersistenceId().toString();
        return new LuceneDocument().createDocuments(corpusPersistenceID, gateDoc, idToUse, annotationSetsToInclude, annotationSetsToExclude, featuresToInclude, featuresToExclude, location, baseTokenAnnotationType, createTokensAutomatically, indexUnitAnnotationType);
    }

    @Override
    public Corpus getCorpus() {
        return this.corpus;
    }

    @Override
    public void setCorpus(Corpus corpus) throws IndexException {
        this.corpus = corpus;
        if (corpus == null) {
            throw new IndexException("Corpus is not initialized");
        }
        corpus.getFeatures().put("CorpusIndexFeature", "AnnicIR");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readParametersFromDisk(URL indexLocationUrl) throws IOException {
        File file = null;
        try {
            file = new File(new File(indexLocationUrl.toURI()), "LuceneIndexDefinition.xml");
        }
        catch (URISyntaxException use) {
            file = new File(indexLocationUrl.getFile(), "LuceneIndexDefinition.xml");
        }
        if (!file.exists()) {
            return;
        }
        try (FileReader fileReader = new FileReader(file);){
            XStream xstream = new XStream((HierarchicalStreamDriver)new StaxDriver());
            this.parameters = (Map)xstream.fromXML((Reader)fileReader);
            this.parameters.put("INDEX_LOCATION_URL", indexLocationUrl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeParametersToDisk() throws IOException {
        URL location = (URL)this.parameters.get("INDEX_LOCATION_URL");
        File file = null;
        try {
            file = new File(new File(location.toURI()), "LuceneIndexDefinition.xml");
        }
        catch (URISyntaxException use) {
            file = new File(location.getFile(), "LuceneIndexDefinition.xml");
        }
        FileWriter fileWriter = new FileWriter(file);
        HashMap<String, Object> indexInformation = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
            String key = entry.getKey();
            if (key.equals("INDEX_LOCATION_URL")) continue;
            indexInformation.put(key, entry.getValue());
        }
        indexInformation.put("CorpusIndexFeature", "AnnicIR");
        if (this.corpus != null) {
            indexInformation.put("CORPUS_SIZE", this.corpus.getDocumentNames().size());
        }
        XStream xstream = new XStream();
        try {
            xstream.toXML(indexInformation, (Writer)fileWriter);
        }
        finally {
            fileWriter.close();
        }
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getNamesOfSerializedFiles(String documentID) throws IndexException {
        HashSet<String> hashSet;
        String location = null;
        try {
            location = new File(((URL)this.parameters.get("INDEX_LOCATION_URL")).toURI()).getAbsolutePath();
        }
        catch (URISyntaxException use) {
            location = new File(((URL)this.parameters.get("INDEX_LOCATION_URL")).getFile()).getAbsolutePath();
        }
        HashSet<String> toReturn = new HashSet<String>();
        Term term = new Term("DOCUMENT_ID", documentID);
        TermQuery tq = new TermQuery(term);
        IndexSearcher searcher = new IndexSearcher(location);
        try {
            Hits luceneHits = searcher.search(tq);
            for (int i = 0; i < luceneHits.length(); ++i) {
                gate.creole.annic.apache.lucene.document.Document luceneDoc = luceneHits.doc(i);
                String documentIdOfSerializedFile = luceneDoc.get("DOCUMENT_ID_FOR_SERIALIZED_FILE");
                toReturn.add(documentIdOfSerializedFile);
            }
            hashSet = toReturn;
        }
        catch (Throwable throwable) {
            try {
                searcher.close();
                throw throwable;
            }
            catch (IOException ioe) {
                throw new IndexException(ioe);
            }
        }
        searcher.close();
        return hashSet;
    }
}

