/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.search;

import gate.creole.annic.apache.lucene.index.Term;
import gate.creole.annic.apache.lucene.index.TermDocs;
import gate.creole.annic.apache.lucene.search.Explanation;
import gate.creole.annic.apache.lucene.search.IndexSearcher;
import gate.creole.annic.apache.lucene.search.Scorer;
import gate.creole.annic.apache.lucene.search.Searcher;
import gate.creole.annic.apache.lucene.search.Similarity;
import gate.creole.annic.apache.lucene.search.TermQuery;
import gate.creole.annic.apache.lucene.search.Weight;
import java.io.IOException;
import java.util.ArrayList;

final class TermScorer
extends Scorer {
    private Weight weight;
    private TermDocs termDocs;
    private byte[] norms;
    private float weightValue;
    private int doc;
    private Term term;
    private final int[] docs = new int[32];
    private final int[] freqs = new int[32];
    private int pointer;
    private int pointerMax;
    private static final int SCORE_CACHE_SIZE = 32;
    private float[] scoreCache = new float[32];

    TermScorer(Weight weight, TermDocs td, Similarity similarity, byte[] norms, Term term) throws IOException {
        super(similarity);
        this.weight = weight;
        this.termDocs = td;
        this.norms = norms;
        this.weightValue = weight.getValue();
        this.term = term;
        for (int i = 0; i < 32; ++i) {
            this.scoreCache[i] = this.getSimilarity().tf(i) * this.weightValue;
        }
    }

    @Override
    public int doc() {
        return this.doc;
    }

    @Override
    public boolean next(Searcher searcher) throws IOException {
        this.searcher = searcher;
        ++this.pointer;
        if (this.pointer >= this.pointerMax) {
            this.pointerMax = this.termDocs.read(this.docs, this.freqs);
            if (this.pointerMax != 0) {
                this.pointer = 0;
            } else {
                this.termDocs.close();
                this.doc = Integer.MAX_VALUE;
                return false;
            }
        }
        this.doc = this.docs[this.pointer];
        return true;
    }

    @Override
    public float score(Searcher searcher) throws IOException {
        this.searcher = searcher;
        int f = this.freqs[this.pointer];
        float raw = f < 32 ? this.scoreCache[f] : this.getSimilarity().tf(f) * this.weightValue;
        float score = raw * Similarity.decodeNorm(this.norms[this.doc]);
        if (score > 0.0f && this.term.type() != null && this.searcher instanceof IndexSearcher) {
            ArrayList<String> termInfo = new ArrayList<String>();
            termInfo.add(this.term.text());
            termInfo.add(this.term.type());
            ((IndexSearcher)this.searcher).setFirstTermPositions(0, this.doc(), termInfo, 1, f);
        }
        return score;
    }

    @Override
    public boolean skipTo(int target) throws IOException {
        ++this.pointer;
        while (this.pointer < this.pointerMax) {
            if (target <= this.docs[this.pointer]) {
                this.doc = this.docs[this.pointer];
                return true;
            }
            ++this.pointer;
        }
        boolean result = this.termDocs.skipTo(target);
        if (result) {
            this.pointerMax = 1;
            this.pointer = 0;
            this.docs[this.pointer] = this.doc = this.termDocs.doc();
            this.freqs[this.pointer] = this.termDocs.freq();
        } else {
            this.doc = Integer.MAX_VALUE;
        }
        return result;
    }

    @Override
    public Explanation explain(int doc) throws IOException {
        TermQuery query = (TermQuery)this.weight.getQuery();
        Explanation tfExplanation = new Explanation();
        int tf = 0;
        while (this.pointer < this.pointerMax) {
            if (this.docs[this.pointer] == doc) {
                tf = this.freqs[this.pointer];
            }
            ++this.pointer;
        }
        if (tf == 0) {
            while (this.termDocs.next()) {
                if (this.termDocs.doc() != doc) continue;
                tf = this.termDocs.freq();
            }
        }
        this.termDocs.close();
        tfExplanation.setValue(this.getSimilarity().tf(tf));
        tfExplanation.setDescription("tf(termFreq(" + query.getTerm() + ")=" + tf + ")");
        return tfExplanation;
    }

    public String toString() {
        return "scorer(" + this.weight + ")";
    }
}

