/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.search;

import gate.creole.annic.apache.lucene.search.Explanation;
import gate.creole.annic.apache.lucene.search.Scorer;
import gate.creole.annic.apache.lucene.search.Searcher;
import gate.creole.annic.apache.lucene.search.Similarity;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;

final class ConjunctionScorer
extends Scorer {
    private LinkedList scorers = new LinkedList();
    private boolean firstTime = true;
    private boolean more = true;
    private float coord;

    public ConjunctionScorer(Similarity similarity) {
        super(similarity);
    }

    final void add(Scorer scorer) throws IOException {
        this.scorers.addLast(scorer);
    }

    private Scorer first() {
        return (Scorer)this.scorers.getFirst();
    }

    private Scorer last() {
        return (Scorer)this.scorers.getLast();
    }

    @Override
    public int doc() {
        return this.first().doc();
    }

    @Override
    public boolean next(Searcher searcher) throws IOException {
        this.searcher = searcher;
        if (this.firstTime) {
            this.init();
        } else if (this.more) {
            this.more = this.last().next(this.searcher);
        }
        return this.doNext();
    }

    private boolean doNext() throws IOException {
        while (this.more && this.first().doc() < this.last().doc()) {
            this.more = this.first().skipTo(this.last().doc());
            this.scorers.addLast(this.scorers.removeFirst());
        }
        return this.more;
    }

    @Override
    public boolean skipTo(int target) throws IOException {
        Iterator i = this.scorers.iterator();
        while (this.more && i.hasNext()) {
            this.more = ((Scorer)i.next()).skipTo(target);
        }
        if (this.more) {
            this.sortScorers();
        }
        return this.doNext();
    }

    @Override
    public float score(Searcher searcher) throws IOException {
        this.searcher = searcher;
        float score = 0.0f;
        Iterator i = this.scorers.iterator();
        while (i.hasNext()) {
            score += ((Scorer)i.next()).score(this.searcher);
        }
        return score *= this.coord;
    }

    private void init() throws IOException {
        this.more = this.scorers.size() > 0;
        this.coord = this.getSimilarity().coord(this.scorers.size(), this.scorers.size());
        Iterator i = this.scorers.iterator();
        while (this.more && i.hasNext()) {
            this.more = ((Scorer)i.next()).next(this.searcher);
        }
        if (this.more) {
            this.sortScorers();
        }
        this.firstTime = false;
    }

    private void sortScorers() throws IOException {
        Scorer[] array = this.scorers.toArray(new Scorer[this.scorers.size()]);
        this.scorers.clear();
        Arrays.sort(array, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Scorer)o1).doc() - ((Scorer)o2).doc();
            }

            public boolean equals(Object o1, Object o2) {
                return ((Scorer)o1).doc() == ((Scorer)o2).doc();
            }
        });
        for (int i = 0; i < array.length; ++i) {
            this.scorers.addLast(array[i]);
        }
    }

    @Override
    public Explanation explain(int doc) throws IOException {
        throw new UnsupportedOperationException();
    }
}

