/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.index;

import gate.creole.annic.apache.lucene.index.IndexReader;
import gate.creole.annic.apache.lucene.index.Term;
import gate.creole.annic.apache.lucene.index.TermEnum;
import gate.creole.annic.apache.lucene.index.TermPositions;
import java.io.IOException;

final class SegmentMergeInfo {
    Term term;
    int base;
    TermEnum termEnum;
    IndexReader reader;
    TermPositions postings;
    int[] docMap = null;

    SegmentMergeInfo(int b, TermEnum te, IndexReader r) throws IOException {
        this.base = b;
        this.reader = r;
        this.termEnum = te;
        this.term = te.term();
        this.postings = this.reader.termPositions();
        if (this.reader.hasDeletions()) {
            int maxDoc = this.reader.maxDoc();
            this.docMap = new int[maxDoc];
            int j = 0;
            for (int i = 0; i < maxDoc; ++i) {
                this.docMap[i] = this.reader.isDeleted(i) ? -1 : j++;
            }
        }
    }

    final boolean next() throws IOException {
        if (this.termEnum.next()) {
            this.term = this.termEnum.term();
            return true;
        }
        this.term = null;
        return false;
    }

    final void close() throws IOException {
        this.termEnum.close();
        this.postings.close();
    }
}

