/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FeatureSchema
implements Serializable {
    private static final long serialVersionUID = 2705192644986091866L;
    String featureName = null;
    Class<?> featureValueClass = null;
    String featureValue = null;
    String featureUse = null;
    Set<Object> featurePermissibleValuesSet = null;

    public FeatureSchema(String aFeatureName, Class<?> aFeatureValueClass, String aFeatureValue, String aFeatureUse, Set<? extends Object> aFeaturePermissibleValuesSet) {
        this.featureName = aFeatureName;
        this.featureValueClass = aFeatureValueClass;
        this.featureValue = aFeatureValue;
        this.featureUse = aFeatureUse;
        this.featurePermissibleValuesSet = aFeaturePermissibleValuesSet;
    }

    public boolean isEnumeration() {
        return this.featurePermissibleValuesSet != null;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public Class<?> getFeatureValueClass() {
        return this.featureValueClass;
    }

    public Set<Object> getPermittedValues() {
        return this.featurePermissibleValuesSet;
    }

    public boolean setPermissibleValues(Set<? extends Object> aPermisibleValuesSet) {
        this.featurePermissibleValuesSet.clear();
        return this.featurePermissibleValuesSet.addAll(aPermisibleValuesSet);
    }

    public boolean addPermissibleValue(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().getName().equals(this.featureValueClass.getName())) {
            return false;
        }
        if (this.featurePermissibleValuesSet == null) {
            this.featurePermissibleValuesSet = new HashSet<Object>();
        }
        return this.featurePermissibleValuesSet.add(obj);
    }

    public String toXSchema(Map<Class<?>, String> aJava2XSchemaMap) {
        StringBuffer schemaString = new StringBuffer();
        schemaString.append("   <attribute name=\"" + this.featureName + "\" ");
        schemaString.append("use=\"" + this.featureUse + "\"");
        if (!this.isEnumeration()) {
            schemaString.append(" type=\"" + aJava2XSchemaMap.get(this.featureValueClass) + "\"/>\n");
        } else {
            schemaString.append(">\n    <simpleType>\n");
            schemaString.append("     <restriction base=\"" + aJava2XSchemaMap.get(this.featureValueClass) + "\">\n");
            Iterator<Object> featurePermissibleValuesSetIterator = this.featurePermissibleValuesSet.iterator();
            while (featurePermissibleValuesSetIterator.hasNext()) {
                String featurePermissibleValue = featurePermissibleValuesSetIterator.next().toString();
                schemaString.append("      <enumeration value=\"" + featurePermissibleValue + "\"/>\n");
            }
            schemaString.append("     </restriction>\n");
            schemaString.append("    </simpleType>\n");
            schemaString.append("   </attribute>\n");
        }
        return schemaString.toString();
    }

    public String getFeatureValue() {
        if (this.isDefault() || this.isFixed()) {
            return this.featureValue;
        }
        return "";
    }

    public String getRawFeatureValue() {
        return this.featureValue;
    }

    public void setFeatureValue(String aFeatureValue) {
        this.featureValue = aFeatureValue;
    }

    public boolean isRequired() {
        return "required".equals(this.featureUse);
    }

    public boolean isDefault() {
        return "default".equals(this.featureUse);
    }

    public boolean isFixed() {
        return "fixed".equals(this.featureUse);
    }

    public boolean isOptional() {
        return "optional".equals(this.featureUse);
    }

    public boolean isProhibited() {
        return "prohibited".equals(this.featureUse);
    }
}

