/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import gate.CreoleRegister;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.creole.Parameter;
import gate.creole.ParameterList;
import gate.creole.Plugin;
import gate.creole.ResourceData;
import gate.util.GateRuntimeException;
import gate.util.GateSaxException;
import gate.util.Strings;
import gate.xml.SimpleErrorHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.SortedMap;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class CreoleXmlHandler
extends DefaultHandler {
    private Stack<String> contentStack = new Stack();
    private ResourceData resourceData;
    private ParameterList currentParamList = new ParameterList();
    private SortedMap<Integer, List<Parameter>> currentParamDisjunction = new TreeMap<Integer, List<Parameter>>();
    private Parameter currentParam;
    private Attributes currentAttributes;
    private static final boolean DEBUG = false;
    private Plugin plugin;
    private SimpleErrorHandler _seh = new SimpleErrorHandler();
    private FeatureMap currentAutoinstanceParams = null;
    private List<FeatureMap> currentAutoinstances = null;
    private StringBuffer contentBuffer = new StringBuffer("");
    private boolean readCharacterStatus = false;
    private CreoleRegister register;

    public CreoleXmlHandler(CreoleRegister register, Plugin plugin) {
        this.register = register;
        this.plugin = plugin;
        this.currentParam = new Parameter(plugin);
    }

    @Override
    public void startDocument() throws GateSaxException {
    }

    @Override
    public void endDocument() throws GateSaxException {
        if (!this.contentStack.isEmpty()) {
            StringBuffer errorMessage = new StringBuffer("document ended but element stack not empty:");
            while (!this.contentStack.isEmpty()) {
                errorMessage.append(Strings.getNl() + "  " + this.contentStack.pop());
            }
            throw new GateSaxException(errorMessage.toString());
        }
    }

    private String attributes2String(Attributes atts) {
        StringBuffer strBuf = new StringBuffer("");
        if (atts == null) {
            return strBuf.toString();
        }
        for (int i = 0; i < atts.getLength(); ++i) {
            String attName = atts.getQName(i);
            String attValue = atts.getValue(i);
            strBuf.append(" ");
            strBuf.append(attName);
            strBuf.append("=");
            strBuf.append(attValue);
        }
        return strBuf.toString();
    }

    @Override
    public void startElement(String uri, String qName, String elementName, Attributes atts) throws SAXException {
        String typeValue;
        if (this.readCharacterStatus) {
            this.readCharacterStatus = false;
            this.charactersAction(new String(this.contentBuffer).toCharArray(), 0, this.contentBuffer.length());
        }
        if (elementName.toUpperCase().equals("RESOURCE")) {
            this.resourceData = new ResourceData();
            this.resourceData.setPlugin(this.plugin);
            this.resourceData.setFeatures(Factory.newFeatureMap());
            this.currentAutoinstances = new ArrayList<FeatureMap>();
        }
        this.currentAttributes = atts;
        if (elementName.toUpperCase().equals("AUTOINSTANCE")) {
            this.currentAutoinstanceParams = Factory.newFeatureMap();
        }
        if (elementName.toUpperCase().equals("HIDDEN-AUTOINSTANCE")) {
            this.currentAutoinstanceParams = Factory.newFeatureMap();
            Gate.setHiddenAttribute(this.currentAutoinstanceParams, true);
        }
        if (elementName.toUpperCase().equals("PARAM")) {
            if (this.currentAutoinstanceParams == null) {
                this.currentAutoinstanceParams = Factory.newFeatureMap();
            }
            String paramName = this.currentAttributes.getValue("NAME");
            String paramStrValue = this.currentAttributes.getValue("VALUE");
            if (paramName == null) {
                throw new GateRuntimeException("Found in creole.xml a PARAM element for resource " + this.resourceData.getClassName() + " without a NAME attribute. Check the file and try again.");
            }
            if (paramStrValue == null) {
                throw new GateRuntimeException("Found in creole.xml a PARAM element for resource " + this.resourceData.getClassName() + " without a VALUE attribute. Check the file and try again.");
            }
            this.currentAutoinstanceParams.put(paramName, paramStrValue);
        }
        if (elementName.toUpperCase().equals("PARAMETER")) {
            this.currentParam.comment = this.currentAttributes.getValue("COMMENT");
            this.currentParam.helpURL = this.currentAttributes.getValue("HELPURL");
            this.currentParam.defaultValueString = this.currentAttributes.getValue("DEFAULT");
            this.currentParam.optional = Boolean.valueOf(this.currentAttributes.getValue("OPTIONAL"));
            this.currentParam.name = this.currentAttributes.getValue("NAME");
            this.currentParam.runtime = Boolean.valueOf(this.currentAttributes.getValue("RUNTIME"));
            this.currentParam.itemClassName = this.currentAttributes.getValue("ITEM_CLASS_NAME");
            String suffixes = this.currentAttributes.getValue("SUFFIXES");
            HashSet<String> suffiexesSet = null;
            if (suffixes != null) {
                suffiexesSet = new HashSet<String>();
                StringTokenizer strTokenizer = new StringTokenizer(suffixes, ";");
                while (strTokenizer.hasMoreTokens()) {
                    suffiexesSet.add(strTokenizer.nextToken());
                }
            }
            this.currentParam.suffixes = suffiexesSet;
        } else if (elementName.toUpperCase().equals("GUI") && (typeValue = this.currentAttributes.getValue("TYPE")) != null) {
            if (typeValue.toUpperCase().equals("LARGE")) {
                this.resourceData.setGuiType(1);
            }
            if (typeValue.toUpperCase().equals("SMALL")) {
                this.resourceData.setGuiType(2);
            }
        }
        if (elementName.toUpperCase().equals("OR") && !this.currentParamDisjunction.isEmpty()) {
            this.currentParamList.addAll(this.currentFlattenedDisjunction());
            this.currentParamDisjunction.clear();
        }
    }

    private void checkStack(String methodName, String elementName) throws GateSaxException {
        if (this.contentStack.isEmpty()) {
            throw new GateSaxException(methodName + " called for element " + elementName + " with empty stack");
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void endElement(String uri, String qName, String elementName) throws GateSaxException, SAXException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void characters(char[] text, int start, int length) throws SAXException {
        if (!this.readCharacterStatus) {
            this.contentBuffer = new StringBuffer(new String(text, start, length));
        } else {
            this.contentBuffer.append(new String(text, start, length));
        }
        this.readCharacterStatus = true;
    }

    public void charactersAction(char[] text, int start, int length) throws SAXException {
        String content = new String(text, start, length).trim();
        if (content.length() == 0) {
            return;
        }
        this.contentStack.push(content);
    }

    protected List<Parameter> currentFlattenedDisjunction() {
        ArrayList<Parameter> listToReturn = new ArrayList<Parameter>();
        for (List<Parameter> l : this.currentParamDisjunction.values()) {
            listToReturn.addAll(l);
        }
        return listToReturn;
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void error(SAXParseException ex) throws SAXException {
        this._seh.error(ex);
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXException {
        this._seh.fatalError(ex);
    }

    @Override
    public void warning(SAXParseException ex) throws SAXException {
        this._seh.warning(ex);
    }
}

