/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import gate.Gate;
import gate.Resource;
import gate.creole.Plugin;
import gate.creole.metadata.AutoInstance;
import gate.creole.metadata.AutoInstanceParam;
import gate.creole.metadata.CreoleParameter;
import gate.creole.metadata.CreoleResource;
import gate.creole.metadata.GuiType;
import gate.creole.metadata.HiddenCreoleParameter;
import gate.creole.metadata.Optional;
import gate.creole.metadata.RunTime;
import gate.util.GateClassLoader;
import gate.util.GateException;
import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;

public class CreoleAnnotationHandler {
    private static final Logger log = Logger.getLogger(CreoleAnnotationHandler.class);
    private Plugin plugin;

    public CreoleAnnotationHandler(Plugin plugin) {
        this.plugin = plugin;
    }

    public void addJarsToClassLoader(GateClassLoader gcl, Document jdomDoc) throws IOException {
        try {
            XPath jarXPath = XPath.newInstance((String)"//*[translate(local-name(), 'ivy', 'IVY') = 'IVY']");
            if (jarXPath.selectNodes((Object)jdomDoc).size() > 0) {
                throw new IOException("Using Ivy for dependency management is no longer supported");
            }
        }
        catch (JDOMException e) {
            throw new IOException("Unable to load plugin", e);
        }
        this.addJarsToClassLoader(gcl, jdomDoc.getRootElement());
    }

    @Deprecated
    public void loadRequiredPlugins(Document jdomDoc) throws IOException {
        try {
            XPath jarXPath = XPath.newInstance((String)"//*[translate(local-name(), 'requires', 'REQUIRES') = 'REQUIRES']");
            List requires = jarXPath.selectNodes((Object)jdomDoc);
            String relativePathMarker = "$relpath$";
            String gatehomePathMarker = "$gatehome$";
            String gatepluginsPathMarker = "$gateplugins$";
            for (Element required : requires) {
                URL url = null;
                String urlString = required.getTextTrim();
                if (urlString.startsWith(relativePathMarker)) {
                    url = new URL(this.plugin.getBaseURL(), urlString.substring(relativePathMarker.length()));
                } else if (urlString.startsWith(gatehomePathMarker)) {
                    URL gatehome = Gate.getGateHome().toURI().toURL();
                    url = new URL(gatehome, urlString.substring(gatehomePathMarker.length()));
                } else if (urlString.startsWith(gatepluginsPathMarker)) {
                    URL gateplugins = Gate.getPluginsHome().toURI().toURL();
                    url = new URL(gateplugins, urlString.substring(gatepluginsPathMarker.length()));
                } else {
                    url = new URL(this.plugin.getBaseURL(), urlString);
                }
                Gate.getCreoleRegister().registerPlugin(new Plugin.Directory(url));
            }
        }
        catch (GateException | JDOMException e) {
            throw new IOException("Unable to load required plugin", e);
        }
    }

    private void addJarsToClassLoader(GateClassLoader gcl, Element jdomElt) throws MalformedURLException {
        if ("JAR".equals(jdomElt.getName())) {
            URL url = new URL(this.plugin.getBaseURL(), jdomElt.getTextTrim());
            try {
                InputStream s = url.openStream();
                s.close();
                gcl.addURL(url);
            }
            catch (IOException e) {
                log.debug((Object)("Unable to add JAR " + url + " specified in creole file  to class loader, hopefully the required classes are already on the classpath."));
            }
        } else {
            for (Element child : jdomElt.getChildren()) {
                this.addJarsToClassLoader(gcl, child);
            }
        }
    }

    public void createResourceElementsForDirInfo(Document jdomDoc) throws MalformedURLException {
        Element jdomElt = jdomDoc.getRootElement();
        HashMap<String, Element> resourceElements = new HashMap<String, Element>();
        this.findResourceElements(resourceElements, jdomElt);
        for (Gate.ResourceInfo resInfo : this.plugin.getResourceInfoList()) {
            if (resourceElements.containsKey(resInfo.getResourceClassName())) continue;
            jdomElt.addContent((Content)new Element("RESOURCE").addContent((Content)new Element("CLASS").setText(resInfo.getResourceClassName())));
        }
    }

    private void findResourceElements(Map<String, Element> map, Element elt) {
        if (elt.getName().equals("RESOURCE")) {
            String className = elt.getChildTextTrim("CLASS");
            if (className != null) {
                map.put(className, elt);
            }
        } else {
            for (Element child : elt.getChildren()) {
                this.findResourceElements(map, child);
            }
        }
    }

    public void processAnnotations(Document jdomDoc) throws GateException {
        this.processAnnotations(jdomDoc.getRootElement());
    }

    private void processAnnotations(Element element) throws GateException {
        if ("RESOURCE".equals(element.getName())) {
            this.processAnnotationsForResource(element);
        } else {
            for (Element child : element.getChildren()) {
                this.processAnnotations(child);
            }
        }
    }

    private void processAnnotationsForResource(Element element) throws GateException {
        String className = element.getChildTextTrim("CLASS");
        if (className == null) {
            throw new GateException("\"CLASS\" element not found for resource in " + this.plugin);
        }
        Class<?> resourceClass = null;
        try {
            resourceClass = Gate.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            log.debug((Object)("Couldn't load class " + className + " for resource in " + this.plugin), (Throwable)e);
            throw new GateException("Couldn't load class " + className + " for resource in " + this.plugin);
        }
        this.processCreoleResourceAnnotations(element, resourceClass);
    }

    public void processCreoleResourceAnnotations(Element element, Class<?> resourceClass) throws GateException {
        CreoleResource creoleResourceAnnot = resourceClass.getAnnotation(CreoleResource.class);
        if (creoleResourceAnnot != null) {
            this.processResourceData(resourceClass, element);
            HashMap<String, Element> parameterMap = new HashMap<String, Element>();
            HashMap<String, Element> disjunctionMap = new HashMap<String, Element>();
            for (Element paramElt : element.getChildren("PARAMETER")) {
                parameterMap.put(paramElt.getAttributeValue("NAME"), paramElt);
            }
            for (Element disjunctionElt : element.getChildren("OR")) {
                String disjunctionId = disjunctionElt.getAttributeValue("ID");
                if (disjunctionId != null) {
                    disjunctionMap.put(disjunctionId, disjunctionElt);
                }
                for (Element paramElt : disjunctionElt.getChildren("PARAMETER")) {
                    parameterMap.put(paramElt.getAttributeValue("NAME"), paramElt);
                }
            }
            this.processParameters(resourceClass, element, parameterMap, disjunctionMap);
        }
    }

    private void processResourceData(Class<?> resourceClass, Element element) {
        CreoleResource cr = resourceClass.getAnnotation(CreoleResource.class);
        if (cr.isPrivate() && element.getChild("PRIVATE") == null) {
            element.addContent((Content)new Element("PRIVATE"));
        }
        if (cr.mainViewer() && element.getChild("MAIN_VIEWER") == null) {
            element.addContent((Content)new Element("MAIN_VIEWER"));
        }
        if (cr.tool() && element.getChild("TOOL") == null) {
            element.addContent((Content)new Element("TOOL"));
        }
        this.addElement(element, "".equals(cr.name()) ? resourceClass.getSimpleName() : cr.name(), "NAME");
        this.processInheritableResourceData(resourceClass, element);
        this.processAutoInstances(cr, element);
    }

    private void processInheritableResourceData(Class<?> clazz, Element element) {
        Class<?> superclass;
        CreoleResource cr = clazz.getAnnotation(CreoleResource.class);
        if (cr != null) {
            this.addElement(element, cr.comment(), "COMMENT");
            this.addElement(element, cr.helpURL(), "HELPURL");
            this.addElement(element, cr.interfaceName(), "INTERFACE");
            this.addElement(element, cr.icon(), "ICON");
            if (cr.guiType() != GuiType.NONE && element.getChild("GUI") == null) {
                Element guiElement = new Element("GUI").setAttribute("TYPE", cr.guiType().toString());
                element.addContent((Content)guiElement);
                this.addElement(guiElement, cr.resourceDisplayed(), "RESOURCE_DISPLAYED");
            }
            this.addElement(element, cr.annotationTypeDisplayed(), "ANNOTATION_TYPE_DISPLAYED");
        }
        if ((superclass = clazz.getSuperclass()) != null) {
            this.processInheritableResourceData(superclass, element);
        }
        for (Class<?> intf : clazz.getInterfaces()) {
            this.processInheritableResourceData(intf, element);
        }
    }

    private void addElement(Element parent, String value, String elementName) {
        if (!"".equals(value) && parent.getChild(elementName) == null) {
            parent.addContent((Content)new Element(elementName).setText(value));
        }
    }

    private void processAutoInstances(CreoleResource cr, Element element) {
        for (AutoInstance ai : cr.autoinstances()) {
            Element aiElt = null;
            aiElt = ai.hidden() ? new Element("HIDDEN-AUTOINSTANCE") : new Element("AUTOINSTANCE");
            element.addContent((Content)aiElt);
            for (AutoInstanceParam param : ai.parameters()) {
                aiElt.addContent((Content)new Element("PARAM").setAttribute("NAME", param.name()).setAttribute("VALUE", param.value()));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processParameters(Class<?> resourceClass, Element resourceElement, Map<String, Element> parameterMap, Map<String, Element> disjunctionMap) throws GateException {
        void var9_15;
        BeanInfo bi;
        try {
            bi = Introspector.getBeanInfo(resourceClass);
        }
        catch (IntrospectionException e) {
            throw new GateException("Failed to introspect " + resourceClass, e);
        }
        for (Method method : resourceClass.getDeclaredMethods()) {
            this.processElement(method, bi, resourceElement, parameterMap, disjunctionMap);
        }
        for (AccessibleObject accessibleObject : resourceClass.getDeclaredFields()) {
            this.processElement(accessibleObject, bi, resourceElement, parameterMap, disjunctionMap);
        }
        Class<?> superclass = resourceClass.getSuperclass();
        if (superclass != null) {
            this.processParameters(superclass, resourceElement, parameterMap, disjunctionMap);
        }
        Class<?>[] classArray = resourceClass.getInterfaces();
        int n = classArray.length;
        boolean bl = false;
        while (var9_15 < n) {
            Class<?> intf = classArray[var9_15];
            this.processParameters(intf, resourceElement, parameterMap, disjunctionMap);
            ++var9_15;
        }
    }

    private void processElement(AnnotatedElement element, BeanInfo bi, Element resourceElement, Map<String, Element> parameterMap, Map<String, Element> disjunctionMap) throws GateException {
        CreoleParameter paramAnnot = element.getAnnotation(CreoleParameter.class);
        HiddenCreoleParameter hiddenParamAnnot = element.getAnnotation(HiddenCreoleParameter.class);
        if (paramAnnot != null || hiddenParamAnnot != null) {
            FeatureDescriptor paramDescriptor;
            Class<?> paramType;
            Type genericParamType;
            String paramName;
            if (element.getClass().equals(Field.class)) {
                Field field = (Field)element;
                paramName = field.getName();
                genericParamType = field.getGenericType();
                paramType = field.getType();
                paramDescriptor = null;
                for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
                    if (!paramName.equals(pd.getName())) continue;
                    paramDescriptor = pd;
                    break;
                }
                if (paramDescriptor == null) {
                    throw new GateException("CREOLE parameter annotation found on field " + field + " but no corresponding JavaBean accessor methods exist.");
                }
                if (((PropertyDescriptor)paramDescriptor).getReadMethod() == null || ((PropertyDescriptor)paramDescriptor).getWriteMethod() == null) {
                    throw new GateException("CREOLE parameter annotation found on field " + field + " but getter or setter is missing.  CREOLE parameters require both.");
                }
            } else if (element.getClass().equals(Method.class)) {
                Method method = (Method)element;
                paramDescriptor = null;
                for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
                    if (!method.equals(pd.getWriteMethod())) continue;
                    paramDescriptor = pd;
                    break;
                }
                if (paramDescriptor == null) {
                    throw new GateException("CREOLE parameter annotation found on " + method + " but this method is not a Java Bean property setter.");
                }
                paramName = paramDescriptor.getName();
                genericParamType = method.getGenericParameterTypes()[0];
                paramType = method.getParameterTypes()[0];
            } else {
                throw new GateException("CREOLE parameter annotation found on " + element + " but can only be placed on Method or Field");
            }
            if (hiddenParamAnnot != null && !parameterMap.containsKey(paramName)) {
                parameterMap.put(paramName, null);
            }
            if (paramAnnot != null) {
                Element paramElt = null;
                if (parameterMap.containsKey(paramName)) {
                    paramElt = parameterMap.get(paramName);
                } else {
                    paramElt = new Element("PARAMETER").setAttribute("NAME", paramName);
                    if (!"".equals(paramAnnot.disjunction())) {
                        Element disjunctionElt = disjunctionMap.get(paramAnnot.disjunction());
                        if (disjunctionElt == null) {
                            disjunctionElt = new Element("OR");
                            resourceElement.addContent((Content)disjunctionElt);
                            disjunctionMap.put(paramAnnot.disjunction(), disjunctionElt);
                        }
                        disjunctionElt.addContent((Content)paramElt);
                    } else {
                        resourceElement.addContent((Content)paramElt);
                    }
                    parameterMap.put(paramName, paramElt);
                }
                if (paramElt != null) {
                    if (paramElt.getTextTrim().length() == 0) {
                        paramElt.setText(paramType.getName());
                        if (!Resource.class.isAssignableFrom(paramType) && Collection.class.isAssignableFrom(paramType)) {
                            this.determineCollectionElementType(element, genericParamType, paramElt);
                        }
                    }
                    this.addAttribute(paramElt, paramAnnot.comment(), "", "COMMENT");
                    this.addAttribute(paramElt, paramAnnot.suffixes(), "", "SUFFIXES");
                    this.addAttribute(paramElt, paramAnnot.defaultValue(), "____NO_DEFAULT____", "DEFAULT");
                    this.addAttribute(paramElt, String.valueOf(paramAnnot.priority()), String.valueOf(Integer.MAX_VALUE), "PRIORITY");
                    String runtimeParam = "";
                    if (element.isAnnotationPresent(RunTime.class)) {
                        runtimeParam = String.valueOf(element.getAnnotation(RunTime.class).value());
                    }
                    this.addAttribute(paramElt, runtimeParam, "", "RUNTIME");
                    String optionalParam = "";
                    if (element.isAnnotationPresent(Optional.class)) {
                        optionalParam = String.valueOf(element.getAnnotation(Optional.class).value());
                    }
                    this.addAttribute(paramElt, optionalParam, "", "OPTIONAL");
                }
            }
        }
    }

    private void determineCollectionElementType(AnnotatedElement method, Type paramType, Element paramElt) {
        CreoleParameter paramAnnot;
        Class<?> elementType;
        if (paramElt.getAttributeValue("ITEM_CLASS_NAME") == null && (elementType = (paramAnnot = method.getAnnotation(CreoleParameter.class)) != null && paramAnnot.collectionElementType() != CreoleParameter.NoElementType.class ? paramAnnot.collectionElementType() : this.findCollectionElementType(paramType)) != null) {
            paramElt.setAttribute("ITEM_CLASS_NAME", elementType.getName());
        }
    }

    private Class<?> findCollectionElementType(Type type) {
        return this.findCollectionElementType(type, new HashMap());
    }

    private Class<?> findCollectionElementType(Type type, Map<TypeVariable<?>, Class<?>> tvMap) {
        Class rawClass = null;
        if (type instanceof Class) {
            rawClass = (Class)type;
        } else if (type instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)type).getRawType();
            if (rawType == Collection.class) {
                Type collectionTypeArgument = ((ParameterizedType)type).getActualTypeArguments()[0];
                if (collectionTypeArgument instanceof Class) {
                    return (Class)collectionTypeArgument;
                }
                if (collectionTypeArgument instanceof TypeVariable) {
                    return tvMap.get(collectionTypeArgument);
                }
                return null;
            }
            if (rawType instanceof Class) {
                rawClass = (Class)rawType;
                Type[] actualTypeParams = ((ParameterizedType)type).getActualTypeArguments();
                TypeVariable<Class<T>>[] formalTypeParams = ((Class)rawType).getTypeParameters();
                for (int i = 0; i < actualTypeParams.length; ++i) {
                    if (actualTypeParams[i] instanceof Class) {
                        tvMap.put(formalTypeParams[i], (Class)actualTypeParams[i]);
                        continue;
                    }
                    if (!(actualTypeParams[i] instanceof TypeVariable)) continue;
                    tvMap.put(formalTypeParams[i], tvMap.get(actualTypeParams[i]));
                }
            }
        }
        if (rawClass != null) {
            Class<?> componentType;
            Type superclass = rawClass.getGenericSuperclass();
            if (type != null && (componentType = this.findCollectionElementType(superclass, tvMap)) != null) {
                return componentType;
            }
            for (Type intf : rawClass.getGenericInterfaces()) {
                Class<?> componentType2 = this.findCollectionElementType(intf, tvMap);
                if (componentType2 == null) continue;
                return componentType2;
            }
        }
        return null;
    }

    private void addAttribute(Element paramElt, Object value, Object defaultValue, String attrName) {
        if (!defaultValue.equals(value) && paramElt.getAttribute(attrName) == null) {
            paramElt.setAttribute(attrName, value.toString());
        }
    }
}

