/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import gate.Controller;
import gate.Corpus;
import gate.CorpusController;
import gate.Document;
import gate.Factory;
import gate.Gate;
import gate.LanguageAnalyser;
import gate.ProcessingResource;
import gate.creole.AbstractResource;
import gate.creole.ConditionalSerialController;
import gate.creole.ControllerAwarePR;
import gate.creole.ExecutionException;
import gate.creole.ExecutionInterruptedException;
import gate.creole.Parameter;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.creole.metadata.CreoleParameter;
import gate.creole.metadata.CreoleResource;
import gate.creole.metadata.Optional;
import gate.creole.metadata.RunTime;
import gate.event.CreoleEvent;
import gate.util.Benchmark;
import gate.util.GateRuntimeException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@CreoleResource(name="Conditional Corpus Pipeline", comment="A serial controller for conditionally run PR pipelines over corpora.", helpURL="http://gate.ac.uk/userguide/sec:developer:cond")
public class ConditionalSerialAnalyserController
extends ConditionalSerialController
implements CorpusController,
LanguageAnalyser,
ControllerAwarePR {
    private static final long serialVersionUID = -2328353583769147103L;
    private static final boolean DEBUG = false;
    protected boolean runningAsSubPipeline = false;
    protected Corpus corpus;
    protected Document document;

    @Override
    public Document getDocument() {
        return this.document;
    }

    @Override
    @Optional
    @RunTime
    @CreoleParameter
    public void setDocument(Document document) {
        this.document = document;
    }

    @Override
    public Corpus getCorpus() {
        return this.corpus;
    }

    @Override
    public void setCorpus(Corpus corpus) {
        this.corpus = corpus;
    }

    @Override
    public void execute() throws ExecutionException {
        this.runningAsSubPipeline = this.document != null;
        if (!this.runningAsSubPipeline && this.controllerCallbacksEnabled) {
            this.invokeControllerExecutionStarted();
        }
        Throwable thrown = null;
        try {
            if (Benchmark.isBenchmarkingEnabled()) {
                Benchmark.startPoint(this.getBenchmarkId());
            }
            this.executeImpl();
        }
        catch (Throwable t) {
            thrown = t;
        }
        finally {
            if (thrown == null) {
                if (!this.runningAsSubPipeline && this.controllerCallbacksEnabled) {
                    this.invokeControllerExecutionFinished();
                }
            } else {
                if (!this.runningAsSubPipeline && this.controllerCallbacksEnabled) {
                    this.invokeControllerExecutionAborted(thrown);
                }
                if (thrown instanceof Error) {
                    throw (Error)thrown;
                }
                if (thrown instanceof RuntimeException) {
                    throw (RuntimeException)thrown;
                }
                if (thrown instanceof ExecutionException) {
                    throw (ExecutionException)thrown;
                }
                throw new UndeclaredThrowableException(thrown);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeImpl() throws ExecutionException {
        this.interrupted = false;
        if (this.corpus == null) {
            throw new ExecutionException("(ConditionalSerialAnalyserController) \"" + this.getName() + "\":\nThe corpus supplied for execution was null!");
        }
        this.benchmarkFeatures.put("corpusName", this.corpus.getName());
        if (this.document == null) {
            for (int i = 0; i < this.corpus.size(); ++i) {
                String savedBenchmarkId = this.getBenchmarkId();
                try {
                    int j;
                    if (this.isInterrupted()) {
                        throw new ExecutionInterruptedException("The execution of the " + this.getName() + " application has been abruptly interrupted!");
                    }
                    boolean docWasLoaded = this.corpus.isDocumentLoaded(i);
                    long documentLoadingStartTime = Benchmark.startPoint();
                    Document doc = (Document)this.corpus.get(i);
                    this.setBenchmarkId(Benchmark.createBenchmarkId("doc_" + doc.getName(), this.getBenchmarkId()));
                    this.benchmarkFeatures.put("documentName", doc.getName());
                    Benchmark.checkPoint(documentLoadingStartTime, Benchmark.createBenchmarkId("documentLoaded", this.getBenchmarkId()), this, this.benchmarkFeatures);
                    for (j = 0; j < this.prList.size(); ++j) {
                        ((LanguageAnalyser)this.prList.get(j)).setDocument(doc);
                        ((LanguageAnalyser)this.prList.get(j)).setCorpus(this.corpus);
                    }
                    try {
                        super.executeImpl();
                    }
                    catch (Throwable throwable) {
                        log.error((Object)("An error occurred processing document '" + doc.getName() + "'. This was document " + (i + 1) + " of " + this.corpus.size() + " in the '" + this.corpus.getName() + "' corpus. See the log for details"));
                        if (throwable instanceof Error) {
                            throw (Error)throwable;
                        }
                        if (throwable instanceof RuntimeException) {
                            throw (RuntimeException)throwable;
                        }
                        if (throwable instanceof ExecutionException) {
                            throw (ExecutionException)throwable;
                        }
                        throw new UndeclaredThrowableException(throwable);
                    }
                    finally {
                        for (j = 0; j < this.prList.size(); ++j) {
                            ((LanguageAnalyser)this.prList.get(j)).setDocument(null);
                            ((LanguageAnalyser)this.prList.get(j)).setCorpus(null);
                        }
                    }
                    if (docWasLoaded) continue;
                    long documentSavingStartTime = Benchmark.startPoint();
                    this.corpus.unloadDocument(doc);
                    Benchmark.checkPoint(documentSavingStartTime, Benchmark.createBenchmarkId("documentSaved", this.getBenchmarkId()), this, this.benchmarkFeatures);
                    Factory.deleteResource(doc);
                    continue;
                }
                finally {
                    this.setBenchmarkId(savedBenchmarkId);
                }
            }
        } else {
            int j;
            for (j = 0; j < this.prList.size(); ++j) {
                ((LanguageAnalyser)this.prList.get(j)).setDocument(this.document);
                ((LanguageAnalyser)this.prList.get(j)).setCorpus(this.corpus);
            }
            try {
                super.executeImpl();
            }
            catch (Throwable throwable) {
                log.error((Object)("An error occurred processing document " + this.document.getName() + ". See the log for details"));
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof ExecutionException) {
                    throw (ExecutionException)throwable;
                }
                throw new UndeclaredThrowableException(throwable);
            }
            finally {
                for (j = 0; j < this.prList.size(); ++j) {
                    ((LanguageAnalyser)this.prList.get(j)).setDocument(null);
                    ((LanguageAnalyser)this.prList.get(j)).setCorpus(null);
                }
            }
        }
    }

    @Override
    public void add(ProcessingResource pr) {
        this.checkLanguageAnalyser(pr);
        super.add(pr);
    }

    @Override
    public void add(int index, ProcessingResource pr) {
        this.checkLanguageAnalyser(pr);
        super.add(index, pr);
    }

    protected void checkLanguageAnalyser(ProcessingResource pr) {
        if (!(pr instanceof LanguageAnalyser)) {
            throw new GateRuntimeException(this.getClass().getName() + " only accepts " + LanguageAnalyser.class.getName() + "s as components\n" + pr.getClass().getName() + " is not!");
        }
    }

    protected void setDocToPrs(Document doc) {
        for (ProcessingResource pr : this.getPRs()) {
            if (!(pr instanceof LanguageAnalyser)) continue;
            ((LanguageAnalyser)pr).setDocument(doc);
        }
    }

    @Override
    public List<ProcessingResource> getOffendingPocessingResources() throws ResourceInstantiationException {
        ArrayList<ProcessingResource> badPRs = new ArrayList<ProcessingResource>(this.getPRs());
        for (ProcessingResource pr : this.getPRs()) {
            ResourceData rData = (ResourceData)Gate.getCreoleRegister().get(pr.getClass().getName());
            List<List<Parameter>> parameters = rData.getParameterList().getRuntimeParameters();
            ArrayList<List<Parameter>> newParameters = new ArrayList<List<Parameter>>();
            for (List<Parameter> aDisjunction : parameters) {
                ArrayList<Parameter> newDisjunction = new ArrayList<Parameter>(aDisjunction);
                Iterator internalParIter = newDisjunction.iterator();
                while (internalParIter.hasNext()) {
                    Parameter parameter = (Parameter)internalParIter.next();
                    if (!parameter.getName().equals("corpus") && !parameter.getName().equals("document")) continue;
                    internalParIter.remove();
                }
                if (newDisjunction.isEmpty()) continue;
                newParameters.add(newDisjunction);
            }
            if (!AbstractResource.checkParameterValues(pr, newParameters)) continue;
            badPRs.remove(pr);
        }
        return badPRs.isEmpty() ? null : badPRs;
    }

    @Override
    public void resourceUnloaded(CreoleEvent e) {
        super.resourceUnloaded(e);
        if (e.getResource() == this.corpus) {
            this.setCorpus(null);
        }
    }

    @Override
    public void controllerExecutionStarted(Controller c) throws ExecutionException {
        for (int i = 0; i < this.getPRs().size(); ++i) {
            ProcessingResource pr = (ProcessingResource)this.getPRs().get(i);
            if (!(pr instanceof ControllerAwarePR) || this.getRunningStrategies().get(i).getRunMode() == 2) continue;
            if (pr instanceof LanguageAnalyser) {
                ((LanguageAnalyser)pr).setCorpus(this.corpus);
            }
            ((ControllerAwarePR)pr).controllerExecutionStarted(c);
        }
    }

    @Override
    public void controllerExecutionFinished(Controller c) throws ExecutionException {
        for (int i = 0; i < this.getPRs().size(); ++i) {
            ProcessingResource pr = (ProcessingResource)this.getPRs().get(i);
            if (!(pr instanceof ControllerAwarePR) || this.getRunningStrategies().get(i).getRunMode() == 2) continue;
            if (pr instanceof LanguageAnalyser) {
                ((LanguageAnalyser)pr).setCorpus(this.corpus);
            }
            ((ControllerAwarePR)pr).controllerExecutionFinished(c);
            if (!(pr instanceof LanguageAnalyser)) continue;
            ((LanguageAnalyser)pr).setCorpus(null);
        }
    }

    @Override
    public void controllerExecutionAborted(Controller c, Throwable t) throws ExecutionException {
        for (int i = 0; i < this.getPRs().size(); ++i) {
            ProcessingResource pr = (ProcessingResource)this.getPRs().get(i);
            if (!(pr instanceof ControllerAwarePR) || this.getRunningStrategies().get(i).getRunMode() == 2) continue;
            if (pr instanceof LanguageAnalyser) {
                ((LanguageAnalyser)pr).setCorpus(this.corpus);
            }
            ((ControllerAwarePR)pr).controllerExecutionAborted(c, t);
            if (!(pr instanceof LanguageAnalyser)) continue;
            ((LanguageAnalyser)pr).setCorpus(null);
        }
    }

    @Override
    public void invokeControllerExecutionStarted() throws ExecutionException {
        for (int i = 0; i < this.getPRs().size(); ++i) {
            ProcessingResource pr = (ProcessingResource)this.getPRs().get(i);
            if (!(pr instanceof ControllerAwarePR) || this.getRunningStrategies().get(i).getRunMode() == 2) continue;
            if (pr instanceof LanguageAnalyser) {
                ((LanguageAnalyser)pr).setCorpus(this.corpus);
            }
            ((ControllerAwarePR)pr).controllerExecutionStarted(this);
        }
    }

    @Override
    public void invokeControllerExecutionFinished() throws ExecutionException {
        for (int i = 0; i < this.getPRs().size(); ++i) {
            ProcessingResource pr = (ProcessingResource)this.getPRs().get(i);
            if (!(pr instanceof ControllerAwarePR) || this.getRunningStrategies().get(i).getRunMode() == 2) continue;
            if (pr instanceof LanguageAnalyser) {
                ((LanguageAnalyser)pr).setCorpus(this.corpus);
            }
            ((ControllerAwarePR)pr).controllerExecutionFinished(this);
            if (!(pr instanceof LanguageAnalyser)) continue;
            ((LanguageAnalyser)pr).setCorpus(null);
        }
    }

    @Override
    public void invokeControllerExecutionAborted(Throwable thrown) throws ExecutionException {
        for (int i = 0; i < this.getPRs().size(); ++i) {
            ProcessingResource pr = (ProcessingResource)this.getPRs().get(i);
            if (!(pr instanceof ControllerAwarePR) || this.getRunningStrategies().get(i).getRunMode() == 2) continue;
            if (pr instanceof LanguageAnalyser) {
                ((LanguageAnalyser)pr).setCorpus(this.corpus);
            }
            ((ControllerAwarePR)pr).controllerExecutionAborted(this, thrown);
            if (!(pr instanceof LanguageAnalyser)) continue;
            ((LanguageAnalyser)pr).setCorpus(null);
        }
    }
}

