/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.Resource;
import gate.creole.Parameter;
import gate.creole.ParameterException;
import gate.creole.ParameterList;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.util.AbstractFeatureBearer;
import gate.util.Err;
import gate.util.GateException;
import gate.util.Strings;
import gate.util.Tools;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractResource
extends AbstractFeatureBearer
implements Resource {
    static final long serialVersionUID = -9196293927841163321L;
    protected String name;
    private static Map<Class<? extends Resource>, BeanInfo> beanInfoCache = new HashMap<Class<? extends Resource>, BeanInfo>();

    @Override
    public Resource init() throws ResourceInstantiationException {
        return this;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void cleanup() {
    }

    public static Object getParameterValue(Resource resource, String paramaterName) throws ResourceInstantiationException {
        BeanInfo resBeanInf = null;
        try {
            resBeanInf = AbstractResource.getBeanInfo(resource.getClass());
        }
        catch (Exception e) {
            throw new ResourceInstantiationException("Couldn't get bean info for resource " + resource.getClass().getName() + Strings.getNl() + "Introspector exception was: " + e);
        }
        PropertyDescriptor[] properties = resBeanInf.getPropertyDescriptors();
        if (properties == null) {
            throw new ResourceInstantiationException("Couldn't get properties info for resource " + resource.getClass().getName());
        }
        boolean done = false;
        Object value = null;
        for (int i = 0; !done && i < properties.length; ++i) {
            PropertyDescriptor prop = properties[i];
            if (!prop.getName().equals(paramaterName)) continue;
            Method getMethod = prop.getReadMethod();
            if (getMethod == null) {
                throw new ResourceInstantiationException("Couldn't get read accessor method for parameter " + paramaterName + " in " + resource.getClass().getName());
            }
            Object[] args = new Object[]{};
            try {
                value = getMethod.invoke((Object)resource, args);
            }
            catch (Exception e) {
                throw new ResourceInstantiationException("couldn't invoke get method: " + e);
            }
            done = true;
        }
        if (done) {
            return value;
        }
        throw new ResourceInstantiationException("Couldn't find parameter named " + paramaterName + " in " + resource.getClass().getName());
    }

    public static void setParameterValue(Resource resource, BeanInfo resBeanInf, String paramaterName, Object parameterValue) throws ResourceInstantiationException {
        PropertyDescriptor[] properties = resBeanInf.getPropertyDescriptors();
        if (properties == null) {
            throw new ResourceInstantiationException("Couldn't get properties info for resource " + resource.getClass().getName());
        }
        boolean done = false;
        for (int i = 0; !done && i < properties.length; ++i) {
            PropertyDescriptor prop = properties[i];
            if (!prop.getName().equals(paramaterName)) continue;
            Method setMethod = prop.getWriteMethod();
            if (setMethod == null) {
                throw new ResourceInstantiationException("Couldn't get write accessor method for parameter " + paramaterName + " in " + resource.getClass().getName());
            }
            if (parameterValue != null) {
                Class<?> paramType;
                Class<?> propertyType;
                Class<?> typeToCreate = propertyType = prop.getPropertyType();
                if (Parameter.substituteClasses.containsKey(propertyType)) {
                    typeToCreate = Parameter.substituteClasses.get(propertyType);
                }
                if (!propertyType.isAssignableFrom(paramType = parameterValue.getClass())) {
                    try {
                        Constructor<?> mostSpecificConstructor = Tools.getMostSpecificConstructor(typeToCreate, paramType);
                        parameterValue = mostSpecificConstructor.newInstance(parameterValue);
                    }
                    catch (Exception e) {
                        if (String.class.isAssignableFrom(paramType)) {
                            Parameter aParam;
                            Iterator<Parameter> paramIter;
                            ResourceData rData = (ResourceData)Gate.getCreoleRegister().get(resource.getClass().getName());
                            ParameterList pList = rData.getParameterList();
                            Parameter param = null;
                            Iterator<List<Parameter>> disjIter = pList.getInitimeParameters().iterator();
                            while (param == null && disjIter.hasNext()) {
                                paramIter = disjIter.next().iterator();
                                while (param == null && paramIter.hasNext()) {
                                    aParam = paramIter.next();
                                    if (!aParam.getName().equals(paramaterName)) continue;
                                    param = aParam;
                                }
                            }
                            disjIter = pList.getRuntimeParameters().iterator();
                            while (param == null && disjIter.hasNext()) {
                                paramIter = disjIter.next().iterator();
                                while (param == null && paramIter.hasNext()) {
                                    aParam = paramIter.next();
                                    if (!aParam.getName().equals(paramaterName)) continue;
                                    param = aParam;
                                }
                            }
                            if (param != null) {
                                try {
                                    parameterValue = param.calculateValueFromString((String)parameterValue);
                                }
                                catch (ParameterException pe) {
                                    throw new ResourceInstantiationException(pe);
                                }
                            }
                            throw new ResourceInstantiationException("Property " + paramaterName + " of resource class " + resource.getClass().getName() + " is not declared as a CREOLE parameter.  Automatic conversion of string values to other types is only supported for declared parameters.");
                        }
                        throw new ResourceInstantiationException("Error converting " + parameterValue.getClass() + " to " + propertyType + ": " + e.toString());
                    }
                }
            }
            Object[] args = new Object[]{parameterValue};
            try {
                setMethod.invoke((Object)resource, args);
            }
            catch (Exception e) {
                e.printStackTrace(Err.getPrintWriter());
                throw new ResourceInstantiationException("couldn't invoke set method for " + paramaterName + " on " + resource.getClass().getName() + ": " + e);
            }
            done = true;
        }
        if (!done) {
            throw new ResourceInstantiationException("Couldn't find parameter named " + paramaterName + " in " + resource.getClass().getName());
        }
    }

    public static void setParameterValues(Resource resource, FeatureMap parameters) throws ResourceInstantiationException {
        BeanInfo resBeanInf = null;
        try {
            resBeanInf = AbstractResource.getBeanInfo(resource.getClass());
        }
        catch (Exception e) {
            throw new ResourceInstantiationException("Couldn't get bean info for resource " + resource.getClass().getName() + Strings.getNl() + "Introspector exception was: " + e);
        }
        for (String parName : parameters.keySet()) {
            AbstractResource.setParameterValue(resource, resBeanInf, parName, parameters.get(parName));
        }
    }

    public static void setResourceListeners(Resource resource, Map<String, ? extends Object> listeners) throws IntrospectionException, InvocationTargetException, IllegalAccessException, GateException {
        BeanInfo resBeanInfo = AbstractResource.getBeanInfo(resource.getClass());
        EventSetDescriptor[] events = resBeanInfo.getEventSetDescriptors();
        if (events != null) {
            for (int i = 0; i < events.length; ++i) {
                EventSetDescriptor event = events[i];
                Object listener = listeners.get(event.getListenerType().getName());
                if (listener == null) continue;
                Method addListener = event.getAddListenerMethod();
                Object[] args = new Object[]{listener};
                addListener.invoke((Object)resource, args);
            }
        }
    }

    public static void removeResourceListeners(Resource resource, Map<String, ? extends Object> listeners) throws IntrospectionException, InvocationTargetException, IllegalAccessException, GateException {
        BeanInfo resBeanInfo = AbstractResource.getBeanInfo(resource.getClass());
        EventSetDescriptor[] events = resBeanInfo.getEventSetDescriptors();
        if (events != null) {
            for (int i = 0; i < events.length; ++i) {
                EventSetDescriptor event = events[i];
                Object listener = listeners.get(event.getListenerType().getName());
                if (listener == null) continue;
                Method removeListener = event.getRemoveListenerMethod();
                Object[] args = new Object[]{listener};
                removeListener.invoke((Object)resource, args);
            }
        }
    }

    public static boolean checkParameterValues(Resource resource, List<List<Parameter>> parameters) throws ResourceInstantiationException {
        for (List<Parameter> disjunction : parameters) {
            boolean required = !disjunction.get(0).isOptional();
            if (!required) continue;
            boolean valueSet = false;
            Iterator<Parameter> parIter = disjunction.iterator();
            while (!valueSet && parIter.hasNext()) {
                Parameter par = parIter.next();
                valueSet = resource.getParameterValue(par.getName()) != null;
            }
            if (valueSet) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object getParameterValue(String paramaterName) throws ResourceInstantiationException {
        return AbstractResource.getParameterValue(this, paramaterName);
    }

    @Override
    public void setParameterValue(String paramaterName, Object parameterValue) throws ResourceInstantiationException {
        BeanInfo resBeanInf = null;
        try {
            resBeanInf = AbstractResource.getBeanInfo(this.getClass());
        }
        catch (Exception e) {
            throw new ResourceInstantiationException("Couldn't get bean info for resource " + this.getClass().getName() + Strings.getNl() + "Introspector exception was: " + e);
        }
        AbstractResource.setParameterValue(this, resBeanInf, paramaterName, parameterValue);
    }

    @Override
    public void setParameterValues(FeatureMap parameters) throws ResourceInstantiationException {
        AbstractResource.setParameterValues(this, parameters);
    }

    public static FeatureMap getParameterValues(Resource res, List<List<Parameter>> params) throws ResourceInstantiationException {
        FeatureMap fm = Factory.newFeatureMap();
        for (List<Parameter> parDisjunction : params) {
            for (Parameter p : parDisjunction) {
                fm.put(p.getName(), res.getParameterValue(p.getName()));
            }
        }
        return fm;
    }

    public static FeatureMap getInitParameterValues(Resource res) throws ResourceInstantiationException {
        ResourceData rData = (ResourceData)Gate.getCreoleRegister().get(res.getClass().getName());
        if (rData == null) {
            throw new ResourceInstantiationException("Could not find CREOLE data for " + res.getClass().getName());
        }
        ParameterList params = rData.getParameterList();
        return AbstractResource.getParameterValues(res, params.getInitimeParameters());
    }

    public FeatureMap getInitParameterValues() throws ResourceInstantiationException {
        return AbstractResource.getInitParameterValues(this);
    }

    public static BeanInfo getBeanInfo(Class<? extends Resource> c) throws IntrospectionException {
        BeanInfo r = beanInfoCache.get(c);
        if (r == null) {
            r = Introspector.getBeanInfo(c, Object.class);
            beanInfoCache.put(c, r);
        }
        return r;
    }

    public static boolean forgetBeanInfo(Class<? extends Resource> c) {
        return beanInfoCache.remove(c) != null;
    }

    public static void flushBeanInfoCache() {
        beanInfoCache.clear();
    }

    public String toString() {
        return this.getName();
    }
}

